/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.BrokerControlState;
import org.apache.kafka.controller.BrokerControlStates;
import org.apache.kafka.controller.BrokerHeartbeatManager;
import org.apache.kafka.metadata.placement.CellDescriber;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class BrokerHeartbeatManagerTest {
    private static final CellDescriber CELL_DESCRIBER = new CellDescriber(){};

    private static BrokerHeartbeatManager newBrokerHeartbeatManager() {
        LogContext logContext = new LogContext();
        MockTime time = new MockTime(0L, 1000000L, 0L);
        return new BrokerHeartbeatManager(logContext, (Time)time, 10000000L);
    }

    @Test
    public void testHasValidSession() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        MockTime time = (MockTime)manager.time();
        Assertions.assertFalse((boolean)manager.hasValidSession(0));
        for (int brokerId = 0; brokerId < 3; ++brokerId) {
            manager.register(brokerId, true);
        }
        manager.touch(0, false, 0L);
        time.sleep(5L);
        manager.touch(1, false, 0L);
        manager.touch(2, false, 0L);
        Assertions.assertTrue((boolean)manager.hasValidSession(0));
        Assertions.assertTrue((boolean)manager.hasValidSession(1));
        Assertions.assertTrue((boolean)manager.hasValidSession(2));
        Assertions.assertFalse((boolean)manager.hasValidSession(3));
        time.sleep(6L);
        Assertions.assertFalse((boolean)manager.hasValidSession(0));
        Assertions.assertTrue((boolean)manager.hasValidSession(1));
        Assertions.assertTrue((boolean)manager.hasValidSession(2));
        Assertions.assertFalse((boolean)manager.hasValidSession(3));
        manager.remove(2);
        Assertions.assertFalse((boolean)manager.hasValidSession(2));
        manager.remove(1);
        Assertions.assertFalse((boolean)manager.hasValidSession(1));
    }

    @Test
    public void testFindOneStaleBroker() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        MockTime time = (MockTime)manager.time();
        Assertions.assertFalse((boolean)manager.hasValidSession(0));
        for (int brokerId = 0; brokerId < 3; ++brokerId) {
            manager.register(brokerId, true);
        }
        manager.touch(0, false, 0L);
        time.sleep(5L);
        manager.touch(1, false, 0L);
        time.sleep(1L);
        manager.touch(2, false, 0L);
        BrokerHeartbeatManager.BrokerHeartbeatStateIterator iter = manager.unfenced().iterator();
        Assertions.assertEquals((int)0, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter.next()).id());
        Assertions.assertEquals((int)1, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter.next()).id());
        Assertions.assertEquals((int)2, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter.next()).id());
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertEquals(Optional.empty(), (Object)manager.findOneStaleBroker());
        time.sleep(5L);
        Assertions.assertEquals(Optional.of(0), (Object)manager.findOneStaleBroker());
        manager.fence(0);
        Assertions.assertEquals(Optional.empty(), (Object)manager.findOneStaleBroker());
        iter = manager.unfenced().iterator();
        Assertions.assertEquals((int)1, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter.next()).id());
        Assertions.assertEquals((int)2, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter.next()).id());
        Assertions.assertFalse((boolean)iter.hasNext());
        time.sleep(20L);
        Assertions.assertEquals(Optional.of(1), (Object)manager.findOneStaleBroker());
        manager.fence(1);
        Assertions.assertEquals(Optional.of(2), (Object)manager.findOneStaleBroker());
        manager.fence(2);
        Assertions.assertEquals(Optional.empty(), (Object)manager.findOneStaleBroker());
        iter = manager.unfenced().iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testNextCheckTimeNs() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        MockTime time = (MockTime)manager.time();
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)manager.nextCheckTimeNs());
        for (int brokerId = 0; brokerId < 4; ++brokerId) {
            manager.register(brokerId, true);
        }
        manager.touch(0, false, 0L);
        time.sleep(2L);
        manager.touch(1, false, 0L);
        time.sleep(1L);
        manager.touch(2, false, 0L);
        time.sleep(1L);
        manager.touch(3, false, 0L);
        Assertions.assertEquals(Optional.empty(), (Object)manager.findOneStaleBroker());
        Assertions.assertEquals((long)10000000L, (long)manager.nextCheckTimeNs());
        time.sleep(7L);
        Assertions.assertEquals((long)10000000L, (long)manager.nextCheckTimeNs());
        Assertions.assertEquals(Optional.of(0), (Object)manager.findOneStaleBroker());
        manager.fence(0);
        Assertions.assertEquals((long)12000000L, (long)manager.nextCheckTimeNs());
        time.sleep(3L);
        Assertions.assertEquals(Optional.of(1), (Object)manager.findOneStaleBroker());
        manager.fence(1);
        Assertions.assertEquals(Optional.of(2), (Object)manager.findOneStaleBroker());
        manager.fence(2);
        Assertions.assertEquals((long)14000000L, (long)manager.nextCheckTimeNs());
    }

    @Test
    public void testMetadataOffsetComparator() {
        TreeSet<BrokerHeartbeatManager.BrokerHeartbeatState> set = new TreeSet<BrokerHeartbeatManager.BrokerHeartbeatState>((Comparator<BrokerHeartbeatManager.BrokerHeartbeatState>)BrokerHeartbeatManager.MetadataOffsetComparator.INSTANCE);
        BrokerHeartbeatManager.BrokerHeartbeatState broker1 = new BrokerHeartbeatManager.BrokerHeartbeatState(1);
        BrokerHeartbeatManager.BrokerHeartbeatState broker2 = new BrokerHeartbeatManager.BrokerHeartbeatState(2);
        BrokerHeartbeatManager.BrokerHeartbeatState broker3 = new BrokerHeartbeatManager.BrokerHeartbeatState(3);
        set.add(broker1);
        set.add(broker2);
        set.add(broker3);
        Iterator iterator = set.iterator();
        Assertions.assertEquals((Object)broker1, iterator.next());
        Assertions.assertEquals((Object)broker2, iterator.next());
        Assertions.assertEquals((Object)broker3, iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertTrue((boolean)set.remove(broker1));
        Assertions.assertTrue((boolean)set.remove(broker2));
        Assertions.assertTrue((boolean)set.remove(broker3));
        Assertions.assertTrue((boolean)set.isEmpty());
        broker1.metadataOffset = 800L;
        broker2.metadataOffset = 400L;
        broker3.metadataOffset = 100L;
        set.add(broker1);
        set.add(broker2);
        set.add(broker3);
        iterator = set.iterator();
        Assertions.assertEquals((Object)broker3, iterator.next());
        Assertions.assertEquals((Object)broker2, iterator.next());
        Assertions.assertEquals((Object)broker1, iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    private static Set<UsableBroker> usableBrokersToSet(BrokerHeartbeatManager manager) {
        HashSet<UsableBroker> brokers = new HashSet<UsableBroker>();
        BrokerHeartbeatManager.UsableBrokerIterator iterator = new BrokerHeartbeatManager.UsableBrokerIterator(manager.brokers().iterator(), id -> id % 2 == 0 ? Optional.of("rack1") : Optional.of("rack2"), Collections.emptySet(), arg_0 -> ((CellDescriber)CELL_DESCRIBER).getBrokerCellId(arg_0), (Map)manager.shutdowns());
        while (iterator.hasNext()) {
            brokers.add((UsableBroker)iterator.next());
        }
        return brokers;
    }

    @Test
    public void testUsableBrokerIterator() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        Assertions.assertEquals(Collections.emptySet(), BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
        for (int brokerId = 0; brokerId < 5; ++brokerId) {
            manager.register(brokerId, true);
        }
        manager.touch(0, false, 100L);
        manager.touch(1, false, 100L);
        manager.touch(2, false, 98L);
        manager.touch(3, false, 100L);
        manager.touch(4, true, 100L);
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Integer>(98L, 2), (Object)manager.lowestActiveOffsetAndBroker());
        HashMap<Integer, UsableBroker> expected = new HashMap<Integer, UsableBroker>();
        expected.put(0, new UsableBroker(0, Optional.of("rack1"), false));
        expected.put(1, new UsableBroker(1, Optional.of("rack2"), false));
        expected.put(2, new UsableBroker(2, Optional.of("rack1"), false));
        expected.put(3, new UsableBroker(3, Optional.of("rack2"), false));
        expected.put(4, new UsableBroker(4, Optional.of("rack1"), true));
        Assertions.assertEquals(new HashSet(expected.values()), BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
        manager.updateControlledShutdownOffset(2, 123L);
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Integer>(100L, 0), (Object)manager.lowestActiveOffsetAndBroker());
        Assertions.assertEquals((Object)"Cannot update the controlled shutdown state of broker 4, because it is fenced.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> manager.updateControlledShutdownOffset(4, 124L))).getMessage());
        manager.touch(4, false, 100L);
        expected.put(4, new UsableBroker(4, Optional.of("rack1"), false));
        expected.put(2, new UsableBroker(2, Optional.of("rack1"), true));
        Assertions.assertEquals(new HashSet(expected.values()), BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
    }

    @Test
    public void testUsableBrokers() {
        Function<Integer, Optional> brokerIdToRack = id -> Optional.of(Integer.toString(id % 3));
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        Assertions.assertEquals(Collections.emptySet(), BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
        for (int brokerId = 0; brokerId < 10; ++brokerId) {
            manager.register(brokerId, true);
        }
        for (int i = 0; i < 10; ++i) {
            manager.touch(i, false, 100L);
        }
        HashSet<Integer> excluded = new HashSet<Integer>(Arrays.asList(1, 2, 3));
        Iterator iter = manager.usableBrokers(brokerIdToRack, excluded, arg_0 -> ((CellDescriber)CELL_DESCRIBER).getBrokerCellId(arg_0));
        while (iter.hasNext()) {
            Assertions.assertFalse((boolean)excluded.contains(((UsableBroker)iter.next()).id()));
        }
    }

    @Test
    public void testControlledShutdownOffsetUpdate() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        Assertions.assertEquals(Collections.emptySet(), BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
        for (int brokerId = 0; brokerId < 5; ++brokerId) {
            manager.register(brokerId, true);
        }
        manager.touch(0, false, 100L);
        manager.touch(1, false, 100L);
        manager.touch(2, false, 98L);
        manager.touch(3, false, 100L);
        manager.touch(4, true, 100L);
        manager.updateControlledShutdownOffset(2, 120L);
        Assertions.assertEquals((long)120L, (Long)((Long)manager.shutdowns().get(2)));
        manager.updateControlledShutdownOffset(3, 111L);
        Assertions.assertEquals((long)111L, (Long)((Long)manager.shutdowns().get(3)));
        manager.updateControlledShutdownOffset(2, 98L);
        manager.updateControlledShutdownOffset(3, 101L);
        Assertions.assertThrows(RuntimeException.class, () -> manager.updateControlledShutdownOffset(4, 101L));
        Assertions.assertEquals((long)101L, (Long)((Long)manager.shutdowns().get(3)));
        Assertions.assertNull(manager.shutdowns().get(0));
    }

    @Test
    public void testBrokerHeartbeatStateList() {
        BrokerHeartbeatManager.BrokerHeartbeatStateList list = new BrokerHeartbeatManager.BrokerHeartbeatStateList();
        Assertions.assertNull((Object)list.first());
        BrokerHeartbeatManager.BrokerHeartbeatStateIterator iterator = list.iterator();
        Assertions.assertFalse((boolean)iterator.hasNext());
        BrokerHeartbeatManager.BrokerHeartbeatState broker0 = new BrokerHeartbeatManager.BrokerHeartbeatState(0);
        broker0.lastContactNs = 200L;
        BrokerHeartbeatManager.BrokerHeartbeatState broker1 = new BrokerHeartbeatManager.BrokerHeartbeatState(1);
        broker1.lastContactNs = 100L;
        BrokerHeartbeatManager.BrokerHeartbeatState broker2 = new BrokerHeartbeatManager.BrokerHeartbeatState(2);
        broker2.lastContactNs = 50L;
        BrokerHeartbeatManager.BrokerHeartbeatState broker3 = new BrokerHeartbeatManager.BrokerHeartbeatState(3);
        broker3.lastContactNs = 150L;
        list.add(broker0);
        list.add(broker1);
        list.add(broker2);
        list.add(broker3);
        Assertions.assertEquals((Object)broker2, (Object)list.first());
        iterator = list.iterator();
        Assertions.assertEquals((Object)broker2, (Object)iterator.next());
        Assertions.assertEquals((Object)broker1, (Object)iterator.next());
        Assertions.assertEquals((Object)broker3, (Object)iterator.next());
        Assertions.assertEquals((Object)broker0, (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        list.remove(broker1);
        iterator = list.iterator();
        Assertions.assertEquals((Object)broker2, (Object)iterator.next());
        Assertions.assertEquals((Object)broker3, (Object)iterator.next());
        Assertions.assertEquals((Object)broker0, (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testCalculateNextBrokerState() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        for (int brokerId = 0; brokerId < 6; ++brokerId) {
            manager.register(brokerId, true);
        }
        manager.touch(0, true, 100L);
        manager.touch(1, false, 98L);
        manager.touch(2, false, 100L);
        manager.touch(3, false, 100L);
        manager.touch(4, true, 100L);
        manager.touch(5, false, 99L);
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Integer>(98L, 1), (Object)manager.lowestActiveOffsetAndBroker());
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.FENCED, BrokerControlState.SHUTDOWN_NOW), (Object)manager.calculateNextBrokerState(0, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.FENCED, BrokerControlState.UNFENCED), (Object)manager.calculateNextBrokerState(0, new BrokerHeartbeatRequestData().setWantFence(false).setCurrentMetadataOffset(100L), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.FENCED, BrokerControlState.FENCED), (Object)manager.calculateNextBrokerState(0, new BrokerHeartbeatRequestData().setWantFence(false).setCurrentMetadataOffset(50L), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.FENCED, BrokerControlState.FENCED), (Object)manager.calculateNextBrokerState(0, new BrokerHeartbeatRequestData().setWantFence(true), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.UNFENCED, BrokerControlState.CONTROLLED_SHUTDOWN), (Object)manager.calculateNextBrokerState(1, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> true));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.UNFENCED, BrokerControlState.SHUTDOWN_NOW), (Object)manager.calculateNextBrokerState(1, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.UNFENCED, BrokerControlState.UNFENCED), (Object)manager.calculateNextBrokerState(1, new BrokerHeartbeatRequestData().setWantFence(false), 100L, () -> false));
        manager.updateControlledShutdownOffset(5, 95L);
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.CONTROLLED_SHUTDOWN, BrokerControlState.CONTROLLED_SHUTDOWN), (Object)manager.calculateNextBrokerState(5, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> true));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.CONTROLLED_SHUTDOWN, BrokerControlState.SHUTDOWN_NOW), (Object)manager.calculateNextBrokerState(5, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.CONTROLLED_SHUTDOWN, BrokerControlState.CONTROLLED_SHUTDOWN), (Object)manager.calculateNextBrokerState(5, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> true));
        manager.updateControlledShutdownOffset(5, 99L);
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.CONTROLLED_SHUTDOWN, BrokerControlState.CONTROLLED_SHUTDOWN), (Object)manager.calculateNextBrokerState(5, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> false));
        manager.fence(1);
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.CONTROLLED_SHUTDOWN, BrokerControlState.SHUTDOWN_NOW), (Object)manager.calculateNextBrokerState(5, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.CONTROLLED_SHUTDOWN, BrokerControlState.CONTROLLED_SHUTDOWN), (Object)manager.calculateNextBrokerState(5, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> true));
        Assertions.assertEquals((Object)"Broker 6 is not registered.", (Object)((IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> manager.calculateNextBrokerState(6, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> true))).getMessage());
        Assertions.assertEquals((Object)"Broker 7 is not registered.", (Object)((IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> manager.calculateNextBrokerState(7, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> true))).getMessage());
    }

    @Test
    public void testTouchThrowsExceptionUnlessRegistered() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        manager.register(1, true);
        manager.register(3, true);
        Assertions.assertEquals((Object)"Broker 2 is not registered.", (Object)((IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> manager.touch(2, false, 0L))).getMessage());
        Assertions.assertEquals((Object)"Broker 4 is not registered.", (Object)((IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> manager.touch(4, false, 0L))).getMessage());
    }

    @Test
    public void testRemoveActiveBrokerAndUpdateFieldInControlledShutdown() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        Assertions.assertEquals(Collections.emptySet(), BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
        for (int brokerId = 0; brokerId < 5; ++brokerId) {
            manager.register(brokerId, true);
        }
        manager.touch(0, false, 100L);
        manager.touch(1, false, 100L);
        manager.touch(2, false, 100L);
        manager.touch(3, false, 100L);
        manager.touch(4, true, 100L);
        Iterator iter = manager.active().iterator();
        Assertions.assertEquals((int)0, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter.next()).id());
        Assertions.assertEquals((int)1, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter.next()).id());
        Assertions.assertEquals((int)2, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter.next()).id());
        Assertions.assertEquals((int)3, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter.next()).id());
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertEquals(Optional.empty(), (Object)manager.findOneStaleBroker());
        Assertions.assertThrows(RuntimeException.class, () -> manager.updateControlledShutdownOffset(4, 1500L));
        manager.updateControlledShutdownOffset(2, 1520L);
        manager.updateControlledShutdownOffset(3, 1530L);
        Assertions.assertEquals((long)1520L, (Long)((Long)manager.shutdowns().get(2)));
        Assertions.assertEquals((long)1530L, (Long)((Long)manager.shutdowns().get(3)));
        Iterator iter1 = manager.active().iterator();
        Assertions.assertEquals((int)0, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter1.next()).id());
        Assertions.assertEquals((int)1, (int)((BrokerHeartbeatManager.BrokerHeartbeatState)iter1.next()).id());
        Assertions.assertFalse((boolean)iter1.hasNext());
        Assertions.assertEquals(Optional.empty(), (Object)manager.findOneStaleBroker());
    }

    @Test
    public void testBrokerNoLongerInControlledShutdownAndOffsetResetWhenFenced() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        Assertions.assertEquals(Collections.emptySet(), BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
        for (int brokerId = 0; brokerId < 1; ++brokerId) {
            manager.register(brokerId, true);
        }
        manager.touch(0, false, 100L);
        manager.updateControlledShutdownOffset(0, 1740L);
        Assertions.assertEquals((long)1740L, (Long)((Long)manager.shutdowns().get(0)));
        manager.updateControlledShutdownOffset(0, 1790L);
        Assertions.assertEquals((long)1790L, (Long)((Long)manager.shutdowns().get(0)));
        manager.touch(0, true, 100L);
        Assertions.assertNull(manager.shutdowns().get(0));
    }

    @Test
    public void testBrokerIdsInControlledShutdown() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        Assertions.assertEquals(Collections.emptySet(), BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
        for (int brokerId = 0; brokerId < 3; ++brokerId) {
            manager.register(brokerId, true);
        }
        manager.touch(0, false, 100L);
        manager.touch(1, false, 100L);
        manager.touch(2, true, 100L);
        manager.updateControlledShutdownOffset(0, 8000L);
        manager.updateControlledShutdownOffset(1, 8005L);
        Assertions.assertEquals(new TreeSet<Integer>(Arrays.asList(0, 1)), manager.shutdowns().keySet());
    }

    @Test
    public void testLowestActiveOffsetWithNoBrokers() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Integer>(Long.MAX_VALUE, -1), (Object)manager.lowestActiveOffsetAndBroker());
    }

    @Test
    public void testLowestActiveOffsetWithOneBroker() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        manager.register(0, false);
        manager.touch(0, false, 123L);
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Integer>(123L, 0), (Object)manager.lowestActiveOffsetAndBroker());
    }

    @Test
    public void testLowestActiveOffsetWithOneFencedBroker() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        manager.register(0, true);
        manager.touch(0, true, 123L);
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Integer>(Long.MAX_VALUE, -1), (Object)manager.lowestActiveOffsetAndBroker());
    }

    @Test
    public void testLowestActiveOffsetWithTwoBrokers() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        manager.register(0, true);
        manager.touch(0, false, 123L);
        manager.register(1, false);
        manager.touch(1, false, 456L);
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Integer>(123L, 0), (Object)manager.lowestActiveOffsetAndBroker());
    }
}

