/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class RegisterBrokerRecord
implements ApiMessage {
    int brokerId;
    boolean isMigratingZkBroker;
    Uuid incarnationId;
    long brokerEpoch;
    BrokerEndpointCollection endPoints;
    BrokerFeatureCollection features;
    String rack;
    boolean fenced;
    boolean inControlledShutdown;
    List<DegradedComponent> degradedComponents;
    List<Encryptor> metadataEncryptors;
    List<Uuid> logDirs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The broker id."), new Field("incarnation_id", (Type)Type.UUID, "The incarnation ID of the broker process"), new Field("broker_epoch", (Type)Type.INT64, "The broker epoch assigned by the controller."), new Field("end_points", (Type)new CompactArrayOf((Type)BrokerEndpoint.SCHEMA_0), "The endpoints that can be used to communicate with this broker."), new Field("features", (Type)new CompactArrayOf((Type)BrokerFeature.SCHEMA_0), "The features on this broker"), new Field("rack", (Type)Type.COMPACT_NULLABLE_STRING, "The broker rack."), new Field("fenced", (Type)Type.BOOLEAN, "True if the broker is fenced."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The broker id."), new Field("incarnation_id", (Type)Type.UUID, "The incarnation ID of the broker process"), new Field("broker_epoch", (Type)Type.INT64, "The broker epoch assigned by the controller."), new Field("end_points", (Type)new CompactArrayOf((Type)BrokerEndpoint.SCHEMA_0), "The endpoints that can be used to communicate with this broker."), new Field("features", (Type)new CompactArrayOf((Type)BrokerFeature.SCHEMA_0), "The features on this broker"), new Field("rack", (Type)Type.COMPACT_NULLABLE_STRING, "The broker rack."), new Field("fenced", (Type)Type.BOOLEAN, "True if the broker is fenced."), new Field("in_controlled_shutdown", (Type)Type.BOOLEAN, "True if the broker is in controlled shutdown."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The broker id."), new Field("is_migrating_zk_broker", (Type)Type.BOOLEAN, "True if the broker is a ZK broker in migration mode. Otherwise, false"), new Field("incarnation_id", (Type)Type.UUID, "The incarnation ID of the broker process"), new Field("broker_epoch", (Type)Type.INT64, "The broker epoch assigned by the controller."), new Field("end_points", (Type)new CompactArrayOf((Type)BrokerEndpoint.SCHEMA_0), "The endpoints that can be used to communicate with this broker."), new Field("features", (Type)new CompactArrayOf((Type)BrokerFeature.SCHEMA_0), "The features on this broker"), new Field("rack", (Type)Type.COMPACT_NULLABLE_STRING, "The broker rack."), new Field("fenced", (Type)Type.BOOLEAN, "True if the broker is fenced."), new Field("in_controlled_shutdown", (Type)Type.BOOLEAN, "True if the broker is in controlled shutdown."), Field.TaggedFieldsSection.of((Object[])new Object[]{10000, new Field("degraded_components", (Type)new CompactArrayOf((Type)DegradedComponent.SCHEMA_2), "List of degraded components"), 10001, new Field("metadata_encryptors", (Type)CompactArrayOf.nullable((Type)Encryptor.SCHEMA_2), "The metadata encryptors known to this broker")})});
    public static final Schema SCHEMA_3 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The broker id."), new Field("is_migrating_zk_broker", (Type)Type.BOOLEAN, "True if the broker is a ZK broker in migration mode. Otherwise, false"), new Field("incarnation_id", (Type)Type.UUID, "The incarnation ID of the broker process"), new Field("broker_epoch", (Type)Type.INT64, "The broker epoch assigned by the controller."), new Field("end_points", (Type)new CompactArrayOf((Type)BrokerEndpoint.SCHEMA_0), "The endpoints that can be used to communicate with this broker."), new Field("features", (Type)new CompactArrayOf((Type)BrokerFeature.SCHEMA_0), "The features on this broker"), new Field("rack", (Type)Type.COMPACT_NULLABLE_STRING, "The broker rack."), new Field("fenced", (Type)Type.BOOLEAN, "True if the broker is fenced."), new Field("in_controlled_shutdown", (Type)Type.BOOLEAN, "True if the broker is in controlled shutdown."), Field.TaggedFieldsSection.of((Object[])new Object[]{10000, new Field("degraded_components", (Type)new CompactArrayOf((Type)DegradedComponent.SCHEMA_2), "List of degraded components"), 10001, new Field("metadata_encryptors", (Type)CompactArrayOf.nullable((Type)Encryptor.SCHEMA_2), "The metadata encryptors known to this broker"), 0, new Field("log_dirs", (Type)new CompactArrayOf((Type)Type.UUID), "Log directories configured in this broker which are available.")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public RegisterBrokerRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public RegisterBrokerRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public RegisterBrokerRecord() {
        this.brokerId = 0;
        this.isMigratingZkBroker = false;
        this.incarnationId = Uuid.ZERO_UUID;
        this.brokerEpoch = 0L;
        this.endPoints = new BrokerEndpointCollection(0);
        this.features = new BrokerFeatureCollection(0);
        this.rack = "";
        this.fenced = true;
        this.inControlledShutdown = false;
        this.degradedComponents = new ArrayList<DegradedComponent>(0);
        this.metadataEncryptors = null;
        this.logDirs = new ArrayList<Uuid>(0);
    }

    public short apiKey() {
        return 0;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 3;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        this.brokerId = _readable.readInt();
        this.isMigratingZkBroker = _version >= 2 ? _readable.readByte() != 0 : false;
        this.incarnationId = _readable.readUuid();
        this.brokerEpoch = _readable.readLong();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field endPoints was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ImplicitLinkedHashMultiCollection newCollection = new BrokerEndpointCollection(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((ImplicitLinkedHashCollection.Element)new BrokerEndpoint(_readable, _version, _context));
        }
        this.endPoints = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field features was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new BrokerFeatureCollection(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((ImplicitLinkedHashCollection.Element)new BrokerFeature(_readable, _version, _context));
        }
        this.features = newCollection;
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.rack = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field rack had invalid length " + length);
            }
            this.rack = _readable.readString(length);
        }
        boolean bl = this.fenced = _readable.readByte() != 0;
        this.inControlledShutdown = _version >= 1 ? _readable.readByte() != 0 : false;
        this.degradedComponents = new ArrayList<DegradedComponent>(0);
        this.metadataEncryptors = null;
        this.logDirs = new ArrayList<Uuid>(0);
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block7: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 10000: {
                    int i2;
                    ArrayList<DegradedComponent> newCollection2;
                    int arrayLength2;
                    if (_version >= 2) {
                        arrayLength2 = _readable.readUnsignedVarint() - 1;
                        if (arrayLength2 < 0) {
                            throw new RuntimeException("non-nullable field degradedComponents was serialized as null");
                        }
                        if (arrayLength2 > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        newCollection2 = new ArrayList<DegradedComponent>(arrayLength2);
                        for (i2 = 0; i2 < arrayLength2; ++i2) {
                            newCollection2.add(new DegradedComponent(_readable, _version, _context));
                        }
                        this.degradedComponents = newCollection2;
                        continue block7;
                    }
                    throw new RuntimeException("Tag 10000 is not valid for version " + _version);
                }
                case 10001: {
                    int i2;
                    ArrayList<DegradedComponent> newCollection2;
                    int arrayLength2;
                    if (_version >= 2) {
                        arrayLength2 = _readable.readUnsignedVarint() - 1;
                        if (arrayLength2 < 0) {
                            this.metadataEncryptors = null;
                            continue block7;
                        }
                        if (arrayLength2 > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        newCollection2 = new ArrayList(arrayLength2);
                        for (i2 = 0; i2 < arrayLength2; ++i2) {
                            newCollection2.add((DegradedComponent)((Object)new Encryptor(_readable, _version, _context)));
                        }
                        this.metadataEncryptors = newCollection2;
                        continue block7;
                    }
                    throw new RuntimeException("Tag 10001 is not valid for version " + _version);
                }
                case 0: {
                    int i2;
                    ArrayList<DegradedComponent> newCollection2;
                    int arrayLength2;
                    if (_version >= 3) {
                        arrayLength2 = _readable.readUnsignedVarint() - 1;
                        if (arrayLength2 < 0) {
                            throw new RuntimeException("non-nullable field logDirs was serialized as null");
                        }
                        if (arrayLength2 > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        newCollection2 = new ArrayList(arrayLength2);
                        for (i2 = 0; i2 < arrayLength2; ++i2) {
                            newCollection2.add((DegradedComponent)_readable.readUuid());
                        }
                        this.logDirs = newCollection2;
                        continue block7;
                    }
                    throw new RuntimeException("Tag 0 is not valid for version " + _version);
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.brokerId);
        if (_version >= 2) {
            _writable.writeByte(this.isMigratingZkBroker ? (byte)1 : 0);
        } else if (this.isMigratingZkBroker) {
            throw new UnsupportedVersionException("Attempted to write a non-default isMigratingZkBroker at version " + _version);
        }
        _writable.writeUuid(this.incarnationId);
        _writable.writeLong(this.brokerEpoch);
        _writable.writeUnsignedVarint(this.endPoints.size() + 1);
        Iterator iterator = this.endPoints.iterator();
        while (iterator.hasNext()) {
            BrokerEndpoint endPointsElement = (BrokerEndpoint)iterator.next();
            endPointsElement.write(_writable, _cache, _version, _context);
        }
        _writable.writeUnsignedVarint(this.features.size() + 1);
        iterator = this.features.iterator();
        while (iterator.hasNext()) {
            BrokerFeature featuresElement = (BrokerFeature)iterator.next();
            featuresElement.write(_writable, _cache, _version, _context);
        }
        if (this.rack == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.rack);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeByte(this.fenced ? (byte)1 : 0);
        if (_version >= 1) {
            _writable.writeByte(this.inControlledShutdown ? (byte)1 : 0);
        } else if (this.inControlledShutdown) {
            throw new UnsupportedVersionException("Attempted to write a non-default inControlledShutdown at version " + _version);
        }
        if (_version >= 2) {
            if (!this.degradedComponents.isEmpty()) {
                ++_numTaggedFields;
            }
        } else if (!this.degradedComponents.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default degradedComponents at version " + _version);
        }
        if (_version >= 2) {
            if (this.metadataEncryptors != null) {
                ++_numTaggedFields;
            }
        } else if (this.metadataEncryptors != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default metadataEncryptors at version " + _version);
        }
        if (_version >= 3) {
            if (!this.logDirs.isEmpty()) {
                ++_numTaggedFields;
            }
        } else if (!this.logDirs.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default logDirs at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (_version >= 3 && !this.logDirs.isEmpty()) {
            _writable.writeUnsignedVarint(0);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.logDirs).intValue());
            _writable.writeUnsignedVarint(this.logDirs.size() + 1);
            for (Uuid logDirsElement : this.logDirs) {
                _writable.writeUuid(logDirsElement);
            }
        }
        _rawWriter.writeRawTags(_writable, 10000);
        if (_version >= 2 && !this.degradedComponents.isEmpty()) {
            _writable.writeUnsignedVarint(10000);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.degradedComponents).intValue());
            _writable.writeUnsignedVarint(this.degradedComponents.size() + 1);
            for (DegradedComponent degradedComponentsElement : this.degradedComponents) {
                degradedComponentsElement.write(_writable, _cache, _version, _context);
            }
        }
        if (_version >= 2 && this.metadataEncryptors != null) {
            _writable.writeUnsignedVarint(10001);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.metadataEncryptors).intValue());
            _writable.writeUnsignedVarint(this.metadataEncryptors.size() + 1);
            for (Encryptor metadataEncryptorsElement : this.metadataEncryptors) {
                metadataEncryptorsElement.write(_writable, _cache, _version, _context);
            }
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        if (_version >= 2) {
            _size.addBytes(1);
        }
        _size.addBytes(16);
        _size.addBytes(8);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.endPoints.size() + 1)));
        Iterator iterator = this.endPoints.iterator();
        while (iterator.hasNext()) {
            BrokerEndpoint endPointsElement = (BrokerEndpoint)iterator.next();
            endPointsElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.features.size() + 1)));
        iterator = this.features.iterator();
        while (iterator.hasNext()) {
            BrokerFeature featuresElement = (BrokerFeature)iterator.next();
            featuresElement.addSize(_size, _cache, _version, _context);
        }
        if (this.rack == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = this.rack.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'rack' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.rack, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        }
        _size.addBytes(1);
        if (_version >= 1) {
            _size.addBytes(1);
        }
        if (_version >= 2 && !this.degradedComponents.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(2);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.degradedComponents.size() + 1)));
            for (DegradedComponent degradedComponentsElement : this.degradedComponents) {
                degradedComponentsElement.addSize(_size, _cache, _version, _context);
            }
            int _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.degradedComponents, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (_version >= 2 && this.metadataEncryptors != null) {
            ++_numTaggedFields;
            _size.addBytes(2);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.metadataEncryptors.size() + 1)));
            for (Encryptor metadataEncryptorsElement : this.metadataEncryptors) {
                metadataEncryptorsElement.addSize(_size, _cache, _version, _context);
            }
            int _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.metadataEncryptors, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (_version >= 3 && !this.logDirs.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.logDirs.size() + 1)));
            _size.addBytes(this.logDirs.size() * 16);
            int _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.logDirs, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RegisterBrokerRecord)) {
            return false;
        }
        RegisterBrokerRecord other = (RegisterBrokerRecord)obj;
        if (this.brokerId != other.brokerId) {
            return false;
        }
        if (this.isMigratingZkBroker != other.isMigratingZkBroker) {
            return false;
        }
        if (!this.incarnationId.equals((Object)other.incarnationId)) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.endPoints == null ? other.endPoints != null : !this.endPoints.equals((Object)other.endPoints)) {
            return false;
        }
        if (this.features == null ? other.features != null : !this.features.equals((Object)other.features)) {
            return false;
        }
        if (this.rack == null ? other.rack != null : !this.rack.equals(other.rack)) {
            return false;
        }
        if (this.fenced != other.fenced) {
            return false;
        }
        if (this.inControlledShutdown != other.inControlledShutdown) {
            return false;
        }
        if (this.degradedComponents == null ? other.degradedComponents != null : !this.degradedComponents.equals(other.degradedComponents)) {
            return false;
        }
        if (this.metadataEncryptors == null ? other.metadataEncryptors != null : !this.metadataEncryptors.equals(other.metadataEncryptors)) {
            return false;
        }
        if (this.logDirs == null ? other.logDirs != null : !this.logDirs.equals(other.logDirs)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + (this.isMigratingZkBroker ? 1231 : 1237);
        hashCode = 31 * hashCode + this.incarnationId.hashCode();
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + (this.endPoints == null ? 0 : this.endPoints.hashCode());
        hashCode = 31 * hashCode + (this.features == null ? 0 : this.features.hashCode());
        hashCode = 31 * hashCode + (this.rack == null ? 0 : this.rack.hashCode());
        hashCode = 31 * hashCode + (this.fenced ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.inControlledShutdown ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.degradedComponents == null ? 0 : this.degradedComponents.hashCode());
        hashCode = 31 * hashCode + (this.metadataEncryptors == null ? 0 : this.metadataEncryptors.hashCode());
        hashCode = 31 * hashCode + (this.logDirs == null ? 0 : this.logDirs.hashCode());
        return hashCode;
    }

    public RegisterBrokerRecord duplicate() {
        Object _element;
        RegisterBrokerRecord _duplicate = new RegisterBrokerRecord();
        _duplicate.brokerId = this.brokerId;
        _duplicate.isMigratingZkBroker = this.isMigratingZkBroker;
        _duplicate.incarnationId = this.incarnationId;
        _duplicate.brokerEpoch = this.brokerEpoch;
        BrokerEndpointCollection newEndPoints = new BrokerEndpointCollection(this.endPoints.size());
        Iterator iterator = this.endPoints.iterator();
        while (iterator.hasNext()) {
            _element = (BrokerEndpoint)iterator.next();
            newEndPoints.add(((BrokerEndpoint)_element).duplicate());
        }
        _duplicate.endPoints = newEndPoints;
        BrokerFeatureCollection newFeatures = new BrokerFeatureCollection(this.features.size());
        _element = this.features.iterator();
        while (_element.hasNext()) {
            BrokerFeature _element2 = (BrokerFeature)_element.next();
            newFeatures.add(_element2.duplicate());
        }
        _duplicate.features = newFeatures;
        _duplicate.rack = this.rack == null ? null : this.rack;
        _duplicate.fenced = this.fenced;
        _duplicate.inControlledShutdown = this.inControlledShutdown;
        ArrayList<DegradedComponent> newDegradedComponents = new ArrayList<DegradedComponent>(this.degradedComponents.size());
        for (DegradedComponent _element3 : this.degradedComponents) {
            newDegradedComponents.add(_element3.duplicate());
        }
        _duplicate.degradedComponents = newDegradedComponents;
        if (this.metadataEncryptors == null) {
            _duplicate.metadataEncryptors = null;
        } else {
            ArrayList<Encryptor> newMetadataEncryptors = new ArrayList<Encryptor>(this.metadataEncryptors.size());
            for (Encryptor encryptor : this.metadataEncryptors) {
                newMetadataEncryptors.add(encryptor.duplicate());
            }
            _duplicate.metadataEncryptors = newMetadataEncryptors;
        }
        ArrayList<Uuid> newLogDirs = new ArrayList<Uuid>(this.logDirs.size());
        for (Uuid uuid : this.logDirs) {
            newLogDirs.add(uuid);
        }
        _duplicate.logDirs = newLogDirs;
        return _duplicate;
    }

    public String toString() {
        return "RegisterBrokerRecord(brokerId=" + this.brokerId + ", isMigratingZkBroker=" + (this.isMigratingZkBroker ? "true" : "false") + ", incarnationId=" + this.incarnationId.toString() + ", brokerEpoch=" + this.brokerEpoch + ", endPoints=" + MessageUtil.deepToString((Iterator)this.endPoints.iterator()) + ", features=" + MessageUtil.deepToString((Iterator)this.features.iterator()) + ", rack=" + (this.rack == null ? "null" : "'" + this.rack.toString() + "'") + ", fenced=" + (this.fenced ? "true" : "false") + ", inControlledShutdown=" + (this.inControlledShutdown ? "true" : "false") + ", degradedComponents=" + MessageUtil.deepToString(this.degradedComponents.iterator()) + ", metadataEncryptors=" + (this.metadataEncryptors == null ? "null" : MessageUtil.deepToString(this.metadataEncryptors.iterator())) + ", logDirs=" + MessageUtil.deepToString(this.logDirs.iterator()) + ")";
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean isMigratingZkBroker() {
        return this.isMigratingZkBroker;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public BrokerEndpointCollection endPoints() {
        return this.endPoints;
    }

    public BrokerFeatureCollection features() {
        return this.features;
    }

    public String rack() {
        return this.rack;
    }

    public boolean fenced() {
        return this.fenced;
    }

    public boolean inControlledShutdown() {
        return this.inControlledShutdown;
    }

    public List<DegradedComponent> degradedComponents() {
        return this.degradedComponents;
    }

    public List<Encryptor> metadataEncryptors() {
        return this.metadataEncryptors;
    }

    public List<Uuid> logDirs() {
        return this.logDirs;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RegisterBrokerRecord setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public RegisterBrokerRecord setIsMigratingZkBroker(boolean v) {
        this.isMigratingZkBroker = v;
        return this;
    }

    public RegisterBrokerRecord setIncarnationId(Uuid v) {
        this.incarnationId = v;
        return this;
    }

    public RegisterBrokerRecord setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public RegisterBrokerRecord setEndPoints(BrokerEndpointCollection v) {
        this.endPoints = v;
        return this;
    }

    public RegisterBrokerRecord setFeatures(BrokerFeatureCollection v) {
        this.features = v;
        return this;
    }

    public RegisterBrokerRecord setRack(String v) {
        this.rack = v;
        return this;
    }

    public RegisterBrokerRecord setFenced(boolean v) {
        this.fenced = v;
        return this;
    }

    public RegisterBrokerRecord setInControlledShutdown(boolean v) {
        this.inControlledShutdown = v;
        return this;
    }

    public RegisterBrokerRecord setDegradedComponents(List<DegradedComponent> v) {
        this.degradedComponents = v;
        return this;
    }

    public RegisterBrokerRecord setMetadataEncryptors(List<Encryptor> v) {
        this.metadataEncryptors = v;
        return this;
    }

    public RegisterBrokerRecord setLogDirs(List<Uuid> v) {
        this.logDirs = v;
        return this;
    }

    public static class Encryptor
    implements Message {
        Uuid encryptorId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public Encryptor(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public Encryptor() {
            this.encryptorId = Uuid.ZERO_UUID;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Encryptor");
            }
            this.encryptorId = _readable.readUuid();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of Encryptor");
            }
            int _numTaggedFields = 0;
            _writable.writeUuid(this.encryptorId);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Encryptor");
            }
            _size.addBytes(16);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Encryptor)) {
                return false;
            }
            Encryptor other = (Encryptor)obj;
            if (!this.encryptorId.equals((Object)other.encryptorId)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.encryptorId.hashCode();
            return hashCode;
        }

        public Encryptor duplicate() {
            Encryptor _duplicate = new Encryptor();
            _duplicate.encryptorId = this.encryptorId;
            return _duplicate;
        }

        public String toString() {
            return "Encryptor(encryptorId=" + this.encryptorId.toString() + ")";
        }

        public Uuid encryptorId() {
            return this.encryptorId;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Encryptor setEncryptorId(Uuid v) {
            this.encryptorId = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field[]{new Field("encryptor_id", (Type)Type.UUID, "The UUID of the metadata encryptor."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{null, null, SCHEMA_2, SCHEMA_3};
        }
    }

    public static class DegradedComponent
    implements Message {
        String reason;
        byte componentCode;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public DegradedComponent(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public DegradedComponent() {
            this.reason = "";
            this.componentCode = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DegradedComponent");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field reason was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field reason had invalid length " + length);
            }
            this.reason = _readable.readString(length);
            this.componentCode = _readable.readByte();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DegradedComponent");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.reason);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.componentCode);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DegradedComponent");
            }
            byte[] _stringBytes = this.reason.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'reason' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.reason, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DegradedComponent)) {
                return false;
            }
            DegradedComponent other = (DegradedComponent)obj;
            if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
                return false;
            }
            if (this.componentCode != other.componentCode) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.reason == null ? 0 : this.reason.hashCode());
            hashCode = 31 * hashCode + this.componentCode;
            return hashCode;
        }

        public DegradedComponent duplicate() {
            DegradedComponent _duplicate = new DegradedComponent();
            _duplicate.reason = this.reason;
            _duplicate.componentCode = this.componentCode;
            return _duplicate;
        }

        public String toString() {
            return "DegradedComponent(reason=" + (this.reason == null ? "null" : "'" + this.reason.toString() + "'") + ", componentCode=" + this.componentCode + ")";
        }

        public String reason() {
            return this.reason;
        }

        public byte componentCode() {
            return this.componentCode;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DegradedComponent setReason(String v) {
            this.reason = v;
            return this;
        }

        public DegradedComponent setComponentCode(byte v) {
            this.componentCode = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field[]{new Field("reason", (Type)Type.COMPACT_STRING, "A unique tag representing why a broker's state is degraded."), new Field("component_code", (Type)Type.INT8, "Which component of the broker is degraded due to the provided reason (UNSPECIFIED=0, STORAGE=1)."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{null, null, SCHEMA_2, SCHEMA_3};
        }
    }

    public static class BrokerFeatureCollection
    extends ImplicitLinkedHashMultiCollection<BrokerFeature> {
        public BrokerFeatureCollection() {
        }

        public BrokerFeatureCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public BrokerFeatureCollection(Iterator<BrokerFeature> iterator) {
            super(iterator);
        }

        public BrokerFeature find(String name) {
            BrokerFeature _key = new BrokerFeature();
            _key.setName(name);
            return (BrokerFeature)this.find(_key);
        }

        public List<BrokerFeature> findAll(String name) {
            BrokerFeature _key = new BrokerFeature();
            _key.setName(name);
            return this.findAll(_key);
        }

        public BrokerFeatureCollection duplicate() {
            BrokerFeatureCollection _duplicate = new BrokerFeatureCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                BrokerFeature _element = (BrokerFeature)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class BrokerFeature
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        short minSupportedVersion;
        short maxSupportedVersion;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public BrokerFeature(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public BrokerFeature() {
            this.name = "";
            this.minSupportedVersion = 0;
            this.maxSupportedVersion = 0;
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerFeature");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.minSupportedVersion = _readable.readShort();
            this.maxSupportedVersion = _readable.readShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.minSupportedVersion);
            _writable.writeShort(this.maxSupportedVersion);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerFeature");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(2);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof BrokerFeature)) {
                return false;
            }
            BrokerFeature other = (BrokerFeature)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerFeature)) {
                return false;
            }
            BrokerFeature other = (BrokerFeature)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.minSupportedVersion != other.minSupportedVersion) {
                return false;
            }
            if (this.maxSupportedVersion != other.maxSupportedVersion) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public BrokerFeature duplicate() {
            BrokerFeature _duplicate = new BrokerFeature();
            _duplicate.name = this.name;
            _duplicate.minSupportedVersion = this.minSupportedVersion;
            _duplicate.maxSupportedVersion = this.maxSupportedVersion;
            return _duplicate;
        }

        public String toString() {
            return "BrokerFeature(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", minSupportedVersion=" + this.minSupportedVersion + ", maxSupportedVersion=" + this.maxSupportedVersion + ")";
        }

        public String name() {
            return this.name;
        }

        public short minSupportedVersion() {
            return this.minSupportedVersion;
        }

        public short maxSupportedVersion() {
            return this.maxSupportedVersion;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BrokerFeature setName(String v) {
            this.name = v;
            return this;
        }

        public BrokerFeature setMinSupportedVersion(short v) {
            this.minSupportedVersion = v;
            return this;
        }

        public BrokerFeature setMaxSupportedVersion(short v) {
            this.maxSupportedVersion = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The feature name."), new Field("min_supported_version", (Type)Type.INT16, "The minimum supported feature level."), new Field("max_supported_version", (Type)Type.INT16, "The maximum supported feature level."), Field.TaggedFieldsSection.of((Object[])new Object[0])})));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }

    public static class BrokerEndpointCollection
    extends ImplicitLinkedHashMultiCollection<BrokerEndpoint> {
        public BrokerEndpointCollection() {
        }

        public BrokerEndpointCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public BrokerEndpointCollection(Iterator<BrokerEndpoint> iterator) {
            super(iterator);
        }

        public BrokerEndpoint find(String name) {
            BrokerEndpoint _key = new BrokerEndpoint();
            _key.setName(name);
            return (BrokerEndpoint)this.find(_key);
        }

        public List<BrokerEndpoint> findAll(String name) {
            BrokerEndpoint _key = new BrokerEndpoint();
            _key.setName(name);
            return this.findAll(_key);
        }

        public BrokerEndpointCollection duplicate() {
            BrokerEndpointCollection _duplicate = new BrokerEndpointCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                BrokerEndpoint _element = (BrokerEndpoint)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class BrokerEndpoint
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        String host;
        int port;
        short securityProtocol;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public BrokerEndpoint(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public BrokerEndpoint() {
            this.name = "";
            this.host = "";
            this.port = 0;
            this.securityProtocol = 0;
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerEndpoint");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readUnsignedShort();
            this.securityProtocol = _readable.readShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue((Object)this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeUnsignedShort(this.port);
            _writable.writeShort(this.securityProtocol);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerEndpoint");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(2);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof BrokerEndpoint)) {
                return false;
            }
            BrokerEndpoint other = (BrokerEndpoint)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerEndpoint)) {
                return false;
            }
            BrokerEndpoint other = (BrokerEndpoint)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            if (this.securityProtocol != other.securityProtocol) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public BrokerEndpoint duplicate() {
            BrokerEndpoint _duplicate = new BrokerEndpoint();
            _duplicate.name = this.name;
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            _duplicate.securityProtocol = this.securityProtocol;
            return _duplicate;
        }

        public String toString() {
            return "BrokerEndpoint(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ", securityProtocol=" + this.securityProtocol + ")";
        }

        public String name() {
            return this.name;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public short securityProtocol() {
            return this.securityProtocol;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BrokerEndpoint setName(String v) {
            this.name = v;
            return this;
        }

        public BrokerEndpoint setHost(String v) {
            this.host = v;
            return this;
        }

        public BrokerEndpoint setPort(int v) {
            if (v < 0 || v > 65535) {
                throw new RuntimeException("Invalid value " + v + " for unsigned short field.");
            }
            this.port = v;
            return this;
        }

        public BrokerEndpoint setSecurityProtocol(short v) {
            this.securityProtocol = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The name of the endpoint."), new Field("host", (Type)Type.COMPACT_STRING, "The hostname."), new Field("port", (Type)Type.UINT16, "The port."), new Field("security_protocol", (Type)Type.INT16, "The security protocol."), Field.TaggedFieldsSection.of((Object[])new Object[0])})));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

