/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.bootstrap;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.NoOpRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=60L)
public class BootstrapMetadataTest {
    static final List<ApiMessageAndVersion> SAMPLE_RECORDS1 = Collections.unmodifiableList(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel((short)7), 0), new ApiMessageAndVersion((ApiMessage)new NoOpRecord(), 0), new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel((short)6), 0)));
    static final List<ApiMessageAndVersion> RECORDS_WITH_OLD_METADATA_VERSION = Collections.unmodifiableList(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_0_IV1.featureLevel()), 0)));

    @Test
    public void testFromVersion() {
        Assertions.assertEquals((Object)new BootstrapMetadata(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel((short)6), 0)), MetadataVersion.IBP_3_3_IV2, "foo"), (Object)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.IBP_3_3_IV2, (String)"foo"));
    }

    @Test
    public void testFromRecordsList() {
        Assertions.assertEquals((Object)new BootstrapMetadata(SAMPLE_RECORDS1, MetadataVersion.IBP_3_3_IV2, "bar"), (Object)BootstrapMetadata.fromRecords(SAMPLE_RECORDS1, (String)"bar"));
    }

    @Test
    public void testFromRecordsListWithoutMetadataVersion() {
        Assertions.assertEquals((Object)"No FeatureLevelRecord for metadata.version was found in the bootstrap metadata from quux", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> BootstrapMetadata.fromRecords(Collections.emptyList(), (String)"quux"))).getMessage());
    }

    @Test
    public void testCopyWithOnlyVersion() {
        Assertions.assertEquals((Object)new BootstrapMetadata(SAMPLE_RECORDS1.subList(2, 3), MetadataVersion.IBP_3_3_IV2, "baz"), (Object)BootstrapMetadata.fromRecords(SAMPLE_RECORDS1, (String)"baz").copyWithOnlyVersion());
    }

    @Test
    public void testFromRecordsListWithOldMetadataVersion() {
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> BootstrapMetadata.fromRecords(RECORDS_WITH_OLD_METADATA_VERSION, (String)"quux"));
        Assertions.assertEquals((Object)"Bootstrap metadata versions before 3.3-IV0 are not supported. Can't load metadata from quux", (Object)exception.getMessage());
    }
}

