/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.controller.metrics.ControllerMetricsChanges;
import org.apache.kafka.controller.metrics.ControllerMetricsTestUtils;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ControllerMetricsChangesTest {
    static final Uuid FOO_ID = Uuid.fromString((String)"wXtW6pQbTS2CL6PjdRCqVw");
    static final TopicDelta TOPIC_DELTA1;
    static final TopicDelta TOPIC_DELTA2;

    @Test
    public void testDelta() {
        Assertions.assertEquals((int)0, (int)ControllerMetricsChanges.delta((boolean)false, (boolean)false));
        Assertions.assertEquals((int)1, (int)ControllerMetricsChanges.delta((boolean)false, (boolean)true));
        Assertions.assertEquals((int)-1, (int)ControllerMetricsChanges.delta((boolean)true, (boolean)false));
        Assertions.assertEquals((int)0, (int)ControllerMetricsChanges.delta((boolean)true, (boolean)true));
    }

    private static BrokerRegistration brokerRegistration(int brokerId, boolean fenced) {
        return new BrokerRegistration.Builder().setId(brokerId).setEpoch(100L).setIncarnationId(Uuid.fromString((String)"Pxi6QwS2RFuN8VSKjqJZyQ")).setFenced(fenced).setInControlledShutdown(false).build();
    }

    private static BrokerRegistration zkBrokerRegistration(int brokerId) {
        return new BrokerRegistration.Builder().setId(brokerId).setEpoch(100L).setIncarnationId(Uuid.fromString((String)"Pxi6QwS2RFuN8VSKjqJZyQ")).setFenced(false).setInControlledShutdown(false).setIsMigratingZkBroker(true).build();
    }

    @Test
    public void testInitialValues() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        Assertions.assertEquals((int)0, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.activeBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.globalTopicsChange());
        Assertions.assertEquals((int)0, (int)changes.globalPartitionsChange());
        Assertions.assertEquals((int)0, (int)changes.offlinePartitionsChange());
        Assertions.assertEquals((int)0, (int)changes.partitionsWithoutPreferredLeaderChange());
    }

    @Test
    public void testHandleNewUnfencedBroker() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(null, ControllerMetricsChangesTest.brokerRegistration(1, false));
        Assertions.assertEquals((int)0, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)1, (int)changes.activeBrokersChange());
    }

    @Test
    public void testHandleNewFencedBroker() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(null, ControllerMetricsChangesTest.brokerRegistration(1, true));
        Assertions.assertEquals((int)1, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.activeBrokersChange());
    }

    @Test
    public void testHandleBrokerFencing() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(ControllerMetricsChangesTest.brokerRegistration(1, false), ControllerMetricsChangesTest.brokerRegistration(1, true));
        Assertions.assertEquals((int)1, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)-1, (int)changes.activeBrokersChange());
    }

    @Test
    public void testHandleBrokerUnfencing() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(ControllerMetricsChangesTest.brokerRegistration(1, true), ControllerMetricsChangesTest.brokerRegistration(1, false));
        Assertions.assertEquals((int)-1, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)1, (int)changes.activeBrokersChange());
    }

    @Test
    public void testHandleZkBroker() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(null, ControllerMetricsChangesTest.zkBrokerRegistration(1));
        Assertions.assertEquals((int)1, (int)changes.migratingZkBrokersChange());
        changes.handleBrokerChange(null, ControllerMetricsChangesTest.zkBrokerRegistration(2));
        changes.handleBrokerChange(null, ControllerMetricsChangesTest.zkBrokerRegistration(3));
        Assertions.assertEquals((int)3, (int)changes.migratingZkBrokersChange());
        changes.handleBrokerChange(ControllerMetricsChangesTest.zkBrokerRegistration(3), ControllerMetricsChangesTest.brokerRegistration(3, true));
        changes.handleBrokerChange(ControllerMetricsChangesTest.brokerRegistration(3, true), ControllerMetricsChangesTest.brokerRegistration(3, false));
        Assertions.assertEquals((int)2, (int)changes.migratingZkBrokersChange());
    }

    @Test
    public void testHandleDeletedTopic() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        HashMap<Integer, PartitionRegistration> partitions = new HashMap<Integer, PartitionRegistration>();
        partitions.put(0, ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL));
        partitions.put(1, ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL));
        partitions.put(2, ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NON_PREFERRED_LEADER));
        partitions.put(3, ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NON_PREFERRED_LEADER));
        partitions.put(4, ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.OFFLINE));
        TopicImage topicImage = new TopicImage("foo", Uuid.fromString((String)"wXtW6pQbTS2CL6PjdRCqVw"), partitions);
        changes.handleDeletedTopic(topicImage);
        Assertions.assertEquals((int)-1, (int)changes.globalTopicsChange());
        Assertions.assertEquals((int)-5, (int)changes.globalPartitionsChange());
        Assertions.assertEquals((int)-1, (int)changes.offlinePartitionsChange());
        Assertions.assertEquals((int)-3, (int)changes.partitionsWithoutPreferredLeaderChange());
    }

    @Test
    public void testHandleNewTopic() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleTopicChange(null, TOPIC_DELTA1);
        Assertions.assertEquals((int)1, (int)changes.globalTopicsChange());
        Assertions.assertEquals((int)5, (int)changes.globalPartitionsChange());
        Assertions.assertEquals((int)0, (int)changes.offlinePartitionsChange());
        Assertions.assertEquals((int)2, (int)changes.partitionsWithoutPreferredLeaderChange());
    }

    @Test
    public void testTopicChange() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleTopicChange(TOPIC_DELTA2.image(), TOPIC_DELTA2);
        Assertions.assertEquals((int)0, (int)changes.globalTopicsChange());
        Assertions.assertEquals((int)1, (int)changes.globalPartitionsChange());
        Assertions.assertEquals((int)0, (int)changes.offlinePartitionsChange());
        Assertions.assertEquals((int)1, (int)changes.partitionsWithoutPreferredLeaderChange());
    }

    static {
        ImageWriterOptions options = new ImageWriterOptions.Builder().setMetadataVersion(MetadataVersion.IBP_3_7_IV0).build();
        TOPIC_DELTA1 = new TopicDelta(new TopicImage("foo", FOO_ID, Collections.emptyMap()));
        TOPIC_DELTA1.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL).toRecord(FOO_ID, 0, options).message());
        TOPIC_DELTA1.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL).toRecord(FOO_ID, 1, options).message());
        TOPIC_DELTA1.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL).toRecord(FOO_ID, 2, options).message());
        TOPIC_DELTA1.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NON_PREFERRED_LEADER).toRecord(FOO_ID, 3, options).message());
        TOPIC_DELTA1.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NON_PREFERRED_LEADER).toRecord(FOO_ID, 4, options).message());
        TOPIC_DELTA2 = new TopicDelta(TOPIC_DELTA1.apply());
        TOPIC_DELTA2.replay(new PartitionChangeRecord().setPartitionId(1).setTopicId(FOO_ID).setLeader(1));
        TOPIC_DELTA2.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL).toRecord(FOO_ID, 5, options).message());
    }
}

