/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.metadata.ControllerRegistration;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuorumFeaturesTest {
    private static final Map<String, VersionRange> LOCAL;
    private static final QuorumFeatures QUORUM_FEATURES;

    @Test
    public void testDefaultFeatureMap() {
        HashMap<String, VersionRange> expectedFeatures = new HashMap<String, VersionRange>(1);
        expectedFeatures.put("metadata.version", VersionRange.of((short)MetadataVersion.MINIMUM_KRAFT_VERSION.featureLevel(), (short)MetadataVersion.LATEST_PRODUCTION.featureLevel()));
        Assertions.assertEquals(expectedFeatures, (Object)QuorumFeatures.defaultFeatureMap((boolean)false));
    }

    @Test
    public void testDefaultFeatureMapWithUnstable() {
        HashMap<String, VersionRange> expectedFeatures = new HashMap<String, VersionRange>(1);
        expectedFeatures.put("metadata.version", VersionRange.of((short)MetadataVersion.MINIMUM_KRAFT_VERSION.featureLevel(), (short)MetadataVersion.latestTesting().featureLevel()));
        Assertions.assertEquals(expectedFeatures, (Object)QuorumFeatures.defaultFeatureMap((boolean)true));
    }

    @Test
    public void testLocalSupportedFeature() {
        Assertions.assertEquals((Object)VersionRange.of((int)0, (int)3), (Object)QUORUM_FEATURES.localSupportedFeature("foo"));
        Assertions.assertEquals((Object)VersionRange.of((int)0, (int)4), (Object)QUORUM_FEATURES.localSupportedFeature("bar"));
        Assertions.assertEquals((Object)VersionRange.of((int)2, (int)2), (Object)QUORUM_FEATURES.localSupportedFeature("baz"));
        Assertions.assertEquals((Object)VersionRange.of((int)0, (int)0), (Object)QUORUM_FEATURES.localSupportedFeature("quux"));
    }

    @Test
    public void testReasonNotSupported() {
        Assertions.assertEquals(Optional.of("Local controller 0 only supports versions 0-3"), (Object)QuorumFeatures.reasonNotSupported((short)10, (String)"Local controller 0", (VersionRange)VersionRange.of((int)0, (int)3)));
        Assertions.assertEquals(Optional.empty(), (Object)QuorumFeatures.reasonNotSupported((short)3, (String)"Local controller 0", (VersionRange)VersionRange.of((int)0, (int)3)));
    }

    @Test
    public void testIsControllerId() {
        Assertions.assertTrue((boolean)QUORUM_FEATURES.isControllerId(0));
        Assertions.assertTrue((boolean)QUORUM_FEATURES.isControllerId(1));
        Assertions.assertTrue((boolean)QUORUM_FEATURES.isControllerId(2));
        Assertions.assertFalse((boolean)QUORUM_FEATURES.isControllerId(3));
    }

    @Test
    public void testZkMigrationNotReadyIfMetadataVersionTooLow() {
        Assertions.assertEquals(Optional.of("Metadata version too low at 3.0-IV1"), (Object)QUORUM_FEATURES.reasonAllControllersZkMigrationNotReady(MetadataVersion.IBP_3_0_IV1, Collections.emptyMap()));
    }

    @Test
    public void testZkMigrationReadyIfControllerRegistrationNotSupported() {
        Assertions.assertEquals(Optional.empty(), (Object)QUORUM_FEATURES.reasonAllControllersZkMigrationNotReady(MetadataVersion.IBP_3_4_IV0, Collections.emptyMap()));
    }

    @Test
    public void testZkMigrationNotReadyIfNotAllControllersRegistered() {
        Assertions.assertEquals(Optional.of("No registration found for controller 0"), (Object)QUORUM_FEATURES.reasonAllControllersZkMigrationNotReady(MetadataVersion.IBP_3_7_IV0, Collections.emptyMap()));
    }

    @Test
    public void testZkMigrationNotReadyIfControllerNotReady() {
        Assertions.assertEquals(Optional.of("Controller 0 has not enabled zookeeper.metadata.migration.enable"), (Object)QUORUM_FEATURES.reasonAllControllersZkMigrationNotReady(MetadataVersion.IBP_3_7_IV0, Collections.singletonMap(0, new ControllerRegistration.Builder().setId(0).setZkMigrationReady(false).setIncarnationId(Uuid.fromString((String)"kCBJaDGNQk6x3y5xbtQOpg")).setListeners(Collections.singletonMap("CONTROLLER", new Endpoint("CONTROLLER", SecurityProtocol.PLAINTEXT, "localhost", 9093))).build())));
    }

    @Test
    public void testZkMigrationReadyIfAllControllersReady() {
        HashMap controllers = new HashMap();
        QUORUM_FEATURES.quorumNodeIds().forEach(id -> controllers.put(id, new ControllerRegistration.Builder().setId(id.intValue()).setZkMigrationReady(true).setIncarnationId(Uuid.fromString((String)"kCBJaDGNQk6x3y5xbtQOpg")).setListeners(Collections.singletonMap("CONTROLLER", new Endpoint("CONTROLLER", SecurityProtocol.PLAINTEXT, "localhost", 9093))).build()));
        Assertions.assertEquals(Optional.empty(), (Object)QUORUM_FEATURES.reasonAllControllersZkMigrationNotReady(MetadataVersion.IBP_3_7_IV0, controllers));
    }

    static {
        HashMap<String, VersionRange> local = new HashMap<String, VersionRange>();
        local.put("foo", VersionRange.of((int)0, (int)3));
        local.put("bar", VersionRange.of((int)0, (int)4));
        local.put("baz", VersionRange.of((int)2, (int)2));
        LOCAL = Collections.unmodifiableMap(local);
        QUORUM_FEATURES = new QuorumFeatures(0, LOCAL, Arrays.asList(0, 1, 2));
    }
}

