/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.client.CannotCreateClientWithCurrentMetadataException;
import org.apache.kafka.server.common.MetadataVersion;

public final class InternalClientInfo {
    private final String endpointName;
    private final SecurityProtocol securityProtocol;
    private final String bootstrapString;
    private final boolean usingControllerBootstrap;

    public InternalClientInfo(String endpointName, SecurityProtocol securityProtocol, String bootstrapString, boolean usingControllerBootstrap) {
        this.endpointName = endpointName;
        this.securityProtocol = securityProtocol;
        this.bootstrapString = bootstrapString;
        this.usingControllerBootstrap = usingControllerBootstrap;
    }

    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public String bootstrapString() {
        return this.bootstrapString;
    }

    public boolean usingControllerBootstrap() {
        return this.usingControllerBootstrap;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(InternalClientInfo.class)) {
            return false;
        }
        InternalClientInfo other = (InternalClientInfo)o;
        return this.endpointName.equals(other.endpointName) && this.securityProtocol.equals((Object)other.securityProtocol) && this.bootstrapString.equals(other.bootstrapString) && this.usingControllerBootstrap == other.usingControllerBootstrap;
    }

    public int hashCode() {
        return Objects.hash(this.endpointName, this.securityProtocol, this.bootstrapString, this.usingControllerBootstrap);
    }

    public String toString() {
        return "InternalClientInfo(endpointName=" + this.endpointName + ", securityProtocol=" + this.securityProtocol + ", bootstrapString=" + this.bootstrapString + ", usingControllerBootstrap=" + this.usingControllerBootstrap + ")";
    }

    public static class Builder {
        private int nodeId = -1;
        private int maxComponents = 5;
        private MetadataVersion metadataVersion = MetadataVersion.MINIMUM_KRAFT_VERSION;
        private ClusterImage clusterImage = ClusterImage.EMPTY;
        private boolean tryControllerBootstrap = false;
        private boolean tryBrokerBootstrap = true;
        private String firstControllerEndpointName = null;
        private String interBrokerEndpointName = null;

        public Builder setNodeId(int nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setMaxComponents(int maxComponents) {
            this.maxComponents = maxComponents;
            return this;
        }

        public Builder setMetadataImage(MetadataImage metadataImage) {
            this.setMetadataVersion(metadataImage.features().metadataVersion());
            this.setClusterImage(metadataImage.cluster());
            return this;
        }

        public Builder setMetadataVersion(MetadataVersion metadataVersion) {
            this.metadataVersion = metadataVersion;
            return this;
        }

        public Builder setClusterImage(ClusterImage clusterImage) {
            this.clusterImage = clusterImage;
            return this;
        }

        public Builder setTryControllerBootstrap(boolean tryControllerBootstrap) {
            this.tryControllerBootstrap = tryControllerBootstrap;
            return this;
        }

        public Builder setTryBrokerBootstrap(boolean tryBrokerBootstrap) {
            this.tryBrokerBootstrap = tryBrokerBootstrap;
            return this;
        }

        public Builder setFirstControllerEndpointName(String firstControllerEndpointName) {
            this.firstControllerEndpointName = firstControllerEndpointName;
            return this;
        }

        public Builder setInterBrokerEndpointName(String interBrokerEndpointName) {
            this.interBrokerEndpointName = interBrokerEndpointName;
            return this;
        }

        public InternalClientInfo build() {
            InternalClientInfo result;
            ArrayList<String> tried = new ArrayList<String>();
            if (this.interBrokerEndpointName == null) {
                throw new ConfigException("You must set interBrokerEndpointName.");
            }
            if (this.tryControllerBootstrap) {
                if (this.firstControllerEndpointName == null) {
                    throw new ConfigException("You must set firstControllerEndpointName if tryControllerBootstrap=true");
                }
                result = this.tryBuildForControllerQuorum();
                if (result != null) {
                    return result;
                }
                tried.add("bootstrap.controller");
            }
            if (this.tryBrokerBootstrap) {
                result = this.tryBuildForBrokers();
                if (result != null) {
                    return result;
                }
                tried.add("bootstrap.server");
            }
            throw new CannotCreateClientWithCurrentMetadataException("Unable to build a " + String.join((CharSequence)" or ", tried) + " configuration from the current cluster metadata.");
        }

        private InternalClientInfo tryBuildForControllerQuorum() {
            return null;
        }

        private InternalClientInfo tryBuildForBrokers() {
            String configComponent;
            ArrayList<String> configComponents = new ArrayList<String>();
            BrokerRegistration registration = this.clusterImage.brokers().get(this.nodeId);
            if (registration != null && (configComponent = this.registrationToConfigComponent(registration)) != null) {
                configComponents.add(configComponent);
            }
            Iterator<BrokerRegistration> iterator = this.clusterImage.brokers().values().iterator();
            while (iterator.hasNext() && configComponents.size() < this.maxComponents) {
                String configComponent2;
                registration = iterator.next();
                if (registration.id() == this.nodeId || (configComponent2 = this.registrationToConfigComponent(registration)) == null) continue;
                configComponents.add(configComponent2);
            }
            if (configComponents.isEmpty()) {
                return null;
            }
            return new InternalClientInfo(this.interBrokerEndpointName, Builder.findSecurityProtocolFromBrokers(this.interBrokerEndpointName, this.clusterImage.brokers().values()), String.join((CharSequence)",", configComponents), false);
        }

        static SecurityProtocol findSecurityProtocolFromBrokers(String endpointName, Collection<BrokerRegistration> brokers) {
            for (BrokerRegistration registration : brokers) {
                Endpoint endpoint = registration.listeners().get(endpointName);
                if (endpoint == null) continue;
                return endpoint.securityProtocol();
            }
            throw new RuntimeException("Can't find security protocol for " + endpointName);
        }

        String registrationToConfigComponent(BrokerRegistration registration) {
            Endpoint endpoint = registration.listeners().get(this.interBrokerEndpointName);
            if (endpoint == null) {
                return null;
            }
            return Builder.endpointToConfigComponent(endpoint);
        }

        static String endpointToConfigComponent(Endpoint endpoint) {
            return endpoint.host() + ":" + endpoint.port();
        }
    }
}

