/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.Tenant;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.TenantRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.node.TenantImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class TenantImage {
    public static final TenantImage EMPTY = new TenantImage(Collections.emptyMap());
    private final Map<String, Tenant> tenantIdToTenant;

    public TenantImage(Map<String, Tenant> tenantIdToTenant) {
        this.tenantIdToTenant = Collections.unmodifiableMap(tenantIdToTenant);
    }

    public Map<String, Tenant> tenantIdToTenant() {
        return this.tenantIdToTenant;
    }

    public boolean isEmpty() {
        return this.tenantIdToTenant.isEmpty();
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        for (Tenant tenant : this.tenantIdToTenant.values()) {
            writer.write(new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(tenant.tenantId()).setCellId(tenant.cellId()), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantImage that = (TenantImage)o;
        return Objects.equals(this.tenantIdToTenant, that.tenantIdToTenant());
    }

    public int hashCode() {
        return Objects.hash(this.tenantIdToTenant);
    }

    public String toString() {
        return new TenantImageNode(this).stringify();
    }
}

