/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public final class ControllerMetadataMetrics
implements AutoCloseable {
    private static final MetricName FENCED_BROKER_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "FencedBrokerCount");
    private static final MetricName ACTIVE_BROKER_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "ActiveBrokerCount");
    private static final MetricName MIGRATING_ZK_BROKER_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "MigratingZkBrokerCount");
    private static final MetricName METADATA_ERROR_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "MetadataErrorCount");
    private static final MetricName ZK_MIGRATION_STATE = ControllerMetadataMetrics.getMetricName("KafkaController", "ZkMigrationState");
    private static final MetricName BROKERS_EXCLUDED_FOR_REPLICA_PLACEMENT_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "BrokersExcludedForReplicaPlacementCount");
    private static final MetricName BROKERS_WITH_DEGRADED_HEALTH_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "BrokersWithDegradedHealthCount");
    private final Optional<MetricsRegistry> registry;
    private final AtomicInteger fencedBrokerCount = new AtomicInteger(0);
    private final AtomicInteger activeBrokerCount = new AtomicInteger(0);
    private final AtomicInteger migratingZkBrokerCount = new AtomicInteger(0);
    private final AtomicInteger brokersWithDegradedHealthCount = new AtomicInteger(0);
    private final AtomicInteger excludedBrokerCount = new AtomicInteger(0);
    private final AtomicInteger metadataErrorCount = new AtomicInteger(0);
    private final AtomicInteger zkMigrationState = new AtomicInteger(-1);

    public ControllerMetadataMetrics(Optional<MetricsRegistry> registry) {
        this.registry = registry;
        registry.ifPresent(r -> r.newGauge(FENCED_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.fencedBrokerCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(ACTIVE_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.activeBrokerCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(METADATA_ERROR_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.metadataErrorCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(ZK_MIGRATION_STATE, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.zkMigrationState();
            }
        }));
        registry.ifPresent(r -> r.newGauge(MIGRATING_ZK_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.migratingZkBrokerCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(BROKERS_WITH_DEGRADED_HEALTH_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.brokersWithDegradedHealthCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(BROKERS_EXCLUDED_FOR_REPLICA_PLACEMENT_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.excludedBrokerCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(MIGRATING_ZK_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.migratingZkBrokerCount();
            }
        }));
    }

    public void setFencedBrokerCount(int brokerCount) {
        this.fencedBrokerCount.set(brokerCount);
    }

    public void addToFencedBrokerCount(int brokerCountDelta) {
        this.fencedBrokerCount.addAndGet(brokerCountDelta);
    }

    public int fencedBrokerCount() {
        return this.fencedBrokerCount.get();
    }

    public void setActiveBrokerCount(int brokerCount) {
        this.activeBrokerCount.set(brokerCount);
    }

    public void addToActiveBrokerCount(int brokerCountDelta) {
        this.activeBrokerCount.addAndGet(brokerCountDelta);
    }

    public int activeBrokerCount() {
        return this.activeBrokerCount.get();
    }

    public void setMigratingZkBrokerCount(int brokerCount) {
        this.migratingZkBrokerCount.set(brokerCount);
    }

    public void addToMigratingZkBrokerCount(int brokerCountDelta) {
        this.migratingZkBrokerCount.addAndGet(brokerCountDelta);
    }

    public int migratingZkBrokerCount() {
        return this.migratingZkBrokerCount.get();
    }

    public void setBrokersWithDegradedHealthCount(int count) {
        this.brokersWithDegradedHealthCount.set(count);
    }

    public void addToBrokersWithDegradedHealthCount(int delta) {
        this.brokersWithDegradedHealthCount.addAndGet(delta);
    }

    public int brokersWithDegradedHealthCount() {
        return this.brokersWithDegradedHealthCount.get();
    }

    public void setExcludedBrokerCount(int count) {
        this.excludedBrokerCount.set(count);
    }

    public void addToExcludedBrokerCount(int delta) {
        this.excludedBrokerCount.addAndGet(delta);
    }

    public int excludedBrokerCount() {
        return this.excludedBrokerCount.get();
    }

    public void incrementMetadataErrorCount() {
        this.metadataErrorCount.getAndIncrement();
    }

    public int metadataErrorCount() {
        return this.metadataErrorCount.get();
    }

    public void setZkMigrationState(byte migrationStateValue) {
        this.zkMigrationState.set(migrationStateValue);
    }

    public byte zkMigrationState() {
        return this.zkMigrationState.byteValue();
    }

    @Override
    public void close() {
        this.registry.ifPresent(r -> Arrays.asList(FENCED_BROKER_COUNT, ACTIVE_BROKER_COUNT, MIGRATING_ZK_BROKER_COUNT, METADATA_ERROR_COUNT, ZK_MIGRATION_STATE, BROKERS_EXCLUDED_FOR_REPLICA_PLACEMENT_COUNT, BROKERS_WITH_DEGRADED_HEALTH_COUNT).forEach(arg_0 -> ((MetricsRegistry)r).removeMetric(arg_0)));
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name);
    }
}

