/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.controller.PartitionReassignmentReplicas;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionChangeBuilder {
    private static final Logger log = LoggerFactory.getLogger(PartitionChangeBuilder.class);
    private final PartitionRegistration partition;
    private final Uuid topicId;
    private final int partitionId;
    private final IntPredicate isAcceptableLeader;
    private final MetadataVersion metadataVersion;
    private final Map<Integer, Set<DegradedBrokerHealthState>> activeBrokerComponentDegradations;
    private List<Integer> targetIsr;
    private List<Integer> targetReplicas;
    private List<Integer> targetObservers;
    private List<Integer> targetRemoving;
    private List<Integer> targetAdding;
    private List<Integer> targetRemovingObservers;
    private List<Integer> targetAddingObservers;
    private Election election = Election.ONLINE;
    private LeaderRecoveryState targetLeaderRecoveryState;
    private boolean zkMigrationEnabled;
    private int linkedLeaderEpoch;
    private PartitionRegistration.LinkState linkState;
    private List<Integer> uncleanShutdownReplicas;
    private boolean eligibleLeaderReplicasEnabled;
    private int minISR;

    public static boolean changeRecordIsNoOp(PartitionChangeRecord record, PartitionRegistration.LinkState priorLinkState) {
        if (record.isr() != null) {
            return false;
        }
        if (record.leader() != -2) {
            return false;
        }
        if (record.replicas() != null) {
            return false;
        }
        if (record.observers() != null) {
            return false;
        }
        if (record.removingReplicas() != null) {
            return false;
        }
        if (record.addingReplicas() != null) {
            return false;
        }
        if (record.removingObservers() != null) {
            return false;
        }
        if (record.addingObservers() != null) {
            return false;
        }
        if (record.leaderRecoveryState() != -1) {
            return false;
        }
        if (record.linkedLeaderEpoch() != -1) {
            return false;
        }
        return priorLinkState.levelCode == record.linkState();
    }

    public PartitionChangeBuilder(PartitionRegistration partition, Uuid topicId, int partitionId, IntPredicate isAcceptableLeader, MetadataVersion metadataVersion, Map<Integer, Set<DegradedBrokerHealthState>> activeBrokerComponentDegradations, int minISR) {
        this.partition = partition;
        this.topicId = topicId;
        this.partitionId = partitionId;
        this.isAcceptableLeader = isAcceptableLeader;
        this.metadataVersion = metadataVersion;
        this.zkMigrationEnabled = false;
        this.activeBrokerComponentDegradations = activeBrokerComponentDegradations;
        this.eligibleLeaderReplicasEnabled = false;
        this.minISR = minISR;
        this.targetIsr = Replicas.toList(partition.isr);
        this.targetReplicas = Replicas.toList(partition.replicas);
        this.targetObservers = Replicas.toList(partition.observers);
        this.targetRemoving = Replicas.toList(partition.removingReplicas);
        this.targetAdding = Replicas.toList(partition.addingReplicas);
        this.targetRemovingObservers = Replicas.toList(partition.removingObservers);
        this.targetAddingObservers = Replicas.toList(partition.addingObservers);
        this.targetLeaderRecoveryState = partition.leaderRecoveryState;
        this.linkedLeaderEpoch = partition.linkedLeaderEpoch;
        this.linkState = partition.linkState;
    }

    public PartitionChangeBuilder setTargetIsr(List<Integer> targetIsr) {
        this.targetIsr = targetIsr;
        return this;
    }

    public PartitionChangeBuilder setTargetIsrWithBrokerStates(List<AlterPartitionRequestData.BrokerState> targetIsrWithEpoch) {
        return this.setTargetIsr(targetIsrWithEpoch.stream().map(brokerState -> brokerState.brokerId()).collect(Collectors.toList()));
    }

    public PartitionChangeBuilder setTargetReplicas(List<Integer> targetReplicas) {
        this.targetReplicas = targetReplicas;
        return this;
    }

    public PartitionChangeBuilder setTargetObservers(List<Integer> targetObservers) {
        this.targetObservers = targetObservers;
        return this;
    }

    public PartitionChangeBuilder setUncleanShutdownReplicas(List<Integer> uncleanShutdownReplicas) {
        this.uncleanShutdownReplicas = uncleanShutdownReplicas;
        return this;
    }

    public PartitionChangeBuilder setElection(Election election) {
        this.election = election;
        return this;
    }

    public PartitionChangeBuilder setTargetRemoving(List<Integer> targetRemoving) {
        this.targetRemoving = targetRemoving;
        return this;
    }

    public PartitionChangeBuilder setTargetAdding(List<Integer> targetAdding) {
        this.targetAdding = targetAdding;
        return this;
    }

    public PartitionChangeBuilder setTargetRemovingObservers(List<Integer> targetRemovingObservers) {
        this.targetRemovingObservers = targetRemovingObservers;
        return this;
    }

    public PartitionChangeBuilder setTargetAddingObservers(List<Integer> targetAddingObservers) {
        this.targetAddingObservers = targetAddingObservers;
        return this;
    }

    public PartitionChangeBuilder setTargetLeaderRecoveryState(LeaderRecoveryState targetLeaderRecoveryState) {
        this.targetLeaderRecoveryState = targetLeaderRecoveryState;
        return this;
    }

    public PartitionChangeBuilder setLinkedLeaderEpoch(int linkedLeaderEpoch) {
        this.linkedLeaderEpoch = linkedLeaderEpoch;
        return this;
    }

    public PartitionChangeBuilder setLinkFailed(boolean linkFailed) {
        this.linkState = linkFailed ? PartitionRegistration.LinkState.FAILED : PartitionRegistration.LinkState.ACTIVE;
        return this;
    }

    public PartitionChangeBuilder setZkMigrationEnabled(boolean zkMigrationEnabled) {
        this.zkMigrationEnabled = zkMigrationEnabled;
        return this;
    }

    public PartitionChangeBuilder setEligibleLeaderReplicasEnabled(boolean eligibleLeaderReplicasEnabled) {
        this.eligibleLeaderReplicasEnabled = eligibleLeaderReplicasEnabled;
        return this;
    }

    ElectionResult electLeader(boolean completedReassignment) {
        Optional<ElectionResult> syncReplicaElectionResult;
        if (this.election == Election.PREFERRED) {
            return this.electPreferredLeader();
        }
        if (this.canAttemptToMoveLeadershipFromObserver(completedReassignment) && (syncReplicaElectionResult = this.electSyncReplica()).isPresent()) {
            return syncReplicaElectionResult.get();
        }
        return this.electAnyLeader();
    }

    protected boolean canAttemptToMoveLeadershipFromObserver(boolean completedReassignment) {
        if (completedReassignment && !this.targetObservers.isEmpty()) {
            return true;
        }
        if (this.isReassignmentInProgress() || this.targetObservers.isEmpty()) {
            return false;
        }
        ArrayList<Integer> syncReplicas = new ArrayList<Integer>(this.targetReplicas);
        syncReplicas.removeAll(this.targetObservers);
        boolean allSyncReplicasInIsr = this.targetIsr.containsAll(syncReplicas);
        return allSyncReplicasInIsr;
    }

    private boolean isReassignmentInProgress() {
        return PartitionReassignmentReplicas.isReassignmentInProgress(this.targetRemoving, this.targetAdding, this.targetRemovingObservers, this.targetAddingObservers);
    }

    public boolean degradedBrokersExist() {
        return this.activeBrokerComponentDegradations != null && !this.activeBrokerComponentDegradations.isEmpty();
    }

    private ElectionResult electPreferredLeader() {
        int preferredLeaderId = this.targetReplicas.get(0);
        if (this.isValidNewLeader(preferredLeaderId) && !this.isDegraded(preferredLeaderId)) {
            return new ElectionResult(preferredLeaderId, false);
        }
        return new ElectionResult(this.bestValidLeaderId(), false);
    }

    private int bestValidLeaderId() {
        if (this.isValidNewLeader(this.partition.leader) && !this.isDegraded(this.partition.leader)) {
            return this.partition.leader;
        }
        int bestValidLeaderId = -1;
        for (Integer replicaId : this.targetReplicas) {
            if (!this.isValidNewLeader(replicaId)) continue;
            if (bestValidLeaderId == -1) {
                bestValidLeaderId = replicaId;
            }
            if (this.isDegraded(replicaId)) continue;
            return replicaId;
        }
        return bestValidLeaderId;
    }

    private int bestUncleanLeaderId() {
        int bestUncleanLeaderId = -1;
        for (Integer replicaId : this.targetReplicas) {
            if (!this.isAcceptableLeader.test(replicaId)) continue;
            if (bestUncleanLeaderId == -1) {
                bestUncleanLeaderId = replicaId;
            }
            if (this.isDegraded(replicaId)) continue;
            return replicaId;
        }
        return bestUncleanLeaderId;
    }

    private ElectionResult electAnyLeader() {
        int bestUncleanLeaderId;
        int bestValidLeaderId = this.bestValidLeaderId();
        if (bestValidLeaderId != -1) {
            return new ElectionResult(bestValidLeaderId, false);
        }
        if (this.election == Election.UNCLEAN && (bestUncleanLeaderId = this.bestUncleanLeaderId()) != -1) {
            return new ElectionResult(bestUncleanLeaderId, true);
        }
        return new ElectionResult(-1, false);
    }

    public boolean isDegraded(Integer brokerId) {
        return this.degradedBrokersExist() && this.activeBrokerComponentDegradations.containsKey(brokerId);
    }

    private boolean isValidNewLeader(int replica) {
        return this.targetIsr.contains(replica) && this.isAcceptableLeader.test(replica);
    }

    private void tryElection(PartitionChangeRecord record, boolean completedReassignment) {
        ElectionResult electionResult = this.electLeader(completedReassignment);
        if (electionResult.node != this.partition.leader) {
            if (electionResult.unclean) {
                log.info("Setting new leader for topicId {}, partition {} to {} using an unclean election", new Object[]{this.topicId, this.partitionId, electionResult.node});
            } else {
                log.trace("Setting new leader for topicId {}, partition {} to {} using a clean election", new Object[]{this.topicId, this.partitionId, electionResult.node});
            }
            record.setLeader(electionResult.node);
            if (electionResult.unclean) {
                record.setIsr(Collections.singletonList(electionResult.node));
                if (this.partition.leaderRecoveryState != LeaderRecoveryState.RECOVERING && this.metadataVersion.isLeaderRecoverySupported()) {
                    record.setLeaderRecoveryState(LeaderRecoveryState.RECOVERING.value());
                }
            }
        } else {
            log.trace("Failed to find a new leader with current state: {}", (Object)this);
        }
    }

    private Optional<ElectionResult> electSyncReplica() {
        if (!this.targetObservers.contains(this.partition.leader)) {
            return Optional.empty();
        }
        Optional<Integer> onlineLeader = this.findSyncLeader(replica -> this.isValidNewLeader((int)replica) && !this.isDegraded((Integer)replica));
        if (!onlineLeader.isPresent()) {
            onlineLeader = this.findSyncLeader(this::isValidNewLeader);
        }
        return onlineLeader.map(leader -> new ElectionResult((int)leader, false));
    }

    private Optional<Integer> findSyncLeader(Predicate<Integer> leaderPredicate) {
        return this.targetReplicas.stream().filter(replica -> !this.targetObservers.contains(replica)).filter(leaderPredicate).findFirst();
    }

    void triggerLeaderEpochBumpIfNeeded(PartitionChangeRecord record) {
        if (record.leader() == -2) {
            boolean bumpLeaderEpochOnIsrShrink;
            boolean bl = bumpLeaderEpochOnIsrShrink = this.metadataVersion.isLeaderEpochBumpRequiredOnIsrShrink() || this.zkMigrationEnabled;
            if (!Replicas.contains(this.targetReplicas, this.partition.replicas)) {
                record.setLeader(this.partition.leader);
            } else if (bumpLeaderEpochOnIsrShrink && !Replicas.contains(this.targetIsr, this.partition.isr)) {
                record.setLeader(this.partition.leader);
            }
        }
    }

    private boolean completeReassignmentIfNeeded() {
        PartitionReassignmentReplicas reassignmentReplicas = new PartitionReassignmentReplicas(this.targetRemoving, this.targetAdding, this.targetReplicas, this.targetObservers, this.targetRemovingObservers, this.targetAddingObservers);
        Optional<PartitionReassignmentReplicas.CompletedReassignment> completedReassignmentOpt = reassignmentReplicas.maybeCompleteReassignment(this.targetIsr);
        if (!completedReassignmentOpt.isPresent()) {
            return false;
        }
        PartitionReassignmentReplicas.CompletedReassignment completedReassignment = completedReassignmentOpt.get();
        this.targetIsr = completedReassignment.isr;
        this.targetReplicas = completedReassignment.replicas;
        this.targetObservers = completedReassignment.observers;
        this.targetRemoving = Collections.emptyList();
        this.targetAdding = Collections.emptyList();
        this.targetRemovingObservers = Collections.emptyList();
        this.targetAddingObservers = Collections.emptyList();
        return true;
    }

    static boolean completedReassignment(PartitionChangeRecord change) {
        return change.removingReplicas() != null || change.addingReplicas() != null || change.removingObservers() != null || change.addingObservers() != null;
    }

    public Optional<ApiMessageAndVersion> build() {
        PartitionChangeRecord record = new PartitionChangeRecord().setTopicId(this.topicId).setPartitionId(this.partitionId);
        boolean completedReassignment = this.completeReassignmentIfNeeded();
        this.tryElection(record, completedReassignment);
        this.triggerLeaderEpochBumpIfNeeded(record);
        if (record.isr() == null && !this.targetIsr.isEmpty() && !this.targetIsr.equals(Replicas.toList(this.partition.isr))) {
            record.setIsr(this.targetIsr);
        }
        this.setAssignmentChanges(record);
        if (this.targetLeaderRecoveryState != this.partition.leaderRecoveryState) {
            record.setLeaderRecoveryState(this.targetLeaderRecoveryState.value());
        }
        if (this.partition.isMirror()) {
            if (this.linkedLeaderEpoch != this.partition.linkedLeaderEpoch) {
                record.setLinkedLeaderEpoch(this.linkedLeaderEpoch);
            }
            record.setLinkState(this.linkState.levelCode);
        }
        if (PartitionChangeBuilder.changeRecordIsNoOp(record, this.partition.linkState)) {
            return Optional.empty();
        }
        return Optional.of(new ApiMessageAndVersion((ApiMessage)record, this.metadataVersion.partitionChangeRecordVersion()));
    }

    private void setAssignmentChanges(PartitionChangeRecord record) {
        if (!this.targetReplicas.isEmpty() && !this.targetReplicas.equals(Replicas.toList(this.partition.replicas))) {
            record.setReplicas(this.targetReplicas);
        }
        if (!this.targetObservers.equals(Replicas.toList(this.partition.observers))) {
            record.setObservers(this.targetObservers);
        }
        if (!this.targetRemoving.equals(Replicas.toList(this.partition.removingReplicas))) {
            record.setRemovingReplicas(this.targetRemoving);
        }
        if (!this.targetAdding.equals(Replicas.toList(this.partition.addingReplicas))) {
            record.setAddingReplicas(this.targetAdding);
        }
        if (!this.targetRemovingObservers.equals(Replicas.toList(this.partition.removingObservers))) {
            record.setRemovingObservers(this.targetRemovingObservers);
        }
        if (!this.targetAddingObservers.equals(Replicas.toList(this.partition.addingObservers))) {
            record.setAddingObservers(this.targetAddingObservers);
        }
    }

    public String toString() {
        return "PartitionChangeBuilder(partition=" + this.partition + ", topicId=" + this.topicId + ", partitionId=" + this.partitionId + ", isAcceptableLeader=" + this.isAcceptableLeader + ", targetIsr=" + this.targetIsr + ", targetReplicas=" + this.targetReplicas + ", targetObservers=" + this.targetObservers + ", targetRemoving=" + this.targetRemoving + ", targetAdding=" + this.targetAdding + ", targetRemovingObservers=" + this.targetRemovingObservers + ", targetAddingObservers=" + this.targetAddingObservers + ", uncleanShutdownReplicas=" + this.uncleanShutdownReplicas + ", election=" + (Object)((Object)this.election) + ", targetLeaderRecoveryState=" + (Object)((Object)this.targetLeaderRecoveryState) + ", linkedLeaderEpoch=" + this.linkedLeaderEpoch + ", linkState=" + (Object)((Object)this.linkState) + ')';
    }

    static class ElectionResult {
        final int node;
        final boolean unclean;

        private ElectionResult(int node, boolean unclean) {
            this.node = node;
            this.unclean = unclean;
        }
    }

    public static enum Election {
        PREFERRED,
        ONLINE,
        UNCLEAN;

    }
}

