/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterBrokerHealthRequestData;
import org.apache.kafka.common.message.AlterBrokerHealthResponseData;
import org.apache.kafka.common.message.AlterBrokerReplicaExclusionsRequestData;
import org.apache.kafka.common.message.AlterCellResponseData;
import org.apache.kafka.common.message.AlterMirrorTopicsRequestData;
import org.apache.kafka.common.message.AlterMirrorTopicsResponseData;
import org.apache.kafka.common.message.AlterMirrorsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.AssignBrokersToCellResponseData;
import org.apache.kafka.common.message.AssignTenantsToCellResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreateCellResponseData;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.message.CreateClusterLinksResponseData;
import org.apache.kafka.common.message.CreateDelegationTokenRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteCellResponseData;
import org.apache.kafka.common.message.DeleteClusterLinksRequestData;
import org.apache.kafka.common.message.DeleteClusterLinksResponseData;
import org.apache.kafka.common.message.DeleteTenantsResponseData;
import org.apache.kafka.common.message.DescribeBrokerHealthResponseData;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.common.message.DescribeTenantsResponseData;
import org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.ExpireDelegationTokenRequestData;
import org.apache.kafka.common.message.ExpireDelegationTokenResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.RenewDelegationTokenRequestData;
import org.apache.kafka.common.message.RenewDelegationTokenResponseData;
import org.apache.kafka.common.message.UnAssignBrokersFromCellResponseData;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.AlterCellRequest;
import org.apache.kafka.common.requests.AlterMirrorsRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.AssignBrokersToCellRequest;
import org.apache.kafka.common.requests.AssignTenantsToCellRequest;
import org.apache.kafka.common.requests.CreateCellRequest;
import org.apache.kafka.common.requests.DeleteCellRequest;
import org.apache.kafka.common.requests.DeleteTenantsRequest;
import org.apache.kafka.common.requests.DescribeCellsRequest;
import org.apache.kafka.common.requests.DescribeTenantsRequest;
import org.apache.kafka.common.requests.UnAssignBrokersFromCellRequest;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.server.common.AlterReplicaExclusionsReply;

public interface Controller
extends AclMutator,
AutoCloseable {
    public CompletableFuture<AlterPartitionResponseData> alterPartition(ControllerRequestContext var1, AlterPartitionRequestData var2);

    public CompletableFuture<AlterUserScramCredentialsResponseData> alterUserScramCredentials(ControllerRequestContext var1, AlterUserScramCredentialsRequestData var2);

    public CompletableFuture<CreateDelegationTokenResponseData> createDelegationToken(ControllerRequestContext var1, CreateDelegationTokenRequestData var2);

    public CompletableFuture<RenewDelegationTokenResponseData> renewDelegationToken(ControllerRequestContext var1, RenewDelegationTokenRequestData var2);

    public CompletableFuture<ExpireDelegationTokenResponseData> expireDelegationToken(ControllerRequestContext var1, ExpireDelegationTokenRequestData var2);

    public CompletableFuture<CreateTopicsResponseData> createTopics(ControllerRequestContext var1, CreateTopicsRequestData var2, Set<String> var3);

    public CompletableFuture<Void> unregisterBroker(ControllerRequestContext var1, int var2);

    public CompletableFuture<Map<String, ResultOrError<Uuid>>> findTopicIds(ControllerRequestContext var1, Collection<String> var2);

    public CompletableFuture<Map<String, Uuid>> findAllTopicIds(ControllerRequestContext var1);

    public CompletableFuture<Map<Uuid, ResultOrError<String>>> findTopicNames(ControllerRequestContext var1, Collection<Uuid> var2);

    public CompletableFuture<Map<Uuid, ApiError>> deleteTopics(ControllerRequestContext var1, Collection<Uuid> var2);

    public CompletableFuture<Map<ConfigResource, ResultOrError<Map<String, String>>>> describeConfigs(ControllerRequestContext var1, Map<ConfigResource, Collection<String>> var2);

    public CompletableFuture<ElectLeadersResponseData> electLeaders(ControllerRequestContext var1, ElectLeadersRequestData var2);

    public CompletableFuture<FinalizedControllerFeatures> finalizedFeatures(ControllerRequestContext var1);

    public CompletableFuture<Map<ConfigResource, ApiError>> incrementalAlterConfigs(ControllerRequestContext var1, Map<ConfigResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>>> var2, boolean var3);

    public CompletableFuture<MetadataResponseData.MetadataResponseBrokerCollection> unfencedBrokerEndpoints(ControllerRequestContext var1, ListenerName var2);

    public CompletableFuture<AlterPartitionReassignmentsResponseData> alterPartitionReassignments(ControllerRequestContext var1, AlterPartitionReassignmentsRequestData var2);

    public CompletableFuture<ListPartitionReassignmentsResponseData> listPartitionReassignments(ControllerRequestContext var1, ListPartitionReassignmentsRequestData var2);

    public CompletableFuture<Map<ConfigResource, ApiError>> legacyAlterConfigs(ControllerRequestContext var1, Map<ConfigResource, Map<String, String>> var2, boolean var3);

    public CompletableFuture<BrokerHeartbeatReply> processBrokerHeartbeat(ControllerRequestContext var1, BrokerHeartbeatRequestData var2);

    public CompletableFuture<BrokerRegistrationReply> registerBroker(ControllerRequestContext var1, BrokerRegistrationRequestData var2);

    public CompletableFuture<Void> waitForReadyBrokers(int var1);

    public CompletableFuture<Map<ClientQuotaEntity, ApiError>> alterClientQuotas(ControllerRequestContext var1, Collection<ClientQuotaAlteration> var2, boolean var3);

    public CompletableFuture<AlterReplicaExclusionsReply> alterBrokerReplicaExclusions(ControllerRequestContext var1, AlterBrokerReplicaExclusionsRequestData var2);

    public CompletableFuture<Map<Integer, String>> describeBrokerReplicaExclusions(ControllerRequestContext var1);

    public CompletableFuture<AlterBrokerHealthResponseData> alterBrokerHealth(ControllerRequestContext var1, AlterBrokerHealthRequestData var2);

    public CompletableFuture<DescribeBrokerHealthResponseData> describeBrokerHealth(ControllerRequestContext var1);

    public CompletableFuture<AllocateProducerIdsResponseData> allocateProducerIds(ControllerRequestContext var1, AllocateProducerIdsRequestData var2);

    public CompletableFuture<UpdateFeaturesResponseData> updateFeatures(ControllerRequestContext var1, UpdateFeaturesRequestData var2);

    public CompletableFuture<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>> createPartitions(ControllerRequestContext var1, List<CreatePartitionsRequestData.CreatePartitionsTopic> var2, boolean var3);

    public CompletableFuture<CreateClusterLinksResponseData> createClusterLinks(ControllerRequestContext var1, CreateClusterLinksRequestData var2, KafkaPrincipal var3);

    public CompletableFuture<DeleteClusterLinksResponseData> deleteClusterLinks(ControllerRequestContext var1, DeleteClusterLinksRequestData var2);

    public CompletableFuture<AlterMirrorTopicsResponseData> alterMirrorTopic(ControllerRequestContext var1, AlterMirrorTopicsRequestData var2);

    public CompletableFuture<AlterMirrorsResponseData> alterMirrors(ControllerRequestContext var1, AlterMirrorsRequest var2);

    public CompletableFuture<DescribeCellsResponseData> describeCells(ControllerRequestContext var1, DescribeCellsRequest var2);

    public CompletableFuture<CreateCellResponseData> createCell(ControllerRequestContext var1, CreateCellRequest var2);

    public CompletableFuture<DeleteCellResponseData> deleteCell(ControllerRequestContext var1, DeleteCellRequest var2);

    public CompletableFuture<AlterCellResponseData> alterCell(ControllerRequestContext var1, AlterCellRequest var2);

    public CompletableFuture<AssignBrokersToCellResponseData> assignBrokersToCell(ControllerRequestContext var1, AssignBrokersToCellRequest var2);

    public CompletableFuture<UnAssignBrokersFromCellResponseData> unassignBrokersFromCell(ControllerRequestContext var1, UnAssignBrokersFromCellRequest var2);

    public CompletableFuture<AssignTenantsToCellResponseData> assignTenantsToCell(ControllerRequestContext var1, AssignTenantsToCellRequest var2);

    public CompletableFuture<DescribeTenantsResponseData> describeTenants(ControllerRequestContext var1, DescribeTenantsRequest var2);

    public CompletableFuture<DeleteTenantsResponseData> deleteTenants(ControllerRequestContext var1, DeleteTenantsRequest var2);

    public void beginShutdown();

    public int curClaimEpoch();

    default public boolean isActive() {
        return this.curClaimEpoch() != -1;
    }

    @Override
    public void close() throws InterruptedException;
}

