/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.image.node.TopicImageNode;

public class TopicsImageByIdNode
implements MetadataNode {
    public static final String NAME = "byId";
    private final TopicsImage image;

    public TopicsImageByIdNode(TopicsImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        ArrayList<String> childNames = new ArrayList<String>();
        for (Uuid id : this.image.topicsById().keySet()) {
            childNames.add(id.toString());
        }
        return childNames;
    }

    @Override
    public MetadataNode child(String name) {
        Uuid id;
        try {
            id = Uuid.fromString((String)name);
        }
        catch (Exception e) {
            return null;
        }
        TopicImage topicImage = this.image.topicsById().get(id);
        if (topicImage == null) {
            return null;
        }
        return new TopicImageNode(topicImage);
    }
}

