/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.placement;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellLoad;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.placement.CellAssignor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CellAssignorTest {
    Random random = new Random(0L);

    CellAssignorTest() {
    }

    @Test
    void testComputeUsableCell() {
        MockTime time = new MockTime(0L, 1000L, 0L);
        CellAssignor cellAssignor = new CellAssignor(this.random, (Time)time);
        short minSize = 2;
        short maxSize = 3;
        List<Cell> cells = Arrays.asList(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1)), CellState.READY, minSize, maxSize), new Cell(1, new HashSet<Integer>(Arrays.asList(2, 3)), CellState.READY, minSize, maxSize), new Cell(2, new HashSet<Integer>(Arrays.asList(4, 5)), CellState.READY, minSize, maxSize));
        Assertions.assertEquals(Optional.empty(), (Object)cellAssignor.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2)), new ArrayList(), 1));
        Assertions.assertEquals(Optional.of(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1)), CellState.READY, minSize, maxSize)), (Object)cellAssignor.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), cells, 1));
        Assertions.assertEquals(Optional.of(new Cell(1, new HashSet<Integer>(Arrays.asList(2, 3)), CellState.READY, minSize, maxSize)), (Object)cellAssignor.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), cells, 1));
        Assertions.assertEquals(Optional.of(new Cell(2, new HashSet<Integer>(Arrays.asList(4, 5)), CellState.READY, minSize, maxSize)), (Object)cellAssignor.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), cells, 1));
        Assertions.assertEquals(Optional.of(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1)), CellState.READY, minSize, maxSize)), (Object)cellAssignor.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), cells, 1));
        HashSet<CellLoad> cellLoads = new HashSet<CellLoad>(Arrays.asList(new CellLoad(0, 0.5), new CellLoad(1, 0.1), new CellLoad(2, 0.1)));
        cellAssignor.fullUpdateCellLoadCache(cellLoads, 1000L);
        Assertions.assertEquals(Optional.of(new Cell(1, new HashSet<Integer>(Arrays.asList(2, 3)), CellState.READY, minSize, maxSize)), (Object)cellAssignor.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), cells, 1));
        Assertions.assertEquals(Optional.of(new Cell(1, new HashSet<Integer>(Arrays.asList(2, 3)), CellState.READY, minSize, maxSize)), (Object)cellAssignor.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), cells, 1));
        Assertions.assertEquals(Optional.of(new Cell(1, new HashSet<Integer>(Arrays.asList(2, 3)), CellState.READY, minSize, maxSize)), (Object)cellAssignor.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), cells, 1));
        Assertions.assertEquals(Optional.of(new Cell(2, new HashSet<Integer>(Arrays.asList(4, 5)), CellState.READY, minSize, maxSize)), (Object)cellAssignor.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), cells, 1));
    }

    @Test
    void testComputeUsableCellPowerOfTwoSimulation() {
        int runs = 100000;
        long currTime = 0L;
        MockTime time = new MockTime(0L, currTime, currTime);
        CellAssignor cellAssignor = new CellAssignor(this.random, (Time)time);
        short minSize = 1;
        short maxSize = 2;
        List<Cell> cells = Arrays.asList(new Cell(0, new HashSet<Integer>(Collections.singletonList(0)), CellState.READY, minSize, maxSize), new Cell(1, new HashSet<Integer>(Collections.singletonList(1)), CellState.READY, minSize, maxSize), new Cell(2, new HashSet<Integer>(Collections.singletonList(2)), CellState.READY, minSize, maxSize), new Cell(3, new HashSet<Integer>(Collections.singletonList(3)), CellState.READY, minSize, maxSize), new Cell(4, new HashSet<Integer>(Collections.singletonList(4)), CellState.READY, minSize, maxSize));
        HashSet<CellLoad> cellLoads = new HashSet<CellLoad>(Arrays.asList(new CellLoad(0, 0.0), new CellLoad(1, 0.1), new CellLoad(2, 0.2), new CellLoad(3, 0.3), new CellLoad(4, 0.4)));
        cellAssignor.fullUpdateCellLoadCache(cellLoads, currTime);
        List<AtomicInteger> cellsChosen = Arrays.asList(new AtomicInteger(), new AtomicInteger(), new AtomicInteger(), new AtomicInteger(), new AtomicInteger());
        for (int i = 0; i < runs; ++i) {
            Cell chosenCell = (Cell)cellAssignor.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4)), cells, 1).get();
            cellsChosen.get(chosenCell.cellId()).getAndIncrement();
        }
        double firstChosenRatio = (double)cellsChosen.get(0).get() / (double)runs;
        double secondChosenRatio = (double)cellsChosen.get(1).get() / (double)runs;
        double thirdChosenRatio = (double)cellsChosen.get(2).get() / (double)runs;
        double fourthChosenRatio = (double)cellsChosen.get(3).get() / (double)runs;
        double fifthChosenRatio = (double)cellsChosen.get(4).get() / (double)runs;
        double error = 0.01;
        Assertions.assertTrue((Math.abs(firstChosenRatio - 0.4) < error ? 1 : 0) != 0);
        Assertions.assertTrue((Math.abs(secondChosenRatio - 0.3) < error ? 1 : 0) != 0);
        Assertions.assertTrue((Math.abs(thirdChosenRatio - 0.2) < error ? 1 : 0) != 0);
        Assertions.assertTrue((Math.abs(fourthChosenRatio - 0.1) < error ? 1 : 0) != 0);
        Assertions.assertEquals((double)0.0, (double)fifthChosenRatio);
    }

    @Test
    void testComputeUsableCellBrokerCountConsideration() {
        int runs = 100;
        long currTime = 1000L;
        MockTime time = new MockTime(0L, currTime, currTime);
        CellAssignor cellAssignor = new CellAssignor(this.random, (Time)time);
        List<Cell> cells = Arrays.asList(new Cell(0, new HashSet<Integer>(Collections.singletonList(0)), CellState.READY, 1, 1), new Cell(1, new HashSet<Integer>(Arrays.asList(1, 2, 3, 4, 5)), CellState.READY, 5, 5));
        HashSet<CellLoad> cellLoads = new HashSet<CellLoad>(Arrays.asList(new CellLoad(0, 0.0), new CellLoad(1, 0.1)));
        cellAssignor.fullUpdateCellLoadCache(cellLoads, currTime);
        List<AtomicInteger> cellsChosen = Arrays.asList(new AtomicInteger(), new AtomicInteger());
        for (int i = 0; i < runs; ++i) {
            Cell chosenCell = (Cell)cellAssignor.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), cells, 5).get();
            cellsChosen.get(chosenCell.cellId()).getAndIncrement();
        }
        double firstChosenRatio = (double)cellsChosen.get(0).get() / (double)runs;
        double secondChosenRatio = (double)cellsChosen.get(1).get() / (double)runs;
        Assertions.assertEquals((double)0.0, (double)firstChosenRatio);
        Assertions.assertEquals((double)1.0, (double)secondChosenRatio);
    }

    @Test
    void testCheckCellMetadata() {
        Cell assignableCell = new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1)), CellState.READY, 2, 2);
        Cell unassignableCell = new Cell(0, new HashSet<Integer>(Collections.singletonList(0)), CellState.READY, 2, 2);
        HashSet<Integer> usableBrokers = new HashSet<Integer>(Arrays.asList(0, 1));
        short replicationFactor = 3;
        Assertions.assertThrows(InvalidRequestException.class, () -> CellAssignor.checkCellMetadata((Cell)new Cell(0, new HashSet(), CellState.READY, -1, 2), (Cell)assignableCell, (Set)usableBrokers, (short)replicationFactor, (int)0));
        Assertions.assertThrows(InvalidRequestException.class, () -> CellAssignor.checkCellMetadata((Cell)new Cell(0, new HashSet(), CellState.READY, 1, -2), (Cell)assignableCell, (Set)usableBrokers, (short)replicationFactor, (int)0));
        Assertions.assertThrows(InvalidRequestException.class, () -> CellAssignor.checkCellMetadata((Cell)new Cell(0, new HashSet(), CellState.READY, 2, 1), (Cell)assignableCell, (Set)usableBrokers, (short)replicationFactor, (int)0));
        Assertions.assertThrows(InvalidRequestException.class, () -> CellAssignor.checkCellMetadata((Cell)new Cell(-1, new HashSet(), CellState.READY, 2, 3), (Cell)assignableCell, (Set)usableBrokers, (short)replicationFactor, (int)0));
        Assertions.assertThrows(InvalidRequestException.class, () -> CellAssignor.checkCellMetadata((Cell)new Cell(-1, new HashSet(), CellState.UNKNOWN, 2, 3), (Cell)assignableCell, (Set)usableBrokers, (short)replicationFactor, (int)0));
        Assertions.assertThrows(InvalidRequestException.class, () -> CellAssignor.checkCellMetadata((Cell)new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2, 3)), CellState.READY, 2, 3), (Cell)assignableCell, (Set)usableBrokers, (short)replicationFactor, (int)0));
        Assertions.assertThrows(InvalidRequestException.class, () -> CellAssignor.checkCellMetadata((Cell)new Cell(0, new HashSet<Integer>(Collections.singletonList(0)), CellState.READY, 2, 3), (Cell)assignableCell, (Set)usableBrokers, (short)replicationFactor, (int)1));
        Assertions.assertThrows(InvalidRequestException.class, () -> CellAssignor.checkCellMetadata((Cell)new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1)), CellState.READY, 6, 6), (Cell)assignableCell, (Set)usableBrokers, (short)replicationFactor, (int)1));
        Assertions.assertThrows(InvalidRequestException.class, () -> CellAssignor.checkCellMetadata((Cell)new Cell(0, new HashSet<Integer>(Collections.singletonList(0)), CellState.READY, 2, 3), (Cell)assignableCell, (Set)usableBrokers, (short)replicationFactor, (int)1));
        Assertions.assertThrows(InvalidRequestException.class, () -> CellAssignor.checkCellMetadata((Cell)new Cell(0, new HashSet(), CellState.READY, 2, 2), (Cell)unassignableCell, (Set)usableBrokers, (short)replicationFactor, (int)1));
        Assertions.assertThrows(InvalidRequestException.class, () -> CellAssignor.checkCellMetadata((Cell)new Cell(0, new HashSet<Integer>(Collections.singletonList(0)), CellState.READY, 3, 3), (Cell)unassignableCell, (Set)usableBrokers, (short)replicationFactor, (int)1));
        CellAssignor.checkCellMetadata((Cell)new Cell(0, new HashSet<Integer>(Collections.singletonList(0)), CellState.READY, 2, 3), (Cell)assignableCell, usableBrokers, (short)replicationFactor, (int)0);
        CellAssignor.checkCellMetadata((Cell)new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1)), CellState.READY, 6, 6), (Cell)assignableCell, usableBrokers, (short)replicationFactor, (int)0);
    }

    @Test
    void testConfirmInitialCellStateValid() {
        Assertions.assertThrows(RuntimeException.class, () -> CellAssignor.confirmInitialCellStateValid((short)0, (short)3, (short)0));
        Assertions.assertThrows(RuntimeException.class, () -> CellAssignor.confirmInitialCellStateValid((short)2, (short)3, (short)1));
        Assertions.assertThrows(RuntimeException.class, () -> CellAssignor.confirmInitialCellStateValid((short)3, (short)2, (short)3));
        CellAssignor.confirmInitialCellStateValid((short)3, (short)4, (short)4);
    }

    @Test
    void testCalculatePartitionPlacementStrategy() {
        MultiTenantPrincipal healthcheckTenantPrincipal = new MultiTenantPrincipal("lkc-abcd", new TenantMetadata.Builder("tenant1", null).healthcheckTenant(true).build());
        MultiTenantPrincipal multiTenantPrincipal = new MultiTenantPrincipal("lkc-abcd", new TenantMetadata.Builder("tenant1", null).healthcheckTenant(false).build());
        KafkaPrincipal kafkaPrincipal = KafkaPrincipal.ANONYMOUS;
        Assertions.assertEquals((Object)PartitionPlacementStrategy.PARTITION_IN_CELL, (Object)CellAssignor.calculatePartitionPlacementStrategy(Optional.empty(), (PartitionPlacementStrategy)PartitionPlacementStrategy.TENANT_IN_CELL));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.PARTITION_IN_CELL, (Object)CellAssignor.calculatePartitionPlacementStrategy(Optional.of(kafkaPrincipal), (PartitionPlacementStrategy)PartitionPlacementStrategy.TENANT_IN_CELL));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.TENANT_IN_CELL, (Object)CellAssignor.calculatePartitionPlacementStrategy(Optional.of(multiTenantPrincipal), (PartitionPlacementStrategy)PartitionPlacementStrategy.TENANT_IN_CELL));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.PARTITION_IN_CELL, (Object)CellAssignor.calculatePartitionPlacementStrategy(Optional.of(healthcheckTenantPrincipal), (PartitionPlacementStrategy)PartitionPlacementStrategy.TENANT_IN_CELL));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.CLUSTER_WIDE, (Object)CellAssignor.calculatePartitionPlacementStrategy(Optional.empty(), (PartitionPlacementStrategy)PartitionPlacementStrategy.CLUSTER_WIDE));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.CLUSTER_WIDE, (Object)CellAssignor.calculatePartitionPlacementStrategy(Optional.of(kafkaPrincipal), (PartitionPlacementStrategy)PartitionPlacementStrategy.CLUSTER_WIDE));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.CLUSTER_WIDE, (Object)CellAssignor.calculatePartitionPlacementStrategy(Optional.of(multiTenantPrincipal), (PartitionPlacementStrategy)PartitionPlacementStrategy.CLUSTER_WIDE));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.CLUSTER_WIDE, (Object)CellAssignor.calculatePartitionPlacementStrategy(Optional.of(healthcheckTenantPrincipal), (PartitionPlacementStrategy)PartitionPlacementStrategy.CLUSTER_WIDE));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.PARTITION_IN_CELL, (Object)CellAssignor.calculatePartitionPlacementStrategy(Optional.empty(), (PartitionPlacementStrategy)PartitionPlacementStrategy.PARTITION_IN_CELL));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.PARTITION_IN_CELL, (Object)CellAssignor.calculatePartitionPlacementStrategy(Optional.of(kafkaPrincipal), (PartitionPlacementStrategy)PartitionPlacementStrategy.PARTITION_IN_CELL));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.PARTITION_IN_CELL, (Object)CellAssignor.calculatePartitionPlacementStrategy(Optional.of(multiTenantPrincipal), (PartitionPlacementStrategy)PartitionPlacementStrategy.PARTITION_IN_CELL));
        Assertions.assertEquals((Object)PartitionPlacementStrategy.PARTITION_IN_CELL, (Object)CellAssignor.calculatePartitionPlacementStrategy(Optional.of(healthcheckTenantPrincipal), (PartitionPlacementStrategy)PartitionPlacementStrategy.PARTITION_IN_CELL));
    }

    @Test
    void testIsTenantCellPlacementEnabled() {
        MultiTenantPrincipal healthcheckTenantPrincipal = new MultiTenantPrincipal("lkc-abcd", new TenantMetadata.Builder("tenant1", null).healthcheckTenant(true).build());
        MultiTenantPrincipal multiTenantPrincipal = new MultiTenantPrincipal("lkc-abcd", new TenantMetadata.Builder("tenant1", null).healthcheckTenant(false).build());
        KafkaPrincipal kafkaPrincipal = KafkaPrincipal.ANONYMOUS;
        Assertions.assertTrue((boolean)CellAssignor.isTenantCellPlacementEnabled(Optional.of(multiTenantPrincipal), (PartitionPlacementStrategy)PartitionPlacementStrategy.TENANT_IN_CELL));
        Assertions.assertFalse((boolean)CellAssignor.isTenantCellPlacementEnabled(Optional.of(multiTenantPrincipal), (PartitionPlacementStrategy)PartitionPlacementStrategy.PARTITION_IN_CELL));
        Assertions.assertFalse((boolean)CellAssignor.isTenantCellPlacementEnabled(Optional.of(multiTenantPrincipal), (PartitionPlacementStrategy)PartitionPlacementStrategy.CLUSTER_WIDE));
        for (KafkaPrincipal principal : Arrays.asList(healthcheckTenantPrincipal, kafkaPrincipal, null)) {
            Assertions.assertFalse((boolean)CellAssignor.isTenantCellPlacementEnabled(Optional.ofNullable(principal), (PartitionPlacementStrategy)PartitionPlacementStrategy.TENANT_IN_CELL));
            Assertions.assertFalse((boolean)CellAssignor.isTenantCellPlacementEnabled(Optional.ofNullable(principal), (PartitionPlacementStrategy)PartitionPlacementStrategy.PARTITION_IN_CELL));
            Assertions.assertFalse((boolean)CellAssignor.isTenantCellPlacementEnabled(Optional.ofNullable(principal), (PartitionPlacementStrategy)PartitionPlacementStrategy.CLUSTER_WIDE));
        }
    }

    @Test
    void testIsCellOpenForAssignment() {
        Cell cell = new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), CellState.READY, 6, 6);
        Assertions.assertTrue((boolean)CellAssignor.isCellOpenForAssignment((Cell)cell, new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), (int)3));
        Assertions.assertTrue((boolean)CellAssignor.isCellOpenForAssignment((Cell)cell, new HashSet<Integer>(Arrays.asList(0, 1, 2)), (int)3));
        Assertions.assertTrue((boolean)CellAssignor.isCellOpenForAssignment((Cell)cell, new HashSet<Integer>(Arrays.asList(0, 3, 5)), (int)3));
        Assertions.assertTrue((boolean)CellAssignor.isCellOpenForAssignment((Cell)cell, new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), (int)2));
        Assertions.assertFalse((boolean)CellAssignor.isCellOpenForAssignment((Cell)cell, new HashSet<Integer>(Arrays.asList(6, 7, 8)), (int)3));
        Assertions.assertFalse((boolean)CellAssignor.isCellOpenForAssignment((Cell)cell, new HashSet<Integer>(Arrays.asList(0, 1, 2)), (int)4));
        Cell invalidCell = new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 6, 6);
        Assertions.assertFalse((boolean)CellAssignor.isCellOpenForAssignment((Cell)invalidCell, new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), (int)3));
        Assertions.assertFalse((boolean)CellAssignor.isCellOpenForAssignment((Cell)invalidCell, new HashSet<Integer>(Arrays.asList(0, 1, 2)), (int)3));
        Assertions.assertFalse((boolean)CellAssignor.isCellOpenForAssignment((Cell)invalidCell, new HashSet<Integer>(Arrays.asList(0, 3, 5)), (int)3));
        Assertions.assertFalse((boolean)CellAssignor.isCellOpenForAssignment((Cell)invalidCell, new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), (int)2));
        Assertions.assertFalse((boolean)CellAssignor.isCellOpenForAssignment((Cell)invalidCell, new HashSet<Integer>(Arrays.asList(6, 7, 8)), (int)3));
        Assertions.assertFalse((boolean)CellAssignor.isCellOpenForAssignment((Cell)invalidCell, new HashSet<Integer>(Arrays.asList(0, 1, 2)), (int)4));
    }

    @Test
    void testCheckBrokerAssignment() {
        Assertions.assertThrows(InvalidRequestException.class, () -> CellAssignor.checkBrokerAssignment(new HashSet<Integer>(Arrays.asList(0, 1)), (int)3, (boolean)false));
        Assertions.assertThrows(InvalidRequestException.class, () -> CellAssignor.checkBrokerAssignment(new HashSet<Integer>(Arrays.asList(0, 1, 3)), (int)3, (boolean)false));
        CellAssignor.checkBrokerAssignment(new HashSet<Integer>(Arrays.asList(0, 1, 2)), (int)3, (boolean)false);
        CellAssignor.checkBrokerAssignment(new HashSet<Integer>(Arrays.asList(0, 1, 3)), (int)3, (boolean)true);
        CellAssignor.checkBrokerAssignment(new HashSet<Integer>(Arrays.asList(0, 1)), (int)3, (boolean)true);
    }
}

