/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.migration.AclMigrationClient;
import org.apache.kafka.metadata.migration.BrokerHealthMigrationClient;
import org.apache.kafka.metadata.migration.CapturingAclMigrationClient;
import org.apache.kafka.metadata.migration.CapturingBrokerHealthMigrationClient;
import org.apache.kafka.metadata.migration.CapturingClusterLinkMigrationClient;
import org.apache.kafka.metadata.migration.CapturingConfigMigrationClient;
import org.apache.kafka.metadata.migration.CapturingReplicaExclusionMigrationClient;
import org.apache.kafka.metadata.migration.CapturingTopicMigrationClient;
import org.apache.kafka.metadata.migration.ClusterLinkMigrationClient;
import org.apache.kafka.metadata.migration.ConfigMigrationClient;
import org.apache.kafka.metadata.migration.KRaftMigrationOperation;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.ReplicaExclusionMigrationClient;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;

class CapturingMigrationClient
implements MigrationClient {
    private final Set<Integer> brokerIds;
    private final TopicMigrationClient topicMigrationClient;
    private final ConfigMigrationClient configMigrationClient;
    private final AclMigrationClient aclMigrationClient;
    private final ClusterLinkMigrationClient clusterLinkMigrationClient;
    private final BrokerHealthMigrationClient brokerHealthMigrationClient;
    private final ReplicaExclusionMigrationClient replicaExclusionMigrationClient;
    private ZkMigrationLeadershipState state = null;

    static Builder newBuilder() {
        return new Builder();
    }

    CapturingMigrationClient(Set<Integer> brokerIdsInZk, TopicMigrationClient topicMigrationClient, ConfigMigrationClient configMigrationClient, AclMigrationClient aclMigrationClient, ClusterLinkMigrationClient clusterLinkMigrationClient, BrokerHealthMigrationClient brokerHealthMigrationClient, ReplicaExclusionMigrationClient replicaExclusionMigrationClient) {
        this.brokerIds = brokerIdsInZk;
        this.topicMigrationClient = topicMigrationClient;
        this.configMigrationClient = configMigrationClient;
        this.aclMigrationClient = aclMigrationClient;
        this.clusterLinkMigrationClient = clusterLinkMigrationClient;
        this.brokerHealthMigrationClient = brokerHealthMigrationClient;
        this.replicaExclusionMigrationClient = replicaExclusionMigrationClient;
    }

    public ZkMigrationLeadershipState getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState initialState) {
        if (this.state == null) {
            this.state = initialState;
        }
        return this.state;
    }

    public ZkMigrationLeadershipState setMigrationRecoveryState(ZkMigrationLeadershipState state) {
        this.state = state;
        return state;
    }

    public ZkMigrationLeadershipState claimControllerLeadership(ZkMigrationLeadershipState state) {
        this.state = state;
        return state;
    }

    public ZkMigrationLeadershipState releaseControllerLeadership(ZkMigrationLeadershipState state) {
        this.state = state;
        return state;
    }

    public TopicMigrationClient topicClient() {
        return this.topicMigrationClient;
    }

    public ConfigMigrationClient configClient() {
        return this.configMigrationClient;
    }

    public AclMigrationClient aclClient() {
        return this.aclMigrationClient;
    }

    public ClusterLinkMigrationClient clusterLinkClient() {
        return this.clusterLinkMigrationClient;
    }

    public BrokerHealthMigrationClient brokerHealthClient() {
        return this.brokerHealthMigrationClient;
    }

    public ReplicaExclusionMigrationClient replicaExclusionClient() {
        return this.replicaExclusionMigrationClient;
    }

    public Optional<ProducerIdsBlock> readProducerId() {
        return Optional.empty();
    }

    public ZkMigrationLeadershipState writeProducerId(long nextProducerId, ZkMigrationLeadershipState state) {
        this.state = state;
        return state;
    }

    public void cleanAndMigrateAllMetadata(Consumer<List<ApiMessageAndVersion>> batchConsumer, Consumer<Integer> brokerIdConsumer, BiConsumer<String, KRaftMigrationOperation> operationConsumer, Map<Integer, BrokerRegistration> brokerRegistrations) {
    }

    public Set<Integer> readBrokerIds() {
        return this.brokerIds;
    }

    public static class Builder {
        Set<Integer> brokersInZk = Collections.emptySet();
        TopicMigrationClient topicMigrationClient = new CapturingTopicMigrationClient();
        ConfigMigrationClient configMigrationClient = new CapturingConfigMigrationClient();
        AclMigrationClient aclMigrationClient = new CapturingAclMigrationClient();
        ClusterLinkMigrationClient clusterLinkMigrationClient = new CapturingClusterLinkMigrationClient();
        BrokerHealthMigrationClient brokerHealthMigrationClient = new CapturingBrokerHealthMigrationClient();
        ReplicaExclusionMigrationClient replicaExclusionMigrationClient = new CapturingReplicaExclusionMigrationClient();

        public Builder setBrokersInZk(int ... brokerIds) {
            this.brokersInZk = IntStream.of(brokerIds).boxed().collect(Collectors.toSet());
            return this;
        }

        public Builder setTopicMigrationClient(TopicMigrationClient topicMigrationClient) {
            this.topicMigrationClient = topicMigrationClient;
            return this;
        }

        public Builder setConfigMigrationClient(ConfigMigrationClient configMigrationClient) {
            this.configMigrationClient = configMigrationClient;
            return this;
        }

        public Builder setAclMigrationClient(AclMigrationClient aclMigrationClient) {
            this.aclMigrationClient = aclMigrationClient;
            return this;
        }

        public Builder setClusterLinkMigrationClient(ClusterLinkMigrationClient linkMigrationClient) {
            this.clusterLinkMigrationClient = linkMigrationClient;
            return this;
        }

        public Builder setBrokerHealthMigrationClient(BrokerHealthMigrationClient brokerHealthMigrationClient) {
            this.brokerHealthMigrationClient = brokerHealthMigrationClient;
            return this;
        }

        public Builder setReplicaExclusionMigrationClient(ReplicaExclusionMigrationClient replicaExclusionMigrationClient) {
            this.replicaExclusionMigrationClient = replicaExclusionMigrationClient;
            return this;
        }

        public CapturingMigrationClient build() {
            return new CapturingMigrationClient(this.brokersInZk, this.topicMigrationClient, this.configMigrationClient, this.aclMigrationClient, this.clusterLinkMigrationClient, this.brokerHealthMigrationClient, this.replicaExclusionMigrationClient);
        }
    }
}

