/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.nio.ByteBuffer;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.MetadataParseException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MetadataRecordSerdeTest {
    MetadataRecordSerdeTest() {
    }

    @Test
    public void testSerde() {
        TopicRecord topicRecord = new TopicRecord().setName("foo").setTopicId(Uuid.randomUuid());
        MetadataRecordSerde serde = new MetadataRecordSerde();
        for (short version = 0; version <= 0; version = (short)(version + 1)) {
            ApiMessageAndVersion messageAndVersion = new ApiMessageAndVersion((ApiMessage)topicRecord, version);
            ObjectSerializationCache cache = new ObjectSerializationCache();
            int size = serde.recordSize(messageAndVersion, cache);
            ByteBuffer buffer = ByteBuffer.allocate(size);
            ByteBufferAccessor bufferAccessor = new ByteBufferAccessor(buffer);
            serde.write(messageAndVersion, cache, (Writable)bufferAccessor);
            buffer.flip();
            Assertions.assertEquals((int)size, (int)buffer.remaining());
            ApiMessageAndVersion readMessageAndVersion = serde.read((Readable)bufferAccessor, size);
            Assertions.assertEquals((Object)messageAndVersion, (Object)readMessageAndVersion);
        }
    }

    @Test
    public void testDeserializeWithUnhandledFrameVersion() {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        ByteUtils.writeUnsignedVarint((int)15, (ByteBuffer)buffer);
        buffer.flip();
        MetadataRecordSerde serde = new MetadataRecordSerde();
        MetadataRecordSerdeTest.assertStartsWith("Could not deserialize metadata record due to unknown frame version", ((MetadataParseException)Assertions.assertThrows(MetadataParseException.class, () -> serde.read((Readable)new ByteBufferAccessor(buffer), 16))).getMessage());
    }

    @Test
    public void testParsingMalformedFrameVersionVarint() {
        MetadataRecordSerde serde = new MetadataRecordSerde();
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.clear();
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.position(0);
        buffer.limit(64);
        MetadataRecordSerdeTest.assertStartsWith("Error while reading frame version", ((MetadataParseException)Assertions.assertThrows(MetadataParseException.class, () -> serde.read((Readable)new ByteBufferAccessor(buffer), buffer.remaining()))).getMessage());
    }

    @Test
    public void testParsingMalformedMessageTypeVarint() {
        MetadataRecordSerde serde = new MetadataRecordSerde();
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.clear();
        buffer.put((byte)1);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.position(0);
        buffer.limit(64);
        MetadataRecordSerdeTest.assertStartsWith("Error while reading type", ((MetadataParseException)Assertions.assertThrows(MetadataParseException.class, () -> serde.read((Readable)new ByteBufferAccessor(buffer), buffer.remaining()))).getMessage());
    }

    @Test
    public void testParsingMalformedMessageVersionVarint() {
        MetadataRecordSerde serde = new MetadataRecordSerde();
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.clear();
        buffer.put((byte)1);
        buffer.put((byte)8);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.put((byte)-128);
        buffer.position(0);
        buffer.limit(64);
        MetadataRecordSerdeTest.assertStartsWith("Error while reading version", ((MetadataParseException)Assertions.assertThrows(MetadataParseException.class, () -> serde.read((Readable)new ByteBufferAccessor(buffer), buffer.remaining()))).getMessage());
    }

    @Test
    public void testParsingVersionTooLarge() {
        MetadataRecordSerde serde = new MetadataRecordSerde();
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.clear();
        buffer.put((byte)1);
        buffer.put((byte)8);
        buffer.put((byte)-1);
        buffer.put((byte)-1);
        buffer.put((byte)-1);
        buffer.put((byte)127);
        buffer.put((byte)-128);
        buffer.position(0);
        buffer.limit(64);
        MetadataRecordSerdeTest.assertStartsWith("Value for version was too large", ((MetadataParseException)Assertions.assertThrows(MetadataParseException.class, () -> serde.read((Readable)new ByteBufferAccessor(buffer), buffer.remaining()))).getMessage());
    }

    @Test
    public void testParsingUnsupportedApiKey() {
        MetadataRecordSerde serde = new MetadataRecordSerde();
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.put((byte)1);
        buffer.put((byte)-1);
        buffer.put((byte)127);
        buffer.put((byte)0);
        buffer.put((byte)-128);
        buffer.position(0);
        buffer.limit(64);
        MetadataRecordSerdeTest.assertStartsWith("Unknown metadata id ", ((MetadataParseException)Assertions.assertThrows(MetadataParseException.class, () -> serde.read((Readable)new ByteBufferAccessor(buffer), buffer.remaining()))).getCause().getMessage());
    }

    @Test
    public void testParsingMalformedMessage() {
        MetadataRecordSerde serde = new MetadataRecordSerde();
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.put((byte)1);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.put((byte)-128);
        buffer.position(0);
        buffer.limit(4);
        MetadataRecordSerdeTest.assertStartsWith("Failed to deserialize record with type", ((MetadataParseException)Assertions.assertThrows(MetadataParseException.class, () -> serde.read((Readable)new ByteBufferAccessor(buffer), buffer.remaining()))).getMessage());
    }

    @Test
    public void testParsingRecordWithGarbageAtEnd() {
        MetadataRecordSerde serde = new MetadataRecordSerde();
        RegisterBrokerRecord message = new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(2L);
        ObjectSerializationCache cache = new ObjectSerializationCache();
        ApiMessageAndVersion messageAndVersion = new ApiMessageAndVersion((ApiMessage)message, 0);
        int size = serde.recordSize(messageAndVersion, cache);
        ByteBuffer buffer = ByteBuffer.allocate(size + 1);
        serde.write(messageAndVersion, cache, (Writable)new ByteBufferAccessor(buffer));
        buffer.clear();
        MetadataRecordSerdeTest.assertStartsWith("Found 1 byte(s) of garbage after", ((MetadataParseException)Assertions.assertThrows(MetadataParseException.class, () -> serde.read((Readable)new ByteBufferAccessor(buffer), size + 1))).getMessage());
    }

    private static void assertStartsWith(String prefix, String str) {
        Assertions.assertTrue((boolean)str.startsWith(prefix), (String)("Expected string '" + str + "' to start with '" + prefix + "'"));
    }
}

