/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class BrokerRegistrationTest {
    private static final List<BrokerRegistration> REGISTRATIONS = Arrays.asList(new BrokerRegistration(0, 0L, Uuid.fromString((String)"pc1GhUlBS92cGGaKXl6ipw"), Arrays.asList(new Endpoint("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost", 9090)), Collections.singletonMap("foo", VersionRange.of((short)1, (short)2)), Optional.empty(), false, false), new BrokerRegistration(1, 0L, Uuid.fromString((String)"3MfdxWlNSn2UDYsmDP1pYg"), Arrays.asList(new Endpoint("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost", 9091)), Collections.singletonMap("foo", VersionRange.of((short)1, (short)2)), Optional.empty(), true, false), new BrokerRegistration(2, 0L, Uuid.fromString((String)"eY7oaG1RREie5Kk9uy1l6g"), Arrays.asList(new Endpoint("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost", 9092)), Stream.of(new AbstractMap.SimpleEntry<String, VersionRange>("foo", VersionRange.of((short)2, (short)3)), new AbstractMap.SimpleEntry<String, VersionRange>("bar", VersionRange.of((short)1, (short)4))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)), Optional.of("myrack1"), false, true), new BrokerRegistration(3, 0L, Uuid.fromString((String)"1t8VyWx2TCSTpUWuqj-FOw"), Arrays.asList(new Endpoint("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost", 9093)), Stream.of(new AbstractMap.SimpleEntry<String, VersionRange>("metadata.version", VersionRange.of((short)7, (short)7))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)), Optional.of("myrack2"), false, true, true, new HashSet<DegradedBrokerHealthState>(Arrays.asList(new DegradedBrokerHealthState("RCCA-123", BrokerComponent.UNSPECIFIED), new DegradedBrokerHealthState("RCCA-234", BrokerComponent.UNSPECIFIED)))));

    @Test
    public void testValues() {
        Assertions.assertEquals((int)0, (int)REGISTRATIONS.get(0).id());
        Assertions.assertEquals((int)1, (int)REGISTRATIONS.get(1).id());
        Assertions.assertEquals((int)2, (int)REGISTRATIONS.get(2).id());
        Assertions.assertEquals((int)3, (int)REGISTRATIONS.get(3).id());
    }

    @Test
    public void testEquals() {
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(0), (Object)REGISTRATIONS.get(1));
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(1), (Object)REGISTRATIONS.get(0));
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(0), (Object)REGISTRATIONS.get(2));
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(2), (Object)REGISTRATIONS.get(0));
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(3), (Object)REGISTRATIONS.get(0));
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(3), (Object)REGISTRATIONS.get(1));
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(3), (Object)REGISTRATIONS.get(2));
        Assertions.assertEquals((Object)REGISTRATIONS.get(0), (Object)REGISTRATIONS.get(0));
        Assertions.assertEquals((Object)REGISTRATIONS.get(1), (Object)REGISTRATIONS.get(1));
        Assertions.assertEquals((Object)REGISTRATIONS.get(2), (Object)REGISTRATIONS.get(2));
        Assertions.assertEquals((Object)REGISTRATIONS.get(3), (Object)REGISTRATIONS.get(3));
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"BrokerRegistration(id=1, epoch=0, incarnationId=3MfdxWlNSn2UDYsmDP1pYg, listeners=[Endpoint(listenerName='INTERNAL', securityProtocol=PLAINTEXT, host='localhost', port=9091)], supportedFeatures={foo: 1-2}, rack=Optional.empty, fenced=true, inControlledShutdown=false, isMigratingZkBroker=false, degradedComponents=[])", (Object)REGISTRATIONS.get(1).toString());
        Assertions.assertEquals((Object)"BrokerRegistration(id=2, epoch=0, incarnationId=eY7oaG1RREie5Kk9uy1l6g, listeners=[Endpoint(listenerName='INTERNAL', securityProtocol=PLAINTEXT, host='localhost', port=9092)], supportedFeatures={bar: 1-4, foo: 2-3}, rack=Optional[myrack1], fenced=false, inControlledShutdown=true, isMigratingZkBroker=false, degradedComponents=[])", (Object)REGISTRATIONS.get(2).toString());
        String prefix = "BrokerRegistration(id=3, epoch=0, incarnationId=1t8VyWx2TCSTpUWuqj-FOw, listeners=[Endpoint(listenerName='INTERNAL', securityProtocol=PLAINTEXT, host='localhost', port=9093)], supportedFeatures={metadata.version: 7}, rack=Optional[myrack2], fenced=false, inControlledShutdown=true, isMigratingZkBroker=true, ";
        Assertions.assertTrue(((prefix + "degradedComponents=[DegradedBrokerHealthState(reason=RCCA-234, component=UNSPECIFIED), DegradedBrokerHealthState(reason=RCCA-123, component=UNSPECIFIED)])").equals(REGISTRATIONS.get(3).toString()) || (prefix + "degradedComponents=[DegradedBrokerHealthState(reason=RCCA-123, component=UNSPECIFIED), DegradedBrokerHealthState(reason=RCCA-234, component=UNSPECIFIED)])").equals(REGISTRATIONS.get(3).toString()) ? 1 : 0) != 0);
    }

    @Test
    public void testFromRecordAndToRecord() {
        this.testRoundTrip(REGISTRATIONS.get(3));
        this.testRoundTrip(REGISTRATIONS.get(0));
        this.testRoundTrip(REGISTRATIONS.get(1));
        this.testRoundTrip(REGISTRATIONS.get(2));
        this.testRoundTrip(REGISTRATIONS.get(3));
    }

    private void testRoundTrip(BrokerRegistration registration) {
        ApiMessageAndVersion messageAndVersion = registration.toRecord(new ImageWriterOptions.Builder().build());
        BrokerRegistration registration2 = BrokerRegistration.fromRecord((RegisterBrokerRecord)((RegisterBrokerRecord)messageAndVersion.message()));
        Assertions.assertEquals((Object)registration, (Object)registration2);
        ApiMessageAndVersion messageAndVersion2 = registration2.toRecord(new ImageWriterOptions.Builder().build());
        Assertions.assertEquals((Object)messageAndVersion, (Object)messageAndVersion2);
    }

    @Test
    public void testToNode() {
        Assertions.assertEquals(Optional.empty(), (Object)REGISTRATIONS.get(0).node("NONEXISTENT"));
        Assertions.assertEquals(Optional.of(new Node(0, "localhost", 9090, null)), (Object)REGISTRATIONS.get(0).node("INTERNAL"));
        Assertions.assertEquals(Optional.of(new Node(1, "localhost", 9091, null)), (Object)REGISTRATIONS.get(1).node("INTERNAL"));
        Assertions.assertEquals(Optional.of(new Node(2, "localhost", 9092, "myrack1")), (Object)REGISTRATIONS.get(2).node("INTERNAL"));
        Assertions.assertEquals(Optional.of(new Node(3, "localhost", 9093, "myrack2")), (Object)REGISTRATIONS.get(3).node("INTERNAL"));
    }
}

