/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.writer;

import java.util.Collections;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.writer.ImageReWriter;
import org.apache.kafka.image.writer.ImageWriterClosedException;
import org.apache.kafka.metadata.RecordTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ImageReWriterTest {
    @Test
    public void testWrite() {
        MetadataDelta delta = new MetadataDelta.Builder().build();
        ImageReWriter writer = new ImageReWriter(delta);
        writer.write(RecordTestUtils.testRecord(0));
        writer.write(RecordTestUtils.testRecord(1));
        writer.close(true);
        Assertions.assertEquals((int)2, (int)delta.getOrCreateTopicsDelta().changedTopics().size());
        Assertions.assertEquals((int)2, (int)writer.image().topics().topicsById().size());
    }

    @Test
    public void testCloseWithoutFreeze() {
        MetadataDelta delta = new MetadataDelta.Builder().build();
        ImageReWriter writer = new ImageReWriter(delta);
        writer.close();
        Assertions.assertNull((Object)writer.image());
    }

    @Test
    public void testWriteAfterClose() {
        MetadataDelta delta = new MetadataDelta.Builder().build();
        ImageReWriter writer = new ImageReWriter(delta);
        writer.close(true);
        Assertions.assertThrows(ImageWriterClosedException.class, () -> writer.write(0, (ApiMessage)new TopicRecord().setName("foo").setTopicId(Uuid.fromString((String)"3B134hrsQgKtz8Sp6QBIfg"))));
    }

    @Test
    public void testCloseInvokesFinishSnapshot() {
        MetadataDelta delta = new MetadataDelta.Builder().build();
        ImageReWriter writer = new ImageReWriter(delta);
        writer.write(0, (ApiMessage)new TopicRecord().setName("foo").setTopicId(Uuid.fromString((String)"3B134hrsQgKtz8Sp6QBIfg")));
        writer.close(true);
        MetadataDelta delta2 = new MetadataDelta.Builder().setImage(writer.image()).build();
        ImageReWriter writer2 = new ImageReWriter(delta2);
        writer2.write(0, (ApiMessage)new ConfigRecord().setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setName("num.io.threads").setValue("12"));
        writer2.close(true);
        MetadataImage newImage = writer2.image();
        Assertions.assertEquals(Collections.emptyMap(), (Object)newImage.topics().topicsById());
        Assertions.assertEquals(Collections.singletonMap("num.io.threads", "12"), (Object)newImage.configs().configMapForResource(new ConfigResource(ConfigResource.Type.BROKER, "")));
    }
}

