/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.image.ClusterDelta;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClusterDeltaTest {
    @Test
    public void testNewBrokers() throws Throwable {
        ClusterDelta delta = new ClusterDelta(this.getBaseImage());
        Assertions.assertEquals((int)0, (int)delta.newBrokers().size());
        for (int i = 4; i <= 6; ++i) {
            delta.replay(new RegisterBrokerRecord().setBrokerId(i).setBrokerEpoch((long)i * 100L).setFenced(true).setRack(null).setIncarnationId(Uuid.randomUuid()));
        }
        Assertions.assertEquals((int)0, (int)delta.newBrokers().size());
        delta.replay(new UnfenceBrokerRecord().setId(1).setEpoch(100L));
        delta.replay(new UnfenceBrokerRecord().setId(4).setEpoch(400L));
        delta.replay(new UnfenceBrokerRecord().setId(5).setEpoch(500L));
        delta.replay(new UnfenceBrokerRecord().setId(6).setEpoch(600L));
        Set newBrokers = delta.newBrokers().stream().map(b -> b.id()).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)newBrokers.equals(new HashSet<Integer>(Arrays.asList(1, 4, 5, 6))));
        delta.replay(new FenceBrokerRecord().setId(4).setEpoch(400L));
        newBrokers = delta.newBrokers().stream().map(b -> b.id()).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)newBrokers.equals(new HashSet<Integer>(Arrays.asList(1, 5, 6))));
        delta.replay(new UnregisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L));
        delta.replay(new UnregisterBrokerRecord().setBrokerId(2).setBrokerEpoch(200L));
        delta.replay(new UnregisterBrokerRecord().setBrokerId(6).setBrokerEpoch(600L));
        newBrokers = delta.newBrokers().stream().map(b -> b.id()).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)newBrokers.equals(Collections.singleton(5)));
    }

    @Test
    public void testRemovedBrokers() throws Throwable {
        ClusterDelta delta = new ClusterDelta(this.getBaseImage());
        Assertions.assertEquals((int)0, (int)delta.removedBrokers().size());
        for (int i = 4; i <= 6; ++i) {
            delta.replay(new RegisterBrokerRecord().setBrokerId(i).setBrokerEpoch((long)i * 100L).setFenced(true).setRack(null).setIncarnationId(Uuid.randomUuid()));
        }
        Assertions.assertEquals((int)0, (int)delta.removedBrokers().size());
        delta.replay(new UnfenceBrokerRecord().setId(1).setEpoch(100L));
        delta.replay(new UnfenceBrokerRecord().setId(4).setEpoch(400L));
        delta.replay(new UnfenceBrokerRecord().setId(5).setEpoch(500L));
        delta.replay(new UnfenceBrokerRecord().setId(6).setEpoch(600L));
        Assertions.assertEquals((int)0, (int)delta.removedBrokers().size());
        delta.replay(new FenceBrokerRecord().setId(4).setEpoch(400L));
        delta.replay(new FenceBrokerRecord().setId(2).setEpoch(200L));
        Assertions.assertTrue((boolean)delta.removedBrokers().equals(Collections.singleton(2)));
        delta.replay(new UnregisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L));
        delta.replay(new UnregisterBrokerRecord().setBrokerId(2).setBrokerEpoch(200L));
        delta.replay(new UnregisterBrokerRecord().setBrokerId(6).setBrokerEpoch(600L));
        Assertions.assertTrue((boolean)delta.removedBrokers().equals(new HashSet<Integer>(Arrays.asList(1, 2))));
    }

    @Test
    public void testNewlyDegradedBrokers() throws Throwable {
        ClusterDelta delta = new ClusterDelta(this.getBaseImage());
        BrokerRegistrationChangeRecord.DegradedComponent degradedComponent1 = new BrokerRegistrationChangeRecord.DegradedComponent().setReason("rcca-123").setComponentCode(BrokerComponent.UNKNOWN.id());
        BrokerRegistrationChangeRecord.DegradedComponent degradedComponent2 = new BrokerRegistrationChangeRecord.DegradedComponent().setReason("rcca-234").setComponentCode(BrokerComponent.STORAGE.id());
        BrokerRegistrationChangeRecord.DegradedComponent degradedComponent3 = new BrokerRegistrationChangeRecord.DegradedComponent().setReason("rcca-234").setComponentCode(BrokerComponent.UNKNOWN.id());
        delta.replay(new RegisterBrokerRecord().setBrokerId(4).setBrokerEpoch(400L).setFenced(false).setRack(null).setIncarnationId(Uuid.randomUuid()));
        Assertions.assertEquals((int)0, (int)delta.newlyDegradedBrokers().size());
        List<BrokerRegistrationChangeRecord.DegradedComponent> degradedComponents1 = Arrays.asList(degradedComponent1, degradedComponent2);
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(100L).setDegradedComponents(degradedComponents1));
        Assertions.assertEquals(Collections.singleton(1), (Object)delta.newlyDegradedBrokers());
        degradedComponents1 = Arrays.asList(degradedComponent1, degradedComponent2, degradedComponent3);
        List<BrokerRegistrationChangeRecord.DegradedComponent> degradedComponents2 = Collections.singletonList(degradedComponent3);
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(100L).setDegradedComponents(degradedComponents1));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(2).setBrokerEpoch(200L).setDegradedComponents(Collections.singletonList(degradedComponent3)));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2)), (Object)delta.newlyDegradedBrokers());
        List<RegisterBrokerRecord.DegradedComponent> degradedComponents5 = Collections.singletonList(new RegisterBrokerRecord.DegradedComponent().setReason("rcca-345").setComponentCode(BrokerComponent.STORAGE.id()));
        delta.replay(new RegisterBrokerRecord().setBrokerId(5).setBrokerEpoch(500L).setFenced(false).setRack(null).setIncarnationId(Uuid.randomUuid()).setDegradedComponents(degradedComponents5));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2, 5)), (Object)delta.newlyDegradedBrokers());
    }

    @Test
    public void testNewlyDegradedBrokersWithExistingDegradations() throws Throwable {
        String baseDegradationReason = "rcca-123";
        byte baseDegradationComponent = BrokerComponent.UNKNOWN.id();
        Map<Integer, List<RegisterBrokerRecord.DegradedComponent>> existingDegradations = Collections.singletonMap(1, Collections.singletonList(new RegisterBrokerRecord.DegradedComponent().setReason(baseDegradationReason).setComponentCode(baseDegradationComponent)));
        ClusterDelta delta = new ClusterDelta(this.getBaseImageWithDegradations(existingDegradations));
        delta.replay(new RegisterBrokerRecord().setBrokerId(4).setBrokerEpoch(400L).setFenced(false).setRack(null).setIncarnationId(Uuid.randomUuid()));
        Assertions.assertEquals((int)0, (int)delta.newlyDegradedBrokers().size());
        BrokerRegistrationChangeRecord.DegradedComponent degradedComponent = new BrokerRegistrationChangeRecord.DegradedComponent().setReason("rcca-234").setComponentCode(BrokerComponent.STORAGE.id());
        List<BrokerRegistrationChangeRecord.DegradedComponent> degradedComponents1 = Arrays.asList(new BrokerRegistrationChangeRecord.DegradedComponent().setReason(baseDegradationReason).setComponentCode(baseDegradationComponent), degradedComponent);
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(100L).setDegradedComponents(Arrays.asList(new BrokerRegistrationChangeRecord.DegradedComponent().setReason(baseDegradationReason).setComponentCode(baseDegradationComponent), degradedComponent)));
        Assertions.assertEquals((int)0, (int)delta.newlyDegradedBrokers().size());
        List<BrokerRegistrationChangeRecord.DegradedComponent> degradedComponents2 = Collections.singletonList(degradedComponent);
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(100L).setDegradedComponents(degradedComponents1));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(2).setBrokerEpoch(200L).setDegradedComponents(degradedComponents2));
        Assertions.assertEquals(Collections.singleton(2), (Object)delta.newlyDegradedBrokers());
    }

    @Test
    public void testNewlyRecoveredBrokers() throws Throwable {
        String baseDegradationReason1 = "rcca-123";
        byte baseDegradationComponent1 = BrokerComponent.UNKNOWN.id();
        List<RegisterBrokerRecord.DegradedComponent> degradedComponents1 = Collections.singletonList(new RegisterBrokerRecord.DegradedComponent().setReason(baseDegradationReason1).setComponentCode(baseDegradationComponent1));
        String baseDegradationReason2 = "rcca-234";
        byte baseDegradationComponent2 = BrokerComponent.STORAGE.id();
        List<RegisterBrokerRecord.DegradedComponent> degradedComponents2 = Arrays.asList(new RegisterBrokerRecord.DegradedComponent().setReason(baseDegradationReason1).setComponentCode(baseDegradationComponent1), new RegisterBrokerRecord.DegradedComponent().setReason(baseDegradationReason2).setComponentCode(baseDegradationComponent2));
        HashMap<Integer, List<RegisterBrokerRecord.DegradedComponent>> existingDegradations = new HashMap<Integer, List<RegisterBrokerRecord.DegradedComponent>>();
        existingDegradations.put(1, degradedComponents1);
        existingDegradations.put(2, degradedComponents2);
        ClusterDelta delta = new ClusterDelta(this.getBaseImageWithDegradations(existingDegradations));
        delta.replay(new RegisterBrokerRecord().setBrokerId(4).setBrokerEpoch(400L).setFenced(false).setRack(null).setIncarnationId(Uuid.randomUuid()));
        Assertions.assertEquals((int)0, (int)delta.newlyRecoveredBrokers().size());
        delta.replay(new UnregisterBrokerRecord().setBrokerId(3).setBrokerEpoch(300L));
        Assertions.assertEquals((int)0, (int)delta.newlyRecoveredBrokers().size());
        delta.replay(new UnregisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L));
        Assertions.assertEquals(Collections.singleton(1), (Object)delta.newlyRecoveredBrokers());
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(2).setBrokerEpoch(200L).setFenced((byte)1));
        Assertions.assertEquals(Collections.singleton(1), (Object)delta.newlyRecoveredBrokers());
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(2).setBrokerEpoch(200L).setDegradedComponents(Collections.singletonList(new BrokerRegistrationChangeRecord.DegradedComponent().setReason(baseDegradationReason1).setComponentCode(baseDegradationComponent1))));
        Assertions.assertEquals(Collections.singleton(1), (Object)delta.newlyRecoveredBrokers());
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(2).setBrokerEpoch(200L).setDegradedComponents(Collections.emptyList()));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2)), (Object)delta.newlyRecoveredBrokers());
    }

    private ClusterImage getBaseImage() {
        HashMap<Integer, BrokerRegistration> brokers = new HashMap<Integer, BrokerRegistration>(){
            {
                this.put(1, new BrokerRegistration(1, 100L, Uuid.randomUuid(), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), true, false));
                this.put(2, new BrokerRegistration(2, 200L, Uuid.randomUuid(), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), false, false));
                this.put(3, new BrokerRegistration(3, 300L, Uuid.randomUuid(), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), false, false));
            }
        };
        ClusterImage baseImage = new ClusterImage((Map)brokers);
        return baseImage;
    }

    private ClusterImage getBaseImageWithDegradations(Map<Integer, List<RegisterBrokerRecord.DegradedComponent>> degradations) {
        HashMap<Integer, BrokerRegistration> brokers = new HashMap<Integer, BrokerRegistration>();
        for (int i = 1; i <= 3; ++i) {
            if (degradations.containsKey(i)) {
                brokers.put(i, new BrokerRegistration(i, (long)i * 100L, Uuid.randomUuid(), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), false, false, false, DegradedBrokerHealthState.fromRegisterBrokerRecord(degradations.getOrDefault(i, Collections.emptyList()))));
                continue;
            }
            brokers.put(i, new BrokerRegistration(i, (long)i * 100L, Uuid.randomUuid(), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), false, false));
        }
        ClusterImage baseImage = new ClusterImage(brokers);
        return baseImage;
    }
}

