/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.metadata.CellRecord;
import org.apache.kafka.common.metadata.RemoveCellRecord;
import org.apache.kafka.image.CellDelta;
import org.apache.kafka.image.CellImage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CellDeltaTest {
    CellDeltaTest() {
    }

    @Test
    void testReplay() {
        HashMap<Integer, Cell> cellIdToCell = new HashMap<Integer, Cell>();
        cellIdToCell.put(0, new Cell(0, new HashSet(), CellState.READY, 3, 6));
        cellIdToCell.put(1, new Cell(1, new HashSet<Integer>(Arrays.asList(3, 4, 5)), CellState.QUARANTINED, 2, 4));
        CellImage image = new CellImage(cellIdToCell);
        CellDelta delta = new CellDelta(image);
        delta.replay(new CellRecord().setCellId(2).setBrokers(Collections.singletonList(6)).setState(CellState.READY.code()).setMinSize((short)1).setMaxSize((short)2));
        delta.replay(new RemoveCellRecord().setCellId(0));
        HashMap<Integer, Cell> expectedCellIdToCell = new HashMap<Integer, Cell>();
        expectedCellIdToCell.put(1, new Cell(1, new HashSet<Integer>(Arrays.asList(3, 4, 5)), CellState.QUARANTINED, 2, 4));
        expectedCellIdToCell.put(2, new Cell(2, Collections.singleton(6), CellState.READY, 1, 2));
        CellImage expectedImage = new CellImage(expectedCellIdToCell);
        Assertions.assertEquals((Object)expectedImage, (Object)delta.apply());
    }
}

