/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.image.BrokerReplicaExclusionsDelta;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BrokerReplicaExclusionsDeltaTest {
    private final Map<Integer, String> startingExclusions = new HashMap<Integer, String>();
    private BrokerReplicaExclusionsDelta delta = new BrokerReplicaExclusionsDelta(new BrokerReplicaExclusionsImage(this.startingExclusions));

    @Test
    public void testApply() {
        HashMap<Integer, String> exclusions = new HashMap<Integer, String>(this.startingExclusions);
        this.assertDelta(Collections.emptyList(), Collections.emptyList());
        exclusions.put(1, "1");
        this.delta.replay(this.record(exclusions));
        this.assertDelta(Collections.singletonList(1), Collections.emptyList());
        Assertions.assertEquals(exclusions, (Object)this.delta.apply().activeBrokerReplicaExclusions());
        exclusions.put(2, "2");
        this.delta.replay(this.record(exclusions));
        this.assertDelta(Arrays.asList(1, 2), Collections.emptyList());
        Assertions.assertEquals(exclusions, (Object)this.delta.apply().activeBrokerReplicaExclusions());
        exclusions.put(3, "3");
        exclusions.put(2, "5");
        exclusions.remove(1);
        this.delta.replay(this.record(exclusions));
        this.assertDelta(Arrays.asList(2, 3), Collections.emptyList());
        Assertions.assertEquals(exclusions, (Object)this.delta.apply().activeBrokerReplicaExclusions());
        exclusions.remove(2);
        exclusions.remove(3);
        this.delta.replay(this.record(exclusions));
        this.assertDelta(Collections.emptyList(), Collections.emptyList());
        Assertions.assertEquals(exclusions, (Object)this.delta.apply().activeBrokerReplicaExclusions());
    }

    @Test
    public void testNewAndRemovedExclusionsDelta() {
        this.startingExclusions.put(1, "1");
        this.startingExclusions.put(2, "2");
        this.startingExclusions.put(3, "3");
        this.delta = new BrokerReplicaExclusionsDelta(new BrokerReplicaExclusionsImage(this.startingExclusions));
        this.assertDelta(Collections.emptyList(), Collections.emptyList());
        HashMap<Integer, String> exclusions = new HashMap<Integer, String>(this.startingExclusions);
        exclusions.put(2, "2");
        this.delta.replay(this.record(exclusions));
        this.assertDelta(Collections.emptyList(), Collections.emptyList());
        Assertions.assertEquals(exclusions, (Object)this.delta.apply().activeBrokerReplicaExclusions());
        exclusions.put(2, "new");
        this.delta.replay(this.record(exclusions));
        this.assertDelta(Collections.singletonList(2), Collections.emptyList());
        Assertions.assertEquals(exclusions, (Object)this.delta.apply().activeBrokerReplicaExclusions());
        exclusions.put(4, "4");
        this.delta.replay(this.record(exclusions));
        this.assertDelta(Arrays.asList(2, 4), Collections.emptyList());
        Assertions.assertEquals(exclusions, (Object)this.delta.apply().activeBrokerReplicaExclusions());
        exclusions.remove(3);
        exclusions.remove(1);
        this.delta.replay(this.record(exclusions));
        this.assertDelta(Arrays.asList(2, 4), Arrays.asList(1, 3));
        Assertions.assertEquals(exclusions, (Object)this.delta.apply().activeBrokerReplicaExclusions());
    }

    private void assertDelta(List<Integer> expectedNewExclusions, List<Integer> expectedRemovedExclusions) {
        Assertions.assertEquals(new HashSet<Integer>(expectedNewExclusions), (Object)this.delta.newExclusions());
        Assertions.assertEquals(new HashSet<Integer>(expectedRemovedExclusions), (Object)this.delta.removedExclusions());
    }

    private BrokerReplicaExclusionRecord record(Map<Integer, String> exclusions) {
        return new BrokerReplicaExclusionRecord().setBrokerExclusions(exclusions.entrySet().stream().map(e -> new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId((Integer)e.getKey()).setReason((String)e.getValue())).collect(Collectors.toList()));
    }
}

