/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.CellRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RemoveCellRecord;
import org.apache.kafka.common.metadata.RemoveTenantRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TenantRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.CellControllerMetrics;
import org.apache.kafka.controller.metrics.CellMetrics;
import org.apache.kafka.controller.metrics.ControllerMetrics;
import org.apache.kafka.controller.metrics.ControllerMetricsManager;
import org.apache.kafka.controller.metrics.MockControllerMetrics;
import org.apache.kafka.metadata.BrokerRegistrationFencingChange;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

final class ControllerMetricsManagerTest {
    CellControllerMetrics cellMetrics;
    MetricsRegistry metricsRegistry;

    ControllerMetricsManagerTest() {
    }

    @BeforeEach
    void setUp() {
        this.metricsRegistry = new MetricsRegistry();
        this.cellMetrics = new CellControllerMetrics(this.metricsRegistry, (Time)new MockTime(), new LogContext());
    }

    @AfterEach
    void tearDown() {
        this.metricsRegistry.shutdown();
    }

    @Test
    public void testActiveBrokerRegistration() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, false));
        Assertions.assertEquals((int)1, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testFenceBrokerRegistration() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, true));
        Assertions.assertEquals((int)0, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)1, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testBrokerChangedToActive() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, true));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerChange(1, 1L, BrokerRegistrationFencingChange.UNFENCE));
        Assertions.assertEquals((int)1, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testBrokerLegacyChangedToActive() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, true));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerUnfence(1, 1L));
        Assertions.assertEquals((int)1, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testBrokerChangedToFence() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, false));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerChange(1, 1L, BrokerRegistrationFencingChange.FENCE));
        Assertions.assertEquals((int)0, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)1, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testBrokerLegacyChangedToFence() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, false));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerFence(1, 1L));
        Assertions.assertEquals((int)0, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)1, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testBrokerUnchanged() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, true));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerChange(1, 1L, BrokerRegistrationFencingChange.NONE));
        Assertions.assertEquals((int)0, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)1, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testBrokerUnregister() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, true));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(2, 1L, false));
        Assertions.assertEquals((int)1, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)1, (int)metrics.fencedBrokerCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerUnregistration(1, 1L));
        Assertions.assertEquals((int)1, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerUnregistration(2, 1L));
        Assertions.assertEquals((int)0, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testReplayBatch() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        manager.replayBatch(0L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, true), 0), new ApiMessageAndVersion((ApiMessage)ControllerMetricsManagerTest.brokerChange(1, 1L, BrokerRegistrationFencingChange.UNFENCE), 0)));
        Assertions.assertEquals((int)1, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
    }

    @Test
    public void testTopicCountIncreased() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test"));
        Assertions.assertEquals((int)1, (int)metrics.globalTopicCount());
    }

    @Test
    public void testTopicCountDecreased() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        Uuid id = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test", id));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.removeTopicRecord(id));
        Assertions.assertEquals((int)0, (int)metrics.globalTopicCount());
    }

    @Test
    public void testPartitionCountIncreased() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        Uuid id = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test", id));
        Assertions.assertEquals((int)0, (int)metrics.globalPartitionCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 0, 0, Arrays.asList(0, 1, 2)));
        Assertions.assertEquals((int)1, (int)metrics.globalPartitionCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 1, 0, Arrays.asList(0, 1, 2)));
        Assertions.assertEquals((int)2, (int)metrics.globalPartitionCount());
    }

    @Test
    public void testPartitionCountDecreased() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        Uuid createTopicId = Uuid.randomUuid();
        Uuid createPartitionTopicId = new Uuid(createTopicId.getMostSignificantBits(), createTopicId.getLeastSignificantBits());
        Uuid removeTopicId = new Uuid(createTopicId.getMostSignificantBits(), createTopicId.getLeastSignificantBits());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test", createTopicId));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(createPartitionTopicId, 0, 0, Arrays.asList(0, 1, 2)));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(createPartitionTopicId, 1, 0, Arrays.asList(0, 1, 2)));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.removeTopicRecord(removeTopicId));
    }

    @Test
    public void testOfflinePartition() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        Uuid id = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test", id));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 0, -1, Arrays.asList(0, 1, 2)));
        Assertions.assertEquals((int)1, (int)metrics.globalOfflinePartitionCount());
    }

    @Test
    public void testImbalancedPartition() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        Uuid id = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test", id));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 0, 1, Arrays.asList(0, 1, 2)));
        Assertions.assertEquals((int)1, (int)metrics.preferredReplicaImbalanceCount());
    }

    @Test
    public void testPartitionChange() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        Uuid id = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test", id));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 0, 0, Arrays.asList(0, 1, 2)));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(id, 0, OptionalInt.of(-1), Optional.empty()));
        Assertions.assertEquals((int)1, (int)metrics.globalOfflinePartitionCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(id, 0, OptionalInt.of(1), Optional.empty()));
        Assertions.assertEquals((int)0, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)1, (int)metrics.preferredReplicaImbalanceCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(id, 0, OptionalInt.of(0), Optional.empty()));
        Assertions.assertEquals((int)0, (int)metrics.preferredReplicaImbalanceCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(id, 0, OptionalInt.empty(), Optional.of(Arrays.asList(1, 2, 0))));
        Assertions.assertEquals((int)1, (int)metrics.preferredReplicaImbalanceCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(id, 0, OptionalInt.of(2), Optional.of(Arrays.asList(2, 0, 1))));
        Assertions.assertEquals((int)0, (int)metrics.preferredReplicaImbalanceCount());
    }

    @Test
    public void testMinIsrConfig() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        Uuid id = Uuid.randomUuid();
        String topicName = "test";
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord(topicName, id));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 0, 0, Arrays.asList(0, 1, 2), Arrays.asList(0, 1)));
        Assertions.assertEquals((int)0, (int)metrics.globalUnderMinIsrCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicConfigRecord(topicName, "min.insync.replicas", "3"));
        Assertions.assertEquals((int)1, (int)metrics.globalUnderMinIsrCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicConfigRecord(topicName, "min.insync.replicas", null));
        Assertions.assertEquals((int)0, (int)metrics.globalUnderMinIsrCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.clusterConfigRecord("min.insync.replicas", "3"));
        Assertions.assertEquals((int)1, (int)metrics.globalUnderMinIsrCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.clusterConfigRecord("min.insync.replicas", null));
        Assertions.assertEquals((int)0, (int)metrics.globalUnderMinIsrCount());
    }

    @Test
    public void testMinIsrConfigBeforeTopic() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics, Optional.of(ControllerMetricsManagerTest::topicNameToTenant));
        Uuid id = Uuid.randomUuid();
        String topicName = "lkc-123_test";
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicConfigRecord(topicName, "min.insync.replicas", "3"));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord(topicName, id));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 0, 0, Arrays.asList(0, 1, 2), Arrays.asList(0, 1)));
        Assertions.assertEquals((int)1, (int)metrics.globalUnderMinIsrCount());
        Assertions.assertEquals((int)1, (int)metrics.tenantMetrics().size());
        Assertions.assertEquals((int)1, (int)metrics.tenantMetrics().get("lkc-123").getPartitionCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.removeTopicRecord(id));
        Assertions.assertEquals((int)0, (int)metrics.globalTopicCount());
        Assertions.assertEquals((int)0, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.tenantMetrics().size());
    }

    @Test
    public void testStartingMetrics() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        Assertions.assertEquals((int)0, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.globalTopicCount());
        Assertions.assertEquals((int)0, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.preferredReplicaImbalanceCount());
        Assertions.assertEquals((int)0, (int)metrics.globalUnderMinIsrCount());
    }

    @Test
    public void testReset() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 1L, true));
        Uuid id = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test", id));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(id, 0, 0, Arrays.asList(0, 1, 2), Arrays.asList(0)));
        manager.reset();
        Assertions.assertEquals((int)0, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.fencedBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.globalTopicCount());
        Assertions.assertEquals((int)0, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.preferredReplicaImbalanceCount());
        Assertions.assertEquals((int)0, (int)metrics.globalUnderMinIsrCount());
    }

    @Test
    public void testTenantPartitionMetrics1() throws Exception {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics, Optional.of(ControllerMetricsManagerTest::topicNameToTenant));
        Uuid nonTenantTopicId = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("test", nonTenantTopicId));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(nonTenantTopicId, 0, 0, Arrays.asList(0, 1, 2)));
        Assertions.assertEquals((int)1, (int)metrics.globalTopicCount());
        Assertions.assertEquals((int)0, (int)metrics.tenantMetrics().size());
        Uuid tenantTopicId = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord("lkc-123_bar", tenantTopicId));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(tenantTopicId, 0, 0, Arrays.asList(0, 1, 2)));
        Assertions.assertEquals((int)2, (int)metrics.globalTopicCount());
        Assertions.assertEquals((int)2, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)1, (int)metrics.tenantMetrics().size());
        Assertions.assertEquals((int)1, (int)metrics.tenantMetrics().get("lkc-123").getPartitionCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.removeTopicRecord(nonTenantTopicId));
        Assertions.assertEquals((int)1, (int)metrics.globalTopicCount());
        Assertions.assertEquals((int)1, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)1, (int)metrics.tenantMetrics().get("lkc-123").getPartitionCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.removeTopicRecord(tenantTopicId));
        Assertions.assertEquals((int)0, (int)metrics.globalTopicCount());
        Assertions.assertEquals((int)0, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.tenantMetrics().size());
    }

    @Test
    public void testTenantPartitionMetrics2() throws Exception {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics, Optional.of(ControllerMetricsManagerTest::topicNameToTenant));
        String tenant = "lkc-xyz";
        String fooTopicName = tenant + "_foo";
        Uuid fooTopicId = Uuid.randomUuid();
        String zarTopicName = tenant + "_zar";
        Uuid zarTopicId = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord(fooTopicName, fooTopicId));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(fooTopicId, 0, 0, Arrays.asList(0, 2)));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(fooTopicId, 1, 0, Arrays.asList(0, 1)));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord(zarTopicName, zarTopicId));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(zarTopicId, 0, 0, Arrays.asList(0, 1, 2)));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(zarTopicId, 1, 1, Arrays.asList(1, 2, 3)));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(zarTopicId, 2, 1, Arrays.asList(1, 2, 0)));
        Assertions.assertEquals((int)5, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)5, (int)metrics.tenantMetrics().get(tenant).getPartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.tenantMetrics().get(tenant).getOfflinePartitionCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(fooTopicId, 0, OptionalInt.of(2), Optional.of(Collections.singletonList(2)), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(fooTopicId, 1, OptionalInt.of(1), Optional.of(Collections.singletonList(1)), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 0, OptionalInt.of(1), Optional.of(Arrays.asList(1, 2)), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 2, OptionalInt.empty(), Optional.of(Arrays.asList(1, 2)), Optional.empty()));
        Assertions.assertEquals((int)0, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.tenantMetrics().get(tenant).getOfflinePartitionCount());
        Assertions.assertEquals((int)2, (int)metrics.tenantMetrics().get(tenant).getUnderMinIsrPartitionsCount());
        Assertions.assertEquals((int)3, (int)metrics.preferredReplicaImbalanceCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(fooTopicId, 1, OptionalInt.of(-1), Optional.empty(), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 0, OptionalInt.of(2), Optional.of(Collections.singletonList(2)), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 1, OptionalInt.of(2), Optional.of(Arrays.asList(2, 3)), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 2, OptionalInt.of(2), Optional.of(Collections.singletonList(2)), Optional.empty()));
        Assertions.assertEquals((int)1, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)3, (int)metrics.globalUnderMinIsrCount());
        Assertions.assertEquals((int)1, (int)metrics.tenantMetrics().get(tenant).getOfflinePartitionCount());
        Assertions.assertEquals((int)3, (int)metrics.tenantMetrics().get(tenant).getUnderMinIsrPartitionsCount());
        Assertions.assertEquals((int)5, (int)metrics.preferredReplicaImbalanceCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(fooTopicId, 0, OptionalInt.of(-1), Optional.empty(), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 0, OptionalInt.of(-1), Optional.empty(), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 1, OptionalInt.of(3), Optional.of(Collections.singletonList(3)), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 2, OptionalInt.of(-1), Optional.empty(), Optional.empty()));
        Assertions.assertEquals((int)4, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)1, (int)metrics.globalUnderMinIsrCount());
        Assertions.assertEquals((int)4, (int)metrics.tenantMetrics().get(tenant).getOfflinePartitionCount());
        Assertions.assertEquals((int)1, (int)metrics.tenantMetrics().get(tenant).getUnderMinIsrPartitionsCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 1, OptionalInt.of(-1), Optional.empty(), Optional.empty()));
        Assertions.assertEquals((int)5, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.globalUnderMinIsrCount());
        Assertions.assertEquals((int)5, (int)metrics.tenantMetrics().get(tenant).getOfflinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.tenantMetrics().get(tenant).getUnderMinIsrPartitionsCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.removeTopicRecord(fooTopicId));
        Assertions.assertEquals((int)3, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)3, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.globalUnderMinIsrCount());
        Assertions.assertEquals((int)3, (int)metrics.tenantMetrics().get(tenant).getPartitionCount());
        Assertions.assertEquals((int)3, (int)metrics.tenantMetrics().get(tenant).getOfflinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.tenantMetrics().get(tenant).getUnderMinIsrPartitionsCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.removeTopicRecord(zarTopicId));
        Assertions.assertEquals((int)0, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.globalUnderMinIsrCount());
        Assertions.assertEquals((int)0, (int)metrics.tenantMetrics().size());
    }

    @Test
    public void testTenantGlobalPartitionMetrics() throws Exception {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics, Optional.of(ControllerMetricsManagerTest::topicNameToTenant));
        String tenant = "lkc-xyz";
        String fooTopicName = tenant + "_foo";
        Uuid fooTopicId = Uuid.randomUuid();
        String zarTopicName = "_zar";
        Uuid zarTopicId = Uuid.randomUuid();
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord(fooTopicName, fooTopicId));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(fooTopicId, 0, 0, Arrays.asList(0, 2)));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(fooTopicId, 1, 0, Arrays.asList(0, 1)));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.topicRecord(zarTopicName, zarTopicId));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(zarTopicId, 0, 0, Arrays.asList(0, 1, 2)));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(zarTopicId, 1, 1, Arrays.asList(1, 2, 3)));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionRecord(zarTopicId, 2, 1, Arrays.asList(1, 2, 0)));
        Assertions.assertEquals((int)5, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)2, (int)metrics.tenantMetrics().get(tenant).getPartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.tenantMetrics().get(tenant).getOfflinePartitionCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(fooTopicId, 0, OptionalInt.of(2), Optional.of(Collections.singletonList(2)), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(fooTopicId, 1, OptionalInt.of(1), Optional.of(Collections.singletonList(1)), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 0, OptionalInt.of(1), Optional.of(Arrays.asList(1, 2)), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 2, OptionalInt.empty(), Optional.of(Arrays.asList(1, 2)), Optional.empty()));
        Assertions.assertEquals((int)5, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)2, (int)metrics.globalUnderMinIsrCount());
        Assertions.assertEquals((int)2, (int)metrics.tenantMetrics().get(tenant).getPartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.tenantMetrics().get(tenant).getOfflinePartitionCount());
        Assertions.assertEquals((int)2, (int)metrics.tenantMetrics().get(tenant).getUnderMinIsrPartitionsCount());
        Assertions.assertEquals((int)3, (int)metrics.preferredReplicaImbalanceCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(fooTopicId, 1, OptionalInt.of(-1), Optional.empty(), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 0, OptionalInt.of(2), Optional.of(Collections.singletonList(2)), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 1, OptionalInt.of(2), Optional.of(Arrays.asList(2, 3)), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 2, OptionalInt.of(2), Optional.of(Collections.singletonList(2)), Optional.empty()));
        Assertions.assertEquals((int)1, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)3, (int)metrics.globalUnderMinIsrCount());
        Assertions.assertEquals((int)1, (int)metrics.tenantMetrics().get(tenant).getOfflinePartitionCount());
        Assertions.assertEquals((int)1, (int)metrics.tenantMetrics().get(tenant).getUnderMinIsrPartitionsCount());
        Assertions.assertEquals((int)5, (int)metrics.preferredReplicaImbalanceCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(fooTopicId, 0, OptionalInt.of(-1), Optional.empty(), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 0, OptionalInt.of(-1), Optional.empty(), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 1, OptionalInt.of(3), Optional.of(Collections.singletonList(3)), Optional.empty()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 2, OptionalInt.of(-1), Optional.empty(), Optional.empty()));
        Assertions.assertEquals((int)5, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)4, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)1, (int)metrics.globalUnderMinIsrCount());
        Assertions.assertEquals((int)2, (int)metrics.tenantMetrics().get(tenant).getPartitionCount());
        Assertions.assertEquals((int)2, (int)metrics.tenantMetrics().get(tenant).getOfflinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.tenantMetrics().get(tenant).getUnderMinIsrPartitionsCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.partitionChangeRecord(zarTopicId, 1, OptionalInt.of(-1), Optional.empty(), Optional.empty()));
        Assertions.assertEquals((int)5, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.globalUnderMinIsrCount());
        Assertions.assertEquals((int)2, (int)metrics.tenantMetrics().get(tenant).getOfflinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.tenantMetrics().get(tenant).getUnderMinIsrPartitionsCount());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.removeTopicRecord(fooTopicId));
        Assertions.assertEquals((int)3, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)3, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.globalUnderMinIsrCount());
        Assertions.assertEquals((int)0, (int)metrics.tenantMetrics().size());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.removeTopicRecord(zarTopicId));
        Assertions.assertEquals((int)0, (int)metrics.globalPartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.globalOfflinePartitionCount());
        Assertions.assertEquals((int)0, (int)metrics.globalUnderMinIsrCount());
        Assertions.assertEquals((int)0, (int)metrics.tenantMetrics().size());
    }

    @Test
    public void testDegradationMetricOnNewRegistrations() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics, Optional.of(ControllerMetricsManagerTest::topicNameToTenant));
        manager.replay((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setFenced(false));
        Assertions.assertEquals((int)1, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.brokersWithDegradedHealthCount());
        manager.replay((ApiMessage)new UnregisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0));
        Assertions.assertEquals((int)0, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.brokersWithDegradedHealthCount());
        manager.replay((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setFenced(false).setDegradedComponents(Collections.singletonList(new RegisterBrokerRecord.DegradedComponent().setReason("rcca-123").setComponentCode((byte)0))));
        Assertions.assertEquals((int)1, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)1, (int)metrics.brokersWithDegradedHealthCount());
        manager.replay((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(1).setRack(null).setFenced(false).setDegradedComponents(Collections.singletonList(new RegisterBrokerRecord.DegradedComponent().setReason("rcca-123").setComponentCode((byte)0))));
        Assertions.assertEquals((int)2, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)2, (int)metrics.brokersWithDegradedHealthCount());
    }

    @Test
    public void testDegradationMetricOnRegistrationChanges() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics, Optional.of(ControllerMetricsManagerTest::topicNameToTenant));
        for (int b = 0; b < 3; ++b) {
            manager.replay((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(b).setRack(null).setFenced(false));
        }
        Assertions.assertEquals((int)3, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.brokersWithDegradedHealthCount());
        BrokerRegistrationChangeRecord.DegradedComponent degradedComponent = new BrokerRegistrationChangeRecord.DegradedComponent().setReason("rcca-123").setComponentCode((byte)0);
        manager.replay((ApiMessage)new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setDegradedComponents(Collections.singletonList(degradedComponent)));
        Assertions.assertEquals((int)1, (int)metrics.brokersWithDegradedHealthCount());
        BrokerRegistrationChangeRecord.DegradedComponent degradedComponent2 = new BrokerRegistrationChangeRecord.DegradedComponent().setReason("rcca-234").setComponentCode((byte)1);
        manager.replay((ApiMessage)new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setDegradedComponents(Arrays.asList(degradedComponent, degradedComponent2)));
        Assertions.assertEquals((int)1, (int)metrics.brokersWithDegradedHealthCount());
        manager.replay((ApiMessage)new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(100L).setDegradedComponents(Arrays.asList(degradedComponent, degradedComponent2)));
        Assertions.assertEquals((int)2, (int)metrics.brokersWithDegradedHealthCount());
        manager.replay((ApiMessage)new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced((byte)1));
        Assertions.assertEquals((int)2, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)2, (int)metrics.brokersWithDegradedHealthCount());
        manager.replay((ApiMessage)new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setDegradedComponents(Collections.emptyList()));
        Assertions.assertEquals((int)1, (int)metrics.brokersWithDegradedHealthCount());
        manager.replay((ApiMessage)new UnregisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L));
        Assertions.assertEquals((int)1, (int)metrics.activeBrokerCount());
        Assertions.assertEquals((int)0, (int)metrics.brokersWithDegradedHealthCount());
    }

    @Test
    public void testCellMetrics() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        CellRecord cellRecord = new CellRecord().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setMinSize((short)1).setMaxSize((short)3).setState(CellState.READY.code());
        manager.replay((ApiMessage)cellRecord);
        manager.replay((ApiMessage)cellRecord.setCellId(1).setBrokers(Arrays.asList(3, 4)).setState(CellState.EXCLUDED.code()));
        manager.replay((ApiMessage)cellRecord.setCellId(2).setBrokers(Collections.emptyList()).setState(CellState.QUARANTINED.code()));
        manager.replay((ApiMessage)new TenantRecord().setTenantId("lkc-abcd").setCellId(0));
        manager.replay((ApiMessage)new TenantRecord().setTenantId("lkc-efgh").setCellId(2));
        Uuid topicId = new Uuid(0L, 0L);
        manager.replay((ApiMessage)new TopicRecord().setTopicId(topicId).setName("lkc-abcd_testtopic"));
        manager.replay((ApiMessage)new PartitionRecord().setPartitionId(0).setReplicas(Arrays.asList(0, 1, 2, 3)).setTopicId(topicId));
        Assertions.assertEquals((int)1, (int)this.cellMetrics.numReadyCells());
        Assertions.assertEquals((int)1, (int)this.cellMetrics.numQuarantinedCells());
        Assertions.assertEquals((int)1, (int)this.cellMetrics.numExcludedCells());
        Assertions.assertEquals((int)3, (int)this.cellMetrics.numCellBrokers(0));
        Assertions.assertEquals((int)2, (int)this.cellMetrics.numCellBrokers(1));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numCellBrokers(2));
        Assertions.assertEquals((int)1, (int)this.cellMetrics.numCellTenants(0));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numCellTenants(1));
        Assertions.assertEquals((int)1, (int)this.cellMetrics.numCellTenants(2));
        Assertions.assertEquals((int)1, (int)this.cellMetrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numIncomingTenants(1));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numIncomingTenants(2));
        Assertions.assertEquals((int)3, (int)this.cellMetrics.numCellReplicas(0));
        Assertions.assertEquals((int)1, (int)this.cellMetrics.numCellReplicas(1));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numCellReplicas(2));
        manager.replay((ApiMessage)new PartitionRecord().setPartitionId(0).setReplicas(Arrays.asList(4, 5, 6, 7)).setAddingReplicas(Arrays.asList(4, 5, 6, 7)).setRemovingReplicas(Arrays.asList(0, 1, 2, 3)).setTopicId(topicId));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numCellReplicas(0));
        Assertions.assertEquals((int)1, (int)this.cellMetrics.numCellReplicas(1));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numCellReplicas(2));
        manager.replay((ApiMessage)new RemoveTopicRecord().setTopicId(topicId));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numIncomingTenants(1));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numIncomingTenants(2));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numCellReplicas(0));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numCellReplicas(1));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numCellReplicas(2));
        manager.replay((ApiMessage)new RemoveTenantRecord().setTenantId("lkc-efgh"));
        Assertions.assertEquals((int)1, (int)this.cellMetrics.numCellTenants(0));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numCellTenants(1));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numCellTenants(2));
        manager.replay((ApiMessage)new RemoveCellRecord().setCellId(2));
        Assertions.assertEquals((int)1, (int)this.cellMetrics.numReadyCells());
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numQuarantinedCells());
        Assertions.assertEquals((int)1, (int)this.cellMetrics.numExcludedCells());
    }

    @Test
    public void testCellUnhealthyMetrics() {
        MockControllerMetrics metrics = new MockControllerMetrics();
        ControllerMetricsManager manager = ControllerMetricsManagerTest.metricsManager(metrics, (CellMetrics)this.cellMetrics);
        CellRecord cellRecord = new CellRecord().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setMinSize((short)3).setMaxSize((short)3).setState(CellState.READY.code());
        manager.replay((ApiMessage)cellRecord);
        manager.replay((ApiMessage)cellRecord.setCellId(1).setBrokers(Arrays.asList(3, 4)).setState(CellState.EXCLUDED.code()));
        manager.replay((ApiMessage)cellRecord.setCellId(2).setBrokers(Collections.emptyList()).setState(CellState.QUARANTINED.code()));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(0, 0L, false));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numStrayBrokerCount());
        Assertions.assertEquals((int)3, (int)this.cellMetrics.numCellsNotReadyForTenantAssignment());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(1, 0L, false));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(2, 0L, false));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numStrayBrokerCount());
        Assertions.assertEquals((int)2, (int)this.cellMetrics.numCellsNotReadyForTenantAssignment());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerRegistration(5, 0L, false));
        Assertions.assertEquals((int)1, (int)this.cellMetrics.numStrayBrokerCount());
        Assertions.assertEquals((int)2, (int)this.cellMetrics.numCellsNotReadyForTenantAssignment());
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerUnregistration(5, 0L));
        manager.replay((ApiMessage)ControllerMetricsManagerTest.brokerUnregistration(2, 0L));
        Assertions.assertEquals((int)0, (int)this.cellMetrics.numStrayBrokerCount());
        Assertions.assertEquals((int)3, (int)this.cellMetrics.numCellsNotReadyForTenantAssignment());
    }

    private static RegisterBrokerRecord brokerRegistration(int brokerId, long epoch, boolean fenced) {
        return new RegisterBrokerRecord().setBrokerId(brokerId).setIncarnationId(Uuid.randomUuid()).setBrokerEpoch(epoch).setFenced(fenced);
    }

    private static UnregisterBrokerRecord brokerUnregistration(int brokerId, long epoch) {
        return new UnregisterBrokerRecord().setBrokerId(brokerId).setBrokerEpoch(epoch);
    }

    private static BrokerRegistrationChangeRecord brokerChange(int brokerId, long epoch, BrokerRegistrationFencingChange fencing) {
        return new BrokerRegistrationChangeRecord().setBrokerId(brokerId).setBrokerEpoch(epoch).setFenced(fencing.value());
    }

    private static UnfenceBrokerRecord brokerUnfence(int brokerId, long epoch) {
        return new UnfenceBrokerRecord().setId(brokerId).setEpoch(epoch);
    }

    private static FenceBrokerRecord brokerFence(int brokerId, long epoch) {
        return new FenceBrokerRecord().setId(brokerId).setEpoch(epoch);
    }

    private static TopicRecord topicRecord(String name) {
        return new TopicRecord().setName(name).setTopicId(Uuid.randomUuid());
    }

    private static TopicRecord topicRecord(String name, Uuid id) {
        return new TopicRecord().setName(name).setTopicId(id);
    }

    private static RemoveTopicRecord removeTopicRecord(Uuid id) {
        return new RemoveTopicRecord().setTopicId(id);
    }

    private static PartitionRecord partitionRecord(Uuid id, int partition, int leader, List<Integer> replicas) {
        return ControllerMetricsManagerTest.partitionRecord(id, partition, leader, replicas, replicas);
    }

    private static PartitionRecord partitionRecord(Uuid id, int partition, int leader, List<Integer> replicas, List<Integer> isr) {
        return new PartitionRecord().setPartitionId(partition).setTopicId(id).setReplicas(replicas).setIsr(isr).setLeader(leader);
    }

    private static PartitionChangeRecord partitionChangeRecord(Uuid id, int partition, OptionalInt leader, Optional<List<Integer>> replicas) {
        return ControllerMetricsManagerTest.partitionChangeRecord(id, partition, leader, replicas, replicas);
    }

    private static PartitionChangeRecord partitionChangeRecord(Uuid id, int partition, OptionalInt leader, Optional<List<Integer>> isr, Optional<List<Integer>> replicas) {
        PartitionChangeRecord record = new PartitionChangeRecord();
        leader.ifPresent(record::setLeader);
        replicas.ifPresent(record::setReplicas);
        isr.ifPresent(record::setIsr);
        return record.setPartitionId(partition).setTopicId(id);
    }

    private static ConfigRecord topicConfigRecord(String topicName, String name, String value) {
        return new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(topicName).setName(name).setValue(value);
    }

    private static ConfigRecord clusterConfigRecord(String name, String value) {
        return new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setName(name).setValue(value);
    }

    private static String topicNameToTenant(String name) {
        if (!name.startsWith("lkc-")) {
            return null;
        }
        int delimIndex = name.indexOf("_");
        return delimIndex == -1 ? null : name.substring(0, delimIndex);
    }

    private static ControllerMetricsManager metricsManager(ControllerMetrics metrics, CellMetrics cellMetrics) {
        return ControllerMetricsManagerTest.metricsManager(metrics, cellMetrics, Optional.empty());
    }

    private static ControllerMetricsManager metricsManager(ControllerMetrics metrics, CellMetrics cellMetrics, Optional<Function<String, String>> topicNameToTenant) {
        return new ControllerMetricsManager(metrics, cellMetrics, topicNameToTenant, 2, 3);
    }
}

