/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import com.yammer.metrics.core.MetricsRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.CellControllerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CellControllerMetricsTest {
    CellControllerMetrics metrics;
    MetricsRegistry metricsRegistry;

    CellControllerMetricsTest() {
    }

    @BeforeEach
    void setUp() {
        this.metricsRegistry = new MetricsRegistry();
        this.metrics = new CellControllerMetrics(this.metricsRegistry, (Time)new MockTime(), new LogContext());
    }

    @AfterEach
    void tearDown() {
        this.metricsRegistry.shutdown();
    }

    @Test
    void testNumOutgoingTenants() {
        List<Cell> cells = Arrays.asList(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 3, 3), new Cell(1, new HashSet<Integer>(Arrays.asList(3, 4, 5)), CellState.QUARANTINED, 3, 3), new Cell(2, new HashSet<Integer>(Arrays.asList(6, 7, 8)), CellState.QUARANTINED, 3, 3), new Cell(3, new HashSet<Integer>(Arrays.asList(9, 10, 11)), CellState.QUARANTINED, 3, 3));
        cells.forEach(arg_0 -> ((CellControllerMetrics)this.metrics).updateCell(arg_0));
        String tenantId = "lkc-abcd";
        String topicName = tenantId + "_foo";
        this.metrics.updateTenantIdToCell(tenantId, 0);
        HashMap<Integer, List<Integer>> partitionIdToReplicasAdded = new HashMap<Integer, List<Integer>>();
        partitionIdToReplicasAdded.put(0, Arrays.asList(0, 1, 2));
        partitionIdToReplicasAdded.put(1, Arrays.asList(3, 4, 5));
        partitionIdToReplicasAdded.put(2, Arrays.asList(6, 7, 8));
        partitionIdToReplicasAdded.put(3, Arrays.asList(9, 10, 11));
        this.metrics.updateReplicaCounts(topicName, partitionIdToReplicasAdded, Collections.emptyMap());
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(2));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(3));
        this.metrics.updateTenantIdToCell(tenantId, 2);
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(2));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(3));
        this.metrics.updateCell(new Cell(3, Collections.emptySet(), CellState.QUARANTINED, 3, 3));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(2));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(3));
        HashMap<Integer, List<Integer>> partitionIdToReplicas = new HashMap<Integer, List<Integer>>();
        partitionIdToReplicas.put(1, Arrays.asList(3, 4, 5));
        this.metrics.updateReplicaCounts(topicName, Collections.emptyMap(), partitionIdToReplicas);
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(2));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(3));
        this.metrics.updateReplicaCounts(topicName, partitionIdToReplicas, Collections.emptyMap());
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(2));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(3));
    }

    @Test
    void testNumOutgoingTenantsWithTwoTenants() {
        this.metrics.updateCell(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 3, 3));
        this.metrics.updateCell(new Cell(1, new HashSet<Integer>(Arrays.asList(3, 4, 5)), CellState.QUARANTINED, 3, 3));
        this.metrics.updateCell(new Cell(2, new HashSet<Integer>(Arrays.asList(6, 7, 8)), CellState.QUARANTINED, 3, 3));
        String tenantId = "lkc-abcd";
        String topicName = tenantId + "_foo";
        this.metrics.updateTenantIdToCell(tenantId, 0);
        String secondTenantId = "lkc-efgh";
        String secondTopicName = secondTenantId + "_foo";
        this.metrics.updateTenantIdToCell(secondTenantId, 0);
        HashMap<Integer, List<Integer>> partitionIdToReplicasAdded = new HashMap<Integer, List<Integer>>();
        partitionIdToReplicasAdded.put(0, Arrays.asList(0, 1, 2));
        partitionIdToReplicasAdded.put(1, Arrays.asList(3, 4, 5));
        partitionIdToReplicasAdded.put(2, Arrays.asList(6, 7, 8));
        partitionIdToReplicasAdded.put(3, Arrays.asList(9, 10, 11));
        this.metrics.updateReplicaCounts(topicName, partitionIdToReplicasAdded, Collections.emptyMap());
        this.metrics.updateReplicaCounts(secondTopicName, partitionIdToReplicasAdded, Collections.emptyMap());
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)2, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)2, (int)this.metrics.numOutgoingTenants(2));
        this.metrics.updateTenantIdToCell(secondTenantId, 1);
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)2, (int)this.metrics.numOutgoingTenants(2));
    }

    @Test
    void testUpdateCell() {
        List<Cell> cells = Arrays.asList(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 3, 3), new Cell(1, new HashSet<Integer>(Collections.singletonList(3)), CellState.QUARANTINED, 1, 1), new Cell(2, new HashSet<Integer>(Collections.singletonList(4)), CellState.QUARANTINED, 1, 1), new Cell(3, new HashSet(Collections.emptyList()), CellState.EXCLUDED, 2, 2));
        cells.forEach(arg_0 -> ((CellControllerMetrics)this.metrics).updateCell(arg_0));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellBrokers(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numCellBrokers(1));
        Assertions.assertEquals((int)1, (int)this.metrics.numCellBrokers(2));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellBrokers(3));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(2));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(3));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(2));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(3));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(2));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(3));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(2));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(3));
        Assertions.assertEquals((int)1, (int)this.metrics.numReadyCells());
        Assertions.assertEquals((int)2, (int)this.metrics.numQuarantinedCells());
        Assertions.assertEquals((int)1, (int)this.metrics.numExcludedCells());
    }

    @Test
    void testUpdateCellExpansion() {
        this.metrics.updateCell(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 3, 3));
        String tenantId = "lkc-abcd";
        String topicName = tenantId + "_foo";
        this.metrics.updateTenantIdToCell(tenantId, 0);
        HashMap<Integer, List<Integer>> partitionIdToReplicasAdded = new HashMap<Integer, List<Integer>>();
        partitionIdToReplicasAdded.put(0, Arrays.asList(0, 1, 2));
        partitionIdToReplicasAdded.put(1, Arrays.asList(0, 1, 2));
        partitionIdToReplicasAdded.put(2, Arrays.asList(0, 1, 2));
        this.metrics.updateReplicaCounts(topicName, partitionIdToReplicasAdded, Collections.emptyMap());
        Cell newCell = new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), CellState.READY, 3, 3);
        this.metrics.updateCell(newCell);
        Assertions.assertEquals((int)6, (int)this.metrics.numCellBrokers(0));
        Assertions.assertEquals((int)9, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numReadyCells());
        Assertions.assertEquals((int)0, (int)this.metrics.numQuarantinedCells());
        Assertions.assertEquals((int)0, (int)this.metrics.numExcludedCells());
        Assertions.assertEquals(Collections.singletonList(newCell), new ArrayList(this.metrics.cells()));
    }

    @Test
    void testUpdateCellShrink() {
        this.metrics.updateCell(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 3, 3));
        String tenantId = "lkc-abcd";
        String topicName = tenantId + "_foo";
        this.metrics.updateTenantIdToCell(tenantId, 0);
        HashMap<Integer, List<Integer>> partitionIdToReplicasAdded = new HashMap<Integer, List<Integer>>();
        partitionIdToReplicasAdded.put(0, Arrays.asList(0, 1, 2));
        partitionIdToReplicasAdded.put(1, Arrays.asList(0, 1, 2));
        partitionIdToReplicasAdded.put(2, Arrays.asList(0, 1, 2));
        this.metrics.updateReplicaCounts(topicName, partitionIdToReplicasAdded, Collections.emptyMap());
        Cell newCell = new Cell(0, new HashSet(), CellState.READY, 3, 3);
        this.metrics.updateCell(newCell);
        Assertions.assertEquals((int)0, (int)this.metrics.numCellBrokers(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numReadyCells());
        Assertions.assertEquals((int)0, (int)this.metrics.numQuarantinedCells());
        Assertions.assertEquals((int)0, (int)this.metrics.numExcludedCells());
        Assertions.assertEquals(Collections.singletonList(newCell), new ArrayList(this.metrics.cells()));
    }

    @Test
    void testDeleteCell() {
        this.metrics.updateCell(new Cell(0, new HashSet(Collections.emptyList()), CellState.READY, 3, 3));
        this.metrics.updateCell(new Cell(1, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.QUARANTINED, 3, 3));
        this.metrics.updateCell(new Cell(2, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.EXCLUDED, 3, 3));
        this.metrics.updateCell(new Cell(3, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.EXCLUDED, 3, 3));
        this.metrics.deleteCell(0);
        Assertions.assertEquals((int)0, (int)this.metrics.numCellBrokers(0));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellBrokers(1));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellBrokers(2));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellBrokers(3));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(2));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(3));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(2));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(3));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(2));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(3));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(2));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(3));
        Assertions.assertEquals((int)0, (int)this.metrics.numReadyCells());
        Assertions.assertEquals((int)1, (int)this.metrics.numQuarantinedCells());
        Assertions.assertEquals((int)2, (int)this.metrics.numExcludedCells());
    }

    @Test
    void testUpdateTenantIdToCell() {
        List<Cell> cells = Arrays.asList(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 3, 3), new Cell(1, new HashSet<Integer>(Arrays.asList(3, 4, 5)), CellState.QUARANTINED, 3, 3));
        cells.forEach(arg_0 -> ((CellControllerMetrics)this.metrics).updateCell(arg_0));
        String tenantId = "lkc-abcd";
        String topicName = tenantId + "_foo";
        this.metrics.updateTenantIdToCell(tenantId, 0);
        HashMap<Integer, List<Integer>> partitionIdToReplicasAdded = new HashMap<Integer, List<Integer>>();
        partitionIdToReplicasAdded.put(0, Arrays.asList(0, 1, 2));
        partitionIdToReplicasAdded.put(1, Arrays.asList(0, 1, 2));
        partitionIdToReplicasAdded.put(2, Arrays.asList(0, 1, 2));
        partitionIdToReplicasAdded.put(3, Arrays.asList(3, 4, 5));
        this.metrics.updateReplicaCounts(topicName, partitionIdToReplicasAdded, Collections.emptyMap());
        Assertions.assertEquals((int)1, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)1, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)9, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellReplicas(1));
        this.metrics.updateTenantIdToCell(tenantId, 1);
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)9, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellReplicas(1));
        HashMap<Integer, List<Integer>> partitionIdToReplicasRemoved = new HashMap<Integer, List<Integer>>();
        partitionIdToReplicasRemoved.put(0, Arrays.asList(0, 1, 2));
        partitionIdToReplicasRemoved.put(1, Arrays.asList(0, 1, 2));
        partitionIdToReplicasRemoved.put(2, Arrays.asList(0, 1, 2));
        this.metrics.updateReplicaCounts(topicName, Collections.emptyMap(), partitionIdToReplicasRemoved);
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellReplicas(1));
    }

    @Test
    void testUpdateReplicaCountsMultipleTimes() {
        List<Cell> cells = Arrays.asList(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 3, 3), new Cell(1, new HashSet<Integer>(Arrays.asList(3, 4, 5)), CellState.QUARANTINED, 3, 3));
        cells.forEach(arg_0 -> ((CellControllerMetrics)this.metrics).updateCell(arg_0));
        String tenantId = "lkc-abcd";
        String topicName = tenantId + "_foo";
        this.metrics.updateTenantIdToCell(tenantId, 0);
        HashMap<Integer, List<Integer>> partitionIdToReplicasAdded = new HashMap<Integer, List<Integer>>();
        partitionIdToReplicasAdded.put(0, Arrays.asList(0, 1, 2));
        partitionIdToReplicasAdded.put(1, Arrays.asList(0, 1, 2));
        partitionIdToReplicasAdded.put(2, Arrays.asList(0, 1, 2));
        partitionIdToReplicasAdded.put(3, Arrays.asList(3, 4, 5));
        this.metrics.updateReplicaCounts(topicName, partitionIdToReplicasAdded, Collections.emptyMap());
        HashMap<Integer, List<Integer>> secondPartitionIdToReplicasAdded = new HashMap<Integer, List<Integer>>();
        secondPartitionIdToReplicasAdded.put(4, Arrays.asList(0, 1, 2));
        secondPartitionIdToReplicasAdded.put(5, Arrays.asList(0, 1, 2));
        secondPartitionIdToReplicasAdded.put(6, Arrays.asList(0, 1, 2));
        this.metrics.updateReplicaCounts(topicName, secondPartitionIdToReplicasAdded, Collections.emptyMap());
        Assertions.assertEquals((int)1, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)1, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)18, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellReplicas(1));
        HashMap<Integer, List<Integer>> partitionIdToReplicasRemoved = new HashMap<Integer, List<Integer>>();
        partitionIdToReplicasRemoved.put(3, Arrays.asList(3, 4, 5));
        this.metrics.updateReplicaCounts(topicName, Collections.emptyMap(), partitionIdToReplicasRemoved);
        Assertions.assertEquals((int)1, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)18, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(1));
    }

    @Test
    void testUpdateTenantIdToCellWithBrokerUnassignment() {
        List<Cell> cells = Arrays.asList(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 1, 3), new Cell(1, new HashSet<Integer>(Arrays.asList(3, 4, 5)), CellState.QUARANTINED, 1, 3));
        cells.forEach(arg_0 -> ((CellControllerMetrics)this.metrics).updateCell(arg_0));
        String tenantId = "lkc-abcd";
        String topicName = tenantId + "_foo";
        this.metrics.updateTenantIdToCell(tenantId, 0);
        HashMap<Integer, List<Integer>> partitionIdToReplicasAdded = new HashMap<Integer, List<Integer>>();
        partitionIdToReplicasAdded.put(0, Arrays.asList(0, 1, 2));
        partitionIdToReplicasAdded.put(1, Arrays.asList(0, 1, 2));
        partitionIdToReplicasAdded.put(2, Arrays.asList(0, 1, 2));
        partitionIdToReplicasAdded.put(3, Arrays.asList(3, 4, 5));
        this.metrics.updateReplicaCounts(topicName, partitionIdToReplicasAdded, Collections.emptyMap());
        List<Cell> newCells = Arrays.asList(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1)), CellState.READY, 2, 2), new Cell(2, new HashSet<Integer>(Arrays.asList(4, 5)), CellState.EXCLUDED, 2, 2), new Cell(1, new HashSet<Integer>(Arrays.asList(2, 3)), CellState.QUARANTINED, 2, 2));
        newCells.forEach(arg_0 -> ((CellControllerMetrics)this.metrics).updateCell(arg_0));
        Assertions.assertEquals((int)1, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(2));
        Assertions.assertEquals((int)1, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(2));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(2));
        Assertions.assertEquals((int)6, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)4, (int)this.metrics.numCellReplicas(1));
        Assertions.assertEquals((int)2, (int)this.metrics.numCellReplicas(2));
    }

    @Test
    void testDeleteTenant() {
        List<Cell> cells = Arrays.asList(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 1, 3), new Cell(1, new HashSet<Integer>(Arrays.asList(3, 4, 5)), CellState.QUARANTINED, 1, 3));
        cells.forEach(arg_0 -> ((CellControllerMetrics)this.metrics).updateCell(arg_0));
        String tenantId = "lkc-abcd";
        this.metrics.updateTenantIdToCell(tenantId, 0);
        this.metrics.deleteTenant(tenantId);
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(1));
        this.metrics.deleteTenant(tenantId);
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(1));
    }

    @Test
    void testFullLifecycle() {
        String tenantId = "lkc-abcd";
        String secondTenantId = "lkc-efgh";
        String thirdTenantId = "lkc-ijkl";
        List<Cell> cells = Arrays.asList(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 1, 3), new Cell(1, new HashSet<Integer>(Arrays.asList(3, 4, 5)), CellState.QUARANTINED, 1, 3));
        cells.forEach(arg_0 -> ((CellControllerMetrics)this.metrics).updateCell(arg_0));
        this.metrics.updateTenantIdToCell(tenantId, 0);
        this.metrics.updateTenantIdToCell(secondTenantId, 0);
        this.metrics.updateTenantIdToCell(thirdTenantId, 1);
        String tenantOneTopicName = tenantId + "_foo";
        HashMap<Integer, List<Integer>> tenantPartitionIdToReplicas = new HashMap<Integer, List<Integer>>();
        tenantPartitionIdToReplicas.put(0, Arrays.asList(0, 1, 2));
        tenantPartitionIdToReplicas.put(1, Arrays.asList(0, 1, 2));
        tenantPartitionIdToReplicas.put(2, Arrays.asList(0, 1, 2));
        tenantPartitionIdToReplicas.put(3, Arrays.asList(3, 4, 5));
        this.metrics.updateReplicaCounts(tenantOneTopicName, tenantPartitionIdToReplicas, Collections.emptyMap());
        String tenantTwoTopicName = secondTenantId + "_bar";
        HashMap<Integer, List<Integer>> secondTenantPartitionIdToReplicas = new HashMap<Integer, List<Integer>>();
        secondTenantPartitionIdToReplicas.put(0, Arrays.asList(0, 1, 2));
        secondTenantPartitionIdToReplicas.put(1, Arrays.asList(0, 1, 2));
        this.metrics.updateReplicaCounts(tenantTwoTopicName, secondTenantPartitionIdToReplicas, Collections.emptyMap());
        Assertions.assertEquals((int)1, (int)this.metrics.numReadyCells());
        Assertions.assertEquals((int)0, (int)this.metrics.numExcludedCells());
        Assertions.assertEquals((int)1, (int)this.metrics.numQuarantinedCells());
        Assertions.assertEquals((int)3, (int)this.metrics.numCellBrokers(0));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellBrokers(1));
        Assertions.assertEquals((int)2, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)1, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)15, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellReplicas(1));
        this.metrics.updateTenantIdToCell(tenantId, 1);
        Assertions.assertEquals((int)1, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)2, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)15, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellReplicas(1));
        this.metrics.updateReplicaCounts(tenantTwoTopicName, Collections.emptyMap(), secondTenantPartitionIdToReplicas);
        Assertions.assertEquals((int)1, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)2, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)9, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellReplicas(1));
        this.metrics.deleteTenant(secondTenantId);
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)2, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)1, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)1, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)9, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellReplicas(1));
        this.metrics.updateCell(new Cell(0, new HashSet(), CellState.READY, 1, 3));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellBrokers(0));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellBrokers(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)2, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellReplicas(1));
        this.metrics.deleteCell(0);
        Assertions.assertEquals((int)0, (int)this.metrics.numReadyCells());
        Assertions.assertEquals((int)0, (int)this.metrics.numExcludedCells());
        Assertions.assertEquals((int)1, (int)this.metrics.numQuarantinedCells());
        Assertions.assertEquals((int)0, (int)this.metrics.numCellBrokers(0));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellBrokers(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellTenants(0));
        Assertions.assertEquals((int)2, (int)this.metrics.numCellTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numIncomingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(0));
        Assertions.assertEquals((int)0, (int)this.metrics.numOutgoingTenants(1));
        Assertions.assertEquals((int)0, (int)this.metrics.numCellReplicas(0));
        Assertions.assertEquals((int)3, (int)this.metrics.numCellReplicas(1));
    }

    @Test
    void testUpdateUnhealthyCellStats() {
        this.metrics.updateUnhealthyCellStats(2, 3);
        Assertions.assertEquals((int)2, (int)this.metrics.numCellsNotReadyForTenantAssignment());
        Assertions.assertEquals((int)3, (int)this.metrics.numStrayBrokerCount());
        this.metrics.updateUnhealthyCellStats(10, 20);
        Assertions.assertEquals((int)10, (int)this.metrics.numCellsNotReadyForTenantAssignment());
        Assertions.assertEquals((int)20, (int)this.metrics.numStrayBrokerCount());
    }
}

