/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellLoad;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterCellResponseData;
import org.apache.kafka.common.message.AssignBrokersToCellResponseData;
import org.apache.kafka.common.message.CreateCellResponseData;
import org.apache.kafka.common.message.DeleteCellResponseData;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.common.message.UnAssignBrokersFromCellResponseData;
import org.apache.kafka.common.metadata.CellRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.RemoveCellRecord;
import org.apache.kafka.common.metadata.TenantRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterCellRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.AssignBrokersToCellRequest;
import org.apache.kafka.common.requests.CreateCellRequest;
import org.apache.kafka.common.requests.DeleteCellRequest;
import org.apache.kafka.common.requests.DescribeCellsRequest;
import org.apache.kafka.common.requests.UnAssignBrokersFromCellRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.CellControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.controller.TenantControlManager;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CellControlManagerTest {
    LogContext logContext = new LogContext();
    SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
    FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(this.snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
    FeatureControlManager legacyFeatureControl = new FeatureControlManager.Builder().setSnapshotRegistry(this.snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.IBP_3_3_IV3).build();
    Random random = new Random(0L);

    CellControlManagerTest() {
    }

    @Test
    void testCreateCellForBroker() {
        short defaultCellSize = 2;
        short defaultCellMinSize = 2;
        short defaultCellMaxSize = 3;
        CellControlManager control = new CellControlManager(this.logContext, Time.SYSTEM, this.snapshotRegistry, this.featureControl, this.random, defaultCellSize, defaultCellMinSize, defaultCellMaxSize, true);
        ArrayList records = new ArrayList();
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize(defaultCellMinSize).setMaxSize(defaultCellMaxSize).setBrokers(Collections.singletonList(0));
        Assertions.assertEquals((int)0, (int)control.createCellForBroker(0, records::add));
        Assertions.assertEquals((int)0, (int)control.createCellForBroker(1, records::add));
        Assertions.assertEquals((int)1, (int)control.createCellForBroker(2, records::add));
        List<ApiMessageAndVersion> expectedRecords = Arrays.asList(new ApiMessageAndVersion((ApiMessage)cellRecord, MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)cellRecord.duplicate().setBrokers(Collections.singletonList(1)), MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)cellRecord.duplicate().setCellId(1).setBrokers(Collections.singletonList(2)), MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedRecords, records);
        control.replay(cellRecord.setBrokers(Arrays.asList(3, 4, 5)));
        ArrayList newRecords = new ArrayList();
        Assertions.assertEquals((int)-1, (int)control.createCellForBroker(0, newRecords::add));
        Assertions.assertEquals(new ArrayList(), newRecords);
    }

    @Test
    void testCreateCellForBrokerAtMaxCellSize() {
        short defaultCellSize = 2;
        short defaultCellMinSize = 2;
        short defaultCellMaxSize = 3;
        CellControlManager control = new CellControlManager(this.logContext, Time.SYSTEM, this.snapshotRegistry, this.featureControl, this.random, defaultCellSize, defaultCellMinSize, defaultCellMaxSize, true);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize(defaultCellMinSize).setMaxSize(defaultCellMaxSize).setBrokers(Arrays.asList(5, 6, 7));
        control.replay(cellRecord);
        ArrayList records = new ArrayList();
        ApiMessageAndVersion expectedRecord = new ApiMessageAndVersion((ApiMessage)cellRecord, MetadataRecordType.CELL_RECORD.highestSupportedVersion());
        Assertions.assertEquals((int)-1, (int)control.createCellForBroker(0, records::add));
        Assertions.assertEquals((int)0, (int)records.size());
        Assertions.assertEquals((int)0, (int)control.createCellForBroker(5, records::add));
        Assertions.assertEquals((int)0, (int)control.createCellForBroker(6, records::add));
        Assertions.assertEquals((int)0, (int)control.createCellForBroker(7, records::add));
        Assertions.assertEquals((int)0, (int)records.size());
    }

    @Test
    void testSortedCells() {
        short defaultCellSize = 2;
        short defaultCellMinSize = 2;
        short defaultCellMaxSize = 3;
        CellControlManager control = new CellControlManager(this.logContext, Time.SYSTEM, this.snapshotRegistry, this.featureControl, this.random, defaultCellSize, defaultCellMinSize, defaultCellMaxSize, true);
        Assertions.assertEquals(new ArrayList(), (Object)control.sortedCells());
        CellRecord createCellRecord = new CellRecord().setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3);
        control.replay(createCellRecord.setCellId(3));
        control.replay(createCellRecord.setCellId(1));
        control.replay(createCellRecord.setCellId(2));
        control.replay(createCellRecord.setCellId(5));
        control.replay(createCellRecord.setCellId(4));
        control.replay(createCellRecord.setCellId(0));
        List expectedCells = IntStream.range(0, 6).mapToObj(cellId -> new Cell(cellId, new HashSet(), CellState.READY, 2, 3)).collect(Collectors.toList());
        Assertions.assertEquals(expectedCells, (Object)control.sortedCells());
    }

    @Test
    void testGetCell() {
        short defaultCellSize = 2;
        short defaultCellMinSize = 2;
        short defaultCellMaxSize = 3;
        CellControlManager control = new CellControlManager(this.logContext, Time.SYSTEM, this.snapshotRegistry, this.featureControl, this.random, defaultCellSize, defaultCellMinSize, defaultCellMaxSize, true);
        Assertions.assertEquals(Optional.empty(), (Object)control.getCell(0));
        CellRecord createCellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3);
        control.replay(createCellRecord);
        Cell expectedCell = new Cell(0, new HashSet(), CellState.READY, 2, 3);
        Assertions.assertEquals(Optional.of(expectedCell), (Object)control.getCell(0));
    }

    @Test
    void testGetBrokerCellId() {
        short defaultCellSize = 2;
        short defaultCellMinSize = 2;
        short defaultCellMaxSize = 3;
        CellControlManager control = new CellControlManager(this.logContext, Time.SYSTEM, this.snapshotRegistry, this.featureControl, this.random, defaultCellSize, defaultCellMinSize, defaultCellMaxSize, true);
        Assertions.assertEquals((int)-1, (int)control.getBrokerCellId(0));
        CellRecord createCellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3).setBrokers(Arrays.asList(0, 1));
        control.replay(createCellRecord);
        Assertions.assertEquals((int)0, (int)control.getBrokerCellId(0));
        Assertions.assertEquals((int)0, (int)control.getBrokerCellId(1));
    }

    @Test
    void testComputeUsableCell() {
        MockTime time = new MockTime(0L, 1000L, 0L);
        CellControlManager control = new CellControlManager(this.logContext, (Time)time, this.snapshotRegistry, this.featureControl, this.random, 2, 2, 3, true);
        Assertions.assertEquals(Optional.empty(), (Object)control.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2)), 1));
        CellRecord createCellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3);
        control.replay(createCellRecord.setBrokers(Arrays.asList(0, 1)));
        control.replay(createCellRecord.setCellId(1).setBrokers(Arrays.asList(2, 3)));
        control.replay(createCellRecord.setCellId(2).setBrokers(Arrays.asList(4, 5)));
        Assertions.assertEquals(Optional.of(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1)), CellState.READY, 2, 3)), (Object)control.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), 1));
        Assertions.assertEquals(Optional.of(new Cell(1, new HashSet<Integer>(Arrays.asList(2, 3)), CellState.READY, 2, 3)), (Object)control.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), 1));
        Assertions.assertEquals(Optional.of(new Cell(2, new HashSet<Integer>(Arrays.asList(4, 5)), CellState.READY, 2, 3)), (Object)control.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), 1));
        Assertions.assertEquals(Optional.of(new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1)), CellState.READY, 2, 3)), (Object)control.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), 1));
        HashSet<CellLoad> cellLoads = new HashSet<CellLoad>(Arrays.asList(new CellLoad(0, 0.5), new CellLoad(1, 0.1), new CellLoad(2, 0.1)));
        control.fullUpdateCellLoadCache(cellLoads, 1000L);
        Assertions.assertEquals(Optional.of(new Cell(1, new HashSet<Integer>(Arrays.asList(2, 3)), CellState.READY, 2, 3)), (Object)control.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), 1));
        Assertions.assertEquals(Optional.of(new Cell(1, new HashSet<Integer>(Arrays.asList(2, 3)), CellState.READY, 2, 3)), (Object)control.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), 1));
        Assertions.assertEquals(Optional.of(new Cell(1, new HashSet<Integer>(Arrays.asList(2, 3)), CellState.READY, 2, 3)), (Object)control.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), 1));
        Assertions.assertEquals(Optional.of(new Cell(2, new HashSet<Integer>(Arrays.asList(4, 5)), CellState.READY, 2, 3)), (Object)control.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), 1));
    }

    @Test
    void testComputeUsableCellPowerOfTwoSimulation() {
        int runs = 100000;
        long currTime = 0L;
        MockTime time = new MockTime(0L, currTime, currTime);
        CellControlManager control = new CellControlManager(this.logContext, (Time)time, this.snapshotRegistry, this.featureControl, this.random, 2, 2, 3, true);
        CellRecord cellRecord = new CellRecord().setState(CellState.READY.code()).setMinSize((short)1).setMaxSize((short)2);
        control.replay(cellRecord.setCellId(0).setBrokers(Collections.singletonList(0)));
        control.replay(cellRecord.setCellId(1).setBrokers(Collections.singletonList(1)));
        control.replay(cellRecord.setCellId(2).setBrokers(Collections.singletonList(2)));
        control.replay(cellRecord.setCellId(3).setBrokers(Collections.singletonList(3)));
        control.replay(cellRecord.setCellId(4).setBrokers(Collections.singletonList(4)));
        HashSet<CellLoad> cellLoads = new HashSet<CellLoad>(Arrays.asList(new CellLoad(0, 0.0), new CellLoad(1, 0.1), new CellLoad(2, 0.2), new CellLoad(3, 0.3), new CellLoad(4, 0.4)));
        control.fullUpdateCellLoadCache(cellLoads, currTime);
        List<AtomicInteger> cellsChosen = Arrays.asList(new AtomicInteger(), new AtomicInteger(), new AtomicInteger(), new AtomicInteger(), new AtomicInteger());
        for (int i = 0; i < runs; ++i) {
            Cell chosenCell = (Cell)control.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4)), 1).get();
            cellsChosen.get(chosenCell.cellId()).getAndIncrement();
        }
        double firstChosenRatio = (double)cellsChosen.get(0).get() / (double)runs;
        double secondChosenRatio = (double)cellsChosen.get(1).get() / (double)runs;
        double thirdChosenRatio = (double)cellsChosen.get(2).get() / (double)runs;
        double fourthChosenRatio = (double)cellsChosen.get(3).get() / (double)runs;
        double fifthChosenRatio = (double)cellsChosen.get(4).get() / (double)runs;
        double error = 0.01;
        Assertions.assertTrue((Math.abs(firstChosenRatio - 0.4) < error ? 1 : 0) != 0);
        Assertions.assertTrue((Math.abs(secondChosenRatio - 0.3) < error ? 1 : 0) != 0);
        Assertions.assertTrue((Math.abs(thirdChosenRatio - 0.2) < error ? 1 : 0) != 0);
        Assertions.assertTrue((Math.abs(fourthChosenRatio - 0.1) < error ? 1 : 0) != 0);
        Assertions.assertEquals((double)0.0, (double)fifthChosenRatio);
    }

    @Test
    void testComputeUsableCellBrokerCountConsideration() {
        int runs = 100;
        long currTime = 1000L;
        MockTime time = new MockTime(0L, currTime, currTime);
        CellControlManager control = new CellControlManager(this.logContext, (Time)time, this.snapshotRegistry, this.featureControl, this.random, 2, 2, 3, true);
        control.replay(new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)1).setMaxSize((short)1).setBrokers(Collections.singletonList(0)));
        control.replay(new CellRecord().setCellId(1).setState(CellState.READY.code()).setMinSize((short)5).setMaxSize((short)5).setBrokers(Arrays.asList(1, 2, 3, 4, 5)));
        HashSet<CellLoad> cellLoads = new HashSet<CellLoad>(Arrays.asList(new CellLoad(0, 0.0), new CellLoad(1, 0.1)));
        control.fullUpdateCellLoadCache(cellLoads, currTime);
        List<AtomicInteger> cellsChosen = Arrays.asList(new AtomicInteger(), new AtomicInteger());
        for (int i = 0; i < runs; ++i) {
            Cell chosenCell = (Cell)control.computeUsableCell(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)), 5).get();
            cellsChosen.get(chosenCell.cellId()).getAndIncrement();
        }
        double firstChosenRatio = (double)cellsChosen.get(0).get() / (double)runs;
        double secondChosenRatio = (double)cellsChosen.get(1).get() / (double)runs;
        Assertions.assertTrue((firstChosenRatio == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((secondChosenRatio == 1.0 ? 1 : 0) != 0);
    }

    @Test
    void testCreateCellOldVersion() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.legacyFeatureControl, this.random, 2, 2, 3, true);
        CreateCellRequest createRequest = (CreateCellRequest)new CreateCellRequest.Builder().setCellId(0).setState(CellState.READY).build();
        Assertions.assertThrows(UnsupportedVersionException.class, () -> control.createCell(createRequest));
    }

    @Test
    void testAlterCellOldVersion() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.legacyFeatureControl, this.random, 2, 2, 3, true);
        AlterCellRequest alterRequest = (AlterCellRequest)new AlterCellRequest.Builder().setCellId(0).setState(CellState.READY).build();
        Assertions.assertThrows(UnsupportedVersionException.class, () -> control.alterCell(alterRequest, new HashSet()));
    }

    @Test
    void testDeleteCellOldVersion() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.legacyFeatureControl, this.random, 2, 2, 3, true);
        DeleteCellRequest deleteRequest = (DeleteCellRequest)new DeleteCellRequest.Builder().setCellId(0).build();
        Assertions.assertThrows(UnsupportedVersionException.class, () -> control.deleteCell(deleteRequest));
    }

    @Test
    void testAssignBrokersToCellOldVersion() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.legacyFeatureControl, this.random, 2, 2, 3, true);
        AssignBrokersToCellRequest assignRequest = (AssignBrokersToCellRequest)new AssignBrokersToCellRequest.Builder().setCellId(0).setBrokers(Arrays.asList(0, 1)).build();
        Assertions.assertThrows(UnsupportedVersionException.class, () -> control.assignBrokersToCell(assignRequest, new HashSet()));
    }

    @Test
    void testUnassignBrokersFromCellOldVersion() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.legacyFeatureControl, this.random, 2, 2, 3, true);
        UnAssignBrokersFromCellRequest unassignRequest = (UnAssignBrokersFromCellRequest)new UnAssignBrokersFromCellRequest.Builder().setBrokers(Arrays.asList(0, 1)).build();
        Assertions.assertThrows(UnsupportedVersionException.class, () -> control.unassignBrokersFromCell(unassignRequest, new HashSet()));
    }

    @Test
    void testDescribeCellsRequest() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 2, 2, 3, true);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)3).setBrokers(Arrays.asList(0, 1, 2));
        control.replay(cellRecord);
        control.replay(cellRecord.setCellId(1).setBrokers(Arrays.asList(3, 4, 5)));
        DescribeCellsRequest request = (DescribeCellsRequest)new DescribeCellsRequest.Builder().setCellId(new ArrayList()).build();
        ControllerResult controllerResult = control.describeCells(request, new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4)));
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        DescribeCellsResponseData expectedResponse = new DescribeCellsResponseData().setCellsEnabled(true).setCells(Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setState(CellState.READY.code()).setBrokers(Arrays.asList(0, 1, 2)).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(1).setState(CellState.READY.code()).setBrokers(Arrays.asList(3, 4, 5))));
        Assertions.assertEquals((Object)expectedResponse, (Object)controllerResult.response());
        DescribeCellsRequest secondRequest = (DescribeCellsRequest)new DescribeCellsRequest.Builder().setCellId(Collections.singletonList(1)).build();
        ControllerResult secondControllerResult = control.describeCells(secondRequest, new HashSet<Integer>(Arrays.asList(0, 1, 2)));
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        DescribeCellsResponseData secondExpectedResponse = new DescribeCellsResponseData().setCellsEnabled(true).setCells(Collections.singletonList(new DescribeCellsResponseData.Cell().setCellId(1).setState(CellState.READY.code()).setBrokers(Arrays.asList(3, 4, 5))));
        Assertions.assertEquals((Object)secondExpectedResponse, (Object)secondControllerResult.response());
    }

    @Test
    void testCreateCellRequest() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 2, 2, 3, true);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)3).setBrokers(Arrays.asList(0, 1, 2));
        control.replay(cellRecord);
        CreateCellRequest request = (CreateCellRequest)new CreateCellRequest.Builder().setCellId(0).setState(CellState.READY).build();
        ControllerResult controllerResult = control.createCell(request);
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)((CreateCellResponseData)controllerResult.response()).errorCode());
        request = (CreateCellRequest)new CreateCellRequest.Builder().setCellId(1).setState(CellState.UNKNOWN).build();
        controllerResult = control.createCell(request);
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)((CreateCellResponseData)controllerResult.response()).errorCode());
        CellRecord expectedRecord = new CellRecord().setCellId(1).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)3).setBrokers(new ArrayList<Integer>());
        List<ApiMessageAndVersion> expectedRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)expectedRecord, MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        request = (CreateCellRequest)new CreateCellRequest.Builder().setCellId(1).setState(CellState.READY).build();
        controllerResult = control.createCell(request);
        Assertions.assertEquals(expectedRecords, (Object)controllerResult.records());
        Assertions.assertEquals((short)ApiError.NONE.error().code(), (short)((CreateCellResponseData)controllerResult.response()).errorCode());
    }

    @Test
    void testAlterCellRequest() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 2, 2, 3, true);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)3).setBrokers(Arrays.asList(0, 1, 2));
        control.replay(cellRecord);
        ControllerResult controllerResult = control.alterCell((AlterCellRequest)new AlterCellRequest.Builder().setCellId(1).setState(CellState.READY).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2)));
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        Assertions.assertEquals((short)Errors.CELL_NOT_FOUND.code(), (short)((AlterCellResponseData)controllerResult.response()).errorCode());
        controllerResult = control.alterCell((AlterCellRequest)new AlterCellRequest.Builder().setCellId(0).setState(CellState.UNKNOWN).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2)));
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)((AlterCellResponseData)controllerResult.response()).errorCode());
        CellRecord expectedRecord = new CellRecord().setCellId(0).setState(CellState.QUARANTINED.code()).setMinSize((short)3).setMaxSize((short)3).setBrokers(Arrays.asList(0, 1, 2));
        List<ApiMessageAndVersion> expectedRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)expectedRecord, MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        controllerResult = control.alterCell((AlterCellRequest)new AlterCellRequest.Builder().setCellId(0).setState(CellState.QUARANTINED).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2)));
        Assertions.assertEquals(expectedRecords, (Object)controllerResult.records());
        Assertions.assertEquals((short)ApiError.NONE.error().code(), (short)((AlterCellResponseData)controllerResult.response()).errorCode());
    }

    @Test
    void testAssignBrokersToCellRequest() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 3, 3, 6, true);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6).setBrokers(Arrays.asList(0, 1, 2));
        control.replay(cellRecord);
        ControllerResult controllerResult = control.assignBrokersToCell((AssignBrokersToCellRequest)new AssignBrokersToCellRequest.Builder().setCellId(1).setBrokers(Arrays.asList(3, 4, 5)).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5)));
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        Assertions.assertEquals((short)Errors.CELL_NOT_FOUND.code(), (short)((AssignBrokersToCellResponseData)controllerResult.response()).errorCode());
        controllerResult = control.assignBrokersToCell((AssignBrokersToCellRequest)new AssignBrokersToCellRequest.Builder().setCellId(0).setBrokers(Arrays.asList(3, 4, 5, 6)).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6)));
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)((AssignBrokersToCellResponseData)controllerResult.response()).errorCode());
        CellRecord expectedRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6).setBrokers(Arrays.asList(0, 1, 2, 3, 4, 5));
        List<ApiMessageAndVersion> expectedRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)expectedRecord, MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        controllerResult = control.assignBrokersToCell((AssignBrokersToCellRequest)new AssignBrokersToCellRequest.Builder().setCellId(0).setBrokers(Arrays.asList(3, 4, 5)).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6)));
        Assertions.assertEquals(expectedRecords, (Object)controllerResult.records());
        Assertions.assertEquals((short)ApiError.NONE.error().code(), (short)((AssignBrokersToCellResponseData)controllerResult.response()).errorCode());
    }

    @Test
    void testAssignBrokersToCellRequestByUnassigningFromAnotherCell() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 3, 3, 6, true);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6).setBrokers(Arrays.asList(0, 1, 2));
        control.replay(cellRecord);
        control.replay(cellRecord.setCellId(1).setBrokers(Arrays.asList(3, 4, 5)));
        CellRecord expectedCell0Record = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6).setBrokers(Arrays.asList(0, 1, 2, 3, 4, 5));
        CellRecord expectedCell1Record = new CellRecord().setCellId(1).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6).setBrokers(Collections.emptyList());
        List<ApiMessageAndVersion> expectedRecords = Arrays.asList(new ApiMessageAndVersion((ApiMessage)expectedCell0Record, MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)expectedCell1Record, MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        ControllerResult controllerResult = control.assignBrokersToCell((AssignBrokersToCellRequest)new AssignBrokersToCellRequest.Builder().setCellId(0).setBrokers(Arrays.asList(3, 4, 5)).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6)));
        Assertions.assertEquals(expectedRecords, (Object)controllerResult.records());
        Assertions.assertEquals((short)ApiError.NONE.error().code(), (short)((AssignBrokersToCellResponseData)controllerResult.response()).errorCode());
    }

    @Test
    void testAssignBrokersToCellRequestWithTenant() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 3, 3, 6, true);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)6).setBrokers(Arrays.asList(0, 1, 2));
        control.replay(cellRecord);
        CellRecord secondCellRecord = new CellRecord().setCellId(1).setState(CellState.READY.code()).setMinSize((short)1).setMaxSize((short)6);
        control.replay(secondCellRecord);
        control.replay(new TenantRecord().setTenantId("lkc-abcd").setCellId(0));
        ControllerResult controllerResult = control.assignBrokersToCell((AssignBrokersToCellRequest)new AssignBrokersToCellRequest.Builder().setCellId(1).setBrokers(Arrays.asList(0, 1)).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2)));
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)((AssignBrokersToCellResponseData)controllerResult.response()).errorCode());
    }

    @Test
    void testAssignBrokersToCellRequestWithTenantBelowMinSize() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 4, 4, 6, true);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)6).setBrokers(Arrays.asList(0, 1, 2, 3));
        control.replay(cellRecord);
        CellRecord secondCellRecord = new CellRecord().setCellId(1).setState(CellState.READY.code()).setMinSize((short)1).setMaxSize((short)6);
        control.replay(secondCellRecord);
        control.replay(new TenantRecord().setTenantId("lkc-abcd").setCellId(0));
        ControllerResult controllerResult = control.assignBrokersToCell((AssignBrokersToCellRequest)new AssignBrokersToCellRequest.Builder().setCellId(1).setBrokers(Collections.singletonList(3)).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2)));
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)((AssignBrokersToCellResponseData)controllerResult.response()).errorCode());
    }

    @Test
    void testUnassignBrokersFromCellRequest() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 3, 3, 6, true);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6).setBrokers(Arrays.asList(0, 1, 2));
        control.replay(cellRecord);
        ControllerResult controllerResult = control.unassignBrokersFromCell((UnAssignBrokersFromCellRequest)new UnAssignBrokersFromCellRequest.Builder().setBrokers(Arrays.asList(3, 4, 5)).build(), new HashSet());
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        Assertions.assertEquals((short)ApiError.NONE.error().code(), (short)((UnAssignBrokersFromCellResponseData)controllerResult.response()).errorCode());
        CellRecord expectedRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6).setBrokers(new ArrayList<Integer>());
        List<ApiMessageAndVersion> expectedRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)expectedRecord, MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        controllerResult = control.unassignBrokersFromCell((UnAssignBrokersFromCellRequest)new UnAssignBrokersFromCellRequest.Builder().setBrokers(Arrays.asList(0, 1, 2)).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2)));
        Assertions.assertEquals(expectedRecords, (Object)controllerResult.records());
        Assertions.assertEquals((short)ApiError.NONE.error().code(), (short)((UnAssignBrokersFromCellResponseData)controllerResult.response()).errorCode());
    }

    @Test
    void testUnassignBrokersFromCellRequestWithTenant() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 3, 3, 6, true);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6).setBrokers(Arrays.asList(0, 1, 2, 3, 4, 5));
        control.replay(cellRecord);
        control.replay(new TenantRecord().setTenantId("lkc-abcd").setCellId(0));
        ControllerResult controllerResult = control.unassignBrokersFromCell((UnAssignBrokersFromCellRequest)new UnAssignBrokersFromCellRequest.Builder().setBrokers(Arrays.asList(0, 1, 2)).build(), new HashSet<Integer>(Arrays.asList(0, 1)));
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)((UnAssignBrokersFromCellResponseData)controllerResult.response()).errorCode());
        controllerResult = control.unassignBrokersFromCell((UnAssignBrokersFromCellRequest)new UnAssignBrokersFromCellRequest.Builder().setBrokers(Arrays.asList(3, 4)).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2)));
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)((UnAssignBrokersFromCellResponseData)controllerResult.response()).errorCode());
        controllerResult = control.unassignBrokersFromCell((UnAssignBrokersFromCellRequest)new UnAssignBrokersFromCellRequest.Builder().setBrokers(Arrays.asList(2, 3, 4)).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2)));
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)((UnAssignBrokersFromCellResponseData)controllerResult.response()).errorCode());
        CellRecord expectedRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6).setBrokers(Arrays.asList(0, 1, 2));
        List<ApiMessageAndVersion> expectedRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)expectedRecord, MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        controllerResult = control.unassignBrokersFromCell((UnAssignBrokersFromCellRequest)new UnAssignBrokersFromCellRequest.Builder().setBrokers(Arrays.asList(3, 4, 5)).build(), new HashSet<Integer>(Arrays.asList(0, 1, 2)));
        Assertions.assertEquals(expectedRecords, (Object)controllerResult.records());
        Assertions.assertEquals((short)ApiError.NONE.error().code(), (short)((UnAssignBrokersFromCellResponseData)controllerResult.response()).errorCode());
    }

    @Test
    void testDeleteCellRequest() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 3, 3, 6, true);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6);
        control.replay(cellRecord);
        RemoveCellRecord expectedRecord = new RemoveCellRecord().setCellId(0);
        List<ApiMessageAndVersion> expectedRecords = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)expectedRecord, MetadataRecordType.REMOVE_CELL_RECORD.highestSupportedVersion()));
        ControllerResult controllerResult = control.deleteCell((DeleteCellRequest)new DeleteCellRequest.Builder().setCellId(0).build());
        Assertions.assertEquals(expectedRecords, (Object)controllerResult.records());
        Assertions.assertEquals((short)ApiError.NONE.error().code(), (short)((DeleteCellResponseData)controllerResult.response()).errorCode());
    }

    @Test
    void testDeleteCellRequestWithBrokers() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 3, 3, 6, true);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6).setBrokers(Arrays.asList(0, 1, 2));
        control.replay(cellRecord);
        RemoveCellRecord expectedRecord = new RemoveCellRecord().setCellId(0);
        ControllerResult controllerResult = control.deleteCell((DeleteCellRequest)new DeleteCellRequest.Builder().setCellId(0).build());
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)((DeleteCellResponseData)controllerResult.response()).errorCode());
    }

    @Test
    void testDeleteCellRequestWithTenants() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 3, 3, 6, true);
        TenantControlManager tenantControl = new TenantControlManager(this.logContext, this.featureControl, control, PartitionPlacementStrategy.TENANT_IN_CELL, 3);
        CellRecord cellRecord = new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6);
        control.replay(cellRecord);
        String tenantId = "tenant-abcd";
        tenantControl.replay(new TenantRecord().setTenantId(tenantId).setCellId(0));
        ControllerResult controllerResult = control.deleteCell((DeleteCellRequest)new DeleteCellRequest.Builder().setCellId(0).build());
        Assertions.assertEquals(new ArrayList(), (Object)controllerResult.records());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)((DeleteCellResponseData)controllerResult.response()).errorCode());
    }

    @Test
    void testImplicitCellCreationEnabled() {
        CellControlManager control = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 3, 3, 6, true);
        Assertions.assertTrue((boolean)control.isImplicitCellCreationEnabled());
        CellControlManager disabledControl = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 3, 3, 6, false);
        Assertions.assertFalse((boolean)disabledControl.isImplicitCellCreationEnabled());
        CellControlManager legacyControl = new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.legacyFeatureControl, this.random, 3, 3, 6, true);
        Assertions.assertFalse((boolean)legacyControl.isImplicitCellCreationEnabled());
    }

    @Test
    void testCellControlManagerConstructor() {
        Assertions.assertThrows(RuntimeException.class, () -> new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 0, 0, 3, true));
        Assertions.assertThrows(RuntimeException.class, () -> new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 1, 2, 3, true));
        Assertions.assertThrows(RuntimeException.class, () -> new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 3, 3, 2, true));
        new CellControlManager(this.logContext, (Time)new MockTime(), this.snapshotRegistry, this.featureControl, this.random, 3, 3, 4, true);
    }
}

