/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.bootstrap;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.NoOpRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class BootstrapDirectoryTest {
    static final List<ApiMessageAndVersion> SAMPLE_RECORDS1 = Collections.unmodifiableList(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel((short)7), 0), new ApiMessageAndVersion((ApiMessage)new NoOpRecord(), 0), new ApiMessageAndVersion((ApiMessage)new NoOpRecord(), 0)));

    @Test
    public void testReadFromEmptyConfiguration() throws Exception {
        try (BootstrapTestDirectory testDirectory = new BootstrapTestDirectory().createDirectory();){
            Assertions.assertEquals((Object)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.latest(), (String)"the default bootstrap"), (Object)new BootstrapDirectory(testDirectory.path(), Optional.empty()).read());
        }
    }

    @Test
    public void testReadFromConfigurationWithAncientVersion() throws Exception {
        try (BootstrapTestDirectory testDirectory = new BootstrapTestDirectory().createDirectory();){
            Assertions.assertEquals((Object)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.MINIMUM_BOOTSTRAP_VERSION, (String)"the minimum version bootstrap with metadata.version 3.3-IV0"), (Object)new BootstrapDirectory(testDirectory.path(), Optional.of("2.7")).read());
        }
    }

    @Test
    public void testReadFromConfiguration() throws Exception {
        try (BootstrapTestDirectory testDirectory = new BootstrapTestDirectory().createDirectory();){
            Assertions.assertEquals((Object)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.IBP_3_3_IV2, (String)"the configured bootstrap with metadata.version 3.3-IV2"), (Object)new BootstrapDirectory(testDirectory.path(), Optional.of("3.3-IV2")).read());
        }
    }

    @Test
    public void testMissingDirectory() throws Exception {
        Assertions.assertEquals((Object)"No such directory as ./non/existent/directory", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new BootstrapDirectory("./non/existent/directory", Optional.empty()).read())).getMessage());
    }

    @Test
    public void testReadFromConfigurationFile() throws Exception {
        try (BootstrapTestDirectory testDirectory = new BootstrapTestDirectory().createDirectory();){
            BootstrapDirectory directory = new BootstrapDirectory(testDirectory.path(), Optional.of("3.0-IV0"));
            BootstrapMetadata metadata = BootstrapMetadata.fromRecords(SAMPLE_RECORDS1, (String)("the binary bootstrap metadata file: " + testDirectory.binaryBootstrapPath()));
            directory.writeBinaryFile(metadata);
            Assertions.assertEquals((Object)metadata, (Object)directory.read());
        }
    }

    static class BootstrapTestDirectory
    implements AutoCloseable {
        File directory = null;

        BootstrapTestDirectory() {
        }

        synchronized BootstrapTestDirectory createDirectory() throws Exception {
            this.directory = TestUtils.tempDirectory((String)"BootstrapTestDirectory");
            return this;
        }

        synchronized String path() {
            return this.directory.getAbsolutePath();
        }

        synchronized String binaryBootstrapPath() {
            return new File(this.directory, "bootstrap.checkpoint").getAbsolutePath();
        }

        @Override
        public synchronized void close() throws Exception {
            if (this.directory != null) {
                Utils.delete((File)this.directory);
            }
            this.directory = null;
        }
    }
}

