/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.util.RecordRedactor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class RecordRedactorTest {
    public static final Map<ConfigResource.Type, ConfigDef> CONFIGS = new HashMap<ConfigResource.Type, ConfigDef>();
    private static final KafkaConfigSchema SCHEMA;
    private static final RecordRedactor REDACTOR;

    @Test
    public void testTopicRecordToString() {
        Assertions.assertEquals((Object)"TopicRecord(name='foo', topicId=UOovKkohSU6AGdYW33ZUNg)", (Object)REDACTOR.toLoggableString((ApiMessage)new TopicRecord().setTopicId(Uuid.fromString((String)"UOovKkohSU6AGdYW33ZUNg")).setName("foo")));
    }

    @Test
    public void testUserScramCredentialRecordToString() {
        Assertions.assertEquals((Object)"UserScramCredentialRecord(name='bob', mechanism=0, salt=(redacted), storedKey=(redacted), serverKey=(redacted), iterations=128)", (Object)REDACTOR.toLoggableString((ApiMessage)new UserScramCredentialRecord().setName("bob").setMechanism((byte)0).setSalt(new byte[512]).setServerKey(new byte[128]).setStoredKey(new byte[128]).setIterations(128)));
    }

    @Test
    public void testUserScramCredentialRecordToStringWithNullName() {
        Assertions.assertEquals((Object)"UserScramCredentialRecord(name=null, mechanism=1, salt=(redacted), storedKey=(redacted), serverKey=(redacted), iterations=256)", (Object)REDACTOR.toLoggableString((ApiMessage)new UserScramCredentialRecord().setName(null).setMechanism((byte)1).setSalt(new byte[512]).setServerKey(new byte[128]).setStoredKey(new byte[128]).setIterations(256)));
    }

    @Test
    public void testSensitiveConfigRecordToString() {
        Assertions.assertEquals((Object)"ConfigRecord(resourceType=4, resourceName='0', name='quux', value='(redacted)')", (Object)REDACTOR.toLoggableString((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("quux").setValue("mysecret")));
    }

    @Test
    public void testNonSensitiveConfigRecordToString() {
        Assertions.assertEquals((Object)"ConfigRecord(resourceType=4, resourceName='0', name='foobar', value='item1,item2')", (Object)REDACTOR.toLoggableString((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("foobar").setValue("item1,item2")));
    }

    static {
        CONFIGS.put(ConfigResource.Type.BROKER, new ConfigDef().define("foobar", ConfigDef.Type.LIST, (Object)"1", ConfigDef.Importance.HIGH, "foo bar doc").define("quux", ConfigDef.Type.PASSWORD, ConfigDef.Importance.HIGH, "quuux2 doc"));
        SCHEMA = new KafkaConfigSchema(CONFIGS, Collections.emptyMap());
        REDACTOR = new RecordRedactor(SCHEMA);
    }
}

