/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.ProducerIdsDelta;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ProducerIdsImageTest {
    public static final ProducerIdsImage IMAGE1 = new ProducerIdsImage(123L);
    static final List<ApiMessageAndVersion> DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
    static final ProducerIdsDelta DELTA1;
    static final ProducerIdsImage IMAGE2;

    @Test
    public void testEmptyImageRoundTrip() throws Throwable {
        this.testToImageAndBack(ProducerIdsImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE1);
    }

    @Test
    public void testApplyDelta1() throws Throwable {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
    }

    @Test
    public void testImage2RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE2);
    }

    private void testToImageAndBack(ProducerIdsImage image) throws Throwable {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        ProducerIdsDelta delta = new ProducerIdsDelta(ProducerIdsImage.EMPTY);
        RecordTestUtils.replayAll(delta, writer.records());
        ProducerIdsImage nextImage = delta.apply();
        Assertions.assertEquals((Object)image, (Object)nextImage);
    }

    static {
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ProducerIdsRecord().setBrokerId(2).setBrokerEpoch(100L).setNextProducerId(456L), 0));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ProducerIdsRecord().setBrokerId(3).setBrokerEpoch(100L).setNextProducerId(789L), 0));
        DELTA1 = new ProducerIdsDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        IMAGE2 = new ProducerIdsImage(789L);
    }
}

