/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.controller.ResultOrError;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ResultOrErrorTest {
    @Test
    public void testError() {
        ResultOrError resultOrError = new ResultOrError(Errors.INVALID_REQUEST, "missing foobar");
        Assertions.assertTrue((boolean)resultOrError.isError());
        Assertions.assertFalse((boolean)resultOrError.isResult());
        Assertions.assertNull((Object)resultOrError.result());
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "missing foobar"), (Object)resultOrError.error());
    }

    @Test
    public void testResult() {
        ResultOrError resultOrError = new ResultOrError((Object)123);
        Assertions.assertFalse((boolean)resultOrError.isError());
        Assertions.assertTrue((boolean)resultOrError.isResult());
        Assertions.assertEquals((int)123, (Integer)((Integer)resultOrError.result()));
        Assertions.assertNull((Object)resultOrError.error());
    }

    @Test
    public void testEquals() {
        ResultOrError a = new ResultOrError(Errors.INVALID_REQUEST, "missing foobar");
        ResultOrError b = new ResultOrError((Object)"abcd");
        Assertions.assertNotEquals((Object)a, (Object)b);
        Assertions.assertNotEquals((Object)b, (Object)a);
        Assertions.assertEquals((Object)a, (Object)a);
        Assertions.assertEquals((Object)b, (Object)b);
        ResultOrError c = new ResultOrError(Errors.INVALID_REQUEST, "missing baz");
        Assertions.assertNotEquals((Object)a, (Object)c);
        Assertions.assertNotEquals((Object)c, (Object)a);
        Assertions.assertEquals((Object)c, (Object)c);
    }
}

