/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.metadata.VersionRange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuorumFeaturesTest {
    private static final Map<String, VersionRange> LOCAL;

    @Test
    public void testDefaultSupportedLevels() {
        QuorumFeatures quorumFeatures = new QuorumFeatures(0, new ApiVersions(), Collections.emptyMap(), Arrays.asList(0, 1, 2));
        Assertions.assertEquals(Optional.empty(), (Object)quorumFeatures.reasonNotSupported("foo", (short)0));
        Assertions.assertEquals(Optional.of("Local controller 0 does not support this feature."), (Object)quorumFeatures.reasonNotSupported("foo", (short)1));
    }

    @Test
    public void testLocalSupportedFeature() {
        QuorumFeatures quorumFeatures = new QuorumFeatures(0, new ApiVersions(), LOCAL, Arrays.asList(0, 1, 2));
        Assertions.assertEquals((Object)VersionRange.of((int)0, (int)3), (Object)quorumFeatures.localSupportedFeature("foo"));
        Assertions.assertEquals((Object)VersionRange.of((int)0, (int)4), (Object)quorumFeatures.localSupportedFeature("bar"));
        Assertions.assertEquals((Object)VersionRange.of((int)2, (int)2), (Object)quorumFeatures.localSupportedFeature("baz"));
        Assertions.assertEquals((Object)VersionRange.of((int)0, (int)0), (Object)quorumFeatures.localSupportedFeature("quux"));
    }

    @Test
    public void testReasonNotSupported() {
        ApiVersions apiVersions = new ApiVersions();
        QuorumFeatures quorumFeatures = new QuorumFeatures(0, apiVersions, LOCAL, Arrays.asList(0, 1, 2));
        Assertions.assertEquals(Optional.of("Local controller 0 only supports versions 0-3"), (Object)quorumFeatures.reasonNotSupported("foo", (short)10));
        apiVersions.update("1", QuorumFeaturesTest.nodeApiVersions(Arrays.asList(new AbstractMap.SimpleImmutableEntry<String, VersionRange>("foo", VersionRange.of((int)1, (int)3)), new AbstractMap.SimpleImmutableEntry<String, VersionRange>("bar", VersionRange.of((int)1, (int)3)), new AbstractMap.SimpleImmutableEntry<String, VersionRange>("baz", VersionRange.of((int)1, (int)2)))));
        Assertions.assertEquals(Optional.empty(), (Object)quorumFeatures.reasonNotSupported("bar", (short)3));
        Assertions.assertEquals(Optional.of("Controller 1 only supports versions 1-3"), (Object)quorumFeatures.reasonNotSupported("bar", (short)4));
    }

    private static NodeApiVersions nodeApiVersions(List<Map.Entry<String, VersionRange>> entries) {
        ArrayList features = new ArrayList();
        entries.forEach(entry -> features.add(new ApiVersionsResponseData.SupportedFeatureKey().setName((String)entry.getKey()).setMinVersion(((VersionRange)entry.getValue()).min()).setMaxVersion(((VersionRange)entry.getValue()).max())));
        return new NodeApiVersions(Collections.emptyList(), features, false);
    }

    @Test
    public void testIsControllerId() {
        QuorumFeatures quorumFeatures = new QuorumFeatures(0, new ApiVersions(), LOCAL, Arrays.asList(0, 1, 2));
        Assertions.assertTrue((boolean)quorumFeatures.isControllerId(0));
        Assertions.assertTrue((boolean)quorumFeatures.isControllerId(1));
        Assertions.assertTrue((boolean)quorumFeatures.isControllerId(2));
        Assertions.assertFalse((boolean)quorumFeatures.isControllerId(3));
    }

    @Test
    public void testZkMigrationReady() {
        ApiVersions apiVersions = new ApiVersions();
        QuorumFeatures quorumFeatures = new QuorumFeatures(0, apiVersions, LOCAL, Arrays.asList(0, 1, 2));
        apiVersions.update("0", new NodeApiVersions(Collections.emptyList(), Collections.emptyList(), true));
        Assertions.assertTrue((boolean)quorumFeatures.reasonAllControllersZkMigrationNotReady().isPresent());
        Assertions.assertTrue((boolean)((String)quorumFeatures.reasonAllControllersZkMigrationNotReady().get()).contains("Missing apiVersion from nodes: [1, 2]"));
        apiVersions.update("1", new NodeApiVersions(Collections.emptyList(), Collections.emptyList(), true));
        Assertions.assertTrue((boolean)quorumFeatures.reasonAllControllersZkMigrationNotReady().isPresent());
        Assertions.assertTrue((boolean)((String)quorumFeatures.reasonAllControllersZkMigrationNotReady().get()).contains("Missing apiVersion from nodes: [2]"));
        apiVersions.update("2", NodeApiVersions.create());
        Assertions.assertTrue((boolean)quorumFeatures.reasonAllControllersZkMigrationNotReady().isPresent());
        Assertions.assertTrue((boolean)((String)quorumFeatures.reasonAllControllersZkMigrationNotReady().get()).contains("Nodes don't enable `zookeeper.metadata.migration.enable`: [2]"));
        apiVersions.update("2", new NodeApiVersions(Collections.emptyList(), Collections.emptyList(), true));
        Assertions.assertFalse((boolean)quorumFeatures.reasonAllControllersZkMigrationNotReady().isPresent());
        apiVersions.update("3", NodeApiVersions.create());
        Assertions.assertFalse((boolean)quorumFeatures.reasonAllControllersZkMigrationNotReady().isPresent());
    }

    static {
        HashMap<String, VersionRange> local = new HashMap<String, VersionRange>();
        local.put("foo", VersionRange.of((int)0, (int)3));
        local.put("bar", VersionRange.of((int)0, (int)4));
        local.put("baz", VersionRange.of((int)2, (int)2));
        LOCAL = Collections.unmodifiableMap(local);
    }
}

