/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.metadata.BrokerReplicaExclusion;
import org.apache.kafka.metadata.migration.ReplicaExclusionMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;

public class CapturingReplicaExclusionMigrationClient
implements ReplicaExclusionMigrationClient {
    public Set<BrokerReplicaExclusion> updatedReplicaExclusions = new HashSet<BrokerReplicaExclusion>();

    public Optional<Set<BrokerReplicaExclusion>> readReplicaExclusions(Set<Integer> registeredBrokers) {
        if (this.updatedReplicaExclusions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.updatedReplicaExclusions.stream().filter(exclusion -> registeredBrokers.contains(exclusion.getBrokerId())).collect(Collectors.toSet()));
    }

    public ZkMigrationLeadershipState writeReplicaExclusions(Set<BrokerReplicaExclusion> replicaExclusions, ZkMigrationLeadershipState state, boolean create) {
        this.updatedReplicaExclusions = replicaExclusions;
        return state;
    }
}

