/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.Provide;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.UnwritableMetadataException;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class PartitionRegistrationTest {
    @Test
    public void testElectionWasClean() {
        Assertions.assertTrue((boolean)PartitionRegistration.electionWasClean((int)1, (int[])new int[]{1, 2}));
        Assertions.assertFalse((boolean)PartitionRegistration.electionWasClean((int)1, (int[])new int[]{0, 2}));
        Assertions.assertFalse((boolean)PartitionRegistration.electionWasClean((int)1, (int[])new int[0]));
        Assertions.assertTrue((boolean)PartitionRegistration.electionWasClean((int)3, (int[])new int[]{1, 2, 3, 4, 5, 6}));
    }

    @Test
    public void testPartitionControlInfoMergeAndDiff() {
        PartitionRegistration a = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build();
        PartitionRegistration b = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{3}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(1)).build();
        PartitionRegistration c = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(1)).build();
        Assertions.assertEquals((Object)b, (Object)a.merge(new PartitionChangeRecord().setLeader(3).setIsr(Arrays.asList(3))));
        Assertions.assertEquals((Object)"isr: [1, 2] -> [3], leader: 1 -> 3, leaderEpoch: 0 -> 1, partitionEpoch: 0 -> 1", (Object)b.diff(a));
        Assertions.assertEquals((Object)"isr: [1, 2] -> [1], partitionEpoch: 0 -> 1", (Object)c.diff(a));
    }

    @Test
    public void testDiffForObservers() {
        PartitionRegistration a = new PartitionRegistration.Builder().setReplicas(new int[]{0, 3}).setObservers(new int[]{3}).setIsr(new int[]{0}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build();
        PartitionRegistration b = new PartitionRegistration.Builder().setReplicas(new int[]{1, 0, 4, 3}).setObservers(new int[]{4, 3}).setIsr(new int[]{0}).setRemovingReplicas(new int[]{0, 3}).setAddingReplicas(new int[]{1, 4}).setRemovingObservers(new int[]{3}).setAddingObservers(new int[]{4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build();
        Assertions.assertEquals((Object)"replicas: [0, 3] -> [1, 0, 4, 3], observers: [3] -> [4, 3], removingReplicas: [] -> [0, 3], addingReplicas: [] -> [1, 4], removingObservers: [] -> [3], addingObservers: [] -> [4]", (Object)b.diff(a));
    }

    @Test
    public void testDiffForClusterLinking() {
        PartitionRegistration a = new PartitionRegistration.Builder().setReplicas(new int[]{3, 4, 5}).setIsr(new int[]{3, 4, 5}).setLeader(Integer.valueOf(4)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(200)).setPartitionEpoch(Integer.valueOf(300)).setLinkedLeaderEpoch(Integer.valueOf(100)).setLinkState(PartitionRegistration.LinkState.ACTIVE).build();
        PartitionRegistration b = new PartitionRegistration.Builder().setReplicas(new int[]{3, 4, 5}).setIsr(new int[]{3, 4, 5}).setLeader(Integer.valueOf(4)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(200)).setPartitionEpoch(Integer.valueOf(301)).setLinkedLeaderEpoch(Integer.valueOf(101)).setLinkState(PartitionRegistration.LinkState.FAILED).build();
        Assertions.assertEquals((Object)"partitionEpoch: 300 -> 301, linkedLeaderEpoch: 100 -> 101, linkedLeaderEpoch: ACTIVE -> FAILED", (Object)b.diff(a));
    }

    @Test
    public void testToStringForObservers() {
        PartitionRegistration a = new PartitionRegistration.Builder().setReplicas(new int[]{1, 0, 4, 3}).setObservers(new int[]{4, 3}).setIsr(new int[]{0}).setRemovingReplicas(new int[]{0, 3}).setAddingReplicas(new int[]{1, 4}).setRemovingObservers(new int[]{3}).setAddingObservers(new int[]{4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build();
        Assertions.assertEquals((Object)"PartitionRegistration(replicas=[1, 0, 4, 3], observers=[4, 3], isr=[0], removingReplicas=[0, 3], addingReplicas=[1, 4], removingObservers=[3], addingObservers=[4], leader=1, leaderRecoveryState=RECOVERED, leaderEpoch=0, partitionEpoch=0, linkedLeaderEpoch=-1, linkState=NOT_MIRROR)", (Object)a.toString());
    }

    @Test
    public void testRecordRoundTrip() {
        PartitionRegistration registrationA = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5}).setObservers(new int[]{4, 5}).setIsr(new int[]{1, 2}).setRemovingReplicas(new int[]{1}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build();
        Uuid topicId = Uuid.fromString((String)"OGdAI5nxT_m-ds3rJMqPLA");
        int partitionId = 4;
        ApiMessageAndVersion record = registrationA.toRecord(topicId, partitionId, this.imageWriterOptions(MetadataVersion.latest()));
        PartitionRegistration registrationB = new PartitionRegistration((PartitionRecord)record.message());
        Assertions.assertEquals((Object)registrationA, (Object)registrationB);
    }

    @Test
    public void testToRecordAtUnsupportedTopicPlacementVersion() {
        PartitionRegistration registrationA = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5}).setIsr(new int[]{1, 2}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build();
        Uuid topicId = Uuid.fromString((String)"OGdAI5nxT_m-ds3rJMqPLA");
        int partitionId = 4;
        ApiMessageAndVersion record = registrationA.toRecord(topicId, partitionId, this.imageWriterOptions(MetadataVersion.IBP_3_4_IV0));
        PartitionRegistration registrationB = new PartitionRegistration((PartitionRecord)record.message());
        Assertions.assertEquals((Object)registrationA, (Object)registrationB);
    }

    @Test
    public void testToRecordAtUnsupportedTopicPlacementVersionWithReassignmentMetadata() {
        PartitionRegistration registrationA = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5}).setIsr(new int[]{1, 2}).setRemovingReplicas(new int[]{4}).setAddingReplicas(new int[]{5}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build();
        Uuid topicId = Uuid.fromString((String)"OGdAI5nxT_m-ds3rJMqPLA");
        int partitionId = 4;
        ApiMessageAndVersion record = registrationA.toRecord(topicId, partitionId, this.imageWriterOptions(MetadataVersion.IBP_3_4_IV0));
        PartitionRegistration registrationB = new PartitionRegistration((PartitionRecord)record.message());
        Assertions.assertEquals((Object)registrationA, (Object)registrationB);
    }

    @Test
    public void testToRecordWithImageWriterOptionsHandlesIsTopicPlacementSupported() {
        int[] replicas = new int[]{1, 2, 3, 4, 5};
        int[] observers = new int[]{4, 5};
        int[] addingObservers = new int[]{4};
        int[] removingObservers = new int[]{5};
        PartitionRegistration registrationA = new PartitionRegistration.Builder().setReplicas(replicas).setObservers(observers).setIsr(new int[]{1, 2, 3}).setRemovingObservers(removingObservers).setAddingObservers(addingObservers).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build();
        Uuid topicId = Uuid.fromString((String)"OGdAI5nxT_m-ds3rJMqPLA");
        ApiMessageAndVersion recordWithTopicPlacementSupport = registrationA.toRecord(topicId, 0, this.imageWriterOptions(MetadataVersion.latest()));
        Assertions.assertEquals((Object)Replicas.toList((int[])observers), ((PartitionRecord)recordWithTopicPlacementSupport.message()).observers());
        Assertions.assertEquals((Object)Replicas.toList((int[])removingObservers), ((PartitionRecord)recordWithTopicPlacementSupport.message()).removingObservers());
        Assertions.assertEquals((Object)Replicas.toList((int[])addingObservers), ((PartitionRecord)recordWithTopicPlacementSupport.message()).addingObservers());
        Throwable throwable = Assertions.assertThrows(UnwritableMetadataException.class, () -> registrationA.toRecord(topicId, 0, this.imageWriterOptions(MetadataVersion.IBP_3_4_IV0)));
        Assertions.assertEquals((Object)"Metadata has been lost because the following could not be represented in metadata version 3.4-IV0: the observer metadata for topic OGdAI5nxT_m-ds3rJMqPLA, partition 0.", (Object)throwable.getMessage());
        replicas = new int[]{0, 1, 2, 3};
        observers = Replicas.NONE;
        addingObservers = Replicas.NONE;
        removingObservers = Replicas.NONE;
        PartitionRegistration registrationB = new PartitionRegistration.Builder().setReplicas(replicas).setObservers(observers).setIsr(new int[]{1, 2, 3}).setRemovingObservers(removingObservers).setAddingObservers(addingObservers).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build();
        ApiMessageAndVersion recordWithTopicPlacementSupportB = registrationB.toRecord(topicId, 0, this.imageWriterOptions(MetadataVersion.IBP_3_4_IV0));
        Assertions.assertEquals((Object)Replicas.toList((int[])observers), ((PartitionRecord)recordWithTopicPlacementSupportB.message()).observers());
        Assertions.assertEquals((Object)Replicas.toList((int[])removingObservers), ((PartitionRecord)recordWithTopicPlacementSupportB.message()).removingObservers());
        Assertions.assertEquals((Object)Replicas.toList((int[])addingObservers), ((PartitionRecord)recordWithTopicPlacementSupportB.message()).addingObservers());
    }

    @Test
    public void testToRecordWithoutImageWriterOptions() {
        int[] replicas = new int[]{1, 2, 3, 4, 5};
        int[] observers = new int[]{4, 5};
        int[] isr = new int[]{1, 2, 3};
        int[] adding = new int[]{1, 4};
        int[] removing = new int[]{2, 5};
        int[] addingObservers = new int[]{4};
        int[] removingObservers = new int[]{5};
        int leader = 1;
        LeaderRecoveryState leaderRecoveryState = LeaderRecoveryState.RECOVERED;
        int leaderEpoch = 2;
        int partitionEpoch = 3;
        int linkedLeaderEpoch = 4;
        PartitionRegistration.LinkState linkState = PartitionRegistration.LinkState.NOT_MIRROR;
        PartitionRegistration registrationA = new PartitionRegistration.Builder().setReplicas(replicas).setObservers(observers).setIsr(isr).setRemovingReplicas(removing).setAddingReplicas(adding).setRemovingObservers(removingObservers).setAddingObservers(addingObservers).setLeader(Integer.valueOf(leader)).setLeaderRecoveryState(leaderRecoveryState).setLeaderEpoch(Integer.valueOf(leaderEpoch)).setPartitionEpoch(Integer.valueOf(partitionEpoch)).setLinkedLeaderEpoch(Integer.valueOf(linkedLeaderEpoch)).setLinkState(linkState).build();
        Uuid topicId = Uuid.fromString((String)"OGdAI5nxT_m-ds3rJMqPLA");
        ApiMessageAndVersion record = registrationA.toRecord(topicId, 0);
        Assertions.assertEquals((Object)Replicas.toList((int[])replicas), ((PartitionRecord)record.message()).replicas());
        Assertions.assertEquals((Object)Replicas.toList((int[])isr), ((PartitionRecord)record.message()).isr());
        Assertions.assertEquals((Object)Replicas.toList((int[])removing), ((PartitionRecord)record.message()).removingReplicas());
        Assertions.assertEquals((Object)Replicas.toList((int[])adding), ((PartitionRecord)record.message()).addingReplicas());
        Assertions.assertEquals((Object)Replicas.toList((int[])observers), ((PartitionRecord)record.message()).observers());
        Assertions.assertEquals((Object)Replicas.toList((int[])removingObservers), ((PartitionRecord)record.message()).removingObservers());
        Assertions.assertEquals((Object)Replicas.toList((int[])addingObservers), ((PartitionRecord)record.message()).addingObservers());
        Assertions.assertEquals((int)leader, (int)((PartitionRecord)record.message()).leader());
        Assertions.assertEquals((byte)leaderRecoveryState.value(), (byte)((PartitionRecord)record.message()).leaderRecoveryState());
        Assertions.assertEquals((int)leaderEpoch, (int)((PartitionRecord)record.message()).leaderEpoch());
        Assertions.assertEquals((int)partitionEpoch, (int)((PartitionRecord)record.message()).partitionEpoch());
        Assertions.assertEquals((int)linkedLeaderEpoch, (int)((PartitionRecord)record.message()).linkedLeaderEpoch());
    }

    @Test
    public void testToLeaderAndIsrPartitionState() {
        Uuid topicId = Uuid.fromString((String)"h8msVngxS1eu_or53vvSKA");
        PartitionRegistration a = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5}).setObservers(new int[]{4, 5}).setIsr(new int[]{1, 2}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(123)).setPartitionEpoch(Integer.valueOf(456)).build();
        PartitionRegistration b = new PartitionRegistration.Builder().setReplicas(new int[]{2, 3, 4, 5, 6}).setObservers(new int[]{5, 6}).setIsr(new int[]{2, 3, 4}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(234)).setPartitionEpoch(Integer.valueOf(567)).build();
        Assertions.assertEquals((Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("foo").setTopicId(topicId).setPartitionIndex(1).setControllerEpoch(-1).setLeader(1).setLeaderEpoch(123).setIsr(Arrays.asList(1, 2)).setPartitionEpoch(456).setReplicas(Arrays.asList(1, 2, 3, 4, 5)).setObservers(Arrays.asList(4, 5)).setAddingReplicas(Collections.emptyList()).setRemovingReplicas(Collections.emptyList()).setIsNew(true).toString(), (Object)a.toLeaderAndIsrPartitionState(new TopicIdPartition(topicId, 1, "foo"), true, Optional.empty(), part -> Collections.emptyList()).toString());
        Assertions.assertEquals((Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("bar").setTopicId(topicId).setPartitionIndex(0).setControllerEpoch(-1).setLeader(2).setLeaderEpoch(234).setIsr(Arrays.asList(2, 3, 4)).setPartitionEpoch(567).setReplicas(Arrays.asList(2, 3, 4, 5, 6)).setObservers(Arrays.asList(5, 6)).setAddingReplicas(Collections.emptyList()).setRemovingReplicas(Collections.emptyList()).setIsNew(false).toString(), (Object)b.toLeaderAndIsrPartitionState(new TopicIdPartition(topicId, 0, "bar"), false, Optional.empty(), part -> Collections.emptyList()).toString());
    }

    @Test
    public void testMergePartitionChangeRecordWithReassignmentData() {
        PartitionRegistration partition0 = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionRegistration partition1 = partition0.merge(new PartitionChangeRecord().setRemovingReplicas(Collections.singletonList(3)).setAddingReplicas(Collections.singletonList(4)).setReplicas(Arrays.asList(1, 2, 3, 4)));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{3}).setAddingReplicas(new int[]{4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(201)).build(), (Object)partition1);
        PartitionRegistration partition2 = partition1.merge(new PartitionChangeRecord().setIsr(Arrays.asList(1, 2, 4)).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()).setReplicas(Arrays.asList(1, 2, 4)));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 4}).setIsr(new int[]{1, 2, 4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(202)).build(), (Object)partition2);
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingReplicas() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder();
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set replicas.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingIsr() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0});
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set isr.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingLeader() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0}).setIsr(new int[]{0}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{0});
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set leader.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingLeaderRecoveryState() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0}).setIsr(new int[]{0}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{0}).setLeader(Integer.valueOf(0));
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set leader recovery state.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingLeaderEpoch() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0}).setIsr(new int[]{0}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{0}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set leader epoch.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingPartitionEpoch() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0}).setIsr(new int[]{0}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{0}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0));
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set partition epoch.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderSuccess() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1}).setIsr(new int[]{0, 1}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0));
        PartitionRegistration partitionRegistration = builder.build();
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{0, 1}), (Object)Replicas.toList((int[])partitionRegistration.replicas));
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{0, 1}), (Object)Replicas.toList((int[])partitionRegistration.isr));
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{0}), (Object)Replicas.toList((int[])partitionRegistration.removingReplicas));
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{1}), (Object)Replicas.toList((int[])partitionRegistration.addingReplicas));
        Assertions.assertEquals((int)0, (int)partitionRegistration.leader);
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERED, (Object)partitionRegistration.leaderRecoveryState);
        Assertions.assertEquals((int)0, (int)partitionRegistration.leaderEpoch);
        Assertions.assertEquals((int)0, (int)partitionRegistration.partitionEpoch);
    }

    @Test
    public void testBuilderSetsDefaultAddingAndRemovingReplicas() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1}).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0));
        PartitionRegistration partitionRegistration = builder.build();
        Assertions.assertEquals((Object)Replicas.toList((int[])Replicas.NONE), (Object)Replicas.toList((int[])partitionRegistration.removingReplicas));
        Assertions.assertEquals((Object)Replicas.toList((int[])Replicas.NONE), (Object)Replicas.toList((int[])partitionRegistration.addingReplicas));
    }

    @Test
    public void testBuilderSuccessWithObserverMetadata() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2, 3}).setObservers(new int[]{2, 3}).setIsr(new int[]{0, 1}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{1}).setRemovingObservers(new int[]{2}).setAddingObservers(new int[]{3}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0));
        PartitionRegistration partitionRegistration = builder.build();
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{2, 3}), (Object)Replicas.toList((int[])partitionRegistration.observers));
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{2}), (Object)Replicas.toList((int[])partitionRegistration.removingObservers));
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{3}), (Object)Replicas.toList((int[])partitionRegistration.addingObservers));
    }

    @Test
    public void testBuilderSuccessWithLink() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1}).setIsr(new int[]{0, 1}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).setLinkedLeaderEpoch(Integer.valueOf(1)).setLinkState(PartitionRegistration.LinkState.ACTIVE);
        PartitionRegistration partitionRegistration = builder.build();
        Assertions.assertEquals((int)1, (int)partitionRegistration.linkedLeaderEpoch);
        Assertions.assertEquals((Object)PartitionRegistration.LinkState.ACTIVE, (Object)partitionRegistration.linkState);
    }

    @Test
    public void testBuilderSetsDefaultObserverMetadata() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1}).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0));
        PartitionRegistration partitionRegistration = builder.build();
        Assertions.assertEquals((Object)Replicas.toList((int[])Replicas.NONE), (Object)Replicas.toList((int[])partitionRegistration.observers));
        Assertions.assertEquals((Object)Replicas.toList((int[])Replicas.NONE), (Object)Replicas.toList((int[])partitionRegistration.removingObservers));
        Assertions.assertEquals((Object)Replicas.toList((int[])Replicas.NONE), (Object)Replicas.toList((int[])partitionRegistration.addingObservers));
    }

    @Test
    public void testBuilderSetsDefaultLinkMetadata() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1}).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0));
        PartitionRegistration partitionRegistration = builder.build();
        Assertions.assertEquals((int)-1, (int)partitionRegistration.linkedLeaderEpoch);
        Assertions.assertEquals((Object)PartitionRegistration.LinkState.NOT_MIRROR, (Object)partitionRegistration.linkState);
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingObservers() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1}).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).setObservers(null);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set observers.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingRemovingObservers() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1}).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).setRemovingObservers(null);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set removing observers.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingAddingObservers() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1}).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).setAddingObservers(null);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set adding observers.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingLinkedLeaderEpoch() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1}).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).setLinkedLeaderEpoch(null);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set linked leader epoch.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingLinkState() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1}).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).setLinkState(null);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set link state.", (Object)exception.getMessage());
    }

    @Test
    public void testMergePartitionChangeRecordWithReassignmentObserverData() {
        int[] originalReplicas = new int[]{0, 1, 4};
        int[] originalObservers = new int[]{4};
        int[] targetReplicas = new int[]{0, 2, 5};
        int[] targetObservers = new int[]{5};
        PartitionRegistration partition0 = new PartitionRegistration.Builder().setReplicas(originalReplicas).setObservers(originalObservers).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionRegistration partition1 = partition0.merge(new PartitionChangeRecord().setRemovingReplicas(Arrays.asList(1, 4)).setAddingReplicas(Arrays.asList(2, 5)).setRemovingObservers(Collections.singletonList(4)).setAddingObservers(Collections.singletonList(5)).setReplicas(Arrays.asList(0, 2, 1, 5, 4)).setObservers(Arrays.asList(5, 4)));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{0, 2, 1, 5, 4}).setObservers(new int[]{5, 4}).setIsr(new int[]{0, 1}).setRemovingReplicas(new int[]{1, 4}).setAddingReplicas(new int[]{2, 5}).setRemovingObservers(new int[]{4}).setAddingObservers(new int[]{5}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(201)).build(), (Object)partition1);
        PartitionRegistration partition2 = partition1.merge(new PartitionChangeRecord().setIsr(Arrays.asList(0, 2)).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()).setRemovingObservers(Collections.emptyList()).setAddingObservers(Collections.emptyList()).setReplicas(Replicas.toList((int[])targetReplicas)).setObservers(Replicas.toList((int[])targetObservers)));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(targetReplicas).setObservers(targetObservers).setIsr(new int[]{0, 2}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(202)).build(), (Object)partition2);
    }

    @Test
    public void testMergePartitionChangeRecordWithReassignmentPartialObserverData() {
        PartitionRegistration partition0 = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setObservers(new int[]{2}).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 0, 2}).setObservers(new int[]{2}).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(201)).build(), (Object)partition0.merge(new PartitionChangeRecord().setReplicas(Arrays.asList(1, 0, 2))));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setObservers(new int[]{1, 2}).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(201)).build(), (Object)partition0.merge(new PartitionChangeRecord().setObservers(Arrays.asList(1, 2))));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setObservers(new int[]{2}).setIsr(new int[]{0, 1}).setRemovingReplicas(new int[]{0}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(201)).build(), (Object)partition0.merge(new PartitionChangeRecord().setRemovingReplicas(Arrays.asList(0))));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setObservers(new int[]{2}).setIsr(new int[]{0, 1}).setAddingReplicas(new int[]{0}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(201)).build(), (Object)partition0.merge(new PartitionChangeRecord().setAddingReplicas(Arrays.asList(0))));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setObservers(new int[]{2}).setIsr(new int[]{0, 1}).setRemovingObservers(new int[]{0}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(201)).build(), (Object)partition0.merge(new PartitionChangeRecord().setRemovingObservers(Arrays.asList(0))));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setObservers(new int[]{2}).setIsr(new int[]{0, 1}).setAddingObservers(new int[]{0}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(201)).build(), (Object)partition0.merge(new PartitionChangeRecord().setAddingObservers(Arrays.asList(0))));
    }

    @Test
    public void testMergePartitionChangeRecordWithNoChange() {
        PartitionRegistration partition0 = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).setLinkedLeaderEpoch(Integer.valueOf(-1)).setLinkState(PartitionRegistration.LinkState.ACTIVE).build();
        PartitionRegistration partition1 = partition0.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(10).setLinkState(PartitionRegistration.LinkState.FAILED.levelCode));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(201)).setLinkedLeaderEpoch(Integer.valueOf(10)).setLinkState(PartitionRegistration.LinkState.FAILED).build(), (Object)partition1);
        PartitionRegistration partition2 = partition1.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(-1).setLinkState(PartitionRegistration.LinkState.FAILED.levelCode));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(202)).setLinkedLeaderEpoch(Integer.valueOf(10)).setLinkState(PartitionRegistration.LinkState.FAILED).build(), (Object)partition2);
        PartitionRegistration partition3 = partition2.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(20).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(203)).setLinkedLeaderEpoch(Integer.valueOf(20)).setLinkState(PartitionRegistration.LinkState.ACTIVE).build(), (Object)partition3);
        PartitionRegistration partition4 = partition3.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(30).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(204)).setLinkedLeaderEpoch(Integer.valueOf(30)).setLinkState(PartitionRegistration.LinkState.ACTIVE).build(), (Object)partition4);
    }

    @Test
    public void testMergePartitionChangeRecordWithClusterLinkData() {
        PartitionRegistration partition0 = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).setLinkedLeaderEpoch(Integer.valueOf(-1)).setLinkState(PartitionRegistration.LinkState.ACTIVE).build();
        PartitionRegistration partition1 = partition0.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(10).setLinkState((byte)1));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(201)).setLinkedLeaderEpoch(Integer.valueOf(10)).setLinkState(PartitionRegistration.LinkState.FAILED).build(), (Object)partition1);
        PartitionRegistration partition2 = partition1.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(20).setLinkState((byte)0));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(202)).setLinkedLeaderEpoch(Integer.valueOf(20)).setLinkState(PartitionRegistration.LinkState.ACTIVE).build(), (Object)partition2);
    }

    @Test
    public void testLinkedLeaderEpochBumpsLeaderEpoch() {
        PartitionRegistration partition0 = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).setLinkedLeaderEpoch(Integer.valueOf(100)).setLinkState(PartitionRegistration.LinkState.ACTIVE).build();
        PartitionRecord record = (PartitionRecord)partition0.toRecord(Uuid.ZERO_UUID, 5, this.imageWriterOptions(MetadataVersion.latest())).message();
        Assertions.assertEquals((Object)new PartitionRecord().setTopicId(Uuid.ZERO_UUID).setPartitionId(5).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1, 2, 3)).setLeader(1).setLeaderEpoch(100).setPartitionEpoch(200).setLinkedLeaderEpoch(100).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode), (Object)record);
        PartitionRegistration partition1 = partition0.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(103).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode));
        record = (PartitionRecord)partition1.toRecord(Uuid.ZERO_UUID, 5, this.imageWriterOptions(MetadataVersion.latest())).message();
        Assertions.assertEquals((Object)new PartitionRecord().setTopicId(Uuid.ZERO_UUID).setPartitionId(5).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1, 2, 3)).setLeader(1).setLeaderEpoch(103).setPartitionEpoch(201).setLinkedLeaderEpoch(103).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode), (Object)record, (String)"Expected leader epoch to be bumped to be equal to the linked leader epoch");
        PartitionRegistration partition2 = partition0.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(101).setLinkState(PartitionRegistration.LinkState.FAILED.levelCode));
        record = (PartitionRecord)partition2.toRecord(Uuid.ZERO_UUID, 5, this.imageWriterOptions(MetadataVersion.latest())).message();
        Assertions.assertEquals((Object)new PartitionRecord().setTopicId(Uuid.ZERO_UUID).setPartitionId(5).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1, 2, 3)).setLeader(1).setLeaderEpoch(101).setPartitionEpoch(201).setLinkedLeaderEpoch(101).setLinkState(PartitionRegistration.LinkState.FAILED.levelCode), (Object)record, (String)"Expected leader epoch to be bumped to be equal to the linked leader epoch");
    }

    @Test
    public void testLinkedLeaderEpochIgnoredForNonMirror() {
        PartitionRegistration partition0 = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).setLinkedLeaderEpoch(Integer.valueOf(-1)).setLinkState(PartitionRegistration.LinkState.NOT_MIRROR).build();
        PartitionRecord record = (PartitionRecord)partition0.toRecord(Uuid.ZERO_UUID, 5, this.imageWriterOptions(MetadataVersion.latest())).message();
        Assertions.assertEquals((Object)new PartitionRecord().setTopicId(Uuid.ZERO_UUID).setPartitionId(5).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1, 2, 3)).setLeader(1).setLeaderEpoch(100).setPartitionEpoch(200).setLinkedLeaderEpoch(-1).setLinkState(PartitionRegistration.LinkState.NOT_MIRROR.levelCode), (Object)record);
        Assertions.assertThrows(RuntimeException.class, () -> partition0.merge(new PartitionChangeRecord().setLinkedLeaderEpoch(103).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode)), (String)"Expected an exception when merging mirror partition record into non-mirror registration");
    }

    @Test
    public void testEffectiveObserversWithAddingSyncReplicas() {
        int[] observers = new int[]{3, 4, 5};
        int[] addingSyncReplicas = new int[]{5};
        Assertions.assertEquals(Arrays.asList(3, 4), (Object)PartitionRegistration.effectiveObservers((List)Replicas.toList((int[])observers), (List)Replicas.toList((int[])addingSyncReplicas)));
    }

    @Test
    public void testEffectiveObserversWithoutAddingSyncReplicas() {
        int[] observers = new int[]{3, 4, 5};
        int[] addingSyncReplicas = new int[]{};
        Assertions.assertEquals(Arrays.asList(3, 4, 5), (Object)PartitionRegistration.effectiveObservers((List)Replicas.toList((int[])observers), (List)Replicas.toList((int[])addingSyncReplicas)));
    }

    @Test
    public void testMergeIgnoresSyncReplicas() {
        PartitionRegistration registrationA = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5}).setObservers(new int[]{4, 5}).setIsr(new int[]{1, 2}).setRemovingReplicas(new int[]{1}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build();
        Uuid topicId = Uuid.fromString((String)"OGdAI5nxT_m-ds3rJMqPLA");
        int partitionId = 4;
        PartitionChangeRecord partitionChangeRecord = new PartitionChangeRecord().setDeprecatedDoNotUseTag1004(Arrays.asList(6)).setDeprecatedDoNotUseTag1003(Arrays.asList(7));
        ApiMessageAndVersion record = registrationA.merge(partitionChangeRecord).toRecord(topicId, partitionId, this.imageWriterOptions(MetadataVersion.latest()));
        Assertions.assertTrue((boolean)(record.message() instanceof PartitionRecord));
        PartitionRecord partitionRecord = (PartitionRecord)record.message();
        Assertions.assertEquals(Collections.emptyList(), partitionRecord.deprecatedDoNotUseTag1004());
        Assertions.assertEquals(Collections.emptyList(), partitionRecord.deprecatedDoNotUseTag1003());
        Assertions.assertNotEquals(partitionChangeRecord.deprecatedDoNotUseTag1004(), partitionRecord.deprecatedDoNotUseTag1004());
        Assertions.assertNotEquals(partitionChangeRecord.deprecatedDoNotUseTag1003(), partitionRecord.deprecatedDoNotUseTag1003());
    }

    @Test
    public void testConstructorIgnoresSyncReplicas() {
        PartitionRecord partitionRecord = new PartitionRecord().setPartitionId(0).setReplicas(Arrays.asList(0)).setObservers(Arrays.asList(0)).setIsr(Arrays.asList(0)).setRemovingReplicas(Arrays.asList(0)).setAddingReplicas(Arrays.asList(0)).setDeprecatedDoNotUseTag1003(Arrays.asList(0)).setDeprecatedDoNotUseTag1004(Arrays.asList(0)).setLeader(0).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()).setLeaderEpoch(100).setPartitionEpoch(200);
        Uuid topicId = Uuid.fromString((String)"OGdAI5nxT_m-ds3rJMqPLA");
        int partitionId = 4;
        ApiMessageAndVersion apiMessageAndVersion = new PartitionRegistration(partitionRecord).toRecord(topicId, partitionId, this.imageWriterOptions(MetadataVersion.latest()));
        Assertions.assertTrue((boolean)(apiMessageAndVersion.message() instanceof PartitionRecord));
        PartitionRecord toPartitionRecord = (PartitionRecord)apiMessageAndVersion.message();
        Assertions.assertEquals(Collections.emptyList(), toPartitionRecord.deprecatedDoNotUseTag1004());
        Assertions.assertEquals(Collections.emptyList(), toPartitionRecord.deprecatedDoNotUseTag1003());
        Assertions.assertNotEquals(partitionRecord.deprecatedDoNotUseTag1004(), toPartitionRecord.deprecatedDoNotUseTag1004());
        Assertions.assertNotEquals(partitionRecord.deprecatedDoNotUseTag1004(), toPartitionRecord.deprecatedDoNotUseTag1003());
    }

    @Test
    public void testEqualsAndHashCode() {
        List<PartitionRegistration> samples = this.samplePartitionRegistrations();
        for (int i = 0; i < samples.size(); ++i) {
            PartitionRegistration a = samples.get(i);
            for (int j = 0; j < samples.size(); ++j) {
                PartitionRegistration b = samples.get(j);
                if (i == j) {
                    Assertions.assertEquals((Object)a, (Object)b);
                    Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
                    continue;
                }
                Assertions.assertNotEquals((Object)a, (Object)b);
                Assertions.assertNotEquals((int)a.hashCode(), (int)b.hashCode());
            }
        }
    }

    @Property
    public void testConsistentEqualsAndHashCode(@ForAll(value="uniqueSamples") PartitionRegistration a, @ForAll(value="uniqueSamples") PartitionRegistration b) {
        if (a.equals((Object)b)) {
            Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        } else {
            Assertions.assertNotEquals((int)a.hashCode(), (int)b.hashCode());
        }
        if (a.hashCode() != b.hashCode()) {
            Assertions.assertNotEquals((Object)a, (Object)b);
        } else {
            Assertions.assertEquals((Object)a, (Object)b);
        }
    }

    @Provide
    Arbitrary<PartitionRegistration> uniqueSamples() {
        return Arbitraries.of(this.samplePartitionRegistrations());
    }

    private List<PartitionRegistration> samplePartitionRegistrations() {
        return Arrays.asList(new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(101)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(201)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERING).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5, 6}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{4, 5, 6}).setAddingReplicas(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5, 6}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{1, 2, 3}).setAddingReplicas(new int[]{4, 5, 6}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5, 6}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5, 6}).setIsr(new int[]{1, 2, 3}).setAddingReplicas(new int[]{4, 5, 6}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5}).setObservers(new int[]{4, 5}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5, 6}).setObservers(new int[]{4, 5, 6}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{2, 5}).setAddingReplicas(new int[]{3, 6}).setRemovingObservers(new int[]{2}).setAddingObservers(new int[]{3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5, 6}).setObservers(new int[]{4, 5, 6}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{2, 5}).setAddingReplicas(new int[]{3, 6}).setRemovingObservers(new int[0]).setAddingObservers(new int[]{3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5, 6}).setObservers(new int[]{4, 5, 6}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{2, 5}).setAddingReplicas(new int[]{3, 6}).setRemovingObservers(new int[]{2}).setAddingObservers(new int[0]).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build());
    }

    private ImageWriterOptions imageWriterOptions(MetadataVersion metadataVersion) {
        return new ImageWriterOptions.Builder().setMetadataVersion(metadataVersion).build();
    }
}

