/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.ClusterLinksImageTest;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.image.writer.UnwritableMetadataException;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class TopicsImageTest {
    public static final TopicsImage IMAGE1;
    public static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final TopicsDelta DELTA1;
    static final TopicsImage IMAGE2;
    static final TopicsImage TOPIC_PLACEMENT_IMAGE;
    static final List<TopicImage> TOPIC_IMAGES1;
    public static final Uuid FOO_UUID;
    private static final Uuid BAR_UUID;
    private static final Uuid BAZ_UUID;
    private static final Uuid TOPIC_PLACEMENT_UUID;
    private static final MirrorTopic NULL_MIRROR_TOPIC_STATE;
    private static final MirrorTopic ACTIVE_MIRROR_TOPIC_STATE;
    private static final MirrorTopic FAILED_MIRROR_TOPIC_STATE;

    private static TopicImage newTopicImage(String name, Uuid id, MirrorTopic mirrorTopic, PartitionRegistration ... partitions) {
        HashMap<Integer, PartitionRegistration> partitionMap = new HashMap<Integer, PartitionRegistration>();
        int i = 0;
        for (PartitionRegistration partition : partitions) {
            partitionMap.put(i++, partition);
        }
        return new TopicImage(name, id, partitionMap, mirrorTopic);
    }

    private static ImmutableMap<Uuid, TopicImage> newTopicsByIdMap(Collection<TopicImage> topics) {
        ImmutableMap map = ImmutableMap.empty();
        for (TopicImage topic : topics) {
            map = map.updated((Object)topic.id(), (Object)topic);
        }
        return map;
    }

    private static ImmutableMap<String, TopicImage> newTopicsByNameMap(Collection<TopicImage> topics) {
        ImmutableMap map = ImmutableMap.empty();
        for (TopicImage topic : topics) {
            map = map.updated((Object)topic.name(), (Object)topic);
        }
        return map;
    }

    private static ImmutableMap<Uuid, ImmutableMap<Uuid, TopicImage>> newTopicsByLinkIdMap(Collection<TopicImage> topics) {
        ImmutableMap map = ImmutableMap.empty();
        for (TopicImage topic : topics) {
            if (!topic.mirrorTopic().isPresent()) continue;
            Uuid linkId = ((MirrorTopic)topic.mirrorTopic().get()).linkId();
            ImmutableMap images = (ImmutableMap)map.getOrDefault((Object)linkId, (Object)ImmutableMap.empty());
            images = images.updated((Object)topic.id(), (Object)topic);
            map = map.updated((Object)linkId, (Object)images);
        }
        return map;
    }

    private ApiMessageAndVersion newPartitionRecord(Uuid topicId, int partitionId, List<Integer> replicas) {
        return new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(partitionId).setTopicId(topicId).setReplicas(replicas).setIsr(replicas).setLeader(replicas.get(0)).setLeaderEpoch(1).setPartitionEpoch(1), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion());
    }

    private PartitionRegistration newPartition(int[] replicas) {
        return new PartitionRegistration.Builder().setReplicas(replicas).setIsr(replicas).setLeader(Integer.valueOf(replicas[0])).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(1)).build();
    }

    @Test
    public void testBasicLocalChanges() {
        int localId = 3;
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>(DELTA1_RECORDS);
        Uuid newFooId = Uuid.fromString((String)"b66ybsWIQoygs01vdjH07A");
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(newFooId), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()));
        topicRecords.add(this.newPartitionRecord(newFooId, 0, Arrays.asList(0, 1, 2)));
        topicRecords.add(this.newPartitionRecord(newFooId, 1, Arrays.asList(0, 1, localId)));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(1).setTopicId(BAZ_UUID).setReplicas(Arrays.asList(4, 2, localId)).setIsr(Arrays.asList(4, 2, localId)).setLeader(4).setLeaderEpoch(2).setPartitionEpoch(1), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(IMAGE1, __ -> null);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("foo", 1))), (Object)changes.deletes());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("baz", 0))), changes.leaders().keySet());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("baz", 1), new TopicPartition("bar", 0), new TopicPartition("foo", 1))), changes.followers().keySet());
    }

    @Test
    public void testDeleteAfterChanges() {
        int localId = 3;
        Uuid zooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("zoo", zooId, NULL_MIRROR_TOPIC_STATE, this.newPartition(new int[]{localId, 1, 2})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics), ImmutableMap.empty(), ImmutableMap.empty());
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(0).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(zooId), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image, __ -> null);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 0))), (Object)changes.deletes());
        Assertions.assertEquals(Collections.emptyMap(), (Object)changes.leaders());
        Assertions.assertEquals(Collections.emptyMap(), (Object)changes.followers());
    }

    @Test
    public void testLocalReassignmentChanges() {
        int localId = 3;
        Uuid zooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("zoo", zooId, NULL_MIRROR_TOPIC_STATE, this.newPartition(new int[]{0, 1, localId}), this.newPartition(new int[]{localId, 1, 2}), this.newPartition(new int[]{0, 1, localId}), this.newPartition(new int[]{localId, 1, 2}), this.newPartition(new int[]{0, 1, 2}), this.newPartition(new int[]{0, 1, 2})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics), ImmutableMap.empty(), ImmutableMap.empty());
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(0).setLeader(localId), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(1).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(2).setIsr(Arrays.asList(0, 1, 2)).setReplicas(Arrays.asList(0, 1, 2)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(3).setLeader(0).setIsr(Arrays.asList(0, 1, 2)).setReplicas(Arrays.asList(0, 1, 2)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(4).setLeader(localId).setIsr(Arrays.asList(localId, 1, 2)).setReplicas(Arrays.asList(localId, 1, 2)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(5).setIsr(Arrays.asList(0, 1, localId)).setReplicas(Arrays.asList(0, 1, localId)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image, __ -> null);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 2), new TopicPartition("zoo", 3))), (Object)changes.deletes());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 0), new TopicPartition("zoo", 4))), changes.leaders().keySet());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 1), new TopicPartition("zoo", 5))), changes.followers().keySet());
    }

    @Test
    public void testEmptyImageRoundTrip() throws Throwable {
        this.testToImageAndBack(TopicsImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE1);
    }

    @Test
    public void testImageHandlesIsTopicPlacementSupported() {
        RecordListWriter latestWriter = new RecordListWriter();
        MetadataVersion latest = MetadataVersion.latest();
        TOPIC_PLACEMENT_IMAGE.write((ImageWriter)latestWriter, new ImageWriterOptions.Builder().setMetadataVersion(latest).build());
        TopicsDelta latestDelta = new TopicsDelta(TopicsImage.EMPTY, __ -> null);
        RecordTestUtils.replayAll(latestDelta, latestWriter.records());
        TopicsImage latestImage = latestDelta.apply();
        Assertions.assertEquals((int)1, (int)latestImage.getPartition((Uuid)TopicsImageTest.TOPIC_PLACEMENT_UUID, (int)0).observers.length);
        Assertions.assertEquals((int)1, (int)latestImage.getPartition((Uuid)TopicsImageTest.TOPIC_PLACEMENT_UUID, (int)0).observers[0]);
        MetadataVersion metadataVersion34 = MetadataVersion.IBP_3_4_IV0;
        RecordListWriter version34Writer = new RecordListWriter();
        Throwable throwable = Assertions.assertThrows(UnwritableMetadataException.class, () -> TOPIC_PLACEMENT_IMAGE.write((ImageWriter)version34Writer, new ImageWriterOptions.Builder().setMetadataVersion(metadataVersion34).build()));
        Assertions.assertEquals((Object)("Metadata has been lost because the following could not be represented in metadata version 3.4-IV0: the observer metadata for topic " + TOPIC_PLACEMENT_UUID + ", partition 0."), (Object)throwable.getMessage());
    }

    @Test
    public void testApplyDelta1() throws Throwable {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
    }

    @Test
    public void testImage2RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE2);
    }

    private void testToImageAndBack(TopicsImage image) throws Throwable {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        TopicsDelta delta = new TopicsDelta(TopicsImage.EMPTY, __ -> null);
        RecordTestUtils.replayAll(delta, writer.records());
        TopicsImage nextImage = delta.apply();
        Assertions.assertEquals((Object)image, (Object)nextImage);
    }

    @Test
    public void testTopicNameToIdView() {
        Map map = IMAGE1.topicNameToIdView();
        Assertions.assertTrue((boolean)map.containsKey("foo"));
        Assertions.assertEquals((Object)FOO_UUID, map.get("foo"));
        Assertions.assertTrue((boolean)map.containsKey("bar"));
        Assertions.assertEquals((Object)BAR_UUID, map.get("bar"));
        Assertions.assertFalse((boolean)map.containsKey("baz"));
        Assertions.assertNull(map.get("baz"));
        HashSet uuids = new HashSet();
        map.values().iterator().forEachRemaining(u -> uuids.add(u));
        HashSet<Uuid> expectedUuids = new HashSet<Uuid>(Arrays.asList(Uuid.fromString((String)"ThIaNwRnSM2Nt9Mx1v0RvA"), Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw")));
        Assertions.assertEquals(expectedUuids, uuids);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            Uuid cfr_ignored_0 = (Uuid)map.remove("foo");
        });
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put("bar", FOO_UUID));
    }

    @Test
    public void testTopicIdToNameView() {
        Map map = IMAGE1.topicIdToNameView();
        Assertions.assertTrue((boolean)map.containsKey(FOO_UUID));
        Assertions.assertEquals((Object)"foo", map.get(FOO_UUID));
        Assertions.assertTrue((boolean)map.containsKey(BAR_UUID));
        Assertions.assertEquals((Object)"bar", map.get(BAR_UUID));
        Assertions.assertFalse((boolean)map.containsKey(BAZ_UUID));
        Assertions.assertNull(map.get(BAZ_UUID));
        HashSet names = new HashSet();
        map.values().iterator().forEachRemaining(n -> names.add(n));
        HashSet<String> expectedNames = new HashSet<String>(Arrays.asList("foo", "bar"));
        Assertions.assertEquals(expectedNames, names);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            String cfr_ignored_0 = (String)map.remove(FOO_UUID);
        });
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put(FOO_UUID, "bar"));
    }

    private void addTopicWithName(TopicsDelta delta, String name) {
        Uuid topicId = new Uuid((long)name.hashCode(), (long)name.hashCode());
        delta.replay(new TopicRecord().setName(name).setTopicId(topicId));
        delta.replay(new PartitionRecord().setPartitionId(0).setTopicId(topicId).setReplicas(Arrays.asList(0, 1, 2)).setIsr(Arrays.asList(0, 1, 2)).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()).setLeader(0).setLeaderEpoch(123).setPartitionEpoch(456));
    }

    @Test
    public void testTenantToTopics() {
        TopicsDelta delta = new TopicsDelta(TopicsImage.EMPTY, (Function)TopicNameToTenant.INSTANCE);
        this.addTopicWithName(delta, "lkc-abcdef_foo");
        this.addTopicWithName(delta, "bar");
        this.addTopicWithName(delta, "lkc-fedcba_foo");
        this.addTopicWithName(delta, "baz");
        this.addTopicWithName(delta, "lkc-fedcba_bar");
        TopicsImage image = delta.apply();
        Assertions.assertEquals(Collections.singleton("lkc-abcdef_foo"), (Object)image.topicsByTenant("lkc-abcdef_"));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("lkc-fedcba_foo", "lkc-fedcba_bar")), (Object)image.topicsByTenant("lkc-fedcba_"));
        Assertions.assertEquals(Collections.emptySet(), (Object)image.topicsByTenant("lkc-blahba_"));
        Assertions.assertEquals(Collections.emptySet(), (Object)image.topicsByTenant(""));
    }

    @Test
    public void testDeleteClusterLink() {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.add(new ApiMessageAndVersion((ApiMessage)new RemoveClusterLinkRecord().setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("doesn't matter"), MetadataRecordType.REMOVE_CLUSTER_LINK_RECORD.highestSupportedVersion()));
        Assertions.assertFalse((boolean)IMAGE1.topicsByLinkId(ClusterLinksImageTest.LINK_FOO_UUID).isEmpty());
        Assertions.assertNotNull((Object)IMAGE1.getTopic(BAR_UUID));
        Assertions.assertTrue((boolean)IMAGE1.getTopic(BAR_UUID).mirrorTopic().isPresent());
        TopicsDelta delta = new TopicsDelta(IMAGE1, __ -> null);
        RecordTestUtils.replayAll(delta, records);
        TopicsImage image = delta.apply();
        Assertions.assertTrue((boolean)image.topicsByLinkId(ClusterLinksImageTest.LINK_FOO_UUID).isEmpty(), (String)"Link was removed, so expected zero topics");
        Assertions.assertNotNull((Object)image.getTopic(BAR_UUID), (String)"Topic should still exist after un-linking");
        Assertions.assertFalse((boolean)image.getTopic(BAR_UUID).mirrorTopic().isPresent(), (String)"Mirror topic data should not be present after un-linking");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testCreateMirrorTopicAndModifyState(boolean removeClusterLink) {
        void var14_17;
        String clusterLinkName = "myClusterLink";
        Uuid clusterLinkId = Uuid.fromString((String)"IuhBqpV2S0O6D_UgPr_YSw");
        Uuid remoteClusterId = Uuid.fromString((String)"RlnrMlrZT_6tTA1hd8o7GA");
        String destinationTopicName = "destination";
        Uuid destinationTopicId = Uuid.fromString((String)"bFmT8AQSQUayhuNKLehnvQ");
        String sourceTopicName = "source";
        Uuid sourceTopicId = Uuid.fromString((String)"2jYFLPWISZaCftP1xFKCRw");
        ArrayList<Object> records = new ArrayList<Object>();
        records.add(new ClusterLinkRecord().setClusterLinkName("myClusterLink").setClusterLinkId(clusterLinkId).setRemoteClusterId(remoteClusterId.toString()).setTenantPrefix("").setLinkMode(ClusterLinkConfig.LinkMode.DESTINATION.toString()));
        records.add(new TopicRecord().setName("destination").setTopicId(destinationTopicId));
        records.add(new MirrorTopicRecord().setTopicId(destinationTopicId).setTopicName("destination").setClusterLinkId(clusterLinkId).setClusterLinkName("myClusterLink").setSourceTopicName("source").setSourceTopicId(sourceTopicId).setMirrorTopicState(MirrorTopic.State.MIRROR.stateName()).setTimeMs(123L));
        records.add(new PartitionRecord().setPartitionId(0).setTopicId(destinationTopicId).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1, 2, 3)).setLeader(1).setLeaderEpoch(123).setPartitionEpoch(456).setLinkedLeaderEpoch(300).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode));
        if (removeClusterLink) {
            records.add(new RemoveClusterLinkRecord().setClusterLinkName("myClusterLink").setClusterLinkId(clusterLinkId));
        }
        MetadataDelta initialDelta = new MetadataDelta(MetadataImage.EMPTY, __ -> null, new MetadataEncryptorFactory());
        initialDelta.replay(new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(MetadataVersion.IBP_3_5_IV0.confluentFeatureLevel()));
        MetadataImage initialImage = initialDelta.apply(MetadataProvenance.EMPTY);
        MetadataDelta testDelta = new MetadataDelta(initialImage, __ -> null, new MetadataEncryptorFactory());
        for (ApiMessage apiMessage : records) {
            testDelta.replay(apiMessage);
        }
        MetadataImage testImage = testDelta.apply(MetadataProvenance.EMPTY);
        Object var14_15 = null;
        if (!removeClusterLink) {
            MirrorTopic.ActiveMirrorTopic activeMirrorTopic = new MirrorTopic.ActiveMirrorTopic(clusterLinkId, "myClusterLink", destinationTopicId, "destination", sourceTopicId, "source", Collections.emptyList(), 123L);
        }
        TopicImage destinationTopic = new TopicImage("destination", destinationTopicId, Collections.singletonMap(0, new PartitionRegistration(new PartitionRecord().setPartitionId(0).setTopicId(destinationTopicId).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1, 2, 3)).setLeader(1).setLeaderEpoch(123).setPartitionEpoch(removeClusterLink ? 457 : 456).setLinkedLeaderEpoch(removeClusterLink ? -1 : 300).setLinkState(removeClusterLink ? PartitionRegistration.LinkState.NOT_MIRROR.levelCode : PartitionRegistration.LinkState.ACTIVE.levelCode))), (MirrorTopic)var14_17);
        Assertions.assertEquals((Object)new TopicsImage(ImmutableMap.singleton((Object)destinationTopicId, (Object)destinationTopic), ImmutableMap.singleton((Object)"destination", (Object)destinationTopic), ImmutableMap.empty(), removeClusterLink ? ImmutableMap.empty() : ImmutableMap.singleton((Object)clusterLinkId, (Object)ImmutableMap.singleton((Object)destinationTopicId, (Object)destinationTopic))), (Object)testImage.topics());
    }

    @Test
    public void testRemoveMirrorTopicAndClusterLinkInSameDelta() {
        String clusterLinkName = "myClusterLink";
        Uuid clusterLinkId = Uuid.fromString((String)"IuhBqpV2S0O6D_UgPr_YSw");
        Uuid sourceClusterId = Uuid.fromString((String)"RlnrMlrZT_6tTA1hd8o7GA");
        String destinationTopicName = "destination";
        Uuid destinationTopicId = Uuid.fromString((String)"bFmT8AQSQUayhuNKLehnvQ");
        String sourceTopicName = "source";
        Uuid sourceTopicId = Uuid.fromString((String)"2jYFLPWISZaCftP1xFKCRw");
        ArrayList<Object> records = new ArrayList<Object>();
        records.add(new ClusterLinkRecord().setClusterLinkName("myClusterLink").setClusterLinkId(clusterLinkId).setRemoteClusterId(sourceClusterId.toString()).setTenantPrefix("").setLinkMode(ClusterLinkConfig.LinkMode.DESTINATION.toString()));
        records.add(new TopicRecord().setName("destination").setTopicId(destinationTopicId));
        records.add(new MirrorTopicRecord().setTopicId(destinationTopicId).setTopicName("destination").setClusterLinkId(clusterLinkId).setClusterLinkName("myClusterLink").setSourceTopicName("source").setSourceTopicId(sourceTopicId).setMirrorTopicState(MirrorTopic.State.MIRROR.stateName()).setTimeMs(123L));
        records.add(new PartitionRecord().setPartitionId(0).setTopicId(destinationTopicId).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1, 2, 3)).setLeader(1).setLeaderEpoch(123).setPartitionEpoch(456).setLinkedLeaderEpoch(300).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode));
        MetadataImage image = MetadataImage.EMPTY;
        MetadataDelta delta = new MetadataDelta(image, name -> null, new MetadataEncryptorFactory());
        records.forEach(arg_0 -> ((MetadataDelta)delta).replay(arg_0));
        image = delta.apply(MetadataProvenance.EMPTY);
        records.clear();
        delta = new MetadataDelta(image, name -> null, new MetadataEncryptorFactory());
        records.add(new RemoveTopicRecord().setTopicId(destinationTopicId));
        records.add(new RemoveClusterLinkRecord().setClusterLinkName("myClusterLink").setClusterLinkId(clusterLinkId));
        records.forEach(arg_0 -> ((MetadataDelta)delta).replay(arg_0));
        image = delta.apply(image.provenance());
        Assertions.assertFalse((boolean)image.topics().topicsByName().containsKey((Object)"destination"));
        Assertions.assertFalse((boolean)image.clusterLinks().linksById().containsKey(clusterLinkId));
    }

    static {
        FOO_UUID = Uuid.fromString((String)"ThIaNwRnSM2Nt9Mx1v0RvA");
        BAR_UUID = Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw");
        BAZ_UUID = Uuid.fromString((String)"tgHBnRglT5W_RlENnuG5vg");
        TOPIC_PLACEMENT_UUID = Uuid.fromString((String)"p0HptygTTjet8SL5ZeREiw");
        NULL_MIRROR_TOPIC_STATE = null;
        ACTIVE_MIRROR_TOPIC_STATE = MirrorTopic.fromRecord((MirrorTopicRecord)new MirrorTopicRecord().setTopicName("bar").setTopicId(BAR_UUID).setSourceTopicName("bar").setSourceTopicId(Uuid.ZERO_UUID).setMirrorTopicState("Mirror").setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("link-foo").setPreviousToPausedState(null).setStoppedLogEndOffsets(Collections.emptyList()));
        FAILED_MIRROR_TOPIC_STATE = MirrorTopic.fromRecord((MirrorTopicRecord)new MirrorTopicRecord().setTopicName("bar").setTopicId(BAR_UUID).setSourceTopicName("bar").setSourceTopicId(Uuid.ZERO_UUID).setMirrorTopicState("FailedMirror").setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("link-foo").setPreviousToPausedState(null).setStoppedLogEndOffsets(Collections.emptyList()));
        TOPIC_IMAGES1 = Arrays.asList(TopicsImageTest.newTopicImage("foo", FOO_UUID, NULL_MIRROR_TOPIC_STATE, new PartitionRegistration.Builder().setReplicas(new int[]{2, 3, 4}).setIsr(new int[]{2, 3}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(345)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{3, 4, 5}).setIsr(new int[]{3, 4, 5}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(4)).setPartitionEpoch(Integer.valueOf(684)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{2, 4, 5}).setIsr(new int[]{2, 4, 5}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(10)).setPartitionEpoch(Integer.valueOf(84)).build()), TopicsImageTest.newTopicImage("bar", BAR_UUID, ACTIVE_MIRROR_TOPIC_STATE, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2, 3, 4}).setIsr(new int[]{0, 1, 2, 3}).setRemovingReplicas(new int[]{1}).setAddingReplicas(new int[]{3, 4}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(345)).build()));
        IMAGE1 = new TopicsImage(TopicsImageTest.newTopicsByIdMap(TOPIC_IMAGES1), TopicsImageTest.newTopicsByNameMap(TOPIC_IMAGES1), ImmutableMap.empty(), TopicsImageTest.newTopicsByLinkIdMap(TOPIC_IMAGES1));
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(FOO_UUID), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(BAR_UUID).setPartitionId(0).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("baz").setTopicId(BAZ_UUID), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(BAZ_UUID).setReplicas(Arrays.asList(1, 2, 3, 4)).setIsr(Arrays.asList(3, 4)).setRemovingReplicas(Collections.singletonList(2)).setAddingReplicas(Collections.singletonList(1)).setLeader(3).setLeaderEpoch(2).setPartitionEpoch(1), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new MirrorTopicChangeRecord().setTopicId(BAR_UUID).setMirrorTopicState("FailedMirror").setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("link-foo").setPreviousToPausedState(null).setStoppedLogEndOffsets(Collections.emptyList()), MetadataRecordType.MIRROR_TOPIC_CHANGE_RECORD.highestSupportedVersion()));
        DELTA1 = new TopicsDelta(IMAGE1, __ -> null);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        List<TopicImage> topics2 = Arrays.asList(TopicsImageTest.newTopicImage("bar", BAR_UUID, FAILED_MIRROR_TOPIC_STATE, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2, 3, 4}).setIsr(new int[]{0, 1, 2, 3}).setRemovingReplicas(new int[]{1}).setAddingReplicas(new int[]{3, 4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(2)).setPartitionEpoch(Integer.valueOf(346)).build()), TopicsImageTest.newTopicImage("baz", BAZ_UUID, NULL_MIRROR_TOPIC_STATE, new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setIsr(new int[]{3, 4}).setRemovingReplicas(new int[]{2}).setAddingReplicas(new int[]{1}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(2)).setPartitionEpoch(Integer.valueOf(1)).build()));
        IMAGE2 = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics2), TopicsImageTest.newTopicsByNameMap(topics2), ImmutableMap.empty(), TopicsImageTest.newTopicsByLinkIdMap(topics2));
        List<TopicImage> placementTopics = Arrays.asList(TopicsImageTest.newTopicImage("placement-topic", TOPIC_PLACEMENT_UUID, NULL_MIRROR_TOPIC_STATE, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1}).setObservers(new int[]{1}).setIsr(new int[]{0}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(1)).build()));
        TOPIC_PLACEMENT_IMAGE = new TopicsImage(TopicsImageTest.newTopicsByIdMap(placementTopics), TopicsImageTest.newTopicsByNameMap(placementTopics), ImmutableMap.empty(), TopicsImageTest.newTopicsByLinkIdMap(placementTopics));
    }

    private static class TopicNameToTenant
    implements Function<String, String> {
        static final TopicNameToTenant INSTANCE = new TopicNameToTenant();

        private TopicNameToTenant() {
        }

        @Override
        public String apply(String name) {
            int i = name.indexOf(95);
            return i == -1 ? null : name.substring(0, i + 1);
        }
    }
}

