/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.kafka.common.Tenant;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.RemoveTenantRecord;
import org.apache.kafka.common.metadata.TenantRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.TenantDelta;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
class TenantImageTest {
    TenantImageTest() {
    }

    @Test
    void testIsEmpty() {
        TenantImage image = new TenantImage(new HashMap());
        Assertions.assertTrue((boolean)image.isEmpty());
        Assertions.assertTrue((boolean)CellImage.EMPTY.isEmpty());
        String tenantId = "lkc-abcd";
        HashMap<String, Tenant> tenantIdToTenant = new HashMap<String, Tenant>();
        tenantIdToTenant.put(tenantId, new Tenant(tenantId, 0));
        Assertions.assertFalse((boolean)new TenantImage(tenantIdToTenant).isEmpty());
    }

    @Test
    void testTenantIdToTenant() {
        TenantImage image = new TenantImage(new HashMap());
        Assertions.assertEquals(new HashMap(), (Object)image.tenantIdToTenant());
        Assertions.assertEquals(new HashMap(), (Object)TenantImage.EMPTY.tenantIdToTenant());
        String tenantId = "lkc-abcd";
        HashMap<String, Tenant> tenantIdToTenant = new HashMap<String, Tenant>();
        tenantIdToTenant.put(tenantId, new Tenant(tenantId, 0));
        Assertions.assertEquals(tenantIdToTenant, (Object)new TenantImage(tenantIdToTenant).tenantIdToTenant());
    }

    @Test
    void testEquals() {
        Assertions.assertEquals((Object)new TenantImage(new HashMap()), (Object)new TenantImage(new HashMap()));
        Assertions.assertEquals((Object)TenantImage.EMPTY, (Object)TenantImage.EMPTY);
        Assertions.assertEquals((Object)new TenantImage(new HashMap()), (Object)TenantImage.EMPTY);
        String tenantId = "lkc-abcd";
        HashMap<String, Tenant> tenantIdToTenant = new HashMap<String, Tenant>();
        tenantIdToTenant.put(tenantId, new Tenant(tenantId, 0));
        Assertions.assertEquals((Object)new TenantImage(tenantIdToTenant), (Object)new TenantImage(tenantIdToTenant));
        Assertions.assertNotEquals((Object)TenantImage.EMPTY, (Object)new TenantImage(tenantIdToTenant));
        Assertions.assertNotEquals((Object)new TenantImage(tenantIdToTenant), (Object)TenantImage.EMPTY);
    }

    @Test
    void testWrite() {
        String tenantId = "lkc-abcd";
        HashMap<String, Tenant> tenantIdToTenant = new HashMap<String, Tenant>();
        tenantIdToTenant.put(tenantId, new Tenant(tenantId, 0));
        TenantImage image = new TenantImage(tenantIdToTenant);
        ArrayList<ApiMessageAndVersion> expectedBatch = new ArrayList<ApiMessageAndVersion>();
        expectedBatch.add(new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId(tenantId).setCellId(0), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()));
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        Assertions.assertEquals(expectedBatch, (Object)writer.records());
    }

    @Test
    void testTenantDeltaReplayAndImageWriteNewTenant() {
        TenantDelta tenantDelta = new TenantDelta(new TenantImage(Collections.emptyMap()));
        tenantDelta.replay(new TenantRecord().setTenantId("lkc-abcd").setCellId(0));
        RecordListWriter writer = new RecordListWriter();
        tenantDelta.apply().write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        List<ApiMessageAndVersion> expectedBatch = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId("lkc-abcd").setCellId(0), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedBatch, (Object)writer.records());
    }

    @Test
    void testTenantDeltaReplayAndImageWriteNewTenantAndRemove() {
        TenantDelta tenantDelta = new TenantDelta(new TenantImage(Collections.emptyMap()));
        tenantDelta.replay(new TenantRecord().setTenantId("lkc-abcd").setCellId(0));
        tenantDelta.replay(new RemoveTenantRecord().setTenantId("lkc-abcd"));
        RecordListWriter writer = new RecordListWriter();
        tenantDelta.apply().write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        Assertions.assertEquals(Collections.emptyList(), (Object)writer.records());
    }

    @Test
    void testTenantDeltaReplayAndImageWriteNewTenantAfterDelete() {
        TenantDelta tenantDelta = new TenantDelta(new TenantImage(Collections.emptyMap()));
        tenantDelta.replay(new TenantRecord().setTenantId("lkc-abcd").setCellId(0));
        tenantDelta.replay(new RemoveTenantRecord().setTenantId("lkc-abcd"));
        tenantDelta.replay(new TenantRecord().setTenantId("lkc-abcd").setCellId(0));
        RecordListWriter writer = new RecordListWriter();
        tenantDelta.apply().write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        List<ApiMessageAndVersion> expectedBatch = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId("lkc-abcd").setCellId(0), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedBatch, (Object)writer.records());
    }

    @Test
    void testTenantDeltaReplayAndImageWriteUpdateTenant() {
        TenantDelta tenantDelta = new TenantDelta(new TenantImage(Collections.emptyMap()));
        tenantDelta.replay(new TenantRecord().setTenantId("lkc-abcd").setCellId(0));
        tenantDelta.replay(new TenantRecord().setTenantId("lkc-abcd").setCellId(1));
        RecordListWriter writer = new RecordListWriter();
        tenantDelta.apply().write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        List<ApiMessageAndVersion> expectedBatch = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId("lkc-abcd").setCellId(1), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedBatch, (Object)writer.records());
    }

    @Test
    void testTenantDeltaReplayAndImageWriteWithOriginalImage() {
        HashMap<String, Tenant> originalTenantIdToTenant = new HashMap<String, Tenant>();
        originalTenantIdToTenant.put("lkc-tenant0", new Tenant("lkc-tenant0", 0));
        originalTenantIdToTenant.put("lkc-tenant1", new Tenant("lkc-tenant1", 1));
        originalTenantIdToTenant.put("lkc-tenant2", new Tenant("lkc-tenant2", 2));
        TenantDelta tenantDelta = new TenantDelta(new TenantImage(originalTenantIdToTenant));
        tenantDelta.replay(new RemoveTenantRecord().setTenantId("lkc-tenant0"));
        tenantDelta.replay(new TenantRecord().setTenantId("lkc-tenant1").setCellId(100));
        tenantDelta.replay(new TenantRecord().setTenantId("lkc-tenant3").setCellId(300));
        RecordListWriter writer = new RecordListWriter();
        tenantDelta.apply().write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        HashSet<ApiMessageAndVersion> expectedBatch = new HashSet<ApiMessageAndVersion>(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId("lkc-tenant1").setCellId(100), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId("lkc-tenant2").setCellId(2), MetadataRecordType.TENANT_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new TenantRecord().setTenantId("lkc-tenant3").setCellId(300), MetadataRecordType.TENANT_RECORD.highestSupportedVersion())));
        Assertions.assertEquals(expectedBatch, new HashSet(writer.records()));
    }
}

