/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.EncryptedEnvelopeRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.AclsImageTest;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsImageTest;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClientQuotasImageTest;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterImageTest;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ClusterLinksImageTest;
import org.apache.kafka.image.ConfigurationImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.ConfigurationsImageTest;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.FeaturesImageTest;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ProducerIdsImageTest;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.ScramImageTest;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.TopicsImageTest;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.AesGcm128MetadataEncryptor;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.migration.ZkMigrationState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class MetadataImageTest {
    public static final MetadataImage IMAGE1;
    public static final MetadataDelta DELTA1;
    public static final MetadataImage IMAGE2;
    public static final KafkaConfigSchema CONFIG_SCHEMA;
    public static final Uuid ENCRYPTOR_UUID;
    public static final MetadataEncryptor ENCRYPTOR;
    public static final MetadataEncryptorFactory ENCRYPTOR_FACTORY;

    @Test
    public void testEmptyImageRoundTrip() throws Throwable {
        this.testToImageAndBack(MetadataImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE1);
    }

    @Test
    public void testApplyDelta1() throws Throwable {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply(IMAGE2.provenance()));
    }

    @Test
    public void testImage2RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE2);
    }

    @Test
    public void testRemoveClusterLink() {
        MetadataDelta delta = new MetadataDelta.Builder().setImage(IMAGE1).build();
        List<ApiMessageAndVersion> records = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new RemoveClusterLinkRecord().setClusterLinkId(ClusterLinksImageTest.LINK_FOO_UUID).setClusterLinkName("doesn't matter"), MetadataRecordType.REMOVE_CLUSTER_LINK_RECORD.highestSupportedVersion()));
        RecordTestUtils.replayAll(delta, records);
        Assertions.assertTrue((boolean)IMAGE1.clusterLinks().linksById().containsKey(ClusterLinksImageTest.LINK_FOO_UUID));
        ImmutableMap topicsWithLink = IMAGE1.topics().topicsByLinkId(ClusterLinksImageTest.LINK_FOO_UUID);
        Assertions.assertFalse((boolean)topicsWithLink.isEmpty());
        for (TopicImage image : topicsWithLink.values()) {
            Assertions.assertTrue((boolean)image.mirrorTopic().isPresent());
            Assertions.assertEquals((Object)ClusterLinksImageTest.LINK_FOO_UUID, (Object)((MirrorTopic)image.mirrorTopic().get()).linkId());
        }
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        Assertions.assertNull(image.clusterLinks().linksById().get(ClusterLinksImageTest.LINK_FOO_UUID), (String)"Should not have this cluster link after removal");
        Assertions.assertTrue((boolean)image.topics().topicsByLinkId(ClusterLinksImageTest.LINK_FOO_UUID).isEmpty(), (String)"Expect zero topics to be using the removed link");
        for (TopicImage topicImage : topicsWithLink.values()) {
            Assertions.assertFalse((boolean)image.topics().getTopic(topicImage.id()).mirrorTopic().isPresent(), (String)"Expected topic to have no mirror state");
        }
    }

    private void testToImageAndBack(MetadataImage image) {
        this.testToImageAndBack(image, new ImageWriterOptions.Builder().setMetadataVersion(image.features().metadataVersion()).build());
    }

    private void testToImageAndBack(MetadataImage image, ImageWriterOptions options) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, options);
        System.out.println("===========================");
        writer.records().forEach(r -> System.out.println("REC = " + r));
        System.out.println("===========================");
        MetadataDelta delta = new MetadataDelta.Builder().setImage(MetadataImage.EMPTY.copyWithEncryptor(image.encryptor())).setMetadataEncryptorFactory(ENCRYPTOR_FACTORY).build();
        RecordTestUtils.replayAll(delta, writer.records());
        MetadataImage nextImage = delta.apply(image.provenance());
        Assertions.assertEquals((Object)image, (Object)nextImage);
    }

    @Test
    public void testSensitiveBrokerConfigsAreEncrypted() {
        String sensitiveConfigName = "sensitive.config";
        ConfigDef brokerConfigDef = new ConfigDef().define(sensitiveConfigName, ConfigDef.Type.PASSWORD, ConfigDef.Importance.HIGH, "");
        KafkaConfigSchema configSchema = new KafkaConfigSchema(Collections.singletonMap(ConfigResource.Type.BROKER, brokerConfigDef), Collections.emptyMap());
        String sensitiveConfigValue = "should_be_encrypted";
        ConfigResource defaultBrokerResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        HashMap<String, String> defaultBrokerConfigs = new HashMap<String, String>();
        defaultBrokerConfigs.put(sensitiveConfigName, sensitiveConfigValue);
        ConfigResource broker1ConfigResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        HashMap<String, String> broker1Configs = new HashMap<String, String>();
        broker1Configs.put(sensitiveConfigName, sensitiveConfigValue);
        HashMap<ConfigResource, ConfigurationImage> allResourceConfigs = new HashMap<ConfigResource, ConfigurationImage>();
        allResourceConfigs.put(defaultBrokerResource, new ConfigurationImage(defaultBrokerResource, defaultBrokerConfigs));
        allResourceConfigs.put(broker1ConfigResource, new ConfigurationImage(broker1ConfigResource, broker1Configs));
        ConfigurationsImage configImage = new ConfigurationsImage(allResourceConfigs);
        MetadataImage image = new MetadataImage(new MetadataProvenance(100L, 4, 4000L), new FeaturesImage(Collections.emptyMap(), MetadataVersion.latest(), ZkMigrationState.NONE), ClusterImage.EMPTY, TopicsImage.EMPTY, configImage, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, CellImage.EMPTY, TenantImage.EMPTY, ScramImage.EMPTY, ENCRYPTOR);
        ImageWriterOptions imageOptions = new ImageWriterOptions.Builder().setConfigSchema(configSchema).build();
        List<ApiMessageAndVersion> expectedEncryptedRecords = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(defaultBrokerResource.type().id()).setResourceName(defaultBrokerResource.name()).setName(sensitiveConfigName).setValue(sensitiveConfigValue), 0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(broker1ConfigResource.type().id()).setResourceName(broker1ConfigResource.name()).setName(sensitiveConfigName).setValue(sensitiveConfigValue), 0));
        this.assertSnapshotEncryption(expectedEncryptedRecords, image, imageOptions, ENCRYPTOR);
        this.testToImageAndBack(image, imageOptions);
    }

    private void assertSnapshotEncryption(List<ApiMessageAndVersion> expectedEncryptedRecords, MetadataImage image, ImageWriterOptions options, MetadataEncryptor encryptor) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, options);
        ArrayList<ApiMessageAndVersion> encryptedRecords = new ArrayList<ApiMessageAndVersion>();
        for (ApiMessageAndVersion record : writer.records()) {
            if (!(record.message() instanceof EncryptedEnvelopeRecord)) continue;
            encryptedRecords.add(encryptor.decrypt((EncryptedEnvelopeRecord)record.message()));
        }
        Assertions.assertEquals(new HashSet<ApiMessageAndVersion>(expectedEncryptedRecords), new HashSet(encryptedRecords));
    }

    @Test
    public void testImage1WithEncryptionRoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE1.copyWithEncryptor(ENCRYPTOR));
    }

    @Test
    public void testImage2WithEncryptionRoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE2.copyWithEncryptor(ENCRYPTOR));
    }

    static {
        CONFIG_SCHEMA = KafkaConfigSchema.EMPTY;
        IMAGE1 = new MetadataImage(new MetadataProvenance(100L, 4, 2000L), FeaturesImageTest.IMAGE1, ClusterImageTest.IMAGE1, TopicsImageTest.IMAGE1, ConfigurationsImageTest.IMAGE1, ClientQuotasImageTest.IMAGE1, ProducerIdsImageTest.IMAGE1, AclsImageTest.IMAGE1, ClusterLinksImageTest.IMAGE1, BrokerReplicaExclusionsImageTest.IMAGE1, CellImage.EMPTY, TenantImage.EMPTY, ScramImageTest.IMAGE1, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
        DELTA1 = new MetadataDelta.Builder().setImage(IMAGE1).build();
        RecordTestUtils.replayAll(DELTA1, FeaturesImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, ClusterImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, TopicsImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, ConfigurationsImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, ClientQuotasImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, ProducerIdsImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, AclsImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, ClusterLinksImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, BrokerReplicaExclusionsImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, ScramImageTest.DELTA1_RECORDS);
        IMAGE2 = new MetadataImage(new MetadataProvenance(200L, 5, 4000L), FeaturesImageTest.IMAGE2, ClusterImageTest.IMAGE2, TopicsImageTest.IMAGE2, ConfigurationsImageTest.IMAGE2, ClientQuotasImageTest.IMAGE2, ProducerIdsImageTest.IMAGE2, AclsImageTest.IMAGE2, ClusterLinksImageTest.IMAGE2, BrokerReplicaExclusionsImageTest.IMAGE2, CellImage.EMPTY, TenantImage.EMPTY, ScramImageTest.IMAGE2, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
        ENCRYPTOR_UUID = Uuid.fromString((String)"nNr41iuoQTOiKXl8DT8lIg");
        try {
            byte[] secret = new byte[16];
            for (int i = 0; i < secret.length; ++i) {
                secret[i] = (byte)(i + 10);
            }
            ENCRYPTOR = new AesGcm128MetadataEncryptor(ENCRYPTOR_UUID, secret);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> factoryConfig = new HashMap<String, String>();
        factoryConfig.put("confluent.metadata.active.encryptor", ENCRYPTOR_UUID.toString());
        factoryConfig.put("confluent.metadata.encryptor.classes", ENCRYPTOR_UUID.toString() + "=" + AesGcm128MetadataEncryptor.class.getCanonicalName());
        factoryConfig.put("confluent.metadata.encryptor.secrets", ENCRYPTOR_UUID.toString() + "=" + Base64.getUrlEncoder().withoutPadding().encodeToString(ENCRYPTOR.secret()));
        ENCRYPTOR_FACTORY = new MetadataEncryptorFactory(factoryConfig);
    }
}

