/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.image.ClusterDelta;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerRegistrationInControlledShutdownChange;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=40L)
public class ClusterImageTest {
    private static final Logger log = LoggerFactory.getLogger(ClusterImageTest.class);
    public static final ClusterImage IMAGE1;
    static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final ClusterDelta DELTA1;
    static final ClusterImage IMAGE2;

    @Test
    public void testEmptyImageRoundTrip() throws Throwable {
        this.testToImageAndBack(ClusterImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE1);
    }

    @Test
    public void testApplyDelta1() throws Throwable {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
    }

    @Test
    public void testImage2RoundTrip() throws Throwable {
        this.testToImageAndBack(IMAGE2);
    }

    private void testToImageAndBack(ClusterImage image) throws Throwable {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        ClusterDelta delta = new ClusterDelta(ClusterImage.EMPTY);
        RecordTestUtils.replayAll(delta, writer.records());
        ClusterImage nextImage = delta.apply();
        Assertions.assertEquals((Object)image, (Object)nextImage);
    }

    static {
        HashMap<Integer, BrokerRegistration> map1 = new HashMap<Integer, BrokerRegistration>();
        map1.put(0, new BrokerRegistration(0, 1000L, Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q"), Arrays.asList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9092)), Collections.singletonMap("foo", VersionRange.of((short)1, (short)3)), Optional.empty(), true, false));
        map1.put(1, new BrokerRegistration(1, 1001L, Uuid.fromString((String)"U52uRe20RsGI0RvpcTx33Q"), Arrays.asList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9093)), Collections.singletonMap("foo", VersionRange.of((short)1, (short)3)), Optional.empty(), false, false, false, new HashSet<DegradedBrokerHealthState>(Collections.singleton(new DegradedBrokerHealthState("RCCA-123", BrokerComponent.UNSPECIFIED)))));
        map1.put(2, new BrokerRegistration(2, 123L, Uuid.fromString((String)"hr4TVh3YQiu3p16Awkka6w"), Arrays.asList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9093)), Collections.emptyMap(), Optional.of("arack"), false, false));
        IMAGE1 = new ClusterImage(map1);
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new UnfenceBrokerRecord().setId(0).setEpoch(1000L), MetadataRecordType.UNFENCE_BROKER_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new FenceBrokerRecord().setId(1).setEpoch(1001L), MetadataRecordType.FENCE_BROKER_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(1000L).setInControlledShutdown(BrokerRegistrationInControlledShutdownChange.IN_CONTROLLED_SHUTDOWN.value()), MetadataRecordType.FENCE_BROKER_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(1001L).setDegradedComponents(Collections.singletonList(new BrokerRegistrationChangeRecord.DegradedComponent().setComponentCode(BrokerComponent.UNSPECIFIED.id()).setReason("RCCA-234"))), MetadataRecordType.BROKER_REGISTRATION_CHANGE_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new UnregisterBrokerRecord().setBrokerId(2).setBrokerEpoch(123L), MetadataRecordType.UNREGISTER_BROKER_RECORD.highestSupportedVersion()));
        DELTA1 = new ClusterDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        HashMap<Integer, BrokerRegistration> map2 = new HashMap<Integer, BrokerRegistration>();
        map2.put(0, new BrokerRegistration(0, 1000L, Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q"), Arrays.asList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9092)), Collections.singletonMap("foo", VersionRange.of((short)1, (short)3)), Optional.empty(), false, true));
        map2.put(1, new BrokerRegistration(1, 1001L, Uuid.fromString((String)"U52uRe20RsGI0RvpcTx33Q"), Arrays.asList(new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9093)), Collections.singletonMap("foo", VersionRange.of((short)1, (short)3)), Optional.empty(), true, false, false, new HashSet<DegradedBrokerHealthState>(Collections.singleton(new DegradedBrokerHealthState("RCCA-234", BrokerComponent.UNSPECIFIED)))));
        IMAGE2 = new ClusterImage(map2);
    }
}

