/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.metadata.CellRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.RemoveCellRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.CellDelta;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
class CellImageTest {
    CellImageTest() {
    }

    @Test
    void testIsEmpty() {
        CellImage image = new CellImage(new HashMap());
        Assertions.assertTrue((boolean)image.isEmpty());
        Assertions.assertTrue((boolean)CellImage.EMPTY.isEmpty());
        HashMap<Integer, Cell> cellIdToCell = new HashMap<Integer, Cell>();
        cellIdToCell.put(0, new Cell(0, new HashSet(), CellState.READY, 3, 6));
        Assertions.assertFalse((boolean)new CellImage(cellIdToCell).isEmpty());
    }

    @Test
    void testCellIdToCell() {
        CellImage image = new CellImage(new HashMap());
        Assertions.assertEquals(new HashMap(), (Object)image.cellIdToCell());
        Assertions.assertEquals(new HashMap(), (Object)CellImage.EMPTY.cellIdToCell());
        HashMap<Integer, Cell> cellIdToCell = new HashMap<Integer, Cell>();
        cellIdToCell.put(0, new Cell(0, new HashSet(), CellState.READY, 3, 6));
        Assertions.assertEquals(cellIdToCell, (Object)new CellImage(cellIdToCell).cellIdToCell());
    }

    @Test
    void testEquals() {
        Assertions.assertEquals((Object)new CellImage(new HashMap()), (Object)new CellImage(new HashMap()));
        Assertions.assertEquals((Object)CellImage.EMPTY, (Object)CellImage.EMPTY);
        Assertions.assertEquals((Object)new CellImage(new HashMap()), (Object)CellImage.EMPTY);
        HashMap<Integer, Cell> cellIdToCell = new HashMap<Integer, Cell>();
        cellIdToCell.put(0, new Cell(0, new HashSet(), CellState.READY, 3, 6));
        cellIdToCell.put(1, new Cell(1, new HashSet(), CellState.QUARANTINED, 2, 4));
        CellImage image = new CellImage(cellIdToCell);
        Assertions.assertEquals((Object)new CellImage(cellIdToCell), (Object)new CellImage(cellIdToCell));
        Assertions.assertNotEquals((Object)CellImage.EMPTY, (Object)new CellImage(cellIdToCell));
        Assertions.assertNotEquals((Object)new CellImage(cellIdToCell), (Object)CellImage.EMPTY);
        HashMap<Integer, Cell> secondCellIdToCell = new HashMap<Integer, Cell>();
        secondCellIdToCell.put(0, new Cell(0, new HashSet(), CellState.EXCLUDED, 3, 6));
        secondCellIdToCell.put(1, new Cell(1, new HashSet(), CellState.READY, 2, 4));
        CellImage secondImage = new CellImage(secondCellIdToCell);
        Assertions.assertNotEquals((Object)image, (Object)secondImage);
    }

    @Test
    void testGetBrokerCellId() {
        HashMap<Integer, Cell> cellIdToCell = new HashMap<Integer, Cell>();
        cellIdToCell.put(0, new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 3, 6));
        cellIdToCell.put(1, new Cell(1, new HashSet<Integer>(Arrays.asList(3, 4, 5)), CellState.QUARANTINED, 2, 4));
        CellImage image = new CellImage(cellIdToCell);
        Assertions.assertEquals((int)0, (int)image.getBrokerCellId(0));
        Assertions.assertEquals((int)0, (int)image.getBrokerCellId(1));
        Assertions.assertEquals((int)0, (int)image.getBrokerCellId(2));
        Assertions.assertEquals((int)1, (int)image.getBrokerCellId(3));
        Assertions.assertEquals((int)1, (int)image.getBrokerCellId(4));
        Assertions.assertEquals((int)1, (int)image.getBrokerCellId(5));
        Assertions.assertEquals((int)-1, (int)image.getBrokerCellId(6));
    }

    @Test
    void testWrite() {
        HashMap<Integer, Cell> cellIdToCell = new HashMap<Integer, Cell>();
        cellIdToCell.put(0, new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 3, 6));
        cellIdToCell.put(1, new Cell(1, new HashSet(), CellState.QUARANTINED, 2, 4));
        CellImage image = new CellImage(cellIdToCell);
        HashSet<ApiMessageAndVersion> expectedBatch = new HashSet<ApiMessageAndVersion>(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(0).setState(CellState.READY.code()).setMinSize((short)3).setMaxSize((short)6).setBrokers(Arrays.asList(0, 1, 2)), MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(1).setState(CellState.QUARANTINED.code()).setMinSize((short)2).setMaxSize((short)4), MetadataRecordType.CELL_RECORD.highestSupportedVersion())));
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        Assertions.assertEquals(expectedBatch, new HashSet(writer.records()));
    }

    @Test
    void testCellDeltaReplayAndImageWritNewCell() {
        CellDelta cellDelta = new CellDelta(new CellImage(Collections.emptyMap()));
        cellDelta.replay(new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2));
        RecordListWriter writer = new RecordListWriter();
        cellDelta.apply().write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        List<ApiMessageAndVersion> expectedBatch = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2), MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedBatch, (Object)writer.records());
    }

    @Test
    void testCellDeltaReplayAndImageWriteNewCellAndRemove() {
        CellDelta cellDelta = new CellDelta(new CellImage(Collections.emptyMap()));
        cellDelta.replay(new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2));
        cellDelta.replay(new RemoveCellRecord().setCellId(0));
        RecordListWriter writer = new RecordListWriter();
        cellDelta.apply().write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        Assertions.assertEquals(Collections.emptyList(), (Object)writer.records());
    }

    @Test
    void testCellDeltaReplayAndImageWriteNewCellAfterDelete() {
        CellDelta cellDelta = new CellDelta(new CellImage(Collections.emptyMap()));
        cellDelta.replay(new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2));
        cellDelta.replay(new RemoveCellRecord().setCellId(0));
        cellDelta.replay(new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2));
        RecordListWriter writer = new RecordListWriter();
        cellDelta.apply().write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        List<ApiMessageAndVersion> expectedBatch = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2), MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedBatch, (Object)writer.records());
    }

    @Test
    void testCellDeltaReplayAndImageWriteUpdateCell() {
        CellDelta cellDelta = new CellDelta(new CellImage(Collections.emptyMap()));
        cellDelta.replay(new CellRecord().setCellId(0).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2));
        cellDelta.replay(new CellRecord().setCellId(0).setBrokers(Arrays.asList(7, 8)).setState(CellState.QUARANTINED.code()).setMinSize((short)1).setMaxSize((short)4));
        RecordListWriter writer = new RecordListWriter();
        cellDelta.apply().write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        List<ApiMessageAndVersion> expectedBatch = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(0).setBrokers(Arrays.asList(7, 8)).setState(CellState.QUARANTINED.code()).setMinSize((short)1).setMaxSize((short)4), MetadataRecordType.CELL_RECORD.highestSupportedVersion()));
        Assertions.assertEquals(expectedBatch, (Object)writer.records());
    }

    @Test
    void testCellDeltaReplayAndImageWriteWithOriginalImage() {
        HashMap<Integer, Cell> originalCellIdToCell = new HashMap<Integer, Cell>();
        originalCellIdToCell.put(0, new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 3, 6));
        originalCellIdToCell.put(1, new Cell(1, new HashSet(), CellState.QUARANTINED, 1, 4));
        originalCellIdToCell.put(2, new Cell(2, new HashSet<Integer>(Arrays.asList(3, 4)), CellState.EXCLUDED, 2, 4));
        CellImage originalImage = new CellImage(originalCellIdToCell);
        CellDelta cellDelta = new CellDelta(originalImage);
        cellDelta.replay(new RemoveCellRecord().setCellId(0));
        cellDelta.replay(new CellRecord().setCellId(1).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2));
        cellDelta.replay(new CellRecord().setCellId(3).setBrokers(Arrays.asList(7, 8)).setState(CellState.QUARANTINED.code()).setMinSize((short)2).setMaxSize((short)3));
        RecordListWriter writer = new RecordListWriter();
        cellDelta.apply().write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        HashSet<ApiMessageAndVersion> expectedBatch = new HashSet<ApiMessageAndVersion>(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(1).setBrokers(Arrays.asList(5, 6)).setState(CellState.READY.code()).setMinSize((short)2).setMaxSize((short)2), MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(2).setBrokers(Arrays.asList(3, 4)).setState(CellState.EXCLUDED.code()).setMinSize((short)2).setMaxSize((short)4), MetadataRecordType.CELL_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new CellRecord().setCellId(3).setBrokers(Arrays.asList(7, 8)).setState(CellState.QUARANTINED.code()).setMinSize((short)2).setMaxSize((short)3), MetadataRecordType.CELL_RECORD.highestSupportedVersion())));
        Assertions.assertEquals(expectedBatch, new HashSet(writer.records()));
    }
}

