/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.controller.metrics.ControllerMetrics;

public final class MockControllerMetrics
implements ControllerMetrics {
    private volatile boolean active = false;
    private volatile int fencedBrokers = 0;
    private volatile int activeBrokers = 0;
    private volatile int brokersWithDegradedHealthCount = 0;
    private volatile int topics = 0;
    private volatile int partitions = 0;
    private volatile int offlinePartitions = 0;
    private volatile int underMinIsrCount = 0;
    private volatile int excludedBrokerCount = 0;
    private volatile int preferredReplicaImbalances = 0;
    private volatile long lastAppliedRecordOffset = 0L;
    private volatile long lastCommittedRecordOffset = 0L;
    private volatile long lastAppliedRecordTimestamp = 0L;
    private final AtomicLong timedOutHeartbeats = new AtomicLong(0L);
    private final Map<String, TenantPartitionMetrics> tenantPartitionMetricsMap = new ConcurrentHashMap<String, TenantPartitionMetrics>();
    private volatile boolean closed = false;
    private volatile long lastControllerLoadMs = -1L;

    public void recordControllerLoadTime(long startMs, long endMs) {
        this.lastControllerLoadMs = endMs - startMs;
    }

    public long lastControllerLoadMs() {
        return this.lastControllerLoadMs;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean active() {
        return this.active;
    }

    public void updateEventQueueTime(long durationMs) {
    }

    public void updateEventQueueProcessingTime(long durationMs) {
    }

    public void setFencedBrokerCount(int brokerCount) {
        this.fencedBrokers = brokerCount;
    }

    public int fencedBrokerCount() {
        return this.fencedBrokers;
    }

    public void setActiveBrokerCount(int brokerCount) {
        this.activeBrokers = brokerCount;
    }

    public int activeBrokerCount() {
        return this.activeBrokers;
    }

    public void setBrokersWithDegradedHealthCount(int degradedCount) {
        this.brokersWithDegradedHealthCount = degradedCount;
    }

    public int brokersWithDegradedHealthCount() {
        return this.brokersWithDegradedHealthCount;
    }

    public void setGlobalTopicCount(int topicCount) {
        this.topics = topicCount;
    }

    public int globalTopicCount() {
        return this.topics;
    }

    public void setGlobalPartitionCount(int partitionCount) {
        this.partitions = partitionCount;
    }

    public int globalPartitionCount() {
        return this.partitions;
    }

    public void setGlobalOfflinePartitionCount(int offlinePartitions) {
        this.offlinePartitions = offlinePartitions;
    }

    public int globalOfflinePartitionCount() {
        return this.offlinePartitions;
    }

    public void setGlobalUnderMinIsrCount(int count) {
        this.underMinIsrCount = count;
    }

    public int globalUnderMinIsrCount() {
        return this.underMinIsrCount;
    }

    public double globalPartitionAvailability() {
        return 1.0;
    }

    public void setTenantOfflinePartitionCount(String tenant, int count) {
        this.tenantPartitionMetricsMap.computeIfAbsent(tenant, key -> new TenantPartitionMetrics()).setOfflinePartitionCount(count);
    }

    public void setTenantPartitionCount(String tenant, int count) {
        this.tenantPartitionMetricsMap.computeIfAbsent(tenant, key -> new TenantPartitionMetrics()).setPartitionCount(count);
    }

    public void setTenantUnderMinIsrCount(String tenant, int count) {
        this.tenantPartitionMetricsMap.computeIfAbsent(tenant, key -> new TenantPartitionMetrics()).setUnderMinIsrCount(count);
    }

    public void removeTenant(String tenant) {
        this.tenantPartitionMetricsMap.remove(tenant);
    }

    public Map<String, TenantPartitionMetrics> tenantMetrics() {
        return this.tenantPartitionMetricsMap;
    }

    public void setExcludedBrokerCount(int excludedBrokerCount) {
        this.excludedBrokerCount = excludedBrokerCount;
    }

    public int excludedBrokerCount() {
        return this.excludedBrokerCount;
    }

    public void setPreferredReplicaImbalanceCount(int replicaImbalances) {
        this.preferredReplicaImbalances = replicaImbalances;
    }

    public int preferredReplicaImbalanceCount() {
        return this.preferredReplicaImbalances;
    }

    public void setLastAppliedRecordOffset(long offset) {
        this.lastAppliedRecordOffset = offset;
    }

    public long lastAppliedRecordOffset() {
        return this.lastAppliedRecordOffset;
    }

    public void setLastCommittedRecordOffset(long offset) {
        this.lastCommittedRecordOffset = offset;
    }

    public long lastCommittedRecordOffset() {
        return this.lastCommittedRecordOffset;
    }

    public void setLastAppliedRecordTimestamp(long timestamp) {
        this.lastAppliedRecordTimestamp = timestamp;
    }

    public long lastAppliedRecordTimestamp() {
        return this.lastAppliedRecordTimestamp;
    }

    public void incrementTimedOutHeartbeats() {
        this.timedOutHeartbeats.addAndGet(1L);
    }

    public void setTimedOutHeartbeats(long heartbeats) {
        this.timedOutHeartbeats.set(heartbeats);
    }

    public long timedOutHeartbeats() {
        return this.timedOutHeartbeats.get();
    }

    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    static final class TenantPartitionMetrics {
        private volatile int underMinIsrPartitionsCount = 0;
        private volatile int totalPartitionsCount = 0;
        private volatile int offlinePartitionsCount = 0;

        TenantPartitionMetrics() {
        }

        public int getPartitionCount() {
            return this.totalPartitionsCount;
        }

        public int getOfflinePartitionCount() {
            return this.offlinePartitionsCount;
        }

        public int getUnderMinIsrPartitionsCount() {
            return this.underMinIsrPartitionsCount;
        }

        private void setPartitionCount(int count) {
            this.totalPartitionsCount = count;
        }

        private void setOfflinePartitionCount(int count) {
            this.offlinePartitionsCount = count;
        }

        private void setUnderMinIsrCount(int count) {
            this.underMinIsrPartitionsCount = count;
        }
    }
}

