/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntPredicate;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.types.TaggedFields;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.controller.PartitionChangeBuilder;
import org.apache.kafka.controller.PartitionReassignmentReplicas;
import org.apache.kafka.controller.PartitionReassignmentRevert;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class PartitionChangeBuilderTest {
    private static final PartitionRegistration FOO = new PartitionRegistration.Builder().setReplicas(new int[]{2, 1, 3}).setIsr(new int[]{2, 1, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
    private static final PartitionRegistration FOO_CL = new PartitionRegistration.Builder().setReplicas(new int[]{2, 1, 3}).setIsr(new int[]{2, 1, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).setLinkedLeaderEpoch(Integer.valueOf(1)).setLinkState(PartitionRegistration.LinkState.ACTIVE).build();
    private static final Uuid FOO_ID = Uuid.fromString((String)"FbrrdcfiR-KC2CPSTHaJrg");
    private static final PartitionRegistration BAR = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{1}).setAddingReplicas(new int[]{4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
    private static final Uuid BAR_ID = Uuid.fromString((String)"LKfUsCBnQKekvL9O5dY9nw");
    private static final PartitionRegistration BAZ = new PartitionRegistration.Builder().setReplicas(new int[]{2, 1, 3}).setIsr(new int[]{1, 3}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
    private static final Uuid BAZ_ID = Uuid.fromString((String)"wQzt5gkSTwuQNXZF5gIw7A");
    private static final Set<DegradedBrokerHealthState> DEGRADED_STATE = Collections.singleton(new DegradedBrokerHealthState("rcca-123", BrokerComponent.UNSPECIFIED));
    private static final PartitionRegistration OFFLINE = new PartitionRegistration.Builder().setReplicas(new int[]{2, 1, 3}).setIsr(new int[]{3}).setLeader(Integer.valueOf(-1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
    private static final Uuid OFFLINE_ID = Uuid.fromString((String)"LKfUsCBnQKekvL9O5dY9nw");

    @Test
    public void testChangeRecordIsNoOp() {
        Assertions.assertEquals((int)0, (int)0);
        Assertions.assertEquals((int)0, (int)0);
        TaggedFields taggedFields = (TaggedFields)PartitionChangeRecord.SCHEMA_0.get((int)2).def.type;
        Assertions.assertEquals((int)13, (int)taggedFields.numFields());
        Assertions.assertTrue((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord(), (PartitionRegistration.LinkState)PartitionRegistration.LinkState.NOT_MIRROR));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setLeader(1), (PartitionRegistration.LinkState)PartitionRegistration.LinkState.NOT_MIRROR));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setIsr(Arrays.asList(1, 2, 3)), (PartitionRegistration.LinkState)PartitionRegistration.LinkState.NOT_MIRROR));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setRemovingReplicas(Arrays.asList(1)), (PartitionRegistration.LinkState)PartitionRegistration.LinkState.NOT_MIRROR));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setAddingReplicas(Arrays.asList(4)), (PartitionRegistration.LinkState)PartitionRegistration.LinkState.NOT_MIRROR));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()), (PartitionRegistration.LinkState)PartitionRegistration.LinkState.NOT_MIRROR));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setLinkedLeaderEpoch(-1).setLinkState(PartitionRegistration.LinkState.FAILED.levelCode), (PartitionRegistration.LinkState)PartitionRegistration.LinkState.ACTIVE));
        Assertions.assertTrue((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setDeprecatedDoNotUseTag1004(Arrays.asList(0)), (PartitionRegistration.LinkState)PartitionRegistration.LinkState.NOT_MIRROR));
        Assertions.assertTrue((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setDeprecatedDoNotUseTag1003(Arrays.asList(0)), (PartitionRegistration.LinkState)PartitionRegistration.LinkState.NOT_MIRROR));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setAddingObservers(Arrays.asList(0)), (PartitionRegistration.LinkState)PartitionRegistration.LinkState.NOT_MIRROR));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setRemovingObservers(Arrays.asList(0)), (PartitionRegistration.LinkState)PartitionRegistration.LinkState.NOT_MIRROR));
    }

    private static PartitionChangeBuilder createFooBuilder() {
        return new PartitionChangeBuilder(FOO, FOO_ID, 0, r -> r != 3, true, Collections.emptyMap());
    }

    private static PartitionChangeBuilder createLinkedFooBuilder() {
        return new PartitionChangeBuilder(FOO_CL, FOO_ID, 0, r -> r != 3, true, Collections.emptyMap());
    }

    private static PartitionChangeBuilder createBarBuilder() {
        return new PartitionChangeBuilder(BAR, BAR_ID, 0, r -> r != 3, true, Collections.emptyMap());
    }

    private static PartitionChangeBuilder createBazBuilder() {
        return new PartitionChangeBuilder(BAZ, BAZ_ID, 0, __ -> true, true, Collections.emptyMap());
    }

    private static PartitionChangeBuilder createBuilderWithDegradations() {
        HashMap<Integer, Set<DegradedBrokerHealthState>> degradedBrokers = new HashMap<Integer, Set<DegradedBrokerHealthState>>();
        degradedBrokers.put(1, DEGRADED_STATE);
        degradedBrokers.put(2, DEGRADED_STATE);
        return new PartitionChangeBuilder(BAR, BAR_ID, 0, __ -> true, true, degradedBrokers);
    }

    private static PartitionChangeBuilder createBuilderWithAllDegradations() {
        HashMap<Integer, Set<DegradedBrokerHealthState>> degradedBrokers = new HashMap<Integer, Set<DegradedBrokerHealthState>>();
        for (int replica : PartitionChangeBuilderTest.BAR.isr) {
            degradedBrokers.put(replica, DEGRADED_STATE);
        }
        return new PartitionChangeBuilder(BAR, BAR_ID, 0, __ -> true, true, degradedBrokers);
    }

    private static PartitionChangeBuilder createOfflineBuilder() {
        return new PartitionChangeBuilder(OFFLINE, OFFLINE_ID, 0, r -> r == 1, true, Collections.emptyMap());
    }

    private static void assertElectLeaderEquals(PartitionChangeBuilder builder, int expectedNode, boolean expectedUnclean) {
        PartitionChangeBuilder.ElectionResult electionResult = builder.electLeader(false);
        Assertions.assertEquals((int)expectedNode, (int)electionResult.node);
        Assertions.assertEquals((Object)expectedUnclean, (Object)electionResult.unclean);
    }

    @Test
    public void testElectLeader() {
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.PREFERRED), 2, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(), 1, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN), 1, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder().setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(Arrays.asList(1, 3))), 1, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(Arrays.asList(1, 3))), 1, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder().setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(Arrays.asList(3))), -1, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(Arrays.asList(3))), 2, true);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(Arrays.asList(4))).setTargetReplicas(Arrays.asList(2, 1, 3, 4)), 4, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createBazBuilder().setElection(PartitionChangeBuilder.Election.PREFERRED), 3, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createBazBuilder(), 3, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createBazBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN), 3, false);
    }

    @Test
    public void testCanAttemptToMoveLeadershipFromObserver() {
        Assertions.assertTrue((boolean)PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.ONLINE).setTargetObservers(Arrays.asList(0)).canAttemptToMoveLeadershipFromObserver(true));
        Assertions.assertFalse((boolean)PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.ONLINE).canAttemptToMoveLeadershipFromObserver(true));
        Assertions.assertFalse((boolean)PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.ONLINE).setTargetAdding(Arrays.asList(0)).canAttemptToMoveLeadershipFromObserver(false));
        Assertions.assertFalse((boolean)PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.ONLINE).canAttemptToMoveLeadershipFromObserver(false));
        Assertions.assertTrue((boolean)PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.ONLINE).setTargetObservers(Arrays.asList(0)).canAttemptToMoveLeadershipFromObserver(false));
        Assertions.assertFalse((boolean)PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.ONLINE).setTargetObservers(Arrays.asList(0)).setTargetIsr(Arrays.asList(99)).canAttemptToMoveLeadershipFromObserver(false));
    }

    @Test
    public void testElectLeaderWithDegradations() {
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createBuilderWithDegradations(), 3, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createBuilderWithDegradations().setElection(PartitionChangeBuilder.Election.PREFERRED), 3, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createBuilderWithDegradations().setElection(PartitionChangeBuilder.Election.UNCLEAN), 3, false);
    }

    private static void testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilder builder, PartitionChangeRecord record, int expectedLeader) {
        builder.triggerLeaderEpochBumpIfNeeded(record);
        Assertions.assertEquals((int)expectedLeader, (int)record.leader());
    }

    @Test
    public void testTriggerLeaderEpochBumpIfNeeded() {
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilderTest.createFooBuilder(), new PartitionChangeRecord(), -2);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilderTest.createFooBuilder().setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(Arrays.asList(2, 1))), new PartitionChangeRecord(), 1);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilderTest.createFooBuilder().setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(Arrays.asList(2, 1, 3, 4))), new PartitionChangeRecord(), -2);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(Arrays.asList(2, 1, 3, 4)), new PartitionChangeRecord(), -2);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeededLeader(PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(Arrays.asList(2, 1, 3, 4)), new PartitionChangeRecord().setLeader(2), 2);
    }

    @Test
    public void testNoChange() {
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createFooBuilder().build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createBarBuilder().build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createBarBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createBazBuilder().setElection(PartitionChangeBuilder.Election.PREFERRED).build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createBuilderWithAllDegradations().build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createBuilderWithAllDegradations().setElection(PartitionChangeBuilder.Election.UNCLEAN).build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createBuilderWithAllDegradations().setElection(PartitionChangeBuilder.Election.PREFERRED).build());
    }

    @Test
    public void testIsrChangeAndLeaderBump() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setIsr(Arrays.asList(2, 1)).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(Arrays.asList(2, 1))).build());
    }

    @Test
    public void testIsrChangeAndLeaderChange() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setIsr(Arrays.asList(2, 3)).setLeader(2), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(Arrays.asList(2, 3))).build());
    }

    @Test
    public void testReassignmentRearrangesReplicas() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(Arrays.asList(3, 2, 1)).build());
    }

    @Test
    public void testIsrEnlargementCompletesReassignment() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(BAR_ID).setPartitionId(0).setReplicas(Arrays.asList(2, 3, 4)).setIsr(Arrays.asList(2, 3, 4)).setLeader(2).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createBarBuilder().setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(Arrays.asList(1, 2, 3, 4))).build());
    }

    @Test
    public void testRevertReassignment() {
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(BAR);
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)revert.isr());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(BAR_ID).setPartitionId(0).setReplicas(Arrays.asList(1, 2, 3)).setLeader(1).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createBarBuilder().setTargetReplicas(revert.replicas()).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs((List)revert.isr())).setTargetRemoving(Collections.emptyList()).setTargetAdding(Collections.emptyList()).build());
    }

    @Test
    public void testRemovingReplicaReassignment() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Replicas.toList((int[])PartitionChangeBuilderTest.FOO.replicas)), new PartitionAssignment(Arrays.asList(1, 2)));
        Assertions.assertEquals(Collections.singletonList(3), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)replicas.replicas());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(1, 2)).setIsr(Arrays.asList(2, 1)).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(replicas.replicas()).setTargetRemoving(replicas.removing()).build());
    }

    @Test
    public void testAddingAndRemovingObserverReplicaReassignment() {
        int[] originalReplicas = new int[]{0, 1, 4};
        int[] originalObservers = new int[]{4};
        int[] isr = new int[]{0, 1};
        int[] targetReplicas = new int[]{0, 2, 5};
        int[] targetObservers = new int[]{5};
        PartitionRegistration part = new PartitionRegistration.Builder().setReplicas(originalReplicas).setObservers(originalObservers).setIsr(isr).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Uuid topicId = Uuid.fromString((String)"SPvicxr4TGGuImklztaKXA");
        PartitionChangeBuilder builder = new PartitionChangeBuilder(part, topicId, 0, r -> true, true, Collections.emptyMap());
        PartitionReassignmentReplicas reassignment = new PartitionReassignmentReplicas(new PartitionAssignment(Replicas.toList((int[])part.replicas), Replicas.toList((int[])part.observers)), new PartitionAssignment(Replicas.toList((int[])targetReplicas), Replicas.toList((int[])targetObservers)));
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setReplicas(Arrays.asList(0, 2, 1, 5, 4)).setObservers(Arrays.asList(5, 4)).setRemovingReplicas(Arrays.asList(1, 4)).setAddingReplicas(Arrays.asList(2, 5)).setRemovingObservers(Arrays.asList(4)).setAddingObservers(Arrays.asList(5)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)builder.setTargetReplicas(reassignment.replicas()).setTargetObservers(reassignment.observers()).setTargetRemoving(reassignment.removing()).setTargetAdding(reassignment.adding()).setTargetRemovingObservers(reassignment.removingObservers()).setTargetAddingObservers(reassignment.addingObservers()).build());
    }

    @Test
    public void testCompletesAddingAndRemovingObserverReplicaReassignment() {
        int[] ongoingReassignmentReplicas = new int[]{0, 2, 1, 5, 4};
        int[] ongoingReassignmentObservers = new int[]{5, 4};
        int[] isr = new int[]{0, 1};
        int[] ongoingReassignmentRemoving = new int[]{1, 4};
        int[] ongoingReassignmentAdding = new int[]{2, 5};
        int[] ongoingReassignmentRemovingObservers = new int[]{4};
        int[] ongoingReassignmentAddingObservers = new int[]{5};
        PartitionRegistration part = new PartitionRegistration.Builder().setReplicas(ongoingReassignmentReplicas).setObservers(ongoingReassignmentObservers).setIsr(isr).setRemovingReplicas(ongoingReassignmentRemoving).setAddingReplicas(ongoingReassignmentAdding).setRemovingObservers(ongoingReassignmentRemovingObservers).setAddingObservers(ongoingReassignmentAddingObservers).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Uuid topicId = Uuid.fromString((String)"SPvicxr4TGGuImklztaKXA");
        PartitionReassignmentReplicas reassignmentReplicas = new PartitionReassignmentReplicas(Replicas.toList((int[])part.removingReplicas), Replicas.toList((int[])part.addingReplicas), Replicas.toList((int[])part.replicas), Replicas.toList((int[])part.observers), Replicas.toList((int[])part.removingObservers), Replicas.toList((int[])part.addingObservers));
        Assertions.assertTrue((boolean)reassignmentReplicas.isReassignmentInProgress());
        PartitionChangeBuilder builder = new PartitionChangeBuilder(part, topicId, 0, r -> true, true, Collections.emptyMap());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setReplicas(reassignmentReplicas.targetReplicas()).setObservers(reassignmentReplicas.targetObservers()).setRemovingReplicas(Collections.emptyList()).setDeprecatedDoNotUseTag1004(null).setDeprecatedDoNotUseTag1003(null).setAddingReplicas(Collections.emptyList()).setRemovingObservers(Collections.emptyList()).setAddingObservers(Collections.emptyList()).setLeader(0).setIsr(Arrays.asList(0, 2)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)builder.setTargetIsr(Arrays.asList(0, 2, 1)).build());
    }

    @Test
    public void testCompletesAddingAndRemovingObserverReplicaReassignmentIsNotDependentOnSyncReplicaFieldsInPartitionRecord() {
        int[] ongoingReassignmentReplicas = new int[]{0, 2, 1, 5, 4};
        int[] ongoingReassignmentObservers = new int[]{5, 4};
        int[] isr = new int[]{0, 1};
        int[] ongoingReassignmentRemoving = new int[]{1, 4};
        int[] ongoingReassignmentAdding = new int[]{2, 5};
        int[] ongoingReassignmentRemovingObservers = new int[]{4};
        int[] ongoingReassignmentAddingObservers = new int[]{5};
        int replicaNotInIsr = 7;
        PartitionRecord partitionRecord = new PartitionRecord().setPartitionId(0).setReplicas(Replicas.toList((int[])ongoingReassignmentReplicas)).setObservers(Replicas.toList((int[])ongoingReassignmentObservers)).setIsr(Replicas.toList((int[])isr)).setRemovingReplicas(Replicas.toList((int[])ongoingReassignmentRemoving)).setAddingReplicas(Replicas.toList((int[])ongoingReassignmentAdding)).setDeprecatedDoNotUseTag1004(Arrays.asList(replicaNotInIsr)).setAddingObservers(Replicas.toList((int[])ongoingReassignmentAddingObservers)).setRemovingObservers(Replicas.toList((int[])ongoingReassignmentRemovingObservers)).setLeader(0).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()).setLeaderEpoch(100).setPartitionEpoch(200);
        PartitionRegistration part = new PartitionRegistration(partitionRecord);
        Uuid topicId = Uuid.fromString((String)"SPvicxr4TGGuImklztaKXA");
        PartitionChangeBuilder builder = new PartitionChangeBuilder(part, topicId, 0, r -> true, true, Collections.emptyMap());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setReplicas(Arrays.asList(0, 2, 5)).setObservers(Arrays.asList(5)).setRemovingReplicas(Collections.emptyList()).setDeprecatedDoNotUseTag1004(null).setDeprecatedDoNotUseTag1003(null).setAddingReplicas(Collections.emptyList()).setRemovingObservers(Collections.emptyList()).setAddingObservers(Collections.emptyList()).setLeader(0).setIsr(Arrays.asList(0, 2)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)builder.setTargetIsr(Arrays.asList(0, 2, 1)).build());
    }

    @Test
    public void testCompletesAddingAndRemovingObserverReplicaReassignmentIsNotDependentOnSyncReplicaFieldsInPartitionChangeRecord() {
        int[] ongoingReassignmentReplicas = new int[]{0, 2, 1, 5, 4};
        int[] ongoingReassignmentObservers = new int[]{5, 4};
        int[] isr = new int[]{0, 1};
        int[] ongoingReassignmentRemoving = new int[]{1, 4};
        int[] ongoingReassignmentAdding = new int[]{2, 5};
        int[] ongoingReassignmentRemovingObservers = new int[]{4};
        int[] ongoingReassignmentAddingObservers = new int[]{5};
        int replicaNotInIsr = 7;
        PartitionRegistration part = new PartitionRegistration.Builder().setReplicas(ongoingReassignmentReplicas).setObservers(ongoingReassignmentObservers).setIsr(isr).setRemovingReplicas(ongoingReassignmentRemoving).setAddingReplicas(ongoingReassignmentAdding).setRemovingObservers(ongoingReassignmentRemovingObservers).setAddingObservers(ongoingReassignmentAddingObservers).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Uuid topicId = Uuid.fromString((String)"SPvicxr4TGGuImklztaKXA");
        PartitionRegistration mergedPart = part.merge(new PartitionChangeRecord().setDeprecatedDoNotUseTag1004(Arrays.asList(replicaNotInIsr)));
        PartitionChangeBuilder builder = new PartitionChangeBuilder(mergedPart, topicId, 0, r -> true, true, Collections.emptyMap());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setReplicas(Arrays.asList(0, 2, 5)).setObservers(Arrays.asList(5)).setRemovingReplicas(Collections.emptyList()).setDeprecatedDoNotUseTag1004(null).setDeprecatedDoNotUseTag1003(null).setAddingReplicas(Collections.emptyList()).setRemovingObservers(Collections.emptyList()).setAddingObservers(Collections.emptyList()).setLeader(0).setIsr(Arrays.asList(0, 2)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)builder.setTargetIsr(Arrays.asList(0, 2, 1)).build());
    }

    @Test
    public void testCompleteReassignmentAndDemoteObserver() {
        int[] ongoingReassignmentReplicas = new int[]{2, 3, 0, 1};
        int[] ongoingReassignmentObservers = new int[]{0, 1, 2, 3};
        int[] isr = new int[]{0, 1, 2, 3};
        int[] ongoingReassignmentRemoving = new int[]{};
        int[] ongoingReassignmentAdding = new int[]{};
        int[] ongoingReassignmentRemovingObservers = new int[]{2, 3};
        int[] ongoingReassignmentAddingObservers = new int[]{0, 1};
        PartitionRegistration part = new PartitionRegistration.Builder().setReplicas(ongoingReassignmentReplicas).setObservers(ongoingReassignmentObservers).setIsr(isr).setRemovingReplicas(ongoingReassignmentRemoving).setAddingReplicas(ongoingReassignmentAdding).setRemovingObservers(ongoingReassignmentRemovingObservers).setAddingObservers(ongoingReassignmentAddingObservers).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Uuid topicId = Uuid.fromString((String)"SPvicxr4TGGuImklztaKXA");
        PartitionReassignmentReplicas reassignmentReplicas = new PartitionReassignmentReplicas(Replicas.toList((int[])part.removingReplicas), Replicas.toList((int[])part.addingReplicas), Replicas.toList((int[])part.replicas), Replicas.toList((int[])part.observers), Replicas.toList((int[])part.removingObservers), Replicas.toList((int[])part.addingObservers));
        Assertions.assertTrue((boolean)reassignmentReplicas.isReassignmentInProgress());
        PartitionChangeBuilder builder = new PartitionChangeBuilder(part, topicId, 0, r -> true, true, Collections.emptyMap());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setObservers(reassignmentReplicas.targetObservers()).setRemovingObservers(Collections.emptyList()).setAddingObservers(Collections.emptyList()).setLeader(2), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)builder.setTargetIsr(Arrays.asList(0, 1, 2, 3)).build());
    }

    @Test
    public void testDemoteObserversWithSingleDegradation() {
        int[] ongoingReassignmentReplicas = new int[]{2, 3, 0, 1};
        int[] ongoingReassignmentObservers = new int[]{0, 1, 2, 3};
        int[] isr = new int[]{0, 1, 2, 3};
        int[] ongoingReassignmentRemoving = new int[]{};
        int[] ongoingReassignmentAdding = new int[]{};
        int[] ongoingReassignmentRemovingObservers = new int[]{2, 3};
        int[] ongoingReassignmentAddingObservers = new int[]{0, 1};
        Map<Integer, Set<DegradedBrokerHealthState>> activeBrokerComponentDegradations = Collections.singletonMap(2, Collections.singleton(new DegradedBrokerHealthState("rcca-123", BrokerComponent.UNSPECIFIED)));
        PartitionRegistration part = new PartitionRegistration.Builder().setReplicas(ongoingReassignmentReplicas).setObservers(ongoingReassignmentObservers).setIsr(isr).setRemovingReplicas(ongoingReassignmentRemoving).setAddingReplicas(ongoingReassignmentAdding).setRemovingObservers(ongoingReassignmentRemovingObservers).setAddingObservers(ongoingReassignmentAddingObservers).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Uuid topicId = Uuid.fromString((String)"SPvicxr4TGGuImklztaKXA");
        PartitionReassignmentReplicas reassignmentReplicas = new PartitionReassignmentReplicas(Replicas.toList((int[])part.removingReplicas), Replicas.toList((int[])part.addingReplicas), Replicas.toList((int[])part.replicas), Replicas.toList((int[])part.observers), Replicas.toList((int[])part.removingObservers), Replicas.toList((int[])part.addingObservers));
        Assertions.assertTrue((boolean)reassignmentReplicas.isReassignmentInProgress());
        PartitionChangeBuilder builder = new PartitionChangeBuilder(part, topicId, 0, r -> true, true, activeBrokerComponentDegradations);
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setObservers(reassignmentReplicas.targetObservers()).setRemovingObservers(Collections.emptyList()).setAddingObservers(Collections.emptyList()).setLeader(3), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)builder.setTargetIsr(Arrays.asList(0, 1, 2, 3)).build());
    }

    @Test
    public void testDemoteObserversWithAllDegradedSyncReplicas() {
        int[] ongoingReassignmentReplicas = new int[]{2, 3, 0, 1};
        int[] ongoingReassignmentObservers = new int[]{0, 1, 2, 3};
        int[] isr = new int[]{0, 1, 2, 3};
        int[] ongoingReassignmentRemoving = new int[]{};
        int[] ongoingReassignmentAdding = new int[]{};
        int[] ongoingReassignmentRemovingObservers = new int[]{2, 3};
        int[] ongoingReassignmentAddingObservers = new int[]{0, 1};
        HashMap<Integer, Set<DegradedBrokerHealthState>> activeBrokerComponentDegradations = new HashMap<Integer, Set<DegradedBrokerHealthState>>();
        activeBrokerComponentDegradations.put(2, Collections.singleton(new DegradedBrokerHealthState("rcca-123", BrokerComponent.UNSPECIFIED)));
        activeBrokerComponentDegradations.put(3, Collections.singleton(new DegradedBrokerHealthState("rcca-123", BrokerComponent.UNSPECIFIED)));
        PartitionRegistration part = new PartitionRegistration.Builder().setReplicas(ongoingReassignmentReplicas).setObservers(ongoingReassignmentObservers).setIsr(isr).setRemovingReplicas(ongoingReassignmentRemoving).setAddingReplicas(ongoingReassignmentAdding).setRemovingObservers(ongoingReassignmentRemovingObservers).setAddingObservers(ongoingReassignmentAddingObservers).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Uuid topicId = Uuid.fromString((String)"SPvicxr4TGGuImklztaKXA");
        PartitionReassignmentReplicas reassignmentReplicas = new PartitionReassignmentReplicas(Replicas.toList((int[])part.removingReplicas), Replicas.toList((int[])part.addingReplicas), Replicas.toList((int[])part.replicas), Replicas.toList((int[])part.observers), Replicas.toList((int[])part.removingObservers), Replicas.toList((int[])part.addingObservers));
        Assertions.assertTrue((boolean)reassignmentReplicas.isReassignmentInProgress());
        PartitionChangeBuilder builder = new PartitionChangeBuilder(part, topicId, 0, r -> true, true, activeBrokerComponentDegradations);
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setObservers(reassignmentReplicas.targetObservers()).setRemovingObservers(Collections.emptyList()).setAddingObservers(Collections.emptyList()).setLeader(2), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)builder.setTargetIsr(Arrays.asList(0, 1, 2, 3)).build());
    }

    @Test
    public void testAddingReplicaReassignment() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Replicas.toList((int[])PartitionChangeBuilderTest.FOO.replicas)), new PartitionAssignment(Arrays.asList(1, 2, 3, 4)));
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Collections.singletonList(4), (Object)replicas.adding());
        Assertions.assertEquals(Collections.singletonList(4), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(1, 2, 3, 4), (Object)replicas.replicas());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(1, 2, 3, 4)).setAddingReplicas(Collections.singletonList(4)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(replicas.replicas()).setTargetAdding(replicas.adding()).build());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testChangeInLeadershipDoesNotChangeRecoveryState(boolean isLeaderRecoverySupported) {
        int noChange = -1;
        int leaderId = 1;
        LeaderRecoveryState recoveryState = LeaderRecoveryState.RECOVERING;
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{leaderId, leaderId + 1, leaderId + 2}).setIsr(new int[]{leaderId}).setLeader(Integer.valueOf(leaderId)).setLeaderRecoveryState(recoveryState).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionChangeBuilder offlineBuilder = new PartitionChangeBuilder(registration, FOO_ID, 0, brokerId -> false, isLeaderRecoverySupported, Collections.emptyMap());
        offlineBuilder.setTargetIsr(Collections.emptyList());
        PartitionChangeRecord changeRecord = (PartitionChangeRecord)((ApiMessageAndVersion)offlineBuilder.build().get()).message();
        Assertions.assertEquals((byte)-1, (byte)changeRecord.leaderRecoveryState());
        Assertions.assertEquals((int)-1, (int)changeRecord.leader());
        registration = registration.merge(changeRecord);
        Assertions.assertEquals((int)-1, (int)registration.leader);
        Assertions.assertEquals((int)leaderId, (int)registration.isr[0]);
        Assertions.assertEquals((Object)recoveryState, (Object)registration.leaderRecoveryState);
        PartitionChangeBuilder onlineBuilder = new PartitionChangeBuilder(registration, FOO_ID, 0, brokerId -> true, isLeaderRecoverySupported, Collections.emptyMap());
        changeRecord = (PartitionChangeRecord)((ApiMessageAndVersion)onlineBuilder.build().get()).message();
        Assertions.assertEquals((byte)-1, (byte)changeRecord.leaderRecoveryState());
        registration = registration.merge(changeRecord);
        Assertions.assertEquals((int)leaderId, (int)registration.leader);
        Assertions.assertEquals((int)leaderId, (int)registration.isr[0]);
        Assertions.assertEquals((Object)recoveryState, (Object)registration.leaderRecoveryState);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testUncleanSetsLeaderRecoveringState(boolean isLeaderRecoverySupported) {
        int noChange = -1;
        int leaderId = 1;
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{leaderId, leaderId + 1, leaderId + 2}).setIsr(new int[]{leaderId + 1, leaderId + 2}).setLeader(Integer.valueOf(-1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionChangeBuilder onlineBuilder = new PartitionChangeBuilder(registration, FOO_ID, 0, brokerId -> brokerId == leaderId, isLeaderRecoverySupported, Collections.emptyMap()).setElection(PartitionChangeBuilder.Election.UNCLEAN);
        PartitionChangeRecord changeRecord = (PartitionChangeRecord)((ApiMessageAndVersion)onlineBuilder.build().get()).message();
        byte expectedRecoveryChange = -1;
        if (isLeaderRecoverySupported) {
            expectedRecoveryChange = LeaderRecoveryState.RECOVERING.value();
        }
        Assertions.assertEquals((byte)expectedRecoveryChange, (byte)changeRecord.leaderRecoveryState());
        Assertions.assertEquals((int)leaderId, (int)changeRecord.leader());
        Assertions.assertEquals((int)1, (int)changeRecord.isr().size());
        Assertions.assertEquals((int)leaderId, (Integer)changeRecord.isr().get(0));
        registration = registration.merge(changeRecord);
        LeaderRecoveryState expectedRecovery = LeaderRecoveryState.RECOVERED;
        if (isLeaderRecoverySupported) {
            expectedRecovery = LeaderRecoveryState.RECOVERING;
        }
        Assertions.assertEquals((int)leaderId, (int)registration.leader);
        Assertions.assertEquals((int)leaderId, (int)registration.isr[0]);
        Assertions.assertEquals((Object)expectedRecovery, (Object)registration.leaderRecoveryState);
    }

    @Test
    public void testUncleanLeaderElection() {
        ApiMessageAndVersion expectedRecord = new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setIsr(Arrays.asList(2)).setLeader(2).setLeaderRecoveryState(LeaderRecoveryState.RECOVERING.value()), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion());
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)PartitionChangeBuilderTest.createFooBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(Arrays.asList(3))).build());
        expectedRecord = new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(OFFLINE_ID).setPartitionId(0).setIsr(Arrays.asList(1)).setLeader(1).setLeaderRecoveryState(LeaderRecoveryState.RECOVERING.value()), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion());
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)PartitionChangeBuilderTest.createOfflineBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).build());
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)PartitionChangeBuilderTest.createOfflineBuilder().setElection(PartitionChangeBuilder.Election.UNCLEAN).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(Arrays.asList(2))).build());
    }

    @Test
    public void testClusterLinkFieldsForMirrorPartition() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createLinkedFooBuilder().setTargetReplicas(Arrays.asList(3, 2, 1)).build());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)).setLinkState(PartitionRegistration.LinkState.FAILED.levelCode), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createLinkedFooBuilder().setTargetReplicas(Arrays.asList(3, 2, 1)).setLinkFailed(true).build());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setLinkedLeaderEpoch(2).setLinkState(PartitionRegistration.LinkState.ACTIVE.levelCode), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createLinkedFooBuilder().setLinkedLeaderEpoch(2).build());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setLinkState(PartitionRegistration.LinkState.FAILED.levelCode).setLinkedLeaderEpoch(2), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createLinkedFooBuilder().setLinkedLeaderEpoch(2).setLinkFailed(true).build());
    }

    @Test
    public void testClusterLinkFieldsForNonMirrorPartition() {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(-1).setLinkState(PartitionRegistration.LinkState.NOT_MIRROR.levelCode), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(32).setLinkFailed(true).build());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(-1).setLinkState(PartitionRegistration.LinkState.NOT_MIRROR.levelCode), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(64).build());
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(Arrays.asList(3, 2, 1)).setLinkedLeaderEpoch(-1).setLinkState(PartitionRegistration.LinkState.NOT_MIRROR.levelCode), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)PartitionChangeBuilderTest.createFooBuilder().setTargetReplicas(Arrays.asList(3, 2, 1)).build());
    }

    @Test
    public void testStoppedLeaderIsDemotedAfterReassignmentCompletesEvenIfNoNewEligibleLeaders() {
        int[] replicas = new int[]{2, 3, 0, 1};
        int[] isr = new int[]{0, 1};
        int[] removingReplicas = new int[]{0, 1};
        int[] addingReplicas = new int[]{2, 3};
        int leader = 0;
        LeaderRecoveryState leaderRecoveryState = LeaderRecoveryState.RECOVERED;
        int leaderEpoch = 0;
        int partitionEpoch = 0;
        PartitionRegistration part = new PartitionRegistration.Builder().setReplicas(replicas).setIsr(isr).setRemovingReplicas(removingReplicas).setAddingReplicas(addingReplicas).setLeader(Integer.valueOf(leader)).setLeaderRecoveryState(leaderRecoveryState).setLeaderEpoch(Integer.valueOf(leaderEpoch)).setPartitionEpoch(Integer.valueOf(partitionEpoch)).build();
        Uuid topicId = Uuid.randomUuid();
        IntPredicate isValidLeader = l -> false;
        PartitionChangeBuilder partitionChangeBuilder = new PartitionChangeBuilder(part, topicId, 0, isValidLeader, false, Collections.emptyMap());
        Assertions.assertEquals((int)0, (int)part.leader);
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setReplicas(Arrays.asList(2, 3)).setIsr(Arrays.asList(2, 3)).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()).setLeader(-1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion())), (Object)partitionChangeBuilder.setTargetIsr(Arrays.asList(0, 1, 2, 3)).build());
    }
}

