/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.protocol.MessageUtil;

public class MirrorTopicRecordJsonConverter {
    public static MirrorTopicRecord read(JsonNode _node, short _version) {
        MirrorTopicRecord _object = new MirrorTopicRecord();
        JsonNode _topicIdNode = _node.get("topicId");
        if (_topicIdNode == null) {
            throw new RuntimeException("MirrorTopicRecord: unable to locate field 'topicId', which is mandatory in version " + _version);
        }
        if (!_topicIdNode.isTextual()) {
            throw new RuntimeException("MirrorTopicRecord expected a JSON string type, but got " + _node.getNodeType());
        }
        _object.topicId = Uuid.fromString((String)_topicIdNode.asText());
        JsonNode _topicNameNode = _node.get("topicName");
        if (_topicNameNode == null) {
            throw new RuntimeException("MirrorTopicRecord: unable to locate field 'topicName', which is mandatory in version " + _version);
        }
        if (!_topicNameNode.isTextual()) {
            throw new RuntimeException("MirrorTopicRecord expected a string type, but got " + _node.getNodeType());
        }
        _object.topicName = _topicNameNode.asText();
        JsonNode _clusterLinkIdNode = _node.get("clusterLinkId");
        if (_clusterLinkIdNode == null) {
            throw new RuntimeException("MirrorTopicRecord: unable to locate field 'clusterLinkId', which is mandatory in version " + _version);
        }
        if (!_clusterLinkIdNode.isTextual()) {
            throw new RuntimeException("MirrorTopicRecord expected a JSON string type, but got " + _node.getNodeType());
        }
        _object.clusterLinkId = Uuid.fromString((String)_clusterLinkIdNode.asText());
        JsonNode _clusterLinkNameNode = _node.get("clusterLinkName");
        if (_clusterLinkNameNode == null) {
            throw new RuntimeException("MirrorTopicRecord: unable to locate field 'clusterLinkName', which is mandatory in version " + _version);
        }
        if (!_clusterLinkNameNode.isTextual()) {
            throw new RuntimeException("MirrorTopicRecord expected a string type, but got " + _node.getNodeType());
        }
        _object.clusterLinkName = _clusterLinkNameNode.asText();
        JsonNode _sourceTopicNameNode = _node.get("sourceTopicName");
        if (_sourceTopicNameNode == null) {
            throw new RuntimeException("MirrorTopicRecord: unable to locate field 'sourceTopicName', which is mandatory in version " + _version);
        }
        if (!_sourceTopicNameNode.isTextual()) {
            throw new RuntimeException("MirrorTopicRecord expected a string type, but got " + _node.getNodeType());
        }
        _object.sourceTopicName = _sourceTopicNameNode.asText();
        JsonNode _sourceTopicIdNode = _node.get("sourceTopicId");
        if (_sourceTopicIdNode == null) {
            throw new RuntimeException("MirrorTopicRecord: unable to locate field 'sourceTopicId', which is mandatory in version " + _version);
        }
        if (!_sourceTopicIdNode.isTextual()) {
            throw new RuntimeException("MirrorTopicRecord expected a JSON string type, but got " + _node.getNodeType());
        }
        _object.sourceTopicId = Uuid.fromString((String)_sourceTopicIdNode.asText());
        JsonNode _mirrorTopicStateNode = _node.get("mirrorTopicState");
        if (_mirrorTopicStateNode == null) {
            throw new RuntimeException("MirrorTopicRecord: unable to locate field 'mirrorTopicState', which is mandatory in version " + _version);
        }
        if (!_mirrorTopicStateNode.isTextual()) {
            throw new RuntimeException("MirrorTopicRecord expected a string type, but got " + _node.getNodeType());
        }
        _object.mirrorTopicState = _mirrorTopicStateNode.asText();
        JsonNode _timeMsNode = _node.get("timeMs");
        if (_timeMsNode == null) {
            throw new RuntimeException("MirrorTopicRecord: unable to locate field 'timeMs', which is mandatory in version " + _version);
        }
        _object.timeMs = MessageUtil.jsonNodeToLong((JsonNode)_timeMsNode, (String)"MirrorTopicRecord");
        JsonNode _mirrorStartOffsetsNode = _node.get("mirrorStartOffsets");
        if (_mirrorStartOffsetsNode == null) {
            _object.mirrorStartOffsets = null;
        } else if (_mirrorStartOffsetsNode.isNull()) {
            _object.mirrorStartOffsets = null;
        } else {
            if (!_mirrorStartOffsetsNode.isArray()) {
                throw new RuntimeException("MirrorTopicRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Long> _collection = new ArrayList<Long>(_mirrorStartOffsetsNode.size());
            _object.mirrorStartOffsets = _collection;
            for (JsonNode _element : _mirrorStartOffsetsNode) {
                _collection.add(MessageUtil.jsonNodeToLong((JsonNode)_element, (String)"MirrorTopicRecord element"));
            }
        }
        JsonNode _previousToPausedStateNode = _node.get("previousToPausedState");
        if (_previousToPausedStateNode == null) {
            _object.previousToPausedState = null;
        } else if (_previousToPausedStateNode.isNull()) {
            _object.previousToPausedState = null;
        } else {
            if (!_previousToPausedStateNode.isTextual()) {
                throw new RuntimeException("MirrorTopicRecord expected a string type, but got " + _node.getNodeType());
            }
            _object.previousToPausedState = _previousToPausedStateNode.asText();
        }
        JsonNode _stoppedLogEndOffsetsNode = _node.get("stoppedLogEndOffsets");
        if (_stoppedLogEndOffsetsNode == null) {
            _object.stoppedLogEndOffsets = null;
        } else if (_stoppedLogEndOffsetsNode.isNull()) {
            _object.stoppedLogEndOffsets = null;
        } else {
            if (!_stoppedLogEndOffsetsNode.isArray()) {
                throw new RuntimeException("MirrorTopicRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Long> _collection = new ArrayList<Long>(_stoppedLogEndOffsetsNode.size());
            _object.stoppedLogEndOffsets = _collection;
            for (JsonNode _element : _stoppedLogEndOffsetsNode) {
                _collection.add(MessageUtil.jsonNodeToLong((JsonNode)_element, (String)"MirrorTopicRecord element"));
            }
        }
        JsonNode _promotedNode = _node.get("promoted");
        if (_promotedNode == null) {
            _object.promoted = false;
        } else {
            if (!_promotedNode.isBoolean()) {
                throw new RuntimeException("MirrorTopicRecord expected Boolean type, but got " + _node.getNodeType());
            }
            _object.promoted = _promotedNode.asBoolean();
        }
        JsonNode _topicLevelPauseNode = _node.get("topicLevelPause");
        if (_topicLevelPauseNode == null) {
            _object.topicLevelPause = false;
        } else {
            if (!_topicLevelPauseNode.isBoolean()) {
                throw new RuntimeException("MirrorTopicRecord expected Boolean type, but got " + _node.getNodeType());
            }
            _object.topicLevelPause = _topicLevelPauseNode.asBoolean();
        }
        JsonNode _linkLevelPauseNode = _node.get("linkLevelPause");
        if (_linkLevelPauseNode == null) {
            _object.linkLevelPause = false;
        } else {
            if (!_linkLevelPauseNode.isBoolean()) {
                throw new RuntimeException("MirrorTopicRecord expected Boolean type, but got " + _node.getNodeType());
            }
            _object.linkLevelPause = _linkLevelPauseNode.asBoolean();
        }
        JsonNode _mirrorTopicErrorNode = _node.get("mirrorTopicError");
        _object.mirrorTopicError = _mirrorTopicErrorNode == null ? (short)-1 : MessageUtil.jsonNodeToShort((JsonNode)_mirrorTopicErrorNode, (String)"MirrorTopicRecord");
        JsonNode _nextStateNode = _node.get("nextState");
        if (_nextStateNode == null) {
            _object.nextState = null;
        } else if (_nextStateNode.isNull()) {
            _object.nextState = null;
        } else {
            if (!_nextStateNode.isTextual()) {
                throw new RuntimeException("MirrorTopicRecord expected a string type, but got " + _node.getNodeType());
            }
            _object.nextState = _nextStateNode.asText();
        }
        return _object;
    }

    public static JsonNode write(MirrorTopicRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
        _node.set("topicName", (JsonNode)new TextNode(_object.topicName));
        _node.set("clusterLinkId", (JsonNode)new TextNode(_object.clusterLinkId.toString()));
        _node.set("clusterLinkName", (JsonNode)new TextNode(_object.clusterLinkName));
        _node.set("sourceTopicName", (JsonNode)new TextNode(_object.sourceTopicName));
        _node.set("sourceTopicId", (JsonNode)new TextNode(_object.sourceTopicId.toString()));
        _node.set("mirrorTopicState", (JsonNode)new TextNode(_object.mirrorTopicState));
        _node.set("timeMs", (JsonNode)new LongNode(_object.timeMs));
        if (_object.mirrorStartOffsets != null) {
            ArrayNode _mirrorStartOffsetsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Long _element : _object.mirrorStartOffsets) {
                _mirrorStartOffsetsArray.add((JsonNode)new LongNode(_element.longValue()));
            }
            _node.set("mirrorStartOffsets", (JsonNode)_mirrorStartOffsetsArray);
        }
        if (_object.previousToPausedState != null) {
            _node.set("previousToPausedState", (JsonNode)new TextNode(_object.previousToPausedState));
        }
        if (_object.stoppedLogEndOffsets != null) {
            ArrayNode _stoppedLogEndOffsetsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Long _element : _object.stoppedLogEndOffsets) {
                _stoppedLogEndOffsetsArray.add((JsonNode)new LongNode(_element.longValue()));
            }
            _node.set("stoppedLogEndOffsets", (JsonNode)_stoppedLogEndOffsetsArray);
        }
        if (_object.promoted) {
            _node.set("promoted", (JsonNode)BooleanNode.valueOf((boolean)_object.promoted));
        }
        if (_object.topicLevelPause) {
            _node.set("topicLevelPause", (JsonNode)BooleanNode.valueOf((boolean)_object.topicLevelPause));
        }
        if (_object.linkLevelPause) {
            _node.set("linkLevelPause", (JsonNode)BooleanNode.valueOf((boolean)_object.linkLevelPause));
        }
        if (_object.mirrorTopicError != -1) {
            _node.set("mirrorTopicError", (JsonNode)new ShortNode(_object.mirrorTopicError));
        }
        if (_object.nextState != null) {
            _node.set("nextState", (JsonNode)new TextNode(_object.nextState));
        }
        return _node;
    }

    public static JsonNode write(MirrorTopicRecord _object, short _version) {
        return MirrorTopicRecordJsonConverter.write(_object, _version, true);
    }
}

