/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class CellRecord
implements ApiMessage {
    int cellId;
    byte state;
    short minSize;
    short maxSize;
    List<Integer> brokers;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("cell_id", (Type)Type.INT32, "The cell id (greater than or equal to 0)."), new Field("state", (Type)Type.INT8, "The state of this cell (ready=0, quarantined=1, excluded=2)."), new Field("min_size", (Type)Type.INT16, "The minimum size for this cell before it can be used for tenant partitions."), new Field("max_size", (Type)Type.INT16, "The maximum size for this cell. A cell must have at most MaxSize number of brokers."), new Field("brokers", (Type)new CompactArrayOf((Type)Type.INT32), "The brokers assigned to this cell."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public CellRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public CellRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public CellRecord() {
        this.cellId = 0;
        this.state = 0;
        this.minSize = 0;
        this.maxSize = 0;
        this.brokers = new ArrayList<Integer>(0);
    }

    public short apiKey() {
        return 10016;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        this.cellId = _readable.readInt();
        this.state = _readable.readByte();
        this.minSize = _readable.readShort();
        this.maxSize = _readable.readShort();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field brokers was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.brokers = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.cellId);
        _writable.writeByte(this.state);
        _writable.writeShort(this.minSize);
        _writable.writeShort(this.maxSize);
        _writable.writeUnsignedVarint(this.brokers.size() + 1);
        for (Integer brokersElement : this.brokers) {
            _writable.writeInt(brokersElement.intValue());
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(1);
        _size.addBytes(2);
        _size.addBytes(2);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.brokers.size() + 1)));
        _size.addBytes(this.brokers.size() * 4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CellRecord)) {
            return false;
        }
        CellRecord other = (CellRecord)obj;
        if (this.cellId != other.cellId) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        if (this.minSize != other.minSize) {
            return false;
        }
        if (this.maxSize != other.maxSize) {
            return false;
        }
        if (this.brokers == null ? other.brokers != null : !this.brokers.equals(other.brokers)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.cellId;
        hashCode = 31 * hashCode + this.state;
        hashCode = 31 * hashCode + this.minSize;
        hashCode = 31 * hashCode + this.maxSize;
        hashCode = 31 * hashCode + (this.brokers == null ? 0 : this.brokers.hashCode());
        return hashCode;
    }

    public CellRecord duplicate() {
        CellRecord _duplicate = new CellRecord();
        _duplicate.cellId = this.cellId;
        _duplicate.state = this.state;
        _duplicate.minSize = this.minSize;
        _duplicate.maxSize = this.maxSize;
        ArrayList<Integer> newBrokers = new ArrayList<Integer>(this.brokers.size());
        for (Integer _element : this.brokers) {
            newBrokers.add(_element);
        }
        _duplicate.brokers = newBrokers;
        return _duplicate;
    }

    public String toString() {
        return "CellRecord(cellId=" + this.cellId + ", state=" + this.state + ", minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", brokers=" + MessageUtil.deepToString(this.brokers.iterator()) + ")";
    }

    public int cellId() {
        return this.cellId;
    }

    public byte state() {
        return this.state;
    }

    public short minSize() {
        return this.minSize;
    }

    public short maxSize() {
        return this.maxSize;
    }

    public List<Integer> brokers() {
        return this.brokers;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public CellRecord setCellId(int v) {
        this.cellId = v;
        return this;
    }

    public CellRecord setState(byte v) {
        this.state = v;
        return this;
    }

    public CellRecord setMinSize(short v) {
        this.minSize = v;
        return this;
    }

    public CellRecord setMaxSize(short v) {
        this.maxSize = v;
        return this;
    }

    public CellRecord setBrokers(List<Integer> v) {
        this.brokers = v;
        return this;
    }
}

