/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.controller.MockAclControlManager;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;

public class MockAclMutator
implements AclMutator {
    MockAclControlManager aclControlManager;

    public MockAclMutator(StandardAuthorizer authorizer) {
        this.aclControlManager = this.createAclControlManager(authorizer);
    }

    private MockAclControlManager createAclControlManager(StandardAuthorizer standardAuthorizer) {
        LogContext logContext = new LogContext();
        return new MockAclControlManager(logContext, Optional.of(standardAuthorizer));
    }

    public CompletableFuture<List<AclCreateResult>> createAcls(ControllerRequestContext context, List<AclBinding> aclBindings) {
        CompletableFuture<List<AclCreateResult>> future = new CompletableFuture<List<AclCreateResult>>();
        future.complete(this.aclControlManager.createAndReplayAcls(aclBindings));
        return future;
    }

    public CompletableFuture<List<AclDeleteResult>> deleteAcls(ControllerRequestContext context, List<AclBindingFilter> aclBindingFilters) {
        CompletableFuture<List<AclDeleteResult>> future = new CompletableFuture<List<AclDeleteResult>>();
        future.complete(this.aclControlManager.deleteAndReplayAcls(aclBindingFilters));
        return future;
    }
}

