/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.server.config.ConfigSynonym;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class KafkaConfigSchemaTest {
    public static final Map<ConfigResource.Type, ConfigDef> CONFIGS = new HashMap<ConfigResource.Type, ConfigDef>();
    public static final Map<String, List<ConfigSynonym>> SYNONYMS;
    private static final KafkaConfigSchema SCHEMA;

    @Test
    public void testTranslateConfigTypes() {
        KafkaConfigSchemaTest.testTranslateConfigType(ConfigDef.Type.BOOLEAN, ConfigEntry.ConfigType.BOOLEAN);
        KafkaConfigSchemaTest.testTranslateConfigType(ConfigDef.Type.STRING, ConfigEntry.ConfigType.STRING);
        KafkaConfigSchemaTest.testTranslateConfigType(ConfigDef.Type.INT, ConfigEntry.ConfigType.INT);
        KafkaConfigSchemaTest.testTranslateConfigType(ConfigDef.Type.SHORT, ConfigEntry.ConfigType.SHORT);
        KafkaConfigSchemaTest.testTranslateConfigType(ConfigDef.Type.LONG, ConfigEntry.ConfigType.LONG);
        KafkaConfigSchemaTest.testTranslateConfigType(ConfigDef.Type.DOUBLE, ConfigEntry.ConfigType.DOUBLE);
        KafkaConfigSchemaTest.testTranslateConfigType(ConfigDef.Type.LIST, ConfigEntry.ConfigType.LIST);
        KafkaConfigSchemaTest.testTranslateConfigType(ConfigDef.Type.CLASS, ConfigEntry.ConfigType.CLASS);
        KafkaConfigSchemaTest.testTranslateConfigType(ConfigDef.Type.PASSWORD, ConfigEntry.ConfigType.PASSWORD);
    }

    private static void testTranslateConfigType(ConfigDef.Type a, ConfigEntry.ConfigType b) {
        Assertions.assertEquals((Object)b, (Object)KafkaConfigSchema.translateConfigType((ConfigDef.Type)a));
    }

    @Test
    public void testTranslateConfigSources() {
        KafkaConfigSchemaTest.testTranslateConfigSource(ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG, DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG);
        KafkaConfigSchemaTest.testTranslateConfigSource(ConfigEntry.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG);
        KafkaConfigSchemaTest.testTranslateConfigSource(ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG);
        KafkaConfigSchemaTest.testTranslateConfigSource(ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG);
        KafkaConfigSchemaTest.testTranslateConfigSource(ConfigEntry.ConfigSource.STATIC_BROKER_CONFIG, DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG);
        KafkaConfigSchemaTest.testTranslateConfigSource(ConfigEntry.ConfigSource.DEFAULT_CONFIG, DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG);
    }

    private static void testTranslateConfigSource(ConfigEntry.ConfigSource a, DescribeConfigsResponse.ConfigSource b) {
        Assertions.assertEquals((Object)b, (Object)KafkaConfigSchema.translateConfigSource((ConfigEntry.ConfigSource)a));
    }

    @Test
    public void testIsSplittable() {
        Assertions.assertTrue((boolean)SCHEMA.isSplittable(ConfigResource.Type.BROKER, "foo.bar"));
        Assertions.assertFalse((boolean)SCHEMA.isSplittable(ConfigResource.Type.BROKER, "baz"));
        Assertions.assertFalse((boolean)SCHEMA.isSplittable(ConfigResource.Type.BROKER, "foo.baz.quux"));
        Assertions.assertFalse((boolean)SCHEMA.isSplittable(ConfigResource.Type.TOPIC, "baz"));
        Assertions.assertTrue((boolean)SCHEMA.isSplittable(ConfigResource.Type.TOPIC, "abc"));
    }

    @Test
    public void testGetConfigValueDefault() {
        Assertions.assertEquals((Object)"1", (Object)SCHEMA.getDefault(ConfigResource.Type.BROKER, "foo.bar"));
        Assertions.assertNull((Object)SCHEMA.getDefault(ConfigResource.Type.BROKER, "foo.baz.quux"));
        Assertions.assertNull((Object)SCHEMA.getDefault(ConfigResource.Type.TOPIC, "abc"));
        Assertions.assertEquals((Object)"true", (Object)SCHEMA.getDefault(ConfigResource.Type.TOPIC, "ghi"));
    }

    @Test
    public void testIsSensitive() {
        Assertions.assertFalse((boolean)SCHEMA.isSensitive(ConfigResource.Type.BROKER, "foo.bar"));
        Assertions.assertTrue((boolean)SCHEMA.isSensitive(ConfigResource.Type.BROKER, "quuux"));
        Assertions.assertTrue((boolean)SCHEMA.isSensitive(ConfigResource.Type.BROKER, "quuux2"));
        Assertions.assertTrue((boolean)SCHEMA.isSensitive(ConfigResource.Type.BROKER, "unknown.config.key"));
        Assertions.assertFalse((boolean)SCHEMA.isSensitive(ConfigResource.Type.TOPIC, "abc"));
    }

    @Test
    public void testResolveEffectiveTopicConfig() {
        HashMap<String, String> staticNodeConfig = new HashMap<String, String>();
        staticNodeConfig.put("foo.bar", "the,static,value");
        staticNodeConfig.put("quux", "123");
        staticNodeConfig.put("ghi", "false");
        HashMap<String, String> dynamicClusterConfigs = new HashMap<String, String>();
        dynamicClusterConfigs.put("foo.bar", "the,dynamic,cluster,config,value");
        dynamicClusterConfigs.put("quux", "456");
        HashMap<String, String> dynamicNodeConfigs = new HashMap<String, String>();
        dynamicNodeConfigs.put("quux", "789");
        HashMap<String, String> dynamicTopicConfigs = new HashMap<String, String>();
        dynamicTopicConfigs.put("ghi", "true");
        HashMap<String, ConfigEntry> expected = new HashMap<String, ConfigEntry>();
        expected.put("abc", new ConfigEntry("abc", "the,dynamic,cluster,config,value", ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, false, false, Collections.emptyList(), ConfigEntry.ConfigType.LIST, "abc doc"));
        expected.put("def", new ConfigEntry("def", "2840400000", ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG, false, false, Collections.emptyList(), ConfigEntry.ConfigType.LONG, "def doc"));
        expected.put("ghi", new ConfigEntry("ghi", "true", ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG, false, false, Collections.emptyList(), ConfigEntry.ConfigType.BOOLEAN, "ghi doc"));
        expected.put("xyz", new ConfigEntry("xyz", "thedefault", ConfigEntry.ConfigSource.DEFAULT_CONFIG, true, false, Collections.emptyList(), ConfigEntry.ConfigType.PASSWORD, "xyz doc"));
        Assertions.assertEquals(expected, (Object)SCHEMA.resolveEffectiveTopicConfigs(staticNodeConfig, dynamicClusterConfigs, dynamicNodeConfigs, dynamicTopicConfigs));
    }

    static {
        CONFIGS.put(ConfigResource.Type.BROKER, new ConfigDef().define("foo.bar", ConfigDef.Type.LIST, (Object)"1", ConfigDef.Importance.HIGH, "foo bar doc").define("baz", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "baz doc").define("quux", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "quux doc").define("quuux", ConfigDef.Type.PASSWORD, ConfigDef.Importance.HIGH, "quuux doc").define("quuux2", ConfigDef.Type.PASSWORD, ConfigDef.Importance.HIGH, "quuux2 doc"));
        CONFIGS.put(ConfigResource.Type.TOPIC, new ConfigDef().define("abc", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "abc doc").define("def", ConfigDef.Type.LONG, ConfigDef.Importance.HIGH, "def doc").define("ghi", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.HIGH, "ghi doc").define("xyz", ConfigDef.Type.PASSWORD, (Object)"thedefault", ConfigDef.Importance.HIGH, "xyz doc"));
        SYNONYMS = new HashMap<String, List<ConfigSynonym>>();
        SYNONYMS.put("abc", Arrays.asList(new ConfigSynonym("foo.bar")));
        SYNONYMS.put("def", Arrays.asList(new ConfigSynonym("quux", ConfigSynonym.HOURS_TO_MILLISECONDS)));
        SYNONYMS.put("ghi", Arrays.asList(new ConfigSynonym("ghi")));
        SYNONYMS.put("xyz", Arrays.asList(new ConfigSynonym("quuux"), new ConfigSynonym("quuux2")));
        SCHEMA = new KafkaConfigSchema(CONFIGS, SYNONYMS);
    }
}

