/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.util.LocalMetadataLogReader;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.SnapshotReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class LocalMetadataLogReaderTest {
    @Test
    public void testLoadFromEmptyLogData() throws Exception {
        ReplicatedLog log = (ReplicatedLog)Mockito.mock(ReplicatedLog.class);
        OptionalLong stopOffset = OptionalLong.empty();
        this.expectNoSnapshotsBelowOffset(log, 0L);
        this.expectLogSegmentsRange(log, 0L, 0L);
        Assertions.assertEquals((Object)OptionalLong.of(0L), (Object)this.loadMetadata(log, stopOffset));
    }

    @Test
    public void testLoadFromLatestSnapshot() throws Exception {
        ReplicatedLog log = (ReplicatedLog)Mockito.mock(ReplicatedLog.class);
        OptionalLong stopOffset = OptionalLong.empty();
        this.expectLoadFromSnapshot(log, stopOffset, this.emptySnapshot(new OffsetAndEpoch(15L, 2)));
        this.expectLogSegmentsRange(log, 10L, 10L);
        Assertions.assertEquals((Object)OptionalLong.of(15L), (Object)this.loadMetadata(log, stopOffset));
    }

    @Test
    public void testLoadFromSnapshotWithStopOffsetMatchingSnapshotId() throws Exception {
        ReplicatedLog log = (ReplicatedLog)Mockito.mock(ReplicatedLog.class);
        OptionalLong stopOffset = OptionalLong.of(10L);
        this.expectLoadFromSnapshot(log, stopOffset, this.emptySnapshot(new OffsetAndEpoch(10L, 1)));
        this.expectLogSegmentsRange(log, 10L, 10L);
        Assertions.assertEquals((Object)OptionalLong.of(10L), (Object)this.loadMetadata(log, stopOffset));
    }

    @Test
    public void testLoadFromSnapshotWithStopOffsetLessThanSnapshotId() throws Exception {
        ReplicatedLog log = (ReplicatedLog)Mockito.mock(ReplicatedLog.class);
        this.expectNoSnapshotsBelowOffset(log, 10L);
        this.expectLogSegmentsRange(log, 10L, 10L);
        Assertions.assertEquals((Object)OptionalLong.of(0L), (Object)this.loadMetadata(log, OptionalLong.of(5L)));
    }

    @Test
    public void testLoadFromLogSegments() throws Exception {
        ReplicatedLog log = (ReplicatedLog)Mockito.mock(ReplicatedLog.class);
        this.expectNoSnapshotsBelowOffset(log, 0L);
        this.expectLogSegmentsRange(log, 0L, 10L);
        this.expectLogSegmentRead(log, 0L, this.dummyBatches(0L, Arrays.asList(2, 5)));
        this.expectLogSegmentRead(log, 7L, this.dummyBatches(7L, Arrays.asList(3)));
        Assertions.assertEquals((Object)OptionalLong.of(10L), (Object)this.loadMetadata(log, OptionalLong.empty()));
    }

    @Test
    public void testLoadFromLogSegmentsWithStopOffset() throws Exception {
        ReplicatedLog log = (ReplicatedLog)Mockito.mock(ReplicatedLog.class);
        OptionalLong stopOffset = OptionalLong.of(10L);
        this.expectNoSnapshotsBelowOffset(log, 0L);
        this.expectLogSegmentsRange(log, 0L, 17L);
        this.expectLogSegmentRead(log, 0L, this.dummyBatches(0L, Arrays.asList(2, 5)));
        this.expectLogSegmentRead(log, 7L, this.dummyBatches(7L, Arrays.asList(3, 7)));
        Assertions.assertEquals((Object)OptionalLong.of(10L), (Object)this.loadMetadata(log, stopOffset));
    }

    @Test
    public void testLoadFromLogSegmentsWithMisalignedStopOffset() {
        ReplicatedLog log = (ReplicatedLog)Mockito.mock(ReplicatedLog.class);
        OptionalLong stopOffset = OptionalLong.of(13L);
        this.expectNoSnapshotsBelowOffset(log, 0L);
        this.expectLogSegmentsRange(log, 0L, 17L);
        this.expectLogSegmentRead(log, 0L, this.dummyBatches(0L, Arrays.asList(2, 5)));
        this.expectLogSegmentRead(log, 7L, this.dummyBatches(7L, Arrays.asList(3, 7)));
        Assertions.assertThrows(LocalMetadataLogReader.MisalignedStopOffsetException.class, () -> this.loadMetadata(log, stopOffset));
    }

    @Test
    public void testGapInLogSegmentData() throws Exception {
        ReplicatedLog log = (ReplicatedLog)Mockito.mock(ReplicatedLog.class);
        this.expectNoSnapshotsBelowOffset(log, 0L);
        this.expectLogSegmentsRange(log, 0L, 10L);
        this.expectLogSegmentRead(log, 0L, this.dummyBatches(0L, Arrays.asList(2, 5)));
        this.expectLogSegmentRead(log, 7L, this.dummyBatches(10L, Arrays.asList(3)));
        Assertions.assertEquals((Object)OptionalLong.of(7L), (Object)this.loadMetadata(log, OptionalLong.empty()));
    }

    private Records dummyBatches(long baseOffset, List<Integer> batchSizes) {
        ArrayList<List<ApiMessageAndVersion>> batches = new ArrayList<List<ApiMessageAndVersion>>(batchSizes.size());
        long offset = baseOffset;
        for (Integer batchSize : batchSizes) {
            batches.add(this.dummyBatchOfSize(offset, batchSize));
            offset += (long)batchSize.intValue();
        }
        return RecordTestUtils.createBatch(baseOffset, 1, batches);
    }

    private List<ApiMessageAndVersion> dummyBatchOfSize(long baseOffset, int numRecords) {
        ArrayList<ApiMessageAndVersion> batch = new ArrayList<ApiMessageAndVersion>(numRecords);
        long offset = baseOffset;
        for (int i = 0; i < numRecords; ++i) {
            batch.add(this.dummyRecord(offset++));
        }
        return batch;
    }

    private ApiMessageAndVersion dummyRecord(long offset) {
        ConfigRecord configRecord = new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setName(offset + "").setValue("whatever");
        return new ApiMessageAndVersion((ApiMessage)configRecord, configRecord.highestSupportedVersion());
    }

    private void expectNoSnapshotsBelowOffset(ReplicatedLog log, long offset) {
        Mockito.when((Object)log.latestSnapshotAtOrBelow(offset)).thenReturn(Optional.empty());
    }

    private RawSnapshotReader expectLoadFromSnapshot(ReplicatedLog log, OptionalLong stopOffset, RawSnapshotReader snapshotReader) {
        if (!stopOffset.isPresent()) {
            Mockito.when((Object)log.latestSnapshotAtOrBelow(Long.MAX_VALUE)).thenReturn(Optional.of(snapshotReader));
        } else {
            Mockito.when((Object)log.latestSnapshotAtOrBelow(stopOffset.getAsLong())).thenReturn(Optional.of(snapshotReader));
        }
        return snapshotReader;
    }

    private void expectLogSegmentsRange(ReplicatedLog log, long startOffset, long endOffset) {
        Mockito.when((Object)log.startOffset()).thenReturn((Object)startOffset);
        Mockito.when((Object)log.endOffset()).thenReturn((Object)new LogOffsetMetadata(endOffset));
    }

    private void expectLogSegmentRead(ReplicatedLog log, long readOffset, Records records) {
        Mockito.when((Object)log.read(readOffset, Isolation.UNCOMMITTED)).thenReturn((Object)new LogFetchInfo(records, new LogOffsetMetadata(readOffset)));
    }

    private RawSnapshotReader emptySnapshot(OffsetAndEpoch snapshotId) {
        RawSnapshotReader rawSnapshotReader = (RawSnapshotReader)Mockito.mock(RawSnapshotReader.class);
        Mockito.when((Object)rawSnapshotReader.snapshotId()).thenReturn((Object)snapshotId);
        Mockito.when((Object)rawSnapshotReader.records()).thenReturn((Object)MemoryRecords.EMPTY);
        return rawSnapshotReader;
    }

    private OptionalLong loadMetadata(ReplicatedLog log, OptionalLong stopOffset) throws Exception {
        LocalMetadataLogReader metadataReader = new LocalMetadataLogReader(log, stopOffset);
        RaftClient.Listener listener = (RaftClient.Listener)Mockito.mock(RaftClient.Listener.class);
        ((RaftClient.Listener)Mockito.doAnswer(invocation -> {
            SnapshotReader reader = (SnapshotReader)invocation.getArgument(0);
            while (reader.hasNext()) {
                reader.next();
            }
            reader.close();
            return null;
        }).when((Object)listener)).handleSnapshot((SnapshotReader)ArgumentMatchers.any());
        ((RaftClient.Listener)Mockito.doAnswer(invocation -> {
            BatchReader reader = (BatchReader)invocation.getArgument(0);
            while (reader.hasNext()) {
                reader.next();
            }
            reader.close();
            return null;
        }).when((Object)listener)).handleCommit((BatchReader)ArgumentMatchers.any());
        metadataReader.start(listener);
        Assertions.assertTrue((boolean)metadataReader.caughtUpFuture().isDone());
        Assertions.assertNull(metadataReader.caughtUpFuture().get());
        return metadataReader.loadedEndOffset();
    }
}

