/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.jqwik.api.Assume;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.constraints.AlphaChars;
import net.jqwik.api.constraints.Chars;
import net.jqwik.api.constraints.NumericChars;
import net.jqwik.api.constraints.Size;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.MockAuthorizableRequestContext;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerTest;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.junit.jupiter.api.Assertions;

public class StandardAuthorizerPropertyTest {
    @Property(tries=5000)
    public void matchingPrefixDenyOverridesAllAllowRules(@ForAll Random random, @ForAll @ValidTopicChars String topic, @ForAll @Size(max=10) @Size(max=10) Set<@ValidTopicChars String> randomSuffixes) throws Exception {
        Assume.that((boolean)Topic.isValid((String)topic));
        StandardAuthorizer authorizer = this.buildAuthorizer();
        String topicPrefix = topic.substring(0, random.nextInt(topic.length()));
        ConfluentStandardAcl denyRule = StandardAuthorizerPropertyTest.buildTopicWriteAcl(topicPrefix, PatternType.PREFIXED, AclPermissionType.DENY);
        authorizer.addAcl(Uuid.randomUuid(), denyRule);
        this.addRandomPrefixAllowAcls(authorizer, topic, randomSuffixes);
        this.assertAuthorizationResult(authorizer, AuthorizationResult.DENIED, AclOperation.WRITE, new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL));
    }

    @Property(tries=5000)
    public void matchingLiteralDenyOverridesAllAllowRules(@ForAll @ValidTopicChars String topic, @ForAll @Size(max=10) @Size(max=10) Set<@ValidTopicChars String> randomSuffixes) throws Exception {
        Assume.that((boolean)Topic.isValid((String)topic));
        StandardAuthorizer authorizer = this.buildAuthorizer();
        ConfluentStandardAcl denyRule = StandardAuthorizerPropertyTest.buildTopicWriteAcl(topic, PatternType.LITERAL, AclPermissionType.DENY);
        authorizer.addAcl(Uuid.randomUuid(), denyRule);
        this.addRandomPrefixAllowAcls(authorizer, topic, randomSuffixes);
        this.assertAuthorizationResult(authorizer, AuthorizationResult.DENIED, AclOperation.WRITE, new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL));
    }

    @Property(tries=5000)
    public void matchingPrefixAllowWithNoMatchingDenyRules(@ForAll Random random, @ForAll @ValidTopicChars String topic, @ForAll @Size(max=10) @Size(max=10) Set<@ValidTopicChars String> randomSuffixes) throws Exception {
        Assume.that((boolean)Topic.isValid((String)topic));
        StandardAuthorizer authorizer = this.buildAuthorizer();
        String topicPrefix = topic.substring(0, random.nextInt(topic.length()));
        ConfluentStandardAcl denyRule = StandardAuthorizerPropertyTest.buildTopicWriteAcl(topicPrefix, PatternType.PREFIXED, AclPermissionType.ALLOW);
        authorizer.addAcl(Uuid.randomUuid(), denyRule);
        this.addRandomNonMatchingPrefixDenyAcls(authorizer, topic, randomSuffixes);
        this.assertAuthorizationResult(authorizer, AuthorizationResult.ALLOWED, AclOperation.WRITE, new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL));
    }

    @Property(tries=5000)
    public void matchingLiteralAllowWithNoMatchingDenyRules(@ForAll @ValidTopicChars String topic, @ForAll @Size(max=10) @Size(max=10) Set<@ValidTopicChars String> randomSuffixes) throws Exception {
        Assume.that((boolean)Topic.isValid((String)topic));
        StandardAuthorizer authorizer = this.buildAuthorizer();
        ConfluentStandardAcl denyRule = StandardAuthorizerPropertyTest.buildTopicWriteAcl(topic, PatternType.LITERAL, AclPermissionType.ALLOW);
        authorizer.addAcl(Uuid.randomUuid(), denyRule);
        this.addRandomNonMatchingPrefixDenyAcls(authorizer, topic, randomSuffixes);
        this.assertAuthorizationResult(authorizer, AuthorizationResult.ALLOWED, AclOperation.WRITE, new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL));
    }

    private StandardAuthorizer buildAuthorizer() {
        StandardAuthorizer authorizer = new StandardAuthorizer();
        authorizer.start((AuthorizerServerInfo)new StandardAuthorizerTest.AuthorizerTestServerInfo(Collections.singletonList(StandardAuthorizerTest.PLAINTEXT)));
        authorizer.completeInitialLoad();
        return authorizer;
    }

    private void assertAuthorizationResult(StandardAuthorizer authorizer, AuthorizationResult expectedResult, AclOperation operation, ResourcePattern pattern) throws Exception {
        Action action = new Action(operation, pattern, 1, false, false);
        List results = authorizer.authorize(StandardAuthorizerPropertyTest.newRequestContext(), Collections.singletonList(action));
        Assertions.assertEquals((int)1, (int)results.size());
        AuthorizationResult actualResult = (AuthorizationResult)results.get(0);
        try {
            Assertions.assertEquals((Object)expectedResult, (Object)actualResult);
        }
        catch (Throwable e) {
            this.printCounterExample(authorizer, operation, pattern, actualResult);
            throw e;
        }
    }

    private void printCounterExample(StandardAuthorizer authorizer, AclOperation operation, ResourcePattern resourcePattern, AuthorizationResult result) {
        System.out.println("Assertion FAILED: Operation " + operation + " on " + resourcePattern + " is " + result + ". Current ACLS:");
        Iterable allAcls = authorizer.acls(new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.ANY), new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY)));
        allAcls.forEach(System.out::println);
    }

    private static AuthorizableRequestContext newRequestContext() throws Exception {
        return new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "user")).build();
    }

    private static ConfluentStandardAcl buildTopicWriteAcl(String resourceName, PatternType patternType, AclPermissionType permissionType) {
        StandardAcl acl = new StandardAcl(ResourceType.TOPIC, resourceName, patternType, "User:*", "*", AclOperation.WRITE, permissionType);
        return new ConfluentStandardAcl(acl, Optional.empty());
    }

    private boolean isPrefix(String value, String prefix) {
        if (prefix.length() > value.length()) {
            return false;
        }
        String matchingPrefix = value.substring(0, prefix.length());
        return matchingPrefix.equals(prefix);
    }

    private void addRandomNonMatchingPrefixDenyAcls(StandardAuthorizer authorizer, String topic, Set<String> randomSuffixes) {
        this.addRandomPrefixRules(authorizer, topic, randomSuffixes, AclPermissionType.DENY, pattern -> !pattern.isEmpty() && !this.isPrefix(topic, (String)pattern));
    }

    private void addRandomPrefixAllowAcls(StandardAuthorizer authorizer, String topic, Set<String> randomSuffixes) {
        this.addRandomPrefixRules(authorizer, topic, randomSuffixes, AclPermissionType.ALLOW, pattern -> !pattern.isEmpty());
    }

    private void addRandomPrefixRules(StandardAuthorizer authorizer, String topic, Set<String> randomSuffixes, AclPermissionType permissionType, Predicate<String> patternFilter) {
        HashSet<String> prefixPatterns = new HashSet<String>();
        for (int i = 0; i < topic.length(); ++i) {
            String prefix = topic.substring(0, i);
            for (String randomSuffix : randomSuffixes) {
                String pattern = prefix + randomSuffix;
                if (!patternFilter.test(pattern)) continue;
                prefixPatterns.add(pattern);
            }
        }
        for (String randomResourcePattern : prefixPatterns) {
            authorizer.addAcl(Uuid.randomUuid(), StandardAuthorizerPropertyTest.buildTopicWriteAcl(randomResourcePattern, PatternType.PREFIXED, permissionType));
        }
    }

    @Target(value={ElementType.ANNOTATION_TYPE, ElementType.PARAMETER, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @AlphaChars
    @NumericChars
    @Chars(value={95, 45, 46})
    public static @interface ValidTopicChars {
    }
}

