/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclTest;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class StandardAclWithIdTest {
    public static final List<StandardAclWithId> TEST_ACLS = new ArrayList<StandardAclWithId>();

    @Test
    public void testToRecordRoundTrips() {
        for (StandardAclWithId acl : TEST_ACLS) {
            AccessControlEntryRecord record = acl.toRecord();
            StandardAclWithId acl2 = StandardAclWithId.fromRecord((AccessControlEntryRecord)record);
            Assertions.assertEquals((Object)acl2, (Object)acl);
        }
    }

    @Test
    public void testEquals() {
        for (int i = 0; i != TEST_ACLS.size(); ++i) {
            for (int j = 0; j != TEST_ACLS.size(); ++j) {
                if (i == j) {
                    Assertions.assertEquals((Object)TEST_ACLS.get(i), (Object)TEST_ACLS.get(j));
                    continue;
                }
                Assertions.assertNotEquals((Object)TEST_ACLS.get(i), (Object)TEST_ACLS.get(j));
            }
        }
    }

    static {
        TEST_ACLS.add(new StandardAclWithId(Uuid.fromString((String)"QZDDv-R7SyaPgetDPGd0Mw"), new ConfluentStandardAcl(StandardAclTest.TEST_ACLS.get(0), Optional.empty())));
        TEST_ACLS.add(new StandardAclWithId(Uuid.fromString((String)"SdDjEdlbRmy2__WFKe3RMg"), new ConfluentStandardAcl(StandardAclTest.TEST_ACLS.get(1), Optional.empty())));
        TEST_ACLS.add(new StandardAclWithId(Uuid.fromString((String)"wQzt5gkSTwuQNXZF5gIw7A"), new ConfluentStandardAcl(StandardAclTest.TEST_ACLS.get(2), Optional.empty())));
        TEST_ACLS.add(new StandardAclWithId(Uuid.fromString((String)"ab_5xjJXSbS1o5jGfhgQXg"), new ConfluentStandardAcl(StandardAclTest.TEST_ACLS.get(3), Optional.empty())));
        TEST_ACLS.add(new StandardAclWithId(Uuid.fromString((String)"wP_cCK0LTEGSX9oDRInJHQ"), new ConfluentStandardAcl(StandardAclTest.TEST_ACLS.get(4), Optional.empty())));
        TEST_ACLS.add(new StandardAclWithId(Uuid.fromString((String)"R3bMhXGmQNmK46EcBnrAiQ"), new ConfluentStandardAcl(new StandardAcl(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:user", "10.0.0.1", AclOperation.ALL, AclPermissionType.ANY), Optional.of(Uuid.fromString((String)"1btx_LQcTNmABQKW0MRBVQ")))));
        TEST_ACLS.add(new StandardAclWithId(Uuid.fromString((String)"MjBENjM4RUEtQUY5Qi00Nj"), new ConfluentStandardAcl(new StandardAcl(ResourceType.TOPIC, "afoo", PatternType.LITERAL, "User:user", "10.0.0.1", AclOperation.ALL, AclPermissionType.ANY), Optional.of(Uuid.fromString((String)"NTA1MDhFQjAtRDVGOC00Qz")))));
    }
}

