/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.internals.MemoryBatchReader;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.util.MockRandom;
import org.junit.jupiter.api.Assertions;

public class RecordTestUtils {
    public static void replayAll(Object target, List<ApiMessageAndVersion> recordsAndVersions) {
        for (ApiMessageAndVersion recordAndVersion : recordsAndVersions) {
            ApiMessage record = recordAndVersion.message();
            try {
                try {
                    Method method = target.getClass().getMethod("replay", record.getClass());
                    method.invoke(target, record);
                }
                catch (NoSuchMethodException e) {
                    try {
                        Method method = target.getClass().getMethod("replay", record.getClass(), Optional.class);
                        method.invoke(target, record, Optional.empty());
                    }
                    catch (NoSuchMethodException t) {
                        try {
                            Method method = target.getClass().getMethod("replay", record.getClass(), Long.TYPE);
                            method.invoke(target, record, 0L);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {}
                    }
                }
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void replayAllBatches(Object target, List<List<ApiMessageAndVersion>> batches) {
        for (List<ApiMessageAndVersion> batch : batches) {
            RecordTestUtils.replayAll(target, batch);
        }
    }

    public static <T> Set<T> iteratorToSet(Iterator<T> iterator) {
        HashSet<T> set = new HashSet<T>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static void assertBatchIteratorContains(List<List<ApiMessageAndVersion>> batches, Iterator<List<ApiMessageAndVersion>> iterator) throws Exception {
        ArrayList actual = new ArrayList();
        while (iterator.hasNext()) {
            actual.add(new ArrayList(iterator.next()));
        }
        RecordTestUtils.deepSortRecords(actual);
        ArrayList<ArrayList<ApiMessageAndVersion>> expected = new ArrayList<ArrayList<ApiMessageAndVersion>>();
        for (List<ApiMessageAndVersion> batch : batches) {
            expected.add(new ArrayList<ApiMessageAndVersion>(batch));
        }
        RecordTestUtils.deepSortRecords(expected);
        Assertions.assertEquals(expected, actual);
    }

    public static void deepSortRecords(Object o) throws Exception {
        if (o == null) {
            return;
        }
        if (o instanceof List) {
            List list = (List)o;
            for (Object entry : list) {
                if (entry == null) continue;
                if (Number.class.isAssignableFrom(entry.getClass())) {
                    return;
                }
                RecordTestUtils.deepSortRecords(entry);
            }
            list.sort(Comparator.comparing(Object::toString));
        } else if (o instanceof ImplicitLinkedHashCollection) {
            ImplicitLinkedHashCollection coll = (ImplicitLinkedHashCollection)o;
            for (Object entry : coll) {
                RecordTestUtils.deepSortRecords(entry);
            }
            coll.sort(Comparator.comparing(Object::toString));
        } else if (o instanceof Message || o instanceof ApiMessageAndVersion) {
            for (Field field : o.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                RecordTestUtils.deepSortRecords(field.get(o));
            }
        }
    }

    public static BatchReader<ApiMessageAndVersion> mockBatchReader(long lastOffset, long appendTimestamp, List<ApiMessageAndVersion> records) {
        ArrayList<Batch> batches = new ArrayList<Batch>();
        long offset = lastOffset - (long)records.size() + 1L;
        Iterator<ApiMessageAndVersion> iterator = records.iterator();
        ArrayList<Object> curRecords = new ArrayList<ApiMessageAndVersion>();
        Assertions.assertTrue((boolean)iterator.hasNext());
        while (true) {
            if (!iterator.hasNext() || curRecords.size() >= 2) {
                batches.add(Batch.data((long)offset, (int)0, (long)appendTimestamp, (int)RecordTestUtils.sizeInBytes(curRecords), curRecords));
                if (!iterator.hasNext()) break;
                offset += (long)curRecords.size();
                curRecords = new ArrayList();
            }
            curRecords.add(iterator.next());
        }
        return MemoryBatchReader.of(batches, __ -> {});
    }

    private static int sizeInBytes(List<ApiMessageAndVersion> records) {
        int size = 0;
        for (ApiMessageAndVersion record : records) {
            ObjectSerializationCache cache = new ObjectSerializationCache();
            size += MetadataRecordSerde.INSTANCE.recordSize(record, cache);
        }
        return size;
    }

    public static ApiMessageAndVersion testRecord(int index) {
        MockRandom random = new MockRandom((long)index);
        return new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test" + index).setTopicId(new Uuid(random.nextLong(), random.nextLong())), 0);
    }

    public static Records createBatch(long baseOffset, int leaderEpoch, List<List<ApiMessageAndVersion>> batches) {
        ByteBufferOutputStream out = new ByteBufferOutputStream(0);
        long batchBaseOffset = baseOffset;
        for (List<ApiMessageAndVersion> batch : batches) {
            MemoryRecordsBuilder builder = new MemoryRecordsBuilder(out, RecordVersion.current().value, CompressionType.NONE, TimestampType.CREATE_TIME, batchBaseOffset, Time.SYSTEM.milliseconds(), -1L, -1, -1, false, false, leaderEpoch, Integer.MAX_VALUE, -1L);
            ObjectSerializationCache cache = new ObjectSerializationCache();
            for (ApiMessageAndVersion messageAndVersion : batch) {
                ByteBuffer buffer = ByteBuffer.allocate(MetadataRecordSerde.INSTANCE.recordSize(messageAndVersion, cache));
                ByteBufferAccessor recordOut = new ByteBufferAccessor(buffer);
                MetadataRecordSerde.INSTANCE.write(messageAndVersion, cache, (Writable)recordOut);
                ByteBuffer recordBuffer = recordOut.buffer();
                recordBuffer.flip();
                builder.append(new SimpleRecord(recordBuffer));
            }
            builder.close();
            batchBaseOffset += (long)batch.size();
        }
        ByteBuffer buffer = out.buffer();
        buffer.flip();
        return MemoryRecords.readableRecords((ByteBuffer)buffer);
    }
}

