/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.controller.QuorumControllerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuorumControllerMetricsTest {
    private static final String EXPECTED_GROUP = "kafka.controller";

    @Test
    public void testKafkaControllerMetricNames() {
        String expectedType = "KafkaController";
        Set expectedMetricNames = Utils.mkSet((Object[])new String[]{"ActiveControllerCount", "FencedBrokerCount", "ActiveBrokerCount", "GlobalTopicCount", "GlobalPartitionCount", "OfflinePartitionsCount", "GlobalUnderMinIsrPartitionCount", "PartitionAvailability", "PreferredReplicaImbalanceCount", "MetadataErrorCount", "LastAppliedRecordLagMs", "LastAppliedRecordOffset", "LastAppliedRecordTimestamp", "LastCommittedRecordOffset", "BrokersExcludedForReplicaPlacementCount"});
        Set expectedSensorNames = Utils.mkSet((Object[])new String[]{"ControllerLoadTime"});
        QuorumControllerMetricsTest.assertMetricsCreatedAndRemovedUponClose(expectedType, expectedMetricNames, expectedSensorNames);
    }

    @Test
    public void testControllerEventManagerMetricNames() {
        String expectedType = "ControllerEventManager";
        Set expectedMetricNames = Utils.mkSet((Object[])new String[]{"EventQueueTimeMs", "EventQueueProcessingTimeMs"});
        QuorumControllerMetricsTest.assertMetricsCreatedAndRemovedUponClose(expectedType, expectedMetricNames, Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateEventQueueTime() {
        MetricsRegistry registry = new MetricsRegistry();
        Metrics kafkaMetrics = new Metrics();
        MockTime time = new MockTime();
        try (QuorumControllerMetrics quorumControllerMetrics = new QuorumControllerMetrics(registry, (Time)time, kafkaMetrics);){
            quorumControllerMetrics.updateEventQueueTime(1000L);
            QuorumControllerMetricsTest.assertMetricHistogram(registry, QuorumControllerMetricsTest.metricName("ControllerEventManager", "EventQueueTimeMs"), 1L, 1000.0);
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateEventQueueProcessingTime() {
        MetricsRegistry registry = new MetricsRegistry();
        Metrics kafkaMetrics = new Metrics();
        MockTime time = new MockTime();
        try (QuorumControllerMetrics quorumControllerMetrics = new QuorumControllerMetrics(registry, (Time)time, kafkaMetrics);){
            quorumControllerMetrics.updateEventQueueProcessingTime(1000L);
            QuorumControllerMetricsTest.assertMetricHistogram(registry, QuorumControllerMetricsTest.metricName("ControllerEventManager", "EventQueueProcessingTimeMs"), 1L, 1000.0);
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastAppliedRecordMetrics() {
        MetricsRegistry registry = new MetricsRegistry();
        Metrics kafkaMetrics = new Metrics();
        MockTime time = new MockTime();
        time.sleep(1000L);
        try (QuorumControllerMetrics quorumControllerMetrics = new QuorumControllerMetrics(registry, (Time)time, kafkaMetrics);){
            quorumControllerMetrics.setLastAppliedRecordOffset(100L);
            quorumControllerMetrics.setLastAppliedRecordTimestamp(500L);
            quorumControllerMetrics.setLastCommittedRecordOffset(50L);
            Gauge lastAppliedRecordOffset = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastAppliedRecordOffset"));
            Assertions.assertEquals((long)100L, (Long)((Long)lastAppliedRecordOffset.value()));
            Gauge lastAppliedRecordTimestamp = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastAppliedRecordTimestamp"));
            Assertions.assertEquals((long)500L, (Long)((Long)lastAppliedRecordTimestamp.value()));
            Gauge lastAppliedRecordLagMs = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastAppliedRecordLagMs"));
            Assertions.assertEquals((long)(time.milliseconds() - 500L), (Long)((Long)lastAppliedRecordLagMs.value()));
            Gauge lastCommittedRecordOffset = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastCommittedRecordOffset"));
            Assertions.assertEquals((long)50L, (Long)((Long)lastCommittedRecordOffset.value()));
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExclusionCountMetric() {
        MetricsRegistry registry = new MetricsRegistry();
        Metrics kafkaMetrics = new Metrics();
        MockTime time = new MockTime();
        time.sleep(1000L);
        try (QuorumControllerMetrics quorumControllerMetrics = new QuorumControllerMetrics(registry, (Time)time, kafkaMetrics);){
            Gauge excludedBrokerCount = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "BrokersExcludedForReplicaPlacementCount"));
            Assertions.assertEquals((int)0, (Integer)((Integer)excludedBrokerCount.value()));
            quorumControllerMetrics.setExcludedBrokerCount(100);
            Assertions.assertEquals((int)100, (Integer)((Integer)excludedBrokerCount.value()));
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadataErrorCount() {
        Metrics kafkaMetrics = new Metrics();
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        try (QuorumControllerMetrics quorumControllerMetrics = new QuorumControllerMetrics(registry, (Time)time, kafkaMetrics);){
            Gauge metadataErrorCount = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "MetadataErrorCount"));
            Assertions.assertEquals((int)0, (Integer)((Integer)metadataErrorCount.value()));
            quorumControllerMetrics.incrementMetadataErrorCount();
            Assertions.assertEquals((int)1, (Integer)((Integer)metadataErrorCount.value()));
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertMetricsCreatedAndRemovedUponClose(String expectedType, Set<String> expectedMetricNames, Set<String> expectedSensorNames) {
        Metrics kafkaMetrics = new Metrics();
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        try {
            try (QuorumControllerMetrics quorumControllerMetrics = new QuorumControllerMetrics(registry, (Time)time, kafkaMetrics);){
                QuorumControllerMetricsTest.assertMetricsCreated(registry, expectedMetricNames, expectedType);
                QuorumControllerMetricsTest.assertKafkaMetricsCreated(kafkaMetrics, expectedSensorNames);
            }
            QuorumControllerMetricsTest.assertMetricsRemoved(registry, expectedMetricNames, expectedType);
            QuorumControllerMetricsTest.assertKafkaMetricsRemoved(kafkaMetrics, expectedSensorNames);
        }
        finally {
            registry.shutdown();
        }
    }

    private static void assertMetricHistogram(MetricsRegistry registry, MetricName metricName, long count, double sum) {
        Histogram histogram = (Histogram)registry.allMetrics().get(metricName);
        Assertions.assertEquals((long)count, (long)histogram.count());
        Assertions.assertEquals((double)sum, (double)histogram.sum(), (double)0.1);
    }

    private static MetricName metricName(String type, String name) {
        String mBeanName = String.format("kafka.controller:type=%s,name=%s", type, name);
        return new MetricName(EXPECTED_GROUP, type, name, null, mBeanName);
    }

    private static void assertMetricsCreated(MetricsRegistry registry, Set<String> expectedMetricNames, String expectedType) {
        Assertions.assertEquals((long)registry.allMetrics().keySet().stream().filter(k -> k.getType() == expectedType).count(), (long)expectedMetricNames.size());
        expectedMetricNames.forEach(expectedName -> {
            MetricName expectMetricName = QuorumControllerMetricsTest.metricName(expectedType, expectedName);
            Assertions.assertTrue((boolean)registry.allMetrics().containsKey(expectMetricName), (String)("Missing metric: " + expectMetricName));
        });
        registry.allMetrics().forEach((actualMetricName, actualMetric) -> {
            if (actualMetricName.getType() == expectedType) {
                Assertions.assertTrue((boolean)expectedMetricNames.contains(actualMetricName.getName()), (String)("Unexpected metric: " + actualMetricName));
            }
        });
    }

    private static void assertKafkaMetricsCreated(Metrics kafkaMetrics, Set<String> expectedSensorNames) {
        for (String sensorName : expectedSensorNames) {
            Assertions.assertNotNull((Object)kafkaMetrics.getSensor(sensorName), (String)("Failed to find sensor named " + sensorName));
        }
    }

    private static void assertMetricsRemoved(MetricsRegistry registry, Set<String> expectedMetricNames, String expectedType) {
        expectedMetricNames.forEach(expectedName -> {
            MetricName expectMetricName = QuorumControllerMetricsTest.metricName(expectedType, expectedName);
            Assertions.assertFalse((boolean)registry.allMetrics().containsKey(expectMetricName), (String)("Found metric: " + expectMetricName));
        });
    }

    private static void assertKafkaMetricsRemoved(Metrics metrics, Set<String> expectedSensorNames) {
        expectedSensorNames.forEach(sensorName -> Assertions.assertNull((Object)metrics.getSensor(sensorName), (String)("Found sensor: " + sensorName)));
    }

    static QuorumControllerMetrics createQuorumControlMetrics() {
        Metrics kafkaMetrics = new Metrics();
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        return new QuorumControllerMetrics(registry, (Time)time, kafkaMetrics);
    }

    @Test
    public void testTenantPartitionAvailabilitySlo() {
        String tenant = "lkc-9pzxv0";
        QuorumControllerMetrics qm = QuorumControllerMetricsTest.createQuorumControlMetrics();
        Map tenantMetrics = qm.getTenantPartitionMetricsMap();
        Assertions.assertTrue((boolean)tenantMetrics.isEmpty());
        qm.setTenantPartitionCount("lkc-9pzxv0", 0);
        Assertions.assertTrue((tenantMetrics.size() == 1 ? 1 : 0) != 0);
        qm.setTenantPartitionCount("lkc-9pzxv0", 10);
        double slo = qm.getTenantPartitionAvailabilitySLO("lkc-9pzxv0");
        Assertions.assertEquals((double)1.0, (double)slo);
        qm.setTenantOfflinePartitionCount("lkc-9pzxv0", 1);
        slo = qm.getTenantPartitionAvailabilitySLO("lkc-9pzxv0");
        Assertions.assertEquals((double)0.9, (double)slo);
        qm.setTenantUnderMinIsrCount("lkc-9pzxv0", 1);
        slo = qm.getTenantPartitionAvailabilitySLO("lkc-9pzxv0");
        Assertions.assertEquals((double)0.8, (double)slo);
        qm.setTenantUnderMinIsrCount("lkc-9pzxv0", 0);
        qm.setTenantOfflinePartitionCount("lkc-9pzxv0", 0);
        slo = qm.getTenantPartitionAvailabilitySLO("lkc-9pzxv0");
        Assertions.assertEquals((double)1.0, (double)slo);
    }

    @Test
    public void testTenantPartitionAvailabilityWithMultipleTenants() {
        QuorumControllerMetrics qm = QuorumControllerMetricsTest.createQuorumControlMetrics();
        Map tenantMetrics = qm.getTenantPartitionMetricsMap();
        Assertions.assertTrue((boolean)tenantMetrics.isEmpty());
        List<String> tenants = Stream.of("t1", "t2", "t3").collect(Collectors.toList());
        tenants.forEach(t -> qm.setTenantPartitionCount(t, 10));
        Assertions.assertEquals((int)tenantMetrics.size(), (int)tenants.size());
        tenants.forEach(t -> Assertions.assertEquals((double)1.0, (Double)qm.getTenantPartitionAvailabilitySLO(t)));
        qm.setTenantUnderMinIsrCount("t1", 1);
        qm.setTenantOfflinePartitionCount("t2", 1);
        Assertions.assertEquals((double)0.9, (Double)qm.getTenantPartitionAvailabilitySLO("t1"));
        Assertions.assertEquals((double)0.9, (Double)qm.getTenantPartitionAvailabilitySLO("t2"));
        Assertions.assertEquals((double)1.0, (Double)qm.getTenantPartitionAvailabilitySLO("t3"));
        qm.setTenantUnderMinIsrCount("t1", 2);
        Assertions.assertEquals((double)0.8, (Double)qm.getTenantPartitionAvailabilitySLO("t1"));
        Assertions.assertEquals((double)0.9, (Double)qm.getTenantPartitionAvailabilitySLO("t2"));
        Assertions.assertEquals((double)1.0, (Double)qm.getTenantPartitionAvailabilitySLO("t3"));
        qm.setTenantPartitionCount("t1", 20);
        Assertions.assertEquals((double)0.9, (Double)qm.getTenantPartitionAvailabilitySLO("t1"));
        qm.setTenantOfflinePartitionCount("t2", 0);
        Assertions.assertEquals((double)0.9, (Double)qm.getTenantPartitionAvailabilitySLO("t1"));
        Assertions.assertEquals((double)1.0, (Double)qm.getTenantPartitionAvailabilitySLO("t2"));
        Assertions.assertEquals((double)1.0, (Double)qm.getTenantPartitionAvailabilitySLO("t3"));
        qm.setTenantUnderMinIsrCount("t1", 0);
        tenants.forEach(t -> Assertions.assertEquals((double)1.0, (Double)qm.getTenantPartitionAvailabilitySLO(t)));
    }
}

