/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class FeatureControlManagerTest {
    private static final FeatureControlManager.Builder TEST_MANAGER_BUILDER1 = new FeatureControlManager.Builder().setQuorumFeatures(FeatureControlManagerTest.features("confluent.metadata.version", MetadataVersion.IBP_3_3_IV0.confluentFeatureLevel(), MetadataVersion.IBP_3_3_IV3.confluentFeatureLevel())).setMetadataVersion(MetadataVersion.IBP_3_3_IV2);

    private static Map<String, VersionRange> rangeMap(Object ... args) {
        HashMap<String, VersionRange> result = new HashMap<String, VersionRange>();
        for (int i = 0; i < args.length; i += 3) {
            String feature = (String)args[i];
            Number low = (Number)args[i + 1];
            Number high = (Number)args[i + 2];
            result.put(feature, VersionRange.of((short)low.shortValue(), (short)high.shortValue()));
        }
        return result;
    }

    private static Map<String, Short> versionMap(Object ... args) {
        HashMap<String, Short> result = new HashMap<String, Short>();
        for (int i = 0; i < args.length; i += 2) {
            String feature = (String)args[i];
            Number ver = (Number)args[i + 1];
            result.put(feature, ver.shortValue());
        }
        return result;
    }

    public static QuorumFeatures features(Object ... args) {
        Map features = QuorumFeatures.defaultFeatureMap();
        features.putAll(FeatureControlManagerTest.rangeMap(args));
        return new QuorumFeatures(0, new ApiVersions(), features, Collections.emptyList());
    }

    private static Map<String, Short> updateMap(Object ... args) {
        HashMap<String, Short> result = new HashMap<String, Short>();
        for (int i = 0; i < args.length; i += 2) {
            String feature = (String)args[i];
            Number ver = (Number)args[i + 1];
            result.put(feature, ver.shortValue());
        }
        return result;
    }

    @Test
    public void testUpdateFeatures() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager manager = new FeatureControlManager.Builder().setQuorumFeatures(FeatureControlManagerTest.features("foo", 1, 2)).setSnapshotRegistry(snapshotRegistry).setMetadataVersion(MetadataVersion.IBP_3_3_IV0).build();
        snapshotRegistry.getOrCreateSnapshot(-1L);
        Assertions.assertEquals((Object)new FinalizedControllerFeatures(Collections.singletonMap("confluent.metadata.version", (short)104), -1L), (Object)manager.finalizedFeatures(-1L));
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.emptyList(), Collections.singletonMap("foo", new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 3 for feature foo. Local controller 0 only supports versions 1-2"))), (Object)manager.updateFeatures(FeatureControlManagerTest.updateMap("foo", 3), Collections.singletonMap("foo", FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), Collections.emptyMap(), false));
        ControllerResult result = manager.updateFeatures(FeatureControlManagerTest.updateMap("foo", 2, "bar", 1), Collections.emptyMap(), Collections.emptyMap(), false);
        HashMap<String, ApiError> expectedMap = new HashMap<String, ApiError>();
        expectedMap.put("foo", ApiError.NONE);
        expectedMap.put("bar", new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 1 for feature bar. Local controller 0 does not support this feature."));
        Assertions.assertEquals(expectedMap, (Object)result.response());
        ArrayList<ApiMessageAndVersion> expectedMessages = new ArrayList<ApiMessageAndVersion>();
        expectedMessages.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo").setFeatureLevel((short)2), 0));
        Assertions.assertEquals(expectedMessages, (Object)result.records());
    }

    @Test
    public void testReplay() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        FeatureLevelRecord record = new FeatureLevelRecord().setName("foo").setFeatureLevel((short)2);
        snapshotRegistry.getOrCreateSnapshot(-1L);
        FeatureControlManager manager = new FeatureControlManager.Builder().setLogContext(logContext).setQuorumFeatures(FeatureControlManagerTest.features("foo", 1, 2)).setSnapshotRegistry(snapshotRegistry).setMetadataVersion(MetadataVersion.IBP_3_3_IV0).build();
        manager.replay(record);
        snapshotRegistry.getOrCreateSnapshot(123L);
        Assertions.assertEquals((Object)new FinalizedControllerFeatures(FeatureControlManagerTest.versionMap("confluent.metadata.version", 104, "foo", 2), 123L), (Object)manager.finalizedFeatures(123L));
    }

    @Test
    public void testUpdateFeaturesErrorCases() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        FeatureControlManager manager = new FeatureControlManager.Builder().setLogContext(logContext).setQuorumFeatures(FeatureControlManagerTest.features("foo", 1, 5, "bar", 1, 2)).setSnapshotRegistry(snapshotRegistry).build();
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.emptyList(), Collections.singletonMap("foo", new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 3 for feature foo. Broker 5 does not support this feature."))), (Object)manager.updateFeatures(FeatureControlManagerTest.updateMap("foo", 3), Collections.singletonMap("foo", FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), Collections.singletonMap(5, FeatureControlManagerTest.rangeMap(new Object[0])), false));
        ControllerResult result = manager.updateFeatures(FeatureControlManagerTest.updateMap("foo", 3), Collections.emptyMap(), Collections.emptyMap(), false);
        Assertions.assertEquals(Collections.singletonMap("foo", ApiError.NONE), (Object)result.response());
        manager.replay((FeatureLevelRecord)((ApiMessageAndVersion)result.records().get(0)).message());
        snapshotRegistry.getOrCreateSnapshot(3L);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.emptyList(), Collections.singletonMap("foo", new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 2 for feature foo. Can't downgrade the version of this feature without setting the upgrade type to either safe or unsafe downgrade."))), (Object)manager.updateFeatures(FeatureControlManagerTest.updateMap("foo", 2), Collections.emptyMap(), Collections.emptyMap(), false));
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo").setFeatureLevel((short)2), 0)), Collections.singletonMap("foo", ApiError.NONE)), (Object)manager.updateFeatures(FeatureControlManagerTest.updateMap("foo", 2), Collections.singletonMap("foo", FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), Collections.emptyMap(), false));
    }

    @Test
    public void testReplayRecords() throws Exception {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        FeatureControlManager manager = new FeatureControlManager.Builder().setLogContext(logContext).setQuorumFeatures(FeatureControlManagerTest.features("foo", 1, 5, "bar", 1, 2)).setSnapshotRegistry(snapshotRegistry).setMetadataVersion(MetadataVersion.IBP_3_3_IV0).build();
        ControllerResult result = manager.updateFeatures(FeatureControlManagerTest.updateMap("foo", 5, "bar", 1), Collections.emptyMap(), Collections.emptyMap(), false);
        RecordTestUtils.replayAll(manager, result.records());
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV0, (Object)manager.metadataVersion());
        Assertions.assertEquals(Optional.of((short)5), (Object)manager.finalizedFeatures(Long.MAX_VALUE).get("foo"));
        Assertions.assertEquals(Optional.of((short)1), (Object)manager.finalizedFeatures(Long.MAX_VALUE).get("bar"));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("confluent.metadata.version", "foo", "bar")), (Object)manager.finalizedFeatures(Long.MAX_VALUE).featureNames());
    }

    @Test
    public void testApplyMetadataVersionChangeRecord() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        manager.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_3_IV3.apacheFeatureLevel()));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)manager.metadataVersion());
    }

    @Test
    public void testCannotDowngradeToVersionBeforeMinimumSupportedKraftVersion() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), Collections.singletonMap("confluent.metadata.version", new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 103 for feature confluent.metadata.version. Local controller 0 only supports versions 104-107"))), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_2_IV0.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE), Collections.emptyMap(), true));
    }

    @Test
    public void testCannotDowngradeToHigherVersion() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), Collections.singletonMap("confluent.metadata.version", new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 107 for feature confluent.metadata.version. Can't downgrade to a newer version."))), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_3_IV3.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), Collections.emptyMap(), true));
    }

    @Test
    public void testCannotUnsafeDowngradeToHigherVersion() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), Collections.singletonMap("confluent.metadata.version", new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 107 for feature confluent.metadata.version. Can't downgrade to a newer version."))), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_3_IV3.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE), Collections.emptyMap(), true));
    }

    @Test
    public void testCannotUpgradeToLowerVersion() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), Collections.singletonMap("confluent.metadata.version", new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid update version 104 for feature confluent.metadata.version. Can't downgrade the version of this feature without setting the upgrade type to either safe or unsafe downgrade."))), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_3_IV0.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.UPGRADE), Collections.emptyMap(), true));
    }

    @Test
    public void testCanUpgradeToHigherVersion() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), Collections.singletonMap("confluent.metadata.version", ApiError.NONE)), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_3_IV3.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.UPGRADE), Collections.emptyMap(), true));
    }

    @Test
    public void testCanUpgradeToHigherVersionViaApacheVersion() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel((short)107), 0)), Collections.singletonMap("metadata.version", ApiError.NONE)), (Object)manager.updateFeatures(Collections.singletonMap("metadata.version", MetadataVersion.IBP_3_3_IV3.apacheFeatureLevel()), Collections.singletonMap("metadata.version", FeatureUpdate.UpgradeType.UPGRADE), Collections.emptyMap(), false));
    }

    @Test
    public void testCannotUseSafeDowngradeIfMetadataChanged() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), Collections.singletonMap("confluent.metadata.version", new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid confluent.metadata.version 104. Refusing to perform the requested downgrade because it might delete metadata information. Retry using UNSAFE_DOWNGRADE if you want to force the downgrade to proceed."))), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_3_IV0.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), Collections.emptyMap(), true));
    }

    @Test
    public void testUnsafeDowngradeIsTemporarilyDisabled() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), Collections.singletonMap("metadata.version", new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid confluent.metadata.version 104. Unsafe metadata downgrade is not supported in this version."))), (Object)manager.updateFeatures(Collections.singletonMap("metadata.version", MetadataVersion.IBP_3_3_IV0.apacheFeatureLevel()), Collections.singletonMap("metadata.version", FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE), Collections.emptyMap(), true));
    }

    @Disabled
    @Test
    public void testCanUseUnsafeDowngradeIfMetadataChanged() {
        FeatureControlManager manager = TEST_MANAGER_BUILDER1.build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), Collections.singletonMap("confluent.metadata.version", ApiError.NONE)), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_3_IV0.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE), Collections.emptyMap(), true));
    }

    @Test
    public void testCanUseSafeDowngradeIfMetadataDidNotChange() {
        FeatureControlManager manager = new FeatureControlManager.Builder().setQuorumFeatures(FeatureControlManagerTest.features("confluent.metadata.version", MetadataVersion.IBP_3_0_IV0.confluentFeatureLevel(), MetadataVersion.IBP_3_3_IV1.confluentFeatureLevel())).setMetadataVersion(MetadataVersion.IBP_3_1_IV0).setMinimumBootstrapVersion(MetadataVersion.IBP_3_0_IV0).build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), Collections.singletonMap("confluent.metadata.version", ApiError.NONE)), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_0_IV1.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), Collections.emptyMap(), true));
    }

    @Test
    public void testCanotDowngradeBefore3_3_IV0() {
        FeatureControlManager manager = new FeatureControlManager.Builder().setQuorumFeatures(FeatureControlManagerTest.features("confluent.metadata.version", MetadataVersion.IBP_3_0_IV0.confluentFeatureLevel(), MetadataVersion.IBP_3_3_IV3.confluentFeatureLevel())).setMetadataVersion(MetadataVersion.IBP_3_3_IV0).build();
        Assertions.assertEquals((Object)ControllerResult.of(Collections.emptyList(), Collections.singletonMap("confluent.metadata.version", new ApiError(Errors.INVALID_UPDATE_VERSION, "Invalid confluent.metadata.version 103. Unable to set a confluent.metadata.version less than 3.3-IV0"))), (Object)manager.updateFeatures(Collections.singletonMap("confluent.metadata.version", MetadataVersion.IBP_3_2_IV0.confluentFeatureLevel()), Collections.singletonMap("confluent.metadata.version", FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE), Collections.emptyMap(), true));
    }

    @Test
    public void testCreateFeatureLevelRecords() {
        HashMap<String, VersionRange> localSupportedFeatures = new HashMap<String, VersionRange>();
        localSupportedFeatures.put("confluent.metadata.version", VersionRange.of((short)MetadataVersion.IBP_3_0_IV1.confluentFeatureLevel(), (short)MetadataVersion.latest().confluentFeatureLevel()));
        localSupportedFeatures.put("foo", VersionRange.of((int)0, (int)2));
        FeatureControlManager manager = new FeatureControlManager.Builder().setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), localSupportedFeatures, Collections.emptyList())).build();
        ControllerResult result = manager.updateFeatures(Collections.singletonMap("foo", (short)1), Collections.singletonMap("foo", FeatureUpdate.UpgradeType.UPGRADE), Collections.singletonMap(1, Collections.singletonMap("foo", VersionRange.of((int)0, (int)3))), false);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo").setFeatureLevel((short)1), 0)), Collections.singletonMap("foo", ApiError.NONE)), (Object)result);
        RecordTestUtils.replayAll(manager, result.records());
        Assertions.assertEquals(Optional.of((short)1), (Object)manager.finalizedFeatures(Long.MAX_VALUE).get("foo"));
        ControllerResult result2 = manager.updateFeatures(Collections.singletonMap("foo", (short)0), Collections.singletonMap("foo", FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE), Collections.singletonMap(1, Collections.singletonMap("foo", VersionRange.of((int)0, (int)3))), false);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo").setFeatureLevel((short)0), 0)), Collections.singletonMap("foo", ApiError.NONE)), (Object)result2);
        RecordTestUtils.replayAll(manager, result2.records());
        Assertions.assertEquals(Optional.empty(), (Object)manager.finalizedFeatures(Long.MAX_VALUE).get("foo"));
    }
}

