/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.Provide;
import net.jqwik.api.arbitraries.ShortArbitrary;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InconsistentClusterIdException;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.controller.ClusterControlManager;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.MockControllerMetrics;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerRegistrationFencingChange;
import org.apache.kafka.metadata.BrokerRegistrationInControlledShutdownChange;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.apache.kafka.metadata.placement.PlacementSpec;
import org.apache.kafka.metadata.placement.ReplicaPlacer;
import org.apache.kafka.metadata.placement.StripedReplicaPlacer;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.AlterReplicaExclusionOp;
import org.apache.kafka.server.common.AlterReplicaExclusionsReply;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockRandom;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class ClusterControlManagerTest {
    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class, names={"IBP_3_0_IV1", "IBP_3_3_IV2"})
    public void testReplay(MetadataVersion metadataVersion) {
        BrokerRegistrationChangeRecord changeRecord;
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(1);
        brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord, 100L);
        clusterControl.checkBrokerEpoch(1, 100L);
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> clusterControl.checkBrokerEpoch(1, 101L));
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> clusterControl.checkBrokerEpoch(2, 100L));
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(1));
        if (metadataVersion.isLessThan(MetadataVersion.IBP_3_3_IV2)) {
            UnfenceBrokerRecord unfenceBrokerRecord = new UnfenceBrokerRecord().setId(1).setEpoch(100L);
            clusterControl.replay(unfenceBrokerRecord);
        } else {
            changeRecord = new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(100L).setFenced(BrokerRegistrationFencingChange.UNFENCE.value());
            clusterControl.replay(changeRecord);
        }
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(1));
        if (metadataVersion.isLessThan(MetadataVersion.IBP_3_3_IV2)) {
            FenceBrokerRecord fenceBrokerRecord = new FenceBrokerRecord().setId(1).setEpoch(100L);
            clusterControl.replay(fenceBrokerRecord);
        } else {
            changeRecord = new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(100L).setFenced(BrokerRegistrationFencingChange.FENCE.value());
            clusterControl.replay(changeRecord);
        }
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(1));
    }

    @Test
    public void testReplayRegisterBrokerRecord() {
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).setFeatureControlManager(featureControl).build();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setFenced(true).setInControlledShutdown(true);
        brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.inControlledShutdown(0));
        brokerRecord.setInControlledShutdown(false);
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        Assertions.assertEquals((long)100L, (long)clusterControl.registerBrokerRecordOffset(brokerRecord.brokerId()).getAsLong());
        brokerRecord.setFenced(false);
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
    }

    @Test
    public void testReplayBrokerRegistrationChangeRecord() {
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).setFeatureControlManager(featureControl).build();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setFenced(false);
        brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        BrokerRegistrationChangeRecord registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setInControlledShutdown(BrokerRegistrationInControlledShutdownChange.IN_CONTROLLED_SHUTDOWN.value());
        clusterControl.replay(registrationChangeRecord);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.inControlledShutdown(0));
        registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(BrokerRegistrationFencingChange.UNFENCE.value());
        clusterControl.replay(registrationChangeRecord);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.inControlledShutdown(0));
    }

    @Provide
    private Arbitrary<Short> validConfluentMetadataVersions() {
        ShortArbitrary oldVersionRange = Arbitraries.shorts().between((short)1, (short)7);
        ShortArbitrary newVersionRange = Arbitraries.shorts().between(MetadataVersion.MINIMUM_KRAFT_VERSION.confluentFeatureLevel(), MetadataVersion.latest().confluentFeatureLevel());
        return Arbitraries.oneOf(Arrays.asList(oldVersionRange, newVersionRange));
    }

    @Property
    public void testRegistrationConfluentMetadataVersion(@ForAll(value="validConfluentMetadataVersions") short featureLevel) {
        if (featureLevel > 107) {
            Assertions.assertThrows(UnsupportedVersionException.class, () -> this.testRegistrationWithConfluentMetadataVersion(featureLevel, (short)1, MetadataVersion.latest().apacheFeatureLevel()));
        } else {
            this.testRegistrationWithConfluentMetadataVersion(featureLevel, (short)1, (short)7);
        }
        this.testRegistrationWithConfluentMetadataVersion(featureLevel, (short)1, MetadataVersion.latest().confluentFeatureLevel());
        this.testRegistrationWithConfluentMetadataVersion(featureLevel, MetadataVersion.MINIMUM_KRAFT_VERSION.confluentFeatureLevel(), MetadataVersion.latest().confluentFeatureLevel());
    }

    private void testRegistrationWithConfluentMetadataVersion(short featureLevel, short brokerMinSupportedLevel, short brokerMaxSupportedLevel) {
        MockTime time = new MockTime();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        QuorumFeatures quorumFeatures = new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.emptyList());
        String clusterId = "WIjw3grwRZmR2uOpdpVXbg";
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(quorumFeatures).setMetadataVersion(MetadataVersion.MINIMUM_KRAFT_VERSION).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setClusterId(clusterId).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        FeatureLevelRecord confluentMetadataVersion = new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(featureLevel);
        featureControl.replay(confluentMetadataVersion);
        if (featureLevel >= 1 && featureLevel <= 7) {
            Assertions.assertEquals((short)featureLevel, (short)featureControl.metadataVersion().apacheFeatureLevel());
        } else {
            Assertions.assertEquals((short)featureLevel, (short)featureControl.metadataVersion().confluentFeatureLevel());
        }
        int brokerId = 0;
        BrokerRegistrationRequestData registration = new BrokerRegistrationRequestData().setClusterId(clusterId).setBrokerId(brokerId).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg"));
        registration.features().add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(brokerMinSupportedLevel).setMaxSupportedVersion(brokerMaxSupportedLevel));
        long brokerEpoch = 12345L;
        ControllerResult result = clusterControl.registerBroker(registration, brokerEpoch, featureControl.finalizedFeatures(Long.MAX_VALUE));
        BrokerRegistrationReply reply = (BrokerRegistrationReply)result.response();
        Assertions.assertEquals((long)brokerEpoch, (long)reply.epoch());
        List records = result.records();
        Assertions.assertEquals((int)1, (int)records.size());
        RegisterBrokerRecord registerBrokerRecord = (RegisterBrokerRecord)((ApiMessageAndVersion)records.get(0)).message();
        Assertions.assertEquals((int)brokerId, (int)registerBrokerRecord.brokerId());
        clusterControl.replay(registerBrokerRecord, brokerEpoch);
        VersionRange versionRange = (VersionRange)clusterControl.registration(brokerId).supportedFeatures().get("confluent.metadata.version");
        Assertions.assertEquals((Object)VersionRange.of((short)brokerMinSupportedLevel, (short)brokerMaxSupportedLevel), (Object)versionRange);
    }

    @Test
    public void testRegistrationWithIncorrectClusterId() throws Exception {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        Assertions.assertThrows(InconsistentClusterIdException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("WIjw3grwRZmR2uOpdpVXbg").setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, new FinalizedControllerFeatures(Collections.emptyMap(), 456L)));
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class, names={"IBP_3_3_IV2", "IBP_3_3_IV3"})
    public void testRegisterBrokerRecordVersion(MetadataVersion metadataVersion) {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(metadataVersion).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        ControllerResult result = clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, new FinalizedControllerFeatures(Collections.emptyMap(), 456L));
        short expectedVersion = metadataVersion.registerBrokerRecordVersion();
        Assertions.assertEquals(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(123L).setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")).setFenced(true).setFeatures(new RegisterBrokerRecord.BrokerFeatureCollection(Arrays.asList(new RegisterBrokerRecord.BrokerFeature().setName("metadata.version").setMinSupportedVersion((short)1).setMaxSupportedVersion((short)1), new RegisterBrokerRecord.BrokerFeature().setName("confluent.metadata.version").setMinSupportedVersion((short)101).setMaxSupportedVersion((short)101)).iterator())).setInControlledShutdown(false), expectedVersion)), (Object)result.records());
    }

    @Test
    public void testUnfencedBrokerEndpoints() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        ListenerName externalListenerName = new ListenerName("EXTERNAL");
        ListenerName internalListenerName = new ListenerName("INTERNAL");
        ListenerName nonExistingListenerName = new ListenerName("NONEXISTING");
        RegisterBrokerRecord broker1Record = new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L).setIncarnationId(Uuid.fromString((String)"fPZv1VBsRFmnlRvmGcOW9w")).setRack("rack1");
        broker1Record.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.SASL_PLAINTEXT.id).setPort(9092).setName(externalListenerName.value()).setHost("localhost"));
        broker1Record.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9093).setName(internalListenerName.value()).setHost("localhost"));
        clusterControl.replay(broker1Record, 100L);
        this.assertUnfencedEndpoints(clusterControl, nonExistingListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, internalListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, externalListenerName, Collections.emptySet());
        clusterControl.replay(new UnfenceBrokerRecord().setId(1).setEpoch(100L));
        this.assertUnfencedEndpoints(clusterControl, nonExistingListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, externalListenerName, Utils.mkSet((Object[])new MetadataResponseData.MetadataResponseBroker[]{new MetadataResponseData.MetadataResponseBroker().setNodeId(1).setHost("localhost").setPort(9092).setRack("rack1")}));
        this.assertUnfencedEndpoints(clusterControl, internalListenerName, Utils.mkSet((Object[])new MetadataResponseData.MetadataResponseBroker[]{new MetadataResponseData.MetadataResponseBroker().setNodeId(1).setHost("localhost").setPort(9093).setRack("rack1")}));
        RegisterBrokerRecord broker2Record = new RegisterBrokerRecord().setBrokerId(2).setBrokerEpoch(100L).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")).setRack("rack2");
        broker2Record.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.SASL_PLAINTEXT.id).setPort(9094).setName(externalListenerName.value()).setHost("localhost"));
        clusterControl.replay(broker2Record, 200L);
        clusterControl.replay(new UnfenceBrokerRecord().setId(2).setEpoch(100L));
        this.assertUnfencedEndpoints(clusterControl, nonExistingListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, externalListenerName, Utils.mkSet((Object[])new MetadataResponseData.MetadataResponseBroker[]{new MetadataResponseData.MetadataResponseBroker().setNodeId(1).setHost("localhost").setPort(9092).setRack("rack1"), new MetadataResponseData.MetadataResponseBroker().setNodeId(2).setHost("localhost").setPort(9094).setRack("rack2")}));
        this.assertUnfencedEndpoints(clusterControl, internalListenerName, Utils.mkSet((Object[])new MetadataResponseData.MetadataResponseBroker[]{new MetadataResponseData.MetadataResponseBroker().setNodeId(1).setHost("localhost").setPort(9093).setRack("rack1")}));
        clusterControl.replay(new FenceBrokerRecord().setId(1).setEpoch(100L));
        this.assertUnfencedEndpoints(clusterControl, nonExistingListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, externalListenerName, Utils.mkSet((Object[])new MetadataResponseData.MetadataResponseBroker[]{new MetadataResponseData.MetadataResponseBroker().setNodeId(2).setHost("localhost").setPort(9094).setRack("rack2")}));
        this.assertUnfencedEndpoints(clusterControl, internalListenerName, Collections.emptySet());
        clusterControl.replay(new FenceBrokerRecord().setId(2).setEpoch(100L));
        this.assertUnfencedEndpoints(clusterControl, nonExistingListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, internalListenerName, Collections.emptySet());
        this.assertUnfencedEndpoints(clusterControl, externalListenerName, Collections.emptySet());
    }

    private void assertUnfencedEndpoints(ClusterControlManager clusterControl, ListenerName listenerName, Set<MetadataResponseData.MetadataResponseBroker> expectedUnfenced) {
        MetadataResponseData.MetadataResponseBrokerCollection actualUnfenced = clusterControl.unfencedBrokerEndpoints(listenerName);
        Assertions.assertEquals((int)expectedUnfenced.size(), (int)actualUnfenced.size());
        for (MetadataResponseData.MetadataResponseBroker expectedBroker : expectedUnfenced) {
            Assertions.assertEquals((Object)expectedBroker, (Object)actualUnfenced.find((ImplicitLinkedHashCollection.Element)expectedBroker));
        }
    }

    @Test
    public void testUnregister() throws Exception {
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L).setIncarnationId(Uuid.fromString((String)"fPZv1VBsRFmnlRvmGcOW9w")).setRack("arack");
        brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertEquals((Object)new BrokerRegistration(1, 100L, Uuid.fromString((String)"fPZv1VBsRFmnlRvmGcOW9w"), Collections.singletonMap("PLAINTEXT", new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "example.com", 9092)), Collections.emptyMap(), Optional.of("arack"), true, false), clusterControl.brokerRegistrations().get(1));
        Assertions.assertEquals((long)100L, (long)clusterControl.registerBrokerRecordOffset(brokerRecord.brokerId()).getAsLong());
        UnregisterBrokerRecord unregisterRecord = new UnregisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L);
        clusterControl.replay(unregisterRecord);
        Assertions.assertFalse((boolean)clusterControl.brokerRegistrations().containsKey(1));
        Assertions.assertFalse((boolean)clusterControl.registerBrokerRecordOffset(brokerRecord.brokerId()).isPresent());
    }

    @ParameterizedTest
    @ValueSource(ints={3, 10})
    public void testPlaceReplicas(int numUsableBrokers) throws Exception {
        int i;
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        MockRandom random = new MockRandom();
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        final ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).setReplicaPlacer((ReplicaPlacer)new StripedReplicaPlacer((Random)random)).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        int replicationFactor = 3;
        for (i = 0; i < numUsableBrokers; ++i) {
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(i);
            brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
            clusterControl.replay(brokerRecord, 100L);
            UnfenceBrokerRecord unfenceRecord = new UnfenceBrokerRecord().setId(i).setEpoch(100L);
            clusterControl.replay(unfenceRecord);
            clusterControl.heartbeatManager().touch(i, false, 0L);
        }
        for (i = 0; i < numUsableBrokers; ++i) {
            Assertions.assertTrue((boolean)clusterControl.isUnfenced(i), (String)String.format("broker %d was not unfenced.", i));
        }
        int excludedBrokerId = -1;
        if (numUsableBrokers > replicationFactor) {
            excludedBrokerId = random.nextInt(numUsableBrokers);
            BrokerReplicaExclusionRecord exclusionRecord = new BrokerReplicaExclusionRecord().setBrokerExclusions(Collections.singletonList(new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(excludedBrokerId).setReason("test")));
            clusterControl.replay(exclusionRecord);
            Assertions.assertTrue((boolean)clusterControl.activeBrokerReplicaExclusions().containsKey(excludedBrokerId), (String)"Expected the excluded broker %d to be in the active broker replica exclusions");
        }
        for (int i2 = 0; i2 < 100; ++i2) {
            List results = clusterControl.replicaPlacer().place(new PlacementSpec(0, 1, 3, "foo", KafkaPrincipal.ANONYMOUS, Collections.emptySet()), new ClusterDescriber(){

                public Iterator<UsableBroker> usableBrokers() {
                    return clusterControl.usableBrokers();
                }

                public Iterator<String> topicNames() {
                    throw new RuntimeException("not implemented");
                }

                public List<List<Integer>> replicasForTopicName(String topicName) {
                    throw new RuntimeException("not implemented");
                }
            }).assignments();
            HashSet<Integer> seen = new HashSet<Integer>();
            for (Integer result : ((PartitionAssignment)results.get(0)).replicas()) {
                Assertions.assertTrue((result >= 0 ? 1 : 0) != 0);
                Assertions.assertTrue((result < numUsableBrokers ? 1 : 0) != 0);
                Assertions.assertNotEquals((Integer)result, (int)excludedBrokerId, (String)String.format("Expected the replica to not be assigned to the excluded broker %d", excludedBrokerId));
                Assertions.assertTrue((boolean)seen.add(result));
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class, names={"IBP_3_3_IV2", "IBP_3_3_IV3"})
    public void testRegistrationsToRecords(MetadataVersion metadataVersion) throws Exception {
        int i;
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(metadataVersion).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        for (i = 0; i < 3; ++i) {
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(i).setRack(null);
            brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092 + i).setName("PLAINTEXT").setHost("example.com"));
            clusterControl.replay(brokerRecord, 100L);
        }
        for (i = 0; i < 2; ++i) {
            UnfenceBrokerRecord unfenceBrokerRecord = new UnfenceBrokerRecord().setId(i).setEpoch(100L);
            clusterControl.replay(unfenceBrokerRecord);
        }
        BrokerRegistrationChangeRecord registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setInControlledShutdown(BrokerRegistrationInControlledShutdownChange.IN_CONTROLLED_SHUTDOWN.value());
        clusterControl.replay(registrationChangeRecord);
        BrokerReplicaExclusionRecord exclusionRecord = new BrokerReplicaExclusionRecord().setBrokerExclusions(Arrays.asList(new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(1).setReason("1"), new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(2).setReason("2"), new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(3).setReason("3")));
        clusterControl.replay(exclusionRecord);
        short expectedVersion = metadataVersion.registerBrokerRecordVersion();
        ImageWriterOptions options = new ImageWriterOptions.Builder().setMetadataVersion(metadataVersion).setLossHandler(__ -> {}).build();
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com")).iterator())).setInControlledShutdown(metadataVersion.isInControlledShutdownStateSupported()).setFenced(false), expectedVersion), (Object)((BrokerRegistration)clusterControl.brokerRegistrations().get(0)).toRecord(options));
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(1).setRack(null).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9093).setName("PLAINTEXT").setHost("example.com")).iterator())).setFenced(false), expectedVersion), (Object)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).toRecord(options));
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(2).setRack(null).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9094).setName("PLAINTEXT").setHost("example.com")).iterator())).setFenced(true), expectedVersion), (Object)((BrokerRegistration)clusterControl.brokerRegistrations().get(2)).toRecord(options));
    }

    @Test
    public void testReplayExclusionRecordWorks() {
        MockControllerMetrics controllerMetrics = new MockControllerMetrics();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setControllerMetrics((ControllerMetrics)controllerMetrics).setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        Assertions.assertEquals((int)0, (int)controllerMetrics.excludedBrokerCount());
        BrokerReplicaExclusionRecord record = new BrokerReplicaExclusionRecord().setBrokerExclusions(Arrays.asList(new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(1).setReason("1"), new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(2).setReason("2"), new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(3).setReason("3")));
        HashMap<Integer, String> expectedExclusionState = new HashMap<Integer, String>();
        expectedExclusionState.put(1, "1");
        expectedExclusionState.put(2, "2");
        expectedExclusionState.put(3, "3");
        clusterControl.replay(record);
        Assertions.assertEquals(expectedExclusionState, (Object)clusterControl.activeBrokerReplicaExclusions());
        Assertions.assertEquals((int)expectedExclusionState.size(), (int)controllerMetrics.excludedBrokerCount());
        BrokerReplicaExclusionRecord newRecord = new BrokerReplicaExclusionRecord().setBrokerExclusions(Arrays.asList(new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(1).setReason("1"), new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(2).setReason("10")));
        clusterControl.replay(newRecord);
        expectedExclusionState.put(2, "10");
        expectedExclusionState.remove(3);
        Assertions.assertEquals(expectedExclusionState, (Object)clusterControl.activeBrokerReplicaExclusions());
        Assertions.assertEquals((int)expectedExclusionState.size(), (int)controllerMetrics.excludedBrokerCount());
    }

    @Test
    public void testProcessAlterReplicaExclusions() {
        MockControllerMetrics controllerMetrics = new MockControllerMetrics();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setControllerMetrics((ControllerMetrics)controllerMetrics).setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        Assertions.assertEquals((int)0, (int)controllerMetrics.excludedBrokerCount());
        HashSet<AlterReplicaExclusionOp> requestedExclusions = new HashSet<AlterReplicaExclusionOp>(Arrays.asList(new AlterReplicaExclusionOp(1, "1", ExclusionOp.OpType.SET), new AlterReplicaExclusionOp(2, "2", ExclusionOp.OpType.SET)));
        HashMap<Integer, String> expectedExclusionState = new HashMap<Integer, String>();
        expectedExclusionState.put(1, "1");
        expectedExclusionState.put(2, "2");
        ControllerResult result = clusterControl.processAlterReplicaExclusions(requestedExclusions);
        this.verifyExclusionResponse(expectedExclusionState, requestedExclusions, true, false, (ControllerResult<AlterReplicaExclusionsReply>)result, clusterControl);
        BrokerReplicaExclusionRecord record = new BrokerReplicaExclusionRecord().setBrokerExclusions(((AlterReplicaExclusionsReply)result.response()).exclusionResults().stream().map(r -> new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId(r.brokerId()).setReason(r.reason())).collect(Collectors.toList()));
        clusterControl.replay(record);
        Assertions.assertEquals(expectedExclusionState, (Object)clusterControl.activeBrokerReplicaExclusions());
        Assertions.assertEquals((int)expectedExclusionState.size(), (int)controllerMetrics.excludedBrokerCount());
        result = clusterControl.processAlterReplicaExclusions(requestedExclusions);
        this.verifyExclusionResponse(expectedExclusionState, expectedExclusionState, requestedExclusions, true, true, (ControllerResult<AlterReplicaExclusionsReply>)result, clusterControl);
    }

    @Test
    public void testProcessAlterReplicaExclusionsDoesNotApplyWhenAnErrorIsPresent() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latest()).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        HashSet<AlterReplicaExclusionOp> requestedExclusions = new HashSet<AlterReplicaExclusionOp>(Arrays.asList(new AlterReplicaExclusionOp(1, "1", ExclusionOp.OpType.SET), new AlterReplicaExclusionOp(2, "2", ExclusionOp.OpType.SET), new AlterReplicaExclusionOp(3, "3", ExclusionOp.OpType.DELETE)));
        HashMap<Integer, String> expectedExclusionState = new HashMap<Integer, String>();
        ControllerResult result = clusterControl.processAlterReplicaExclusions(requestedExclusions);
        this.verifyExclusionResponse(expectedExclusionState, requestedExclusions, false, false, (ControllerResult<AlterReplicaExclusionsReply>)result, clusterControl);
    }

    private void verifyExclusionResponse(Map<Integer, String> expectedExclusions, Set<AlterReplicaExclusionOp> requestedExclusions, boolean expectedToBeSuccessful, boolean expectedToBeSuccessfulNoOp, ControllerResult<AlterReplicaExclusionsReply> receivedResult, ClusterControlManager controlManager) {
        this.verifyExclusionResponse(expectedExclusions, Collections.emptyMap(), requestedExclusions, expectedToBeSuccessful, expectedToBeSuccessfulNoOp, receivedResult, controlManager);
    }

    private void verifyExclusionResponse(Map<Integer, String> expectedExclusions, Map<Integer, String> expectedInMemoryExclusions, Set<AlterReplicaExclusionOp> requestedExclusions, boolean expectedToBeSuccessful, boolean expectedToBeSuccessfulNoOp, ControllerResult<AlterReplicaExclusionsReply> receivedResult, ClusterControlManager controlManager) {
        if (expectedToBeSuccessfulNoOp) {
            Assertions.assertTrue((boolean)((AlterReplicaExclusionsReply)receivedResult.response()).wasSuccessful(), (String)"Expected the exclusions to have applied successfully");
            Assertions.assertTrue((boolean)((AlterReplicaExclusionsReply)receivedResult.response()).wasSuccessfulNoOp(), (String)"Expected the exclusions to have applied successfully");
            Assertions.assertEquals((int)0, (int)receivedResult.records().size(), (String)"Expected no records to be persisted because the request was a no-op");
            Assertions.assertEquals((int)requestedExclusions.size(), (int)((AlterReplicaExclusionsReply)receivedResult.response()).exclusionResults().size());
            Assertions.assertEquals(expectedInMemoryExclusions, (Object)controlManager.activeBrokerReplicaExclusions());
        } else if (expectedToBeSuccessful) {
            Assertions.assertTrue((boolean)((AlterReplicaExclusionsReply)receivedResult.response()).wasSuccessful(), (String)"Expected the exclusions to have applied successfully");
            Assertions.assertFalse((boolean)((AlterReplicaExclusionsReply)receivedResult.response()).wasSuccessfulNoOp(), (String)"Expected the exclusion request to NOT have been a no-op");
            Assertions.assertEquals((int)1, (int)receivedResult.records().size());
            BrokerReplicaExclusionRecord expectedRecord = new BrokerReplicaExclusionRecord().setBrokerExclusions(expectedExclusions.entrySet().stream().map(entry -> new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setReason((String)entry.getValue()).setBrokerId((Integer)entry.getKey())).collect(Collectors.toList()));
            Assertions.assertEquals((Object)expectedRecord, (Object)((ApiMessageAndVersion)receivedResult.records().get(0)).message());
            Assertions.assertEquals((int)requestedExclusions.size(), (int)((AlterReplicaExclusionsReply)receivedResult.response()).exclusionResults().size());
            Assertions.assertEquals(expectedInMemoryExclusions, (Object)controlManager.activeBrokerReplicaExclusions());
        } else {
            Assertions.assertFalse((boolean)((AlterReplicaExclusionsReply)receivedResult.response()).wasSuccessful(), (String)"Expected the exclusions to have NOT applied");
            Assertions.assertEquals((int)0, (int)receivedResult.records().size(), (String)"No records should have been persistent when exclusions were not applied succesfully");
            Assertions.assertEquals(expectedInMemoryExclusions, (Object)controlManager.activeBrokerReplicaExclusions());
        }
    }

    @Test
    public void testRegistrationWithUnsupportedMetadataVersion() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, new ApiVersions(), Collections.singletonMap("confluent.metadata.version", VersionRange.of((short)MetadataVersion.IBP_3_1_IV0.confluentFeatureLevel(), (short)MetadataVersion.IBP_3_3_IV0.confluentFeatureLevel())), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.IBP_3_3_IV0).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setControllerMetrics((ControllerMetrics)new MockControllerMetrics()).setFeatureControlManager(featureControl).build();
        clusterControl.activate();
        Assertions.assertEquals((Object)"Unable to register broker 0 because it does not support version 104 of confluent.metadata.version. It wants a version between 101 and 101, inclusive.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, featureControl.finalizedFeatures(Long.MAX_VALUE)))).getMessage());
        Assertions.assertEquals((Object)"Unable to register broker 0 because it does not support version 104 of confluent.metadata.version. It wants a version between 107 and 107, inclusive.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Collections.singleton(new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(MetadataVersion.IBP_3_3_IV3.confluentFeatureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_3_IV3.confluentFeatureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, featureControl.finalizedFeatures(Long.MAX_VALUE)))).getMessage());
        Assertions.assertEquals((Object)"Unable to register broker 0 because it does not support confluent.metadata.version. Please upgrade your broker to Confluent Platform, or downgrade your controller to Apache Kafka. Brokers must be upgraded first in a rolling upgrade from Apache to CP.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Collections.singleton(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.IBP_3_3_IV3.apacheFeatureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_3_IV3.apacheFeatureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, featureControl.finalizedFeatures(Long.MAX_VALUE)))).getMessage());
    }
}

