/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.util;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.metadata.util.SnapshotReason;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class SnapshotReasonTest {
    @Test
    public void testUnknown() {
        Assertions.assertEquals((Object)"unknown reason", (Object)SnapshotReason.UNKNOWN.toString());
    }

    @Test
    public void testMaxBytesExceeded() {
        long bytes = 1000L;
        long maxBytes = 900L;
        String expectedMessage = "1000 bytes exceeded the maximum bytes of 900";
        Assertions.assertEquals((Object)expectedMessage, (Object)SnapshotReason.maxBytesExceeded((long)bytes, (long)maxBytes).toString());
    }

    @Test
    public void testMaxIntervalExceeded() {
        long interval = 1000L;
        long maxInterval = 900L;
        String expectedMessage = "1000 ms exceeded the maximum snapshot interval of 900 ms";
        Assertions.assertEquals((Object)expectedMessage, (Object)SnapshotReason.maxIntervalExceeded((long)interval, (long)maxInterval).toString());
    }

    @Test
    public void testMetadataVersionChanged() {
        MetadataVersion metadataVersion = MetadataVersion.IBP_3_3_IV3;
        String expectedMessage = "metadata version was changed to 3.3-IV3";
        Assertions.assertEquals((Object)expectedMessage, (Object)SnapshotReason.metadataVersionChanged((MetadataVersion)metadataVersion).toString());
    }

    @Test
    public void testJoinReasons() {
        long bytes = 1000L;
        long maxBytes = 900L;
        long interval = 1000L;
        long maxInterval = 900L;
        MetadataVersion metadataVersion = MetadataVersion.IBP_3_3_IV3;
        List<SnapshotReason> reasons = Arrays.asList(SnapshotReason.UNKNOWN, SnapshotReason.maxBytesExceeded((long)bytes, (long)maxBytes), SnapshotReason.maxIntervalExceeded((long)interval, (long)maxInterval), SnapshotReason.metadataVersionChanged((MetadataVersion)metadataVersion));
        String joinedReasons = SnapshotReason.stringFromReasons(reasons);
        Assertions.assertTrue((boolean)joinedReasons.contains("unknown reason"), (String)joinedReasons);
        Assertions.assertTrue((boolean)joinedReasons.contains("1000 bytes exceeded the maximum bytes of 900"), (String)joinedReasons);
        Assertions.assertTrue((boolean)joinedReasons.contains("1000 ms exceeded the maximum snapshot interval of 900 ms"), (String)joinedReasons);
        Assertions.assertTrue((boolean)joinedReasons.contains("metadata version was changed to 3.3-IV3"), (String)joinedReasons);
    }
}

