/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ConfluentStandardAclTest {
    private final String host = "10.0.0.1";
    private final String principal = "User:user";
    private final String resourceName = "foo";
    private final AclOperation operation = AclOperation.ALL;
    private final PatternType patternType = PatternType.LITERAL;
    private final ResourceType resourceType = ResourceType.TOPIC;
    private final AclPermissionType permissionType = AclPermissionType.ALLOW;

    @Test
    public void testFromAclBindingWithoutLinks() {
        AclBinding aclBinding = this.newAclBinding();
        List confluentStandardAclList = ConfluentStandardAcl.fromAclBinding((AclBinding)aclBinding);
        Assertions.assertEquals((int)1, (int)confluentStandardAclList.size());
        Assertions.assertEquals((Object)new ConfluentStandardAcl(StandardAcl.fromAclBinding((AclBinding)this.newAclBinding()), Optional.empty()), confluentStandardAclList.get(0));
    }

    @Test
    public void testFromAclBindingWithLinks() {
        Uuid link1 = Uuid.fromString((String)"R3bMhXGmQNmK46EcBnrAiQ");
        Uuid link2 = Uuid.fromString((String)"1btx_LQcTNmABQKW0MRBVQ");
        ArrayList<Uuid> links = new ArrayList<Uuid>();
        links.add(link1);
        links.add(link2);
        AclBinding aclBinding = this.newAclBinding(links);
        List confluentStandardAclList = ConfluentStandardAcl.fromAclBinding((AclBinding)aclBinding);
        Assertions.assertEquals((int)2, (int)confluentStandardAclList.size());
        Assertions.assertEquals((Object)new ConfluentStandardAcl(StandardAcl.fromAclBinding((AclBinding)this.newAclBinding()), Optional.of(link1)), confluentStandardAclList.get(0));
        Assertions.assertEquals((Object)new ConfluentStandardAcl(StandardAcl.fromAclBinding((AclBinding)this.newAclBinding()), Optional.of(link2)), confluentStandardAclList.get(1));
    }

    @Test
    public void testToAclBindingWithLinks() {
        Uuid link1 = Uuid.fromString((String)"R3bMhXGmQNmK46EcBnrAiQ");
        ConfluentStandardAcl confluentStandardAcl = this.newConfluentStandardAcl(Optional.of(link1));
        Assertions.assertEquals((Object)this.newAclBinding(Arrays.asList(link1)), (Object)confluentStandardAcl.toBinding());
    }

    @Test
    public void testToAclBindingWithoutLinks() {
        ConfluentStandardAcl confluentStandardAcl = this.newConfluentStandardAcl(Optional.empty());
        Assertions.assertEquals((Object)this.newAclBinding(), (Object)confluentStandardAcl.toBinding());
    }

    @Test
    public void testFromRecordWithoutLink() {
        AccessControlEntryRecord accessControlEntryRecord = new AccessControlEntryRecord();
        accessControlEntryRecord.setResourceType(this.resourceType.code());
        accessControlEntryRecord.setResourceName("foo");
        accessControlEntryRecord.setPermissionType(this.permissionType.code());
        accessControlEntryRecord.setPrincipal("User:user");
        accessControlEntryRecord.setHost("10.0.0.1");
        accessControlEntryRecord.setOperation(this.operation.code());
        accessControlEntryRecord.setPatternType(this.patternType.code());
        ConfluentStandardAcl confluentStandardAcl = ConfluentStandardAcl.fromRecord((AccessControlEntryRecord)accessControlEntryRecord);
        Assertions.assertEquals((Object)this.newConfluentStandardAcl(Optional.empty()), (Object)confluentStandardAcl);
    }

    @Test
    public void testFromRecordWithLink() {
        AccessControlEntryRecord accessControlEntryRecord = new AccessControlEntryRecord();
        accessControlEntryRecord.setResourceType(this.resourceType.code());
        accessControlEntryRecord.setResourceName("foo");
        accessControlEntryRecord.setPermissionType(this.permissionType.code());
        accessControlEntryRecord.setPrincipal("User:user");
        accessControlEntryRecord.setHost("10.0.0.1");
        accessControlEntryRecord.setOperation(this.operation.code());
        accessControlEntryRecord.setPatternType(this.patternType.code());
        Uuid link1 = Uuid.fromString((String)"R3bMhXGmQNmK46EcBnrAiQ");
        accessControlEntryRecord.setClusterLinkId(link1);
        ConfluentStandardAcl confluentStandardAcl = ConfluentStandardAcl.fromRecord((AccessControlEntryRecord)accessControlEntryRecord);
        Assertions.assertEquals((Object)this.newConfluentStandardAcl(Optional.of(link1)), (Object)confluentStandardAcl);
    }

    @Test
    public void testEquals() {
        ArrayList<ConfluentStandardAcl> inputs = new ArrayList<ConfluentStandardAcl>();
        Uuid link1 = Uuid.fromString((String)"R3bMhXGmQNmK46EcBnrAiQ");
        ConfluentStandardAcl confluentStandardAcl1 = this.newConfluentStandardAcl(Optional.of(link1));
        inputs.add(confluentStandardAcl1);
        ConfluentStandardAcl confluentStandardAcl2 = this.newConfluentStandardAcl(Optional.of(link1), "foo1");
        inputs.add(confluentStandardAcl2);
        ConfluentStandardAcl confluentStandardAcl3 = this.newConfluentStandardAcl(Optional.empty());
        inputs.add(confluentStandardAcl3);
        for (int i = 0; i != inputs.size(); ++i) {
            for (int j = 0; j != inputs.size(); ++j) {
                if (i == j) {
                    Assertions.assertEquals(inputs.get(i), inputs.get(j));
                    continue;
                }
                Assertions.assertNotEquals(inputs.get(i), inputs.get(j));
            }
        }
    }

    private ConfluentStandardAcl newConfluentStandardAcl(Optional<Uuid> linkId, String resourceName) {
        return new ConfluentStandardAcl(new StandardAcl(this.resourceType, resourceName, this.patternType, "User:user", "10.0.0.1", this.operation, this.permissionType), linkId);
    }

    private ConfluentStandardAcl newConfluentStandardAcl(Optional<Uuid> linkId) {
        return this.newConfluentStandardAcl(linkId, "foo");
    }

    private AclBinding newAclBinding() {
        return this.newAclBinding(Collections.emptyList());
    }

    private AclBinding newAclBinding(List<Uuid> links) {
        return new AclBinding(new ResourcePattern(this.resourceType, "foo", this.patternType), new AccessControlEntry("User:user", "10.0.0.1", this.operation, this.permissionType, links));
    }
}

