/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.AesGcm128MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class MetadataEncryptorFactoryTest {
    public static final Uuid FOO_ID = Uuid.fromString((String)"ZUpeNz1eSKyT_qiVKswGfA");
    public static final Uuid BAR_ID = Uuid.fromString((String)"8PKWuzWBR3C7cFAZKzdmkg");
    public static final Uuid BAZ_ID = Uuid.fromString((String)"mZXxfuVgR4Ka70TYtTrYqw");
    public static final Map<String, Object> TEST_CONFIG;

    @Test
    public void testCreateFromEmptyConfig() {
        MetadataEncryptorFactory factory = new MetadataEncryptorFactory(Collections.emptyMap());
        Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)factory.activeId());
        MetadataEncryptor encryptor = factory.createFromConfig(Uuid.ZERO_UUID);
        Assertions.assertEquals(NoOpMetadataEncryptor.class, encryptor.getClass());
        Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)encryptor.id());
    }

    @Test
    public void testCreateFromConfig() {
        MetadataEncryptorFactory factory = new MetadataEncryptorFactory(TEST_CONFIG);
        Assertions.assertEquals((Object)FOO_ID, (Object)factory.activeId());
        MetadataEncryptor encryptor = factory.createFromConfig(BAR_ID);
        Assertions.assertEquals(AesGcm128MetadataEncryptor.class, encryptor.getClass());
        Assertions.assertEquals((Object)BAR_ID, (Object)encryptor.id());
        Assertions.assertArrayEquals((byte[])new byte[]{97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112}, (byte[])encryptor.secret());
    }

    @Test
    public void testCreateRandom() throws Exception {
        MetadataEncryptorFactory factory = new MetadataEncryptorFactory(Collections.emptyMap());
        String className = AesGcm128MetadataEncryptor.class.getCanonicalName();
        MetadataEncryptor first = factory.createRandom(className);
        TestUtils.retryOnExceptionWithTimeout((long)30000L, (long)0L, () -> {
            MetadataEncryptor second = factory.createRandom(className);
            Assertions.assertNotEquals((Object)first.id(), (Object)second.id());
            Assertions.assertNotEquals((Object)first.secret(), (Object)second.secret());
        });
    }

    @Test
    public void testCreateFromConfigFailsWithoutConfig() {
        MetadataEncryptorFactory factory = new MetadataEncryptorFactory(TEST_CONFIG);
        Assertions.assertEquals((Object)"No configuration found for metadata encryptor mZXxfuVgR4Ka70TYtTrYqw", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> factory.createFromConfig(BAZ_ID))).getMessage());
    }

    static {
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put("confluent.metadata.active.encryptor", "ZUpeNz1eSKyT_qiVKswGfA");
        newMap.put("confluent.metadata.encryptor.classes", "ZUpeNz1eSKyT_qiVKswGfA=" + AesGcm128MetadataEncryptor.class.getCanonicalName() + ",8PKWuzWBR3C7cFAZKzdmkg=" + AesGcm128MetadataEncryptor.class.getCanonicalName());
        newMap.put("confluent.metadata.encryptor.secrets", "ZUpeNz1eSKyT_qiVKswGfA=cG9ubWxramloZ2ZlZGNiYQ,8PKWuzWBR3C7cFAZKzdmkg=YWJjZGVmZ2hpamtsbW5vcA");
        TEST_CONFIG = Collections.unmodifiableMap(newMap);
    }
}

